#include "Group.hh"
#include "Application.hh"
#include "Debug.hh"

#define GroupBackground RGB(0, 0x22, 0x95)
//#define GroupBackground RGB(0x20, 0x20, 0x20)

Group::Group(const Align _align=VAVertical)
    : first(0), last(0), current(0), ChildAlign(_align)
{
  SetColor(GroupBackground, ciBackground);
  SetColor(GroupBackground, ciHighlightedBG);
}

Group::~Group()
{
  View * p = first;
  while (p) {
    View * q = p->next;
    delete p;
    p = q;
  }
}

void Group::Insert(View * view)
{
  view->parent = this;
  if (!last)
    first = view;
  else
    last->next = view;
  last = view;
//  ReArrange(TRUE);
  if (view->AutoResize) {
    Event e(this);
    e.type = evnCommand;
    e.command = cmSizeChanged;
    view->HandleEvent(e);
  }
  if ((Visible) && (!Hidden))
    view->Show();
  if ((!current) && Selected)
    view->Select();
}

void Group::Delete(View * view)
{
  View * p = first;
  View * prev = 0;
  while (p && (p != view)) {
    prev = p;
    p = p->next;
  }
  if (!p)
    return;
  if (p == current)
    p->SelectNext(TRUE);
  if (prev)
    prev->next = p->next;
  if (p == first)
    first = p->next;
  if (p == last)
    last = prev;
  if (current == p)
    current = first;
  p->Hide();
  p->parent = 0;
//  ReArrange(TRUE);
}

void Group::Replace(View * old, View * newv)
{
  View * p = first;
  View * prev = 0;
  while (p && (p != old)) {
    prev = p;
    p = p->next;
  }
  if (!p)
    return;
  newv->parent = this;
  if ((p == current) && (!newv->Selectable))
    p->SelectNext(TRUE);
  if (prev)
    prev->next = newv;
  newv->next = old->next;
  if (old == first)
    first = newv;
  if (old == last)
    last = newv;
  old->Hide();
  old->parent = 0;
//  ReArrange(TRUE);
  if ((Visible) && (!Hidden))
    newv->Show();
  if ((old == current) || (!current)) {
    current = newv;
    newv->Select();
  }
}

void Group::Draw()
{
  View::Draw();
  View * p = first;
  while (p) {
    p->Redraw();
    p=p->next;
  }
}

void Group::ReArrange(bool CallParent=TRUE, View * except=0)
{
  if (!app_global->CanReArrange)
    return;
  for (View * v = first; v; v = v->next)
    if (v != except)
      v->ReArrange(FALSE);
  int W = 0;
  int H = 0;
  if (ChildAlign == VAVertical) {
    for (View * v = first; v; v = v->next)
	W = Max(W, v->MinSize.X);
  } else {
    for (View * v = first; v; v = v->next)    
      H = Max(H, v->MinSize.Y);
  }
  View * c = 0;
  for (View * v = first; v; v=v->next) {
    if (v->Hidden)
      continue;
    if (v == current)
      c = v;
    Point o;
    Point s;
    switch (ChildAlign) {
    case VAHorizontal:
      o.X = W;
      if (v->AutoCenter && (!v->AutoResize))
	o.Y = (H-(v->GetH()))/2;
      else
	o.Y = 0;
      if (v->AutoResize) {
	s.X = v->GetW();
	s.Y = H;	
      }
      v->IsLargest = (v->MinSize.Y == H);
      W += v->GetW();
      break;
    default: //case VAVertical:
      if (v->AutoCenter && (!v->AutoResize))
	o.X = (W-(v->GetW()))/2;	
      else
	o.X = 0;
      o.Y = H;
      if (v->AutoResize) {
	s.X = W;
	s.Y  = v->GetH();
      }
      v->IsLargest = (v->MinSize.X == W);
      H += v->GetH();
    }
    v->Area.Origin = o;
    if (v->AutoResize)
      v->SetSize(s, FALSE);
  }
  if ((!c) && (first) && Selected)
    first->Select();
  MinSize.X = W;
  MinSize.Y = H;
  if (!(Area.Size == MinSize)) {
    if (!IsLargest) {
      Align a = (parent ? parent->ChildAlign : VAHorizontal);
      int oS = (a == VAHorizontal) ? Area.Size.Y : Area.Size.X;
      int oS2 = (a == VAHorizontal) ? Area.Size.X : Area.Size.Y;
      int nS = (a == VAHorizontal) ? MinSize.Y : MinSize.X;
      int nS2 = (a == VAHorizontal) ? MinSize.X : MinSize.Y;      
      if (oS2 == nS2) {
	if (oS >= nS) {
	  if (oS == nS)
	    IsLargest = TRUE;
	  return;
	}
      }
    }
    Area.Size = MinSize;
    if (parent && CallParent)
      parent->ReArrange(TRUE,  this);
    else
      if (CallParent)
	Redraw();
  } else
    if (CallParent)
      Redraw();
}

void Group::Show()
{
  for (View * p = first; p; p=p->next)
    if (!(p->Hidden))
      p->Show();
  View::Show();
}

void Group::Hide()
{
  app_global->StopRedraw();
  for (View * p = first; p; p=p->next)
    p->Hide();
  View::Hide();
  app_global->StartRedraw();
  (parent ? parent : this)->Redraw();
}

void Group::Select()
{
//  app_global->StopRedraw();
  if (Visible && (!Selected) && (!Hidden)) {
    if (current)
      current->Select();
    else if (first)
      first->Select();
    if (current) // something is selected
      Selectable = TRUE;
  View::Select();
  }
//  app_global->StartRedraw();
//  (parent ? parent : this)->Redraw();  
}

void Group::Deselect()
{
  if (!Selected)
    return;
//  app_global->StopRedraw();
  if (current)
    current->Deselect();
  View::Deselect();
//  app_global->StartRedraw();
//  (parent ? parent : this)->Redraw();
}

bool Group::SelectNext(bool Forward)
{
  if (View::SelectNext(Forward))
    return TRUE;
  else {
    if (first) {
      if (current)
	current->Deselect();      
      first->Select();
      return TRUE;
    }
  }
  return FALSE;
}

bool Group::HandleEvent(Event& event)
{
  if (!View::HandleEvent(event))
    return FALSE;  
  if (Hidden || (!Visible))
    return TRUE;
  if ((current) && (!current->HandleEvent(event)))
    return FALSE;
  if (event.type == evKeypress)
    return TRUE;
  View * v = first;
  while (v) {
    if ((current != v) && (v->Visible) && (!v->Hidden) && (v->Enabled) && (!v->HandleEvent(event)))
      return FALSE;
    v = v->next;
  }
  return TRUE;
}

void Group::PutEvent(Event& event)
{
  for (View * v = first; v; v=v->next)
    if ((v->Visible) && (!v->Hidden) && (!v->HandleEvent(event)))
      return;
  View::PutEvent(event);
}

void Group::SetHidden(bool _hidden, bool rearrange=TRUE)
{
  if ((!_hidden) && (rearrange))
    app_global->StopRedraw();
#ifdef DEBUGVision
  if (rearrange)
    DEBUGPVision("sethidden start");
#endif
   if (rearrange)
    app_global->StopReArrange();
  View::SetHidden(_hidden, FALSE);
  for (View * v = first; v; v = v->next)
    v->SetHidden(_hidden, FALSE);
   if (rearrange)
    app_global->StartReArrange();
  if ((!_hidden) && (rearrange)) {
    DEBUGPVision("rearrange");
    ReArrange(TRUE);
    DEBUGPVision("sethidden before redraw");
    app_global->StartRedraw();
    {
      FrameBuffer * f = app_global->fb;
      if (f)
        f->Fill_sd(0, 0, f->WindowSizeX, f->WindowSizeY, RGB(0, 0, 0));
    }
    app_global->Redraw();
    DEBUGPVision("sethidden before after redraw");    
  }
}

void Group::DrawPartBG(View * child)
{
  if (!app_global->fb)
    return;
  // same as DrawBackground, but only a partial area
  Pixel_t color = Colors[Selected ? ciHighlightedBG : ciBackground];
  if (color.NotZero())
    app_global->fb->Fill_sd(child->GetX(), child->GetY(),
			    child->Area.Size.X, child->Area.Size.Y, color);
  else
    if (parent)
      parent->DrawPartBG(child);
}

class _creategroupclass {
  public:
    _creategroupclass * next;
    View * item;
    _creategroupclass(View * _item, _creategroupclass * _next);
    void InsertInMenu(Group * root);
    ~_creategroupclass();
};

_creategroupclass::_creategroupclass(View * _item, _creategroupclass * _next)
    : next(_next), item(_item)
{
}

void _creategroupclass::InsertInMenu(Group * root)
{
  root->Insert(item);
  if (next)
    next->InsertInMenu(root);
}

_creategroupclass::~_creategroupclass()
{
  delete next;
}

Group * CreateGroup(Group * root, _creategroupclass * item)
{
  if (item)
    item->InsertInMenu(root);
  delete item;
  return root;
}

_creategroupclass * CreateItem(View * item, _creategroupclass * next)
{
  return new _creategroupclass(item, next);
}

