#ifndef _Views_hh_
#define _Views_hh_

#include "FrameBuffer.hh"
#include "Event.hh"

enum Align { VAHorizontal, VAVertical };
enum ColorIndex { ciForeground, ciHighlightedFG, ciDisabledFG,
						 ciBackground, ciHighlightedBG };
const ColorIndexCount = 5;

const CommandType cmSizeChanged = 1000;
const CommandType cmCancel = 1001;
const CommandType cmDataChanged = 1002;

class Group;

class View {
  protected:
    friend class Group;
    Rectangle Area;
    View * next;
    bool Visible;
    bool Hidden;
    bool Selectable;
    bool Selected;
    bool Enabled;
    bool AutoResize;
    bool AutoCenter;
    bool IsLargest;
    Pixel_t Colors[ColorIndexCount];
    CommandType choosecommand;
    Point MinSize;    
    View();
    virtual void Draw();
    void DrawBackground();
    void SetOrigin(const Point& neworigin);
    void SetSize(const Point& newsize, bool redraw=TRUE);
    Point RelativePoint(const Point& absolute);
    virtual void Choose();
    bool IsUsedNow(ColorIndex index) const;
  public:
    Group * parent;
    virtual void Redraw();  
    virtual ~View();
    virtual void Select();
    virtual void Deselect();
    virtual bool SelectNext(bool Forward);
    virtual void Show();
    virtual void Hide();
    virtual void SetColor(const Pixel_t color, const ColorIndex index);
    Pixel_t GetColor(const ColorIndex index);
    inline const int GetX() const;
    inline const int GetY() const;
    inline const int GetW() const { return Area.Size.X; };
    inline const int GetH() const { return Area.Size.Y; };
    virtual bool HandleEvent(Event& event);
    virtual void PutEvent(Event& event);
    virtual void SetHidden(bool _hidden, bool rearrange=TRUE);
    virtual void ReArrange(bool CallParent=TRUE, View * except=0);
    void SetEnabled(bool _Enabled=TRUE);
    void SetAutoCenter(bool _AutoCenter=TRUE) { AutoCenter = _AutoCenter; };
    void SendDataChanged();
};

class SelectableView : public View {
  public:
    SelectableView();    
    bool HandleEvent(Event& event);
};

#endif
