#include "XlibImage.hh"
#include <X11/Xutil.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include "Utils.hh"

static bool DontUseShm = FALSE;

char WindowName[] = "Wormz";
char * WindowNameP = WindowName;

// nowhere defined???
extern "C" {
extern int XShmQueryExtension (Display * dpy); 
};

XDrawable::XDrawable()
{
  if (!(display = XOpenDisplay(0)))
    Die("can't open display");
  screen = DefaultScreen(display);
  visual = *DefaultVisual(display, screen);
}

XDrawable::~XDrawable()
{
  XFreeGC(display, gc);
}

void XDrawable::InitGC()
{
  // create graphics context
  XGCValues values;
  gc = XCreateGC(display, d, 0, &values);
  
  XSetBackground(display, gc, BlackPixel(display, screen));
  XSetForeground(display, gc, WhitePixel(display, screen));
  XSetFunction(display, gc, GXcopy);
  XSetPlaneMask(display, gc, (unsigned long) -1);
}

XlibMainWindow::XlibMainWindow(char ** argv, int argc)
{
  if ((argc>1) && (!strcmp(argv[1], "-noshm")))
    DontUseShm = TRUE;
  else 	
    DontUseShm = FALSE;

  d = XCreateWindow(display, XRootWindow(display, screen),
			 50, 50, WindowSizeX, WindowSizeY,
			 0, ScreenDepth,
			 InputOutput, &visual, 0, 0);
  CreateColormap();
  
  XSizeHints * sizehints = XAllocSizeHints();
  sizehints->flags = PSize | PMinSize | PMaxSize;
  sizehints->min_width = WindowSizeX;
  sizehints->min_height = WindowSizeY;
  sizehints->max_width = WindowSizeX;
  sizehints->max_height = WindowSizeY;
  
  XWMHints * wmhints = XAllocWMHints();
  wmhints->initial_state = NormalState;
  wmhints->input = TRUE;
  wmhints->flags |= StateHint | InputHint;
  wmhints->icon_pixmap = 0;
  wmhints->flags = 0;
  
  XClassHint * classhints = XAllocClassHint();
  classhints->res_name = WindowName;
  classhints->res_class = WindowName;
  XTextProperty windowname, iconname;
  XStringListToTextProperty(&WindowNameP,  1, &windowname);
  XStringListToTextProperty(&WindowNameP,  1, &iconname);  
  XSetWMProperties(display, d, &windowname, &iconname, argv, argc, sizehints, wmhints, classhints);
  
  XFree(wmhints);
  XFree(classhints);
  XFree(sizehints);
  
  InitGC();
}

void XlibMainWindow::CreateColormap()
{
#ifdef Color8
  colormap = XCreateColormap (display, d, DefaultVisual (display, XDefaultScreen (display)),
			      AllocAll);
  for(int i=0; i<256; i++) {
    XColor c;
    Pixel_t pixel;
    pixel.SetColor(i);
    c.pixel = i;
    c.red = pixel.RPixel()*256; // RPixel returns 0-255, XColor.red is 0-65535
    c.green = pixel.GPixel()*256;
    c.blue = pixel.BPixel()*256;
    c.flags = DoRed | DoGreen | DoBlue;
    XStoreColors(display, colormap, &c, 1);
  }
  XSetWindowColormap (display, d, colormap);
#endif
}

XlibMainWindow::~XlibMainWindow()
{
  XUnmapWindow(display, d);
#ifdef Color8
  XFreeColormap(display, colormap);
#endif
}

void XlibMainWindow::Show()
{
  XMapWindow(display, d);
  XFillRectangle(display, d, gc, 0, 0, WindowSizeX, WindowSizeY);  
  XSync(display, FALSE);
  XFlush(display);
}

void XlibMainWindow::Hide()
{
  XUnmapWindow(display, d);
  XSync(display, FALSE);
  XFlush(display);
}

XBuffer * XlibMainWindow::CreateXImage()
{
  if (DontUseShm || !XShmQueryExtension (display))
    return new XImageBuffer(this);
  else
    return new XSHMBuffer(this);
}

XPixmap::XPixmap(XDrawable * parent)
{
  d = XCreatePixmap(display, parent->GetDrawable(),
		    WindowSizeX, WindowSizeY, ScreenDepth);
  InitGC();
}

XBuffer * XPixmap::CreateXImage()
{
    return new XImageBuffer(this);
}

XBuffer::XBuffer(XDrawable * mainw, bool _Shared)
    : d(mainw->GetDrawable()),
  display(mainw->GetDisplay()), visual(mainw->GetVisual()),
  screen(mainw->GetScreen()), Shared(_Shared), buffer(0), image(0)
{
    // create graphics context
  XGCValues values;
  gc = XCreateGC(display, d, 0, &values);
}

XBuffer::~XBuffer()
{
  XDestroyImage(image);
  XFreeGC(display, gc);  
}

XSHMBuffer::XSHMBuffer(XDrawable* mainw)
    : XBuffer(mainw, TRUE)
{
  // create X image
  Assert(!(image = XShmCreateImage(display, &visual, ScreenDepth,
				   ZPixmap, 0, &shminfo, WindowSizeX, WindowSizeY)),
	 "can't create shared image");
  // create shared memory region
  Assert((shminfo.shmid = shmget(IPC_PRIVATE,
				WindowSizeX*WindowSizeY*sizeof(Pixel_t), IPC_CREAT | 0777)) < 0,
	 "can't create shared memory ID");
  buffer = (Pixel_t *) shmat(shminfo.shmid, 0, 0);
  shminfo.shmaddr = (char *) buffer;
  if (buffer < 0) {
    shmctl(shminfo.shmid, IPC_RMID, 0);
    Die("can't map shared memory");
  }
  // attach shared memory to X server
  shminfo.readOnly = FALSE;
  image->data = (char *) buffer;
  Assert(!XShmAttach(display, &shminfo), "can't attach to X shared memory");
  XSync(display, FALSE);
    
  // if we'll be killed, this removes the IPC memory
  shmctl(shminfo.shmid, IPC_RMID, 0);
};

XSHMBuffer::~XSHMBuffer()
{
  // delete shared memory region
  XShmDetach(display, &shminfo);
  shmctl(shminfo.shmid, IPC_RMID, 0);
}

XImageBuffer::XImageBuffer(XDrawable * mainw)
    : XBuffer(mainw, FALSE)
{
  buffer = new Pixel_t[WindowSizeX*WindowSizeY];
  Assert(!(image = XCreateImage(display, &visual, ScreenDepth,
				   ZPixmap, 0, (char *) buffer, WindowSizeX, WindowSizeY,
				BitmapPad(display), 0)),
	 "can't create shared image");
  // buffer is deleted in XDestroyImage
}

static int (* orig_errorhandler) (Display * display, XErrorEvent * e);

static int ErrorHandler(Display * /* display */, XErrorEvent * /* e */)
{
//  (* orig_errorhandler) (display, e);
  *((char *) 0) = 0;
  return 0;
}

void InstallErrorHandler()
{
  orig_errorhandler = XSetErrorHandler(ErrorHandler);
}
