#ifndef _Picture_hh_
#define _Picture_hh_

#include "GraphConfig.hh"

class Picture {
  protected:
    int W, H;
    Pixel_t * data;
    Picture(int _W=0, int _H=0, Pixel_t * _data=0) : W(_W), H(_H), data(_data) { };
  public:
    virtual ~Picture() { if (0 != data) delete data; };
    const int Width() const { return W; }
    const int Height() const { return H; }
    const Pixel_t * Data() const { return data; }
    const int OK() const { return (0 != data); };
    Picture * CreateCopy();
};

#endif
