#ifndef _Utils_hh_
#define _Utils_hh_

#include <stdio.h>
#include "Compat.hh"

int Rand(int Max);

void Die (const char * text);
void Error(const char * text);
void Print(const char * text);
void StdError(const char * text);

#define Assert(cond, text) if (cond) Die(text)
// cond != 0 => Die

inline bool between(int what, int min, int max)
{
  return (min <= what) && (what <= max);
}
class MyErrStream {
  public:
    inline MyErrStream() { };
    inline MyErrStream& operator<<(int number) { fprintf(stderr, "%i", number); return *this; };
    inline MyErrStream& operator<<(const char * text) { fprintf(stderr, "%s", text); return *this; };
};

#define nl "\n"

extern MyErrStream PrintErr;

class Point {
  public:
    int X, Y;
    Point(const int _X=0, const int _Y=0) : X(_X), Y(_Y) { };
    bool operator==(const Point& p) { return (p.X == X) && (p.Y == Y); };
};

class Rectangle {
  public:
    Point Origin, Size;
    Rectangle(const int _X=0, const int _Y=0, const int _W=0, const int _H=0)
      : Origin(_X, _Y), Size(_W, _H) { };
    bool Inside(const Point& p) const;
    bool Intersect(const Rectangle& second) const;
    const int Right() const { return Origin.X+Size.X; };
    const int Bottom() const { return Origin.Y+Size.Y; };
};

inline int Max(const int A, const int B)
{
  return (A > B) ? A : B;
}

inline int Min(const int A, const int B)
{
  return (A < B) ? A : B;
}

#endif

