#include <iostream.h>
#include <string.h>

struct TargaHeader {
  unsigned char id;
  unsigned char color_map;
  unsigned char im_type;
  char gap[9];
  unsigned short W;
  unsigned short H;
  unsigned char bpp;
  unsigned char im_des;
} ;

int main(int argc, char ** argv) {
  
  filebuf fb;
  istream is(fb.open(argv[1], "rb"));
  
  TargaHeader th;
  is.read(&th, sizeof(th));
  
  filebuf fb2;
  ostream os(fb2.open(argv[2], "w+"));

  int depth = th.bpp/8;
  
  int size = th.W*th.H;
  char * buffer = new char[size*depth];
  is.read(buffer, size*depth);
  
  typedef unsigned char uc;
//  struct _bgr { uc b; uc g; uc r; } bgr;
  struct _rgb { uc r; uc g; uc b; } rgb;
  
  for (int i=0; i<size; i++) {
    rgb = *((_rgb *)(buffer+i*depth));
    // *topnm creates FF00FF instead of 000000???
    if ((rgb.r == 0) && (rgb.g == 6) && (rgb.b == 0)) {
      rgb.r = 0;
      rgb.g = 0;
      rgb.b = 0;
    }
    *((_rgb *)(buffer+i*depth)) = rgb;
  };
  os.write(&th, sizeof(th));
  os.write(buffer, size*depth);
}
