#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <minix/com.h>
#include <minix/type.h>
#include <minix/syslib.h>

void
xf86EnableIO()
{
	int fd;

	/* IOPL is enabled when /dev/mem is opened */
	fd= open("/dev/mem", O_RDWR);
	if (fd < 0)
	{
		FatalError("xf86EnableIO: unable to open /dev/mem: %s\n",
			strerror(errno));
	}
	close(fd);
}
	
void
xf86DisableIO()
{
}

int
xf86DisableInterrupts()
{
	intr_disable();

	return 1;
}

void
xf86EnableInterrupts()
{
	intr_enable();
}

