#define NEED_EVENTS
#include "X.h"

/* #include "compiler.h" */

#include "xf86.h"
#include "xf86Priv.h"
#include "xf86_OSlib.h"

#include "xf86Xinput.h"
#include "xf86OSKbd.h"
/* #include "atKeynames.h" */
#include "mnx3_kbd.h"

#include <sys/ioctl.h>
#include <sys/kbdio.h>

typedef struct
{
	int dummy;
} Mnx3KbdPrivRec, *Mnx3KbdPrivPtr;
static int kbdFd= -1;

static KbdProtocolRec protocols[] = {
   {"standard", PROT_STD },
   { NULL, PROT_UNKNOWN_KBD }
};

int
xf86KbdOff()
{
	if (kbdFd != -1)
	{
		close(kbdFd);
		kbdFd= -1;
	}
	return kbdFd;
}


static
int KbdInit(InputInfoPtr pInfo, int what)
{
    KbdDevPtr pKbd = (KbdDevPtr) pInfo->private;
    Mnx3KbdPrivPtr priv = (Mnx3KbdPrivPtr) pKbd->private;

#if 0
         tcgetattr(pInfo->fd, &(priv->kbdtty));
#endif

    return Success;
}

static int
KbdOn(InputInfoPtr pInfo, int what)
{
    KbdDevPtr pKbd = (KbdDevPtr) pInfo->private;
    Mnx3KbdPrivPtr priv = (Mnx3KbdPrivPtr)pKbd->private;

    if (kbdFd != -1)
	FatalError("KbdOn: kbdFd = %d\n", kbdFd);
    if (pInfo->fd != -1)
	FatalError("KbdOn: pInfo->fd = %d\n", pInfo->fd);
    kbdFd= pInfo->fd= open("/dev/kbd", O_RDONLY);
    if (pInfo->fd == -1)
    {
	FatalError("KbdOn: unable to open /dev/kbd: %s\n", strerror(errno));
    }
    return Success;
}

static int
KbdOff(InputInfoPtr pInfo, int what)
{
	KbdDevPtr pKbd = (KbdDevPtr) pInfo->private;
	Mnx3KbdPrivPtr priv = (Mnx3KbdPrivPtr) pKbd->private;

	if (kbdFd == -1)
		FatalError("KbdOff: kbdFd = -1\n");
	if (pInfo->fd == -1)
		FatalError("KbdOff: pInfo->fd = -1\n");
	close(kbdFd);
	kbdFd= pInfo->fd= -1;
	return Success;
}


static void
SoundBell(InputInfoPtr pInfo, int loudness, int pitch, int duration)
{
    KbdDevPtr pKbd = (KbdDevPtr) pInfo->private;
    kio_bell_t bell;

    bell.kb_pitch= pitch;
    bell.kb_volume= 1000000 / 100 * loudness;
    bell.kb_duration.tv_sec= duration / 1000;
    bell.kb_duration.tv_usec= (duration % 1000) * 1000;

    if (loudness && pitch)
	ioctl(pInfo->fd, KIOCBELL, &bell);
}

static void
SetKbdLeds(InputInfoPtr pInfo, int leds)
{
    KbdDevPtr pKbd = (KbdDevPtr) pInfo->private;
    kio_leds_t real_leds;

    real_leds.kl_bits= 0;

    if (leds & XLED1)  real_leds.kl_bits |= KBD_LEDS_CAPS;
    if (leds & XLED2)  real_leds.kl_bits |= KBD_LEDS_NUM;
    if (leds & XLED3)  real_leds.kl_bits |= KBD_LEDS_SCROLL;
    if (leds & XLED4)  real_leds.kl_bits |= KBD_LEDS_SCROLL;

    ioctl(pInfo->fd, KIOCSLEDS, &real_leds);
}

static int
GetKbdLeds(InputInfoPtr pInfo)
{
    FatalError("GetKbdLeds not implemented");
#if 0
    KbdDevPtr pKbd = (KbdDevPtr) pInfo->private;
    int leds = 0, real_leds = 0;

    switch (pKbd->consType) {
	case PCCONS:
	     break;
#if defined (SYSCONS_SUPPORT) || defined (PCVT_SUPPORT)
	case SYSCONS:
	case PCVT:
	     ioctl(pInfo->fd, KDGETLED, &real_leds);
	     break;
#endif
#if defined(WSCONS_SUPPORT)
        case WSCONS:
             ioctl(pInfo->fd, WSKBDIO_GETLEDS, &real_leds);
             break;
#endif
    }

    if (real_leds & LED_CAP) leds |= XLED1;
    if (real_leds & LED_NUM) leds |= XLED2;
    if (real_leds & LED_SCR) leds |= XLED3;

    return(leds);
#endif
}

static void
SetKbdRepeat(InputInfoPtr pInfo, char rad)
{
    ErrorF("SetKbdRepeat not implemented\n");
#if 0
    KbdDevPtr pKbd = (KbdDevPtr) pInfo->private;
    switch (pKbd->consType) {

	case PCCONS:
		break;
#if defined (SYSCONS_SUPPORT) || defined (PCVT_SUPPORT)
	case SYSCONS:
	case PCVT:
		ioctl(pInfo->fd, KDSETRAD, rad);
		break;
#endif
    }
#endif
}

#define ModifierSet(k) ((modifiers & (k)) == (k))

static
Bool SpecialKey(InputInfoPtr pInfo, int key, Bool down, int modifiers)
{
    return FALSE;
#if 0
  KbdDevPtr pKbd = (KbdDevPtr) pInfo->private;

  if(!pKbd->vtSwitchSupported)
      return FALSE;

  if ((ModifierSet(ControlMask | AltMask)) ||
      (ModifierSet(ControlMask | AltLangMask))) {
      if (VTSwitchEnabled && !xf86Info.vtSysreq && !xf86Info.dontVTSwitch) {
         switch (key) {
             case KEY_F1:
             case KEY_F2:
             case KEY_F3:
             case KEY_F4:
             case KEY_F5:
             case KEY_F6:
             case KEY_F7:
             case KEY_F8:
             case KEY_F9:
             case KEY_F10:
                  if (down) {
                    ioctl(xf86Info.consoleFd, VT_ACTIVATE, key - KEY_F1 + 1);
                    return TRUE;
                  }
             case KEY_F11:
             case KEY_F12:
                  if (down) {
                    ioctl(xf86Info.consoleFd, VT_ACTIVATE, key - KEY_F11 + 11);
                    return TRUE;
                  }
         }
      }
    }
#ifdef USE_VT_SYSREQ
    if (VTSwitchEnabled && xf86Info.vtSysreq && !xf86Info.dontVTSwitch) {
        switch (key) {
            case KEY_F1:
            case KEY_F2:
            case KEY_F3:
            case KEY_F4:
            case KEY_F5:
            case KEY_F6:
            case KEY_F7:
            case KEY_F8:
            case KEY_F9:
            case KEY_F10:
                 if (VTSysreqToggle && down) {
                     ioctl(xf86Info.consoleFd, VT_ACTIVATE, key - KEY_F1 + 1);
                     VTSysreqToggle = FALSE;
                     return TRUE;
                 }
                 break;
            case KEY_F11:
            case KEY_F12:
                 if (VTSysreqToggle && down) {
                     ioctl(xf86Info.consoleFd, VT_ACTIVATE, key - KEY_F11 + 11);
                     VTSysreqToggle = FALSE;
                     return TRUE;
                 }
                 break;
            /* Ignore these keys -- ie don't let them cancel an alt-sysreq */
            case KEY_Alt:
            case KEY_AltLang:
                 break;
            case KEY_SysReqest:
                 if ((ModifierSet(AltMask) || ModifierSet(AltLangMask)) && down)
                     VTSysreqToggle = TRUE;
                 break;
            default:
                 /*
                  * We only land here when Alt-SysReq is followed by a
                  * non-switching key.
                  */
                 if (VTSysreqToggle)
                     VTSysreqToggle = FALSE;
        }
    }
#endif /* USE_VT_SYSREQ */

    return FALSE;
#endif
}

static void
stdReadInput(InputInfoPtr pInfo)
{
    KbdDevPtr pKbd = (KbdDevPtr) pInfo->private;
    unsigned char rBuf[64];
    int nBytes, i;
    if ((nBytes = read( pInfo->fd, (char *)rBuf, sizeof(rBuf))) > 0) {
	for (i = 0; i < nBytes; i++)
	{
	   pKbd->PostEvent(pInfo, rBuf[i] & 0x7f,
                           rBuf[i] & 0x80 ? FALSE : TRUE);
	}
    }
}

static Bool
OpenKeyboard(InputInfoPtr pInfo)
{
    KbdDevPtr pKbd = (KbdDevPtr) pInfo->private;
    int i;
    KbdProtocolId prot = PROT_UNKNOWN_KBD;
    char *s;

    s = xf86SetStrOption(pInfo->options, "Protocol", NULL);
    for (i = 0; protocols[i].name; i++) {
        if (xf86NameCmp(s, protocols[i].name) == 0) {
           prot = protocols[i].id;
           break;
        }
    }

    switch (prot) {
    	case PROT_STD:
           pInfo->read_input = stdReadInput;
           break;
        default:
           xf86Msg(X_ERROR,"\"%s\" is not a valid keyboard protocol name\n", s);
           xfree(s);
           return FALSE;
    }
    xf86Msg(X_CONFIG, "%s: Protocol: %s\n", pInfo->name, s);
    xfree(s);

    s = xf86SetStrOption(pInfo->options, "Device", NULL);
    if (s == NULL) {
       if (prot == PROT_WSCONS) {
           xf86Msg(X_ERROR,"A \"device\" option is required with"
                                  " the \"wskbd\" keyboard protocol\n");
           return FALSE;
       } else {
           pInfo->fd = xf86Info.consoleFd;
           pKbd->isConsole = TRUE;
           /* pKbd->consType = xf86Info.consType; */
       }
    } else {
	pInfo->fd = open(s, O_RDONLY | O_NONBLOCK | O_EXCL);
       if (pInfo->fd == -1) {
           xf86Msg(X_ERROR, "%s: cannot open \"%s\"\n", pInfo->name, s);
           xfree(s);
           return FALSE;
       }
       pKbd->isConsole = FALSE;
       /* pKbd->consType = xf86Info.consType; */
       xfree(s);
    }

#ifdef WSCONS_SUPPORT
    if( prot == PROT_WSCONS) {
       pKbd->consType = WSCONS;
       /* Find out keyboard type */
       if (ioctl(pInfo->fd, WSKBDIO_GTYPE, &(pKbd->wsKbdType)) == -1) {
           xf86Msg(X_ERROR, "%s: cannot get keyboard type", pInfo->name);
           close(pInfo->fd);
           return FALSE;
       }
       switch (pKbd->wsKbdType) {
           case WSKBD_TYPE_PC_XT:
               printWsType("XT", pInfo->name);
               break;
           case WSKBD_TYPE_PC_AT:
               printWsType("AT", pInfo->name);
               break;
           case WSKBD_TYPE_USB:
               printWsType("USB", pInfo->name);
               break;
#ifdef WSKBD_TYPE_ADB
           case WSKBD_TYPE_ADB:
               printWsType("ADB", pInfo->name);
               break;
#endif
#ifdef WSKBD_TYPE_SUN
           case WSKBD_TYPE_SUN:
               printWsType("Sun", pInfo->name);
               break;
#endif
#ifdef WSKBD_TYPE_SUN5
     case WSKBD_TYPE_SUN5:
	     xf86Msg(X_PROBED, "Keyboard type: Sun5\n");
	     break;
#endif
           default:
               xf86Msg(X_ERROR, "%s: Unsupported wskbd type \"%d\"",
                                pInfo->name, pKbd->wsKbdType);
               close(pInfo->fd);
               return FALSE;
       }
    }
#endif
    return TRUE;
}


Bool
xf86OSKbdPreInit(InputInfoPtr pInfo)
{
    KbdDevPtr pKbd = pInfo->private;

    pKbd->KbdInit	= KbdInit;
    pKbd->KbdOn		= KbdOn;
    pKbd->KbdOff	= KbdOff;
    pKbd->Bell		= SoundBell;
    pKbd->SetLeds	= SetKbdLeds;
    pKbd->GetLeds	= GetKbdLeds;
    pKbd->SetKbdRepeat	= SetKbdRepeat;
    pKbd->KbdGetMapping	= KbdGetMapping;
    pKbd->SpecialKey	= SpecialKey;

    pKbd->RemapScanCode = NULL;
    pKbd->GetSpecialKey = NULL;

    pKbd->OpenKeyboard = OpenKeyboard;
    pKbd->vtSwitchSupported = FALSE;
    pKbd->CustomKeycodes = FALSE;
    
    pKbd->private = xcalloc(sizeof(Mnx3KbdPrivRec), 1);
    if (pKbd->private == NULL) {
       xf86Msg(X_ERROR,"can't allocate keyboard OS private data\n");
       return FALSE;
    }
    return TRUE;
}
