#!/bin/sh

PATH=${PWD}/../src:${PATH}
chmod +x ../src/acr ../src/acr-sh

ERROR=0

for A in ../examples/*.acr ; do
	echo "[*] generating ${A} "
	cp ${A} configure.acr
	acr -p >/dev/null
	if [ "$?" = "0" ]; then
		echo "[>] executing ${A}"
		./configure 2>/dev/null > /dev/null
		echo ""
	else
		echo "[FAILED]"
		acr >/dev/null
		ERROR=1
	fi
	rm configure.acr
done
echo "==> Cleaning..."
rm -f `ls | egrep -v "test.sh|CVS"`

if [ "${ERROR}" = "0" ]; then
	echo "OK: All tests has passed fine"
else
	echo "ERROR: One or more tests has failed"
fi

exit ${ERROR}
