// cpu.cpp
// Revision 10-mar-2004

#include "cpu.h"

#include <assert.h>
#define ASSERT assert
#include <iostream>
using std::cerr;
using std::endl;

// Static vars.

std::vector <Cpu *> Cpu::vi;

Cpu::Cpu () :
	self (putvi (this) )
{
	#if ! defined USE_ImcZ80 || defined DISASM_WITH_libz80

	// Initialize Z80Context
	z.memRead= & memread;
	z.memWrite= & memwrite;
	z.memParam= self;
	z.ioRead= & ioread;
	z.ioWrite= & iowrite;
	z.ioParam= self;
	cerr << "Z80Context initialized" << endl;

	#endif

	cerr << "Cpu initialized, memory at " <<
		static_cast <void *> (mem) << endl;
}

Cpu::~Cpu ()
{
	vi [self]= NULL;
}

int Cpu::putvi (Cpu * p)
{
	int i= vi.size ();
	vi.push_back (p);
	return i;
}

byte Cpu::memread (int param, ushort address)
{
	ASSERT (vi [param]->self == param);
	return vi [param]->memread (address);
}

void Cpu::memwrite (int param, ushort address, byte data)
{
	ASSERT (vi [param]->self == param);
	vi [param]->memwrite (address, data);
}

byte Cpu::ioread (int, ushort)
{
	return 0;
}

void Cpu::iowrite (int, ushort, byte)
{
	// Does nothing
}

byte Cpu::memread (ushort address) const
{
	byte b= mem [address];
	return b;
}

ushort Cpu::memreadw (ushort address) const
{
	ushort v= mem [address] | (ushort (mem [address + 1] ) << 8);
	return v;
}

void Cpu::memwrite (ushort address, byte data)
{
	mem [address]= data;
}

void Cpu::memwritew (ushort address, ushort data)
{
	mem [address + 0]= data & 0xFF;
	mem [address + 1]= data >> 8;
}

namespace {
static char hexdigit []= "0123456789ABCDEF";
} // namespace

std::ostream & operator << (std::ostream & os, const Hex2 & h2)
{
	byte b= h2.getb ();
	os << hexdigit [(b >> 4) & 0x0F] << hexdigit [b & 0x0F];
	return os;
}

std::ostream & operator << (std::ostream & os, const Hex4 & h4)
{
	ushort n= h4.getn ();
	os << hexdigit [(n >> 12) & 0x0F] << hexdigit [(n >> 8) & 0x0F] <<
		hexdigit [(n >> 4) & 0x0F] << hexdigit [n & 0x0F];
	return os;
}

// End of cpu.cpp
