# Greek language file.
#
# (C) 2003-2007 Anope Team
# Contact us at info@anope.org
#
# Please read COPYING and README for furhter details.
#
# Based on the original code of Epona by Lara.
# Based on the original code of Services by Andy Church.
#
# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, let us know
# (dev@anope.org) which message is causing a problem and I'll see
# what I can do.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# services.conf).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	 (Greek)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%b %d %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %b %d %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%b %d %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	
	
	
	
	
	
	
# %A
STRFTIME_DAYS_LONG
	
	
	
	
	
	
	
# %b
STRFTIME_MONTHS_SHORT
	
	
	
	
	
	
	
	
	
	
	
	
# %B
STRFTIME_MONTHS_LONG
	
	
	
	
	
	
	
	
	
	
	
	


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	, 


# Various error messages.
USER_RECORD_NOT_FOUND
	  -    .
UNKNOWN_COMMAND
	  %s.
UNKNOWN_COMMAND_HELP
	  %s.  "%R%s HELP"  .
SYNTAX_ERROR
	 : %s
MORE_INFO
	%R%s HELP %s   .
NO_HELP_AVAILABLE
	     %s.
OBSOLETE_COMMAND
	    ;  %s   .

BAD_USERHOST_MASK
	       user@host.
BAD_EXPIRY_TIME
	  .
USERHOST_MASK_TOO_WIDE
	%s     ;      .

SERVICE_OFFLINE
	 %s     off.
READ_ONLY_MODE
	:     ;      !
PASSWORD_INCORRECT
	 .
INVALID_TARGET
	"/msg %s" is no longer supported.  Use "/msg %s@%s" or "/%s" instead.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	    .
PERMISSION_DENIED
	  .
RAW_DISABLED
	The RAW option has been disabled. If you must use it, enable the DisableRaw directive in Services configuration.

MORE_OBSCURE_PASSWORD
	       .         ,       (..        ),         .
PASSWORD_TRUNCATED
	:       %d .

NICK_NOT_REGISTERED
	     .
NICK_NOT_REGISTERED_HELP
	     .   %R%s HELP        ..
NICK_X_IS_SERVICES
	Nick %s is part of this Network's Services.
NICK_X_NOT_REGISTERED
	   %s   .
NICK_X_IN_USE
	Nick %s is currently in use.
NICK_X_NOT_IN_USE
	   %s     .
NICK_X_NOT_ON_CHAN
	%s         %s.
NICK_X_FORBIDDEN
	   %s       .
NICK_X_FORBIDDEN_OPER
	   %s     %s:
	%s
NICK_X_ILLEGAL
	Nick %s is an illegal nickname and cannot be used.
NICK_X_TRUNCATED
	Nick %s was truncated to %d characters.
NICK_X_SUSPENDED
	Nick %s is currently suspended.
CHAN_X_NOT_REGISTERED
	   %s   .
CHAN_X_NOT_IN_USE
	   %s  .
CHAN_X_FORBIDDEN
	   %s       .
CHAN_X_FORBIDDEN_OPER
	   %s     %s:
	%s
CHAN_X_SUSPENDED
	      Suspended: [%s] %s
NICK_IDENTIFY_REQUIRED
	       .
	   %R%s IDENTIFY ^_^_.
CHAN_IDENTIFY_REQUIRED
	       .
	   %R%s IDENTIFY %s ^_^_.
	
MAIL_DISABLED
	         .
MAIL_INVALID
	   %s  .
MAIL_X_INVALID
	%s    .
MAIL_LATER
	          ;    .
MAIL_DELAYED
	  ^B%d^B   .
	
NO_REASON
	 
UNKNOWN
	<>

# Duration system
DURATION_DAY
	1 
DURATION_DAYS
	%d 
DURATION_HOUR
	1 
DURATION_HOURS
	%d 
DURATION_MINUTE
	1 
DURATION_MINUTES
	%d 
DURATION_SECOND
	1 
DURATION_SECONDS
	%d 

# Human readable expiration
NO_EXPIRE
	  
EXPIRES_SOON
	    
EXPIRES_M
	   %d 
EXPIRES_1M
	   %d 
EXPIRES_HM
	   %d , %d 
EXPIRES_H1M
	   %d , %d 
EXPIRES_1HM
	   %d , %d 
EXPIRES_1H1M
	   %d , %d 
EXPIRES_D
	   %d 
EXPIRES_1D
	   %d 

# Generic Footer message
END_OF_ANY_LIST
	End of %s list.

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
LIST_INCORRECT_RANGE
	Incorrect range specified. The correct syntax is #from-to.
CS_LIST_INCORRECT_RANGE
	To search for channels starting with #, search for the channel
	name without the #-sign prepended (anope instead of #anope).

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
HELP_LIMIT_SERV_OPER
	Limited to Services Operators.
HELP_LIMIT_SERV_ADMIN
	Limited to Services Administrators.
HELP_LIMIT_SERV_ROOT
	Limited to Services Roots.
HELP_LIMIT_IRC_OPER
	Limited to IRC Operators.
HELP_LIMIT_HOST_SETTER
	Limited to Host Setters.
HELP_LIMIT_HOST_REMOVER
	Limited to Host Removers.


###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	      .     .
	(     ,  %R%s IDENTIFY ^_^_.)
NICK_IS_SECURE
	      .     
	 ,  %R%s IDENTIFY ^_^_.  ,
	    .
NICK_MAY_NOT_BE_USED
	      .     .
FORCENICKCHANGE_IN_1_MINUTE
	         ,     .
FORCENICKCHANGE_IN_20_SECONDS
	        20 ,     .
FORCENICKCHANGE_NOW
	     ;     .
FORCENICKCHANGE_CHANGING
	      %s

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER ^_^_ [^_email^_]	
NICK_REGISTER_SYNTAX_EMAIL
	REGISTER ^_^_ ^_email^_
NICK_REGISTRATION_DISABLED
	,         .
NICK_REGISTRATION_FAILED
	,   .
NICK_REG_PLEASE_WAIT
	  %d        .
NICK_CANNOT_BE_REGISTERED
	   %s    .
NICK_ALREADY_REGISTERED
	   %s   !
NICK_REGISTERED
	   %s     : %s
NICK_REGISTERED_NO_MASK
	Nickname %s registered.
NICK_PASSWORD_IS
	    %s -     .

# GROUP responses
NICK_REG_DELAY
	You have to be connected longer than %d seconds to register your nick.

# GROUP responses
NICK_GROUP_SYNTAX
	GROUP ^_^_ ^_^_
NICK_GROUP_DISABLED
	,          .
NICK_GROUP_FAILED
	,          .
NICK_GROUP_PLEASE_WAIT
	  %d       .
NICK_GROUP_CHANGE_DISABLED
	     ;  %R%s DROP .
NICK_GROUP_SAME
	      %s.
NICK_GROUP_TOO_MANY
	     %s's ;     .
	 ^B%R%s HELP GLIST^B  %R%s HELP DROP 
	  .
NICK_GROUP_JOINED
	      %s.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY ^_^_
NICK_IDENTIFY_FAILED
	,   .
NICK_IDENTIFY_SUCCEEDED
	    -   .
NICK_IDENTIFY_EMAIL_REQUIRED
	    e-mail    .
	   e-mail        
	   .
NICK_IDENTIFY_EMAIL_HOWTO
	 %R%S SET EMAIL ^_e-mail^_     e-mail     .
	   ;   e-mail         
	  .
	
# LOGOUT responses
NICK_ALREADY_IDENTIFIED
	You are already identified.

# UPDATE responses
NICK_UPDATE_SUCCESS
	Status updated (memos, vhost, chmodes, flags).
	
# LOGOUT responses
NICK_LOGOUT_SYNTAX
	LOGOUT
NICK_LOGOUT_SUCCEEDED
	      ,         .
NICK_LOGOUT_X_SUCCEEDED
	   %s     .

# DROP responses
NICK_LOGOUT_SERVICESADMIN
	Can't logout %s because he's a services administrator.

# DROP responses
NICK_DROP_DISABLED
	,          .
NICK_DROPPED
	       .
NICK_X_DROPPED
	  %s     .

# SET responses
NICK_SET_SYNTAX
	SET ^_^_ ^_^_
NICK_SET_SERVADMIN_SYNTAX
	SET [^_^_] ^_^_ ^_^_
NICK_SET_DISABLED
	,               .
NICK_SET_UNKNOWN_OPTION
	 SET  %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	 SET  %s,      .
NICK_SET_OPTION_DISABLED
	  %s       .

# SET DISPLAY responses
NICK_SET_DISPLAY_INVALID
	            !
NICK_SET_DISPLAY_CHANGED
	     %s.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	,      .
NICK_SET_PASSWORD_CHANGED
	  .
NICK_SET_PASSWORD_CHANGED_TO
	    %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE ^_number^_
NICK_SET_LANGUAGE_UNKNOWN
	   %d.   %R%s HELP SET LANGUAGE      .
NICK_SET_LANGUAGE_CHANGED
	    .

# SET URL responses
NICK_SET_URL_CHANGED
	URL   %s.
NICK_SET_URL_UNSET
	URL  .

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	   e-mail   %s.
NICK_SET_EMAIL_UNSET
	   e-mail .
NICK_SET_EMAIL_UNSET_IMPOSSIBLE
	       e-mail    .
	
# SET ICQ responses
NICK_SET_ICQ_CHANGED
	   ICQ   %s.
NICK_SET_ICQ_UNSET
	   ICQ .
NICK_SET_ICQ_INVALID
	%s    .
	
# SET GREET responses
NICK_SET_GREET_CHANGED
	     %s.
NICK_SET_GREET_UNSET
	    .

# SET PROTECT responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	     ON.
NICK_SET_KILL_QUICK
	     ON,        .
NICK_SET_KILL_IMMED
	     ON,       .
NICK_SET_KILL_IMMED_DISABLED
	 IMMED        .
NICK_SET_KILL_OFF
	     OFF.

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	     ON.
NICK_SET_SECURE_OFF
	     OFF.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	     ON.
NICK_SET_PRIVATE_OFF
	     OFF.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	   e-mail     %s INFO 
NICK_SET_HIDE_EMAIL_OFF
	   -mail    %s INFO .
NICK_SET_HIDE_MASK_ON
	     user@host  %s INFO .
NICK_SET_HIDE_MASK_OFF
	    user@host  %s INFO .
NICK_SET_HIDE_QUIT_ON
	             %s INFO .
NICK_SET_HIDE_QUIT_OFF
	            %s INFO .
	
# SET MSG responses
NICK_SET_HIDE_STATUS_ON
	Your services access status will now be hidden from %s INFO displays.
NICK_SET_HIDE_STATUS_OFF
	Your services access status will now be shown in %s INFO displays.
	
# SET MSG responses
NICK_SET_MSG_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_MSG_ON
	      messages.
NICK_SET_MSG_OFF
	      notices.

# SET AUTOOP responses
NICK_SET_AUTOOP_SYNTAX
	SET AUTOOP {ON | OFF}
NICK_SET_AUTOOP_ON
	Services will now autoop you in channels.
NICK_SET_AUTOOP_OFF
	Services will no longer autoop you in channels.

# SET NOEXPIRE responses
NICK_SASET_SYNTAX
	SASET nickname option parameters
NICK_SASET_DISABLED
	Sorry, nickname option setting is temporarily disabled.
NICK_SASET_UNKNOWN_OPTION
	Unknown SASET option %s.
NICK_SASET_BAD_NICK
	Nickname %s not registered.
NICK_SASET_OPTION_DISABLED
	Option %s cannot be set on this network.

# SASET DISPLAY responses
NICK_SASET_DISPLAY_INVALID
	The new display for %s MUST be a nickname of the nickname group!
NICK_SASET_DISPLAY_CHANGED
	The new display is now %s.

# SASET PASSWORD responses
NICK_SASET_PASSWORD_FAILED
	Sorry, couldn't change password for %s.
NICK_SASET_PASSWORD_CHANGED
	Password for %s changed.
NICK_SASET_PASSWORD_CHANGED_TO
	Password for %s changed to %s.

# SASET LANGUAGE responses
NICK_SASET_URL_CHANGED
	URL for %s changed to %s.
NICK_SASET_URL_UNSET
	URL %s unset.

# SASET EMAIL responses
NICK_SASET_EMAIL_CHANGED
	E-mail address for %s changed to %s.
NICK_SASET_EMAIL_UNSET
	E-mail address for %s unset.
NICK_SASET_EMAIL_UNSET_IMPOSSIBLE
	You cannot unset the e-mail on this network.
	
# SASET ICQ responses
NICK_SASET_ICQ_CHANGED
	ICQ number for %s set to %s.
NICK_SASET_ICQ_UNSET
	ICQ number for %s unset.
NICK_SASET_ICQ_INVALID
	%s is not a valid number.
	
# SASET GREET responses
NICK_SASET_GREET_CHANGED
	Greet message for %s changed to %s.
NICK_SASET_GREET_UNSET
	Greet message for %s unset.

# SASET PROTECT responses
NICK_SASET_KILL_SYNTAX
	SASET nickname KILL {ON | QUICK | OFF}
NICK_SASET_KILL_IMMED_SYNTAX
	SASET nickname KILL {ON | QUICK | IMMED | OFF}
NICK_SASET_KILL_ON
	Protection is now ON for %s.
NICK_SASET_KILL_QUICK
	Protection is now ON for %s, with a reduced delay.
NICK_SASET_KILL_IMMED
	Protection is now ON for %s, with no delay.
NICK_SASET_KILL_IMMED_DISABLED
	The IMMED option is not available on this network.
NICK_SASET_KILL_OFF
	Protection is now OFF for %s.

# SASET SECURE responses
NICK_SASET_SECURE_SYNTAX
	SASET nickname SECURE {ON | OFF}
NICK_SASET_SECURE_ON
	Secure option is now ON for %s.
NICK_SASET_SECURE_OFF
	Secure option is now OFF for %s.

# SASET PRIVATE responses
NICK_SASET_PRIVATE_SYNTAX
	SASET nickname PRIVATE {ON | OFF}
NICK_SASET_PRIVATE_ON
	Private option is now ON for %s.
NICK_SASET_PRIVATE_OFF
	Private option is now OFF for %s.

# SASET HIDE responses
NICK_SASET_HIDE_SYNTAX
	SET nickname HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SASET_HIDE_EMAIL_ON
	The E-mail address of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_EMAIL_OFF
	The E-mail address of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_MASK_ON
	The last seen user@host mask of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_MASK_OFF
	The last seen user@host mask of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_QUIT_ON
	The last quit message of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_QUIT_OFF
	The last quit message of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_STATUS_ON
	The services access status of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_STATUS_OFF
	The services access status of %s will now be shown in %s INFO displays.
	
# SASET MSG responses
NICK_SASET_MSG_SYNTAX
	SSAET nickname PRIVATE {ON | OFF}
NICK_SASET_MSG_ON
	Services will now reply to %s with messages.
NICK_SASET_MSG_OFF
	Services will now reply to %s with notices.

# SET NOEXPIRE responses
NICK_SASET_NOEXPIRE_SYNTAX
	SASET nickname NOEXPIRE {ON | OFF}
NICK_SASET_NOEXPIRE_ON
	Nick %s will not expire.
NICK_SASET_NOEXPIRE_OFF
	Nick %s will expire.

# ACCESS responses
NICK_SASET_AUTOOP_SYNTAX
	SASET nickname AUTOOP {ON | OFF}
NICK_SASET_AUTOOP_ON
	Services will now autoop %s in channels.
NICK_SASET_AUTOOP_OFF
	Services will no longer autoop %s in channels.


# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [mask]
NICK_ACCESS_ALREADY_PRESENT
	  %s      .
NICK_ACCESS_REACHED_LIMIT
	,     %d     .
NICK_ACCESS_ADDED
	%s      .
NICK_ACCESS_NOT_FOUND
	%s      .
NICK_ACCESS_DELETED
	%s      .
NICK_ACCESS_LIST
	 :
NICK_ACCESS_LIST_X
	   %s:
NICK_ACCESS_LIST_EMPTY
	Your access list is empty.
NICK_ACCESS_LIST_X_EMPTY
	Access list for %s is empty.

# Status messages
NICK_STATUS_0
	STATUS %s 0
NICK_STATUS_1
	STATUS %s 1
NICK_STATUS_2
	STATUS %s 2
NICK_STATUS_3
	STATUS %s 3

# INFO responses
NICK_INFO_SYNTAX
	INFO nick [ALL]
NICK_INFO_REALNAME
	%s  %s
NICK_INFO_SERVICES_OPER
	%s     .
NICK_INFO_SERVICES_ADMIN
	%s     .
NICK_INFO_SERVICES_ROOT
	%s is a services root administrator.
NICK_INFO_ADDRESS
	 : %s
NICK_INFO_ADDRESS_ONLINE
	     : %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s     .
NICK_INFO_TIME_REGGED
	      : %s
NICK_INFO_LAST_SEEN
	        : %s
NICK_INFO_LAST_QUIT
	  : %s
NICK_INFO_URL
	              URL: %s
NICK_INFO_EMAIL
	   E-mail : %s
NICK_INFO_VHOST
	            vhost: %s
NICK_INFO_VHOST2
	            vhost: %s@%s
NICK_INFO_ICQ
	            ICQ #: %d
NICK_INFO_GREET
	     : %s
NICK_INFO_OPTIONS
	          : %s
NICK_INFO_EXPIRE
	Expires in: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	
NICK_INFO_OPT_SECURE
	
NICK_INFO_OPT_PRIVATE
	
NICK_INFO_OPT_MSG
	 
NICK_INFO_OPT_AUTOOP
	Auto-op
NICK_INFO_OPT_NONE
	
NICK_INFO_NO_EXPIRE
	      .
NICK_INFO_FOR_MORE
	  ,  %R%s INFO %s ALL.

# LIST responses
NICK_INFO_SUSPENDED
	This nickname is currently suspended, reason: %s
NICK_INFO_SUSPENDED_NO_REASON
	This nickname is currently suspended

# LIST responses
NICK_LIST_SYNTAX
	LIST pattern
NICK_LIST_SERVADMIN_SYNTAX
	LIST pattern [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
NICK_LIST_HEADER
	      %s:
NICK_LIST_RESULTS
	   - %d/%d   .

# GLIST responses
NICK_ALIST_SYNTAX
	ALIST nickname
NICK_ALIST_HEADER
	Channels that you have access on:
	  Num  Channel              Level    Description 
NICK_ALIST_HEADER_X
	Channels that %s has access on:
	  Num  Channel              Level    Description 
NICK_ALIST_XOP_FORMAT
	  %3d %c%-20s %-8s %s
NICK_ALIST_ACCESS_FORMAT
	  %3d %c%-20s %-8d %s
NICK_ALIST_FOOTER
	   - %d/%d   .

# GLIST responses
NICK_GLIST_HEADER
	      :
NICK_GLIST_HEADER_X
	        %s:
NICK_GLIST_FOOTER
	%d    .
NICK_GLIST_REPLY
	   %c%s
NICK_GLIST_REPLY_ADMIN
	   %c%s (expires in %s)

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER nickname [password]
NICK_NO_RECOVER_SELF
	      !
NICK_RECOVERED
	 kill        .
	%R%s RELEASE %s            .

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE nickname [password]
NICK_RELEASE_NOT_HELD
	  %s  ..
NICK_RELEASED
	     .

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST nickname [password]
NICK_NO_GHOST_SELF
	      !
NICK_GHOST_KILLED
	    kill  ghost .

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS nickname
NICK_GETPASS_UNAVAILABLE
	 GETPASS        .
NICK_GETPASS_PASSWORD_IS
	    %s  %s.

# SENDPASS responses
NICK_GETEMAIL_SYNTAX
	GETEMAIL user@email-host No WildCards!!
NICK_GETEMAIL_EMAILS_ARE
	Emails Match %s to %s.
NICK_GETEMAIL_NOT_USED
	No Emails listed for %s.
	
# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS nickname
NICK_SENDPASS_UNAVAILABLE
	 SENDPASS        .
NICK_SENDPASS_SUBJECT
	    (%s)
NICK_SENDPASS_HEAD
	,
NICK_SENDPASS_LINE_1
	           %s  e-mail.
NICK_SENDPASS_LINE_2
	    %s   ,                 e-mail.
NICK_SENDPASS_LINE_3
	      e-mail   ,      .
NICK_SENDPASS_LINE_4
	      E-MAIL!
NICK_SENDPASS_LINE_5
	%s  .
NICK_SENDPASS_OK
	   %s  .

# FORBID responses
NICK_SUSPEND_SYNTAX
	SUSPEND nickname reason
NICK_SUSPEND_SUCCEEDED
	Nick %s is now suspended.
NICK_SUSPEND_FAILED
	Couldn't suspend nick %s!

# UNSUSPEND responses
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND nickname
NICK_UNSUSPEND_SUCCEEDED
	Nick %s is now released.
NICK_UNSUSPEND_FAILED
	Couldn't release nick %s!

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID nickname [reason]
NICK_FORBID_SYNTAX_REASON
	FORBID nickname reason
NICK_FORBID_SUCCEEDED
	  %s   .
NICK_FORBID_FAILED
	       %s!

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
NICK_REQUESTED
	This nick has already been requested, please check your e-mail address for the pass code
NICK_REG_RESENT
	Your passcode has been re-sent to %s.
NICK_REG_UNABLE
	Nick NOT registered, please try again later.
NICK_IS_PREREG
	This nick is awaiting an e-mail verification code before completing registration.
NICK_ENTER_REG_CODE
	A passcode has been sent to %s, please type %R%s confirm <passcode> to complete registration
NICK_CONFIRM_NOT_FOUND
	Registration step 1 may have expired, please use "%R%s register <password> <email>" first.
NICK_CONFIRM_INVALID
	Invalid passcode has been entered, please check the e-mail again, and retry
NICK_REG_MAIL_SUBJECT
	Nickname Registration (%s)
NICK_REG_MAIL_HEAD
	Hi,
NICK_REG_MAIL_LINE_1
	You have requested to register the following nickname %s.
NICK_REG_MAIL_LINE_2
	Please type " %R%s confirm %s " to complete registration.
NICK_REG_MAIL_LINE_3
	If you don't know why this mail is sent to you, please ignore it silently.
NICK_REG_MAIL_LINE_4
	PLEASE DON'T ANSWER TO THIS MAIL!
NICK_REG_MAIL_LINE_5
	%s administrators.
NICK_GETPASS_PASSCODE_IS
	Passcode for %s is %s.
NICK_FORCE_REG
	Nickname %s confirmed

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	   operator status     
CHAN_LEVEL_AUTOVOICE
	     +v     
CHAN_LEVEL_AUTOHALFOP
	   half op  +h     
CHAN_LEVEL_AUTOPROTECT
	     +a  
CHAN_LEVEL_AUTODEOP
	     operator status
CHAN_LEVEL_NOJOIN
	        RESTRICTED
CHAN_LEVEL_INVITE
	   INVITE 
CHAN_LEVEL_AKICK
	   AKICK 
CHAN_LEVEL_SET
	   SET  (not FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	   CLEAR 
CHAN_LEVEL_UNBAN
	   UNBAN 
CHAN_LEVEL_OPDEOP
	   OP/DEOP 
CHAN_LEVEL_ACCESS_LIST
	     
CHAN_LEVEL_ACCESS_CHANGE
	        
CHAN_LEVEL_MEMO
	              
CHAN_LEVEL_ASSIGN
	  /  bot
CHAN_LEVEL_BADWORDS
	    BADWORDS 
CHAN_LEVEL_NOKICK
	 bot's      kickers
CHAN_LEVEL_FANTASIA
	   fantaisist 
CHAN_LEVEL_SAY
	   SAY  ACT 
CHAN_LEVEL_GREET
	    
CHAN_LEVEL_VOICEME
	   (de)voice   
CHAN_LEVEL_VOICE
	   VOICE/DEVOICE 
CHAN_LEVEL_GETKEY
	    GETKEY 
CHAN_LEVEL_OPDEOPME
	   (de)op   
CHAN_LEVEL_HALFOPME
	   (de)halfop   
CHAN_LEVEL_HALFOP
	   HALFOP/DEHALFOP 
CHAN_LEVEL_PROTECTME
	   (de)protect   
CHAN_LEVEL_PROTECT
	   PROTECT/DEPROTECT 
CHAN_LEVEL_KICKME
	   kick   
CHAN_LEVEL_KICK
	    KICK 
CHAN_LEVEL_SIGNKICK
	 signed kick   SIGNKICK LEVEL 
CHAN_LEVEL_BANME
	   Ban   
CHAN_LEVEL_BAN
	    BAN 
CHAN_LEVEL_TOPIC
	    TOPIC 
CHAN_LEVEL_INFO
	    INFO    ALL 

# Automatic responses
CHAN_IS_REGISTERED
	       %s.
CHAN_NOT_ALLOWED_OP
	    chanop status     %s.
CHAN_MAY_NOT_BE_USED
	      .
CHAN_NOT_ALLOWED_TO_JOIN
	         .
	
# REGISTER responses
CHAN_X_INVALID
	Channel %s is not a valid channel.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER channel password description
CHAN_REGISTER_DISABLED
	,         .
CHAN_REGISTER_NOT_LOCAL
	     .
CHAN_MUST_REGISTER_NICK
	      .   %R%s HELP         ..
CHAN_MUST_IDENTIFY_NICK
	       %s ,   :
	%R%s IDENTIFY password
CHAN_MAY_NOT_BE_REGISTERED
	  %s    .
CHAN_ALREADY_REGISTERED
	  %s   !
CHAN_MUST_BE_CHANOP
	     operator status      .
CHAN_REACHED_CHANNEL_LIMIT
	,        %d .
CHAN_EXCEEDED_CHANNEL_LIMIT
	,        %d .
CHAN_REGISTRATION_FAILED
	,   .
CHAN_REGISTERED
	  %s      : %s
CHAN_PASSWORD_IS
	     %s -       .
CHAN_REGISTER_NONE_CHANNEL
	You have attempted to register a nonexistent channel %s
CHAN_SYMBOL_REQUIRED
	Please use the symbol of # when attempting to register


# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY channel password
CHAN_IDENTIFY_FAILED
	,      .
CHAN_IDENTIFY_SUCCEEDED
	    -   founder-level   %s.

# LOGOUT responses
CHAN_LOGOUT_SYNTAX
	LOGOUT channel nickname
CHAN_LOGOUT_SERVADMIN_SYNTAX
	LOGOUT channel [nickname]
CHAN_LOGOUT_SUCCEEDED
	  %s  logged out    %s.
CHAN_LOGOUT_ALL_SUCCEEDED
	   logged out    %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP channel
CHAN_DROP_DISABLED
	,      .
CHAN_DROPPED
	  %s    .

# SET responses
CHAN_SET_SYNTAX
	SET channel option parameters
CHAN_SET_DISABLED
	,         .
CHAN_SET_UNKNOWN_OPTION
	 SET  %s.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s    .
CHAN_FOUNDER_CHANGED
	 Founder  %s     %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	 Successor  %s     %s.
CHAN_SUCCESSOR_UNSET
	 Successor  %s   .
CHAN_SUCCESSOR_IS_FOUNDER
	%s     successor   %s   founder  .

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	,       .
CHAN_PASSWORD_CHANGED
	%s   .
CHAN_PASSWORD_CHANGED_TO
	%s     %s.

# SET DESC responses
CHAN_DESC_CHANGED
	  %s   %s.

# SET URL responses
CHAN_URL_CHANGED
	URL  %s   %s.
CHAN_URL_UNSET
	URL  %s   .

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	E-mail   %s   %s.
CHAN_EMAIL_UNSET
	E-mail   %s   .

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	    %s .
CHAN_ENTRY_MSG_UNSET
	    %s   .
	
# SET BANTYPE responses
CHAN_SET_BANTYPE_INVALID
	%s    ban .
CHAN_SET_BANTYPE_CHANGED
	Ban    %s   #%d.

# SET MLOCK responses
CHAN_SET_MLOCK_UNKNOWN_CHAR
	   %c .
CHAN_SET_MLOCK_IMPOSSIBLE_CHAR
	  %c       .
CHAN_SET_MLOCK_L_REQUIRED
	     +l    +L.
CHAN_SET_MLOCK_K_REQUIRED
	    +i    +K.
CHAN_MLOCK_CHANGED
	     %s   %s.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET channel KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Topic retention option for %s is now ON.
CHAN_SET_KEEPTOPIC_OFF
	Topic retention option for %s is now OFF.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET channel TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Topic lock option for %s is now ON.
CHAN_SET_TOPICLOCK_OFF
	Topic lock option for %s is now OFF.

# SET PEACE responses
CHAN_SET_PEACE_SYNTAX
	SET channel PEACE {ON | OFF}
CHAN_SET_PEACE_ON
	Peace option for %s is now ON.
CHAN_SET_PEACE_OFF
	Peace option for %s is now OFF.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET channel PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Private option for %s is now ON.
CHAN_SET_PRIVATE_OFF
	Private option for %s is now OFF.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET channel SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Secure ops option for %s is now ON.
CHAN_SET_SECUREOPS_OFF
	Secure ops option for %s is now OFF.

# SET SECUREFOUNDER responses
CHAN_SET_SECUREFOUNDER_SYNTAX
	SET channel SECUREFOUNDER {ON | OFF}
CHAN_SET_SECUREFOUNDER_ON
	Secure founder option for %s is now ON.
CHAN_SET_SECUREFOUNDER_OFF
	Secure founder option for %s is now OFF.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET channel RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Restricted access option for %s is now ON.
CHAN_SET_RESTRICTED_OFF
	Restricted access option for %s is now OFF.

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET channel SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Secure option for %s is now ON.
CHAN_SET_SECURE_OFF
	Secure option for %s is now OFF.

# SET SIGNKICK responses
CHAN_SET_SIGNKICK_SYNTAX
	SET channel SIGNKICK {ON | LEVEL | OFF}
CHAN_SET_SIGNKICK_ON
	Signed kick option for %s is now ON.
CHAN_SET_SIGNKICK_LEVEL
	Signed kick option for %s is now ON, but depends of the
	level of the user that is using the command.
CHAN_SET_SIGNKICK_OFF
	Signed kick option for %s is now OFF.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET channel OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Op-notice option for %s is now ON.
CHAN_SET_OPNOTICE_OFF
	Op-notice option for %s is now OFF.

# SET XOP responses
CHAN_SET_XOP_SYNTAX
	SET channel XOP {ON | OFF}
CHAN_SET_XOP_ON
	xOP lists system for %s is now ON.
CHAN_SET_XOP_OFF
	xOP lists system for %s is now OFF.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET channel NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	  %s   .
CHAN_SET_NOEXPIRE_OFF
	  %s  .

# xOP messages
CHAN_XOP_REACHED_LIMIT
	,     %d AOP/SOP/VOP  .
CHAN_XOP_LIST_FORMAT
	  %3d  %s
CHAN_XOP_ACCESS
	      .   ACCESS    .
	 %R%s HELP ACCESS   .
CHAN_XOP_NOT_AVAILABLE
	xOP system is not available.

# AOP messages
CHAN_AOP_SYNTAX
	AOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_AOP_DISABLED
	,      AOP   .
CHAN_AOP_NICKS_ONLY
	  Channel AOP     .
CHAN_AOP_ADDED
	/ %s    AOP   %s.
CHAN_AOP_MOVED
	%s moved to %s AOP list.
CHAN_AOP_NO_SUCH_ENTRY
	     (#%d)  AOP   %s.
CHAN_AOP_NOT_FOUND
	/ %s      AOP   %s.
CHAN_AOP_NO_MATCH
	    AOP   %s.
CHAN_AOP_DELETED
	/ %s     AOP   %s.
CHAN_AOP_DELETED_ONE
	 1    AOP   %s.
CHAN_AOP_DELETED_SEVERAL
	 %d    AOP   %s.
CHAN_AOP_LIST_EMPTY
	 AOP   %s  .
CHAN_AOP_LIST_HEADER
	 AOP   %s  :
	    

# HOP messages
CHAN_AOP_CLEAR
	Channel %s AOP list has been cleared.

# HOP messages
CHAN_HOP_SYNTAX
	HOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_HOP_DISABLED
	,      HOP   .
CHAN_HOP_NICKS_ONLY
	  Channel HOP     .
CHAN_HOP_ADDED
	/ %s    HOP   %s.
CHAN_HOP_MOVED
	%s moved to %s HOP list.
CHAN_HOP_NO_SUCH_ENTRY
	     (#%d)  HOP   %s.
CHAN_HOP_NOT_FOUND
	/ %s    HOP   %s.
CHAN_HOP_NO_MATCH
	    HOP   %s.
CHAN_HOP_DELETED
	/ %s     HOP   %s.
CHAN_HOP_DELETED_ONE
	 1 8   HOP   %s.
CHAN_HOP_DELETED_SEVERAL
	 %d    OP   %s.
CHAN_HOP_LIST_EMPTY
	 HOP   %s  .
CHAN_HOP_LIST_HEADER
	 HOP   %s :
	    

# SOP messages
CHAN_HOP_CLEAR
	Channel %s HOP list has been cleared.

# SOP messages
CHAN_SOP_SYNTAX
	SOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_SOP_DISABLED
	,      SOP   .
CHAN_SOP_NICKS_ONLY
	  Channel SOP     .
CHAN_SOP_ADDED
	/ %s    SOP   %s.
CHAN_SOP_MOVED
	%s moved to %s SOP list.
CHAN_SOP_NO_SUCH_ENTRY
	     (#%d)  SOP   %s.
CHAN_SOP_NOT_FOUND
	/ %s    SOP   %s.
CHAN_SOP_NO_MATCH
	    SOP   %s.
CHAN_SOP_DELETED
	/ %s     SOP   %s.
CHAN_SOP_DELETED_ONE
	 1 8   SOP   %s.
CHAN_SOP_DELETED_SEVERAL
	 %d    SOP   %s.
CHAN_SOP_LIST_EMPTY
	 SOP   %s  .
CHAN_SOP_LIST_HEADER
	 SOP   %s :
	    

# VOP messages
CHAN_SOP_CLEAR
	Channel %s SOP list has been cleared.

# VOP messages
CHAN_VOP_SYNTAX
	VOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_VOP_DISABLED
	,      VOP   .
CHAN_VOP_NICKS_ONLY
	  Channel VOP     .
CHAN_VOP_ADDED
	/ %s    VOP   %s.
CHAN_VOP_MOVED
	%s moved to %s VOP list.
CHAN_VOP_NO_SUCH_ENTRY
	     (#%d)  VOP   %s.
CHAN_VOP_NOT_FOUND
	/ %s    VOP   %s.
CHAN_VOP_NO_MATCH
	    VOP   %s.
CHAN_VOP_DELETED
	/ %s     VOP   %s.
CHAN_VOP_DELETED_ONE
	 1 8   VOP   %s.
CHAN_VOP_DELETED_SEVERAL
	 %d    VOP   %s.
CHAN_VOP_LIST_EMPTY
	 VOP   %s  .
CHAN_VOP_LIST_HEADER
	 VOP   %s :
	    

# ACCESS messages
CHAN_VOP_CLEAR
	Channel %s VOP list has been cleared.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS channel {ADD|DEL|LIST|CLEAR} [nick [level] | entry-list]
CHAN_ACCESS_XOP
	      . 
	 AOP, SOP  VOP     access.
	 %R%s HELP command   .
CHAN_ACCESS_XOP_HOP
	You can't use this command. 
	Use the AOP, SOP, HOP and VOP commands instead.
	Type %R%s HELP command for more information.
CHAN_ACCESS_DISABLED
	,      access   .
CHAN_ACCESS_LEVEL_NONZERO
	 Access level       .
CHAN_ACCESS_LEVEL_RANGE
	 Access level      %d  %d .
CHAN_ACCESS_NICKS_ONLY
	 Channel access     .
CHAN_ACCESS_REACHED_LIMIT
	,     %d access  .
CHAN_ACCESS_LEVEL_UNCHANGED
	 Access level  %s  %s     %d.
CHAN_ACCESS_LEVEL_CHANGED
	 Access level   %s  %s   %d.
CHAN_ACCESS_ADDED
	/ %s   access list  %s  level %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	     (#%d)  %s access list.
CHAN_ACCESS_NOT_FOUND
	/ %s    %s  access list.
CHAN_ACCESS_NO_MATCH
	    %s  access list.
CHAN_ACCESS_DELETED
	%s    access list  %s.
CHAN_ACCESS_DELETED_ONE
	 1   %s access list.
CHAN_ACCESS_DELETED_SEVERAL
	 %d   %s access list.
CHAN_ACCESS_LIST_EMPTY
	   %s access list  .
CHAN_ACCESS_LIST_HEADER
	 access   %s :
	       
CHAN_ACCESS_LIST_FOOTER
	   .
CHAN_ACCESS_LIST_XOP_FORMAT
	  %3d   %s  %s
CHAN_ACCESS_LIST_AXS_FORMAT
	  %3d  %4d  %s

# AKICK responses
CHAN_ACCESS_CLEAR
	Channel %s access list has been cleared.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK channel {ADD | STICK | UNSTICK | DEL | LIST | VIEW | ENFORCE | CLEAR} [nick-or-usermask] [reason]
CHAN_AKICK_DISABLED
	,      akick   .
CHAN_AKICK_ALREADY_EXISTS
	/ %s    autokick   %s.
CHAN_AKICK_REACHED_LIMIT
	,     %d autokick   .
CHAN_AKICK_ADDED
	/ %s    autokick   %s.
CHAN_AKICK_NO_SUCH_ENTRY
	     (#%d)  %s akick list.
CHAN_AKICK_NOT_FOUND
	O %s    autokick list  %s.
CHAN_AKICK_NO_MATCH
	    autokick list  %s.
CHAN_AKICK_STUCK
	%s       %s.
CHAN_AKICK_UNSTUCK
	%s        %s.
CHAN_AKICK_DELETED
	/ %s    autokick list  %s.
CHAN_AKICK_DELETED_ONE
	 1    autokick list %s.
CHAN_AKICK_DELETED_SEVERAL
	 %d    autokick list %s.
CHAN_AKICK_LIST_EMPTY
	H autokick list  %s  .
CHAN_AKICK_LIST_HEADER
	 Autokick list  %s :
CHAN_AKICK_LIST_FORMAT
	  %3d %s (%s)
CHAN_AKICK_VIEW_FORMAT
	%3d %s ( %s  %s)
	    %s
CHAN_AKICK_VIEW_FORMAT_STUCK
	%3d %s (stuck) ( %s  %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	 AKICK ENFORCE   %s ; %d   .

# LEVELS responses
CHAN_AKICK_CLEAR
	Channel %s akick list has been cleared.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS channel {SET | DIS[ABLE] | LIST | RESET} [item [level]]
CHAN_LEVELS_XOP
	        .
CHAN_LEVELS_RANGE
	      %d  %d.
CHAN_LEVELS_CHANGED
	    %s   %s   %d.
CHAN_LEVELS_UNKNOWN
	  %s   .   %R%s HELP LEVELS DESC       .
CHAN_LEVELS_DISABLED
	%s    %s.
CHAN_LEVELS_LIST_HEADER
	  access    %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  ()
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  ( )
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	  Access   %s   .

# Status Messages
CHAN_STATUS_SYNTAX
	STATUS ERROR Syntax error
CHAN_STATUS_NOT_REGGED
	STATUS ERROR Channel %s not registered
CHAN_STATUS_FORBIDDEN
	STATUS ERROR Channel %s forbidden
CHAN_STATUS_NOTONLINE
	STATUS ERROR Nick %s not online
CHAN_STATUS_INFO
	STATUS %s %s %d

# INFO responses
CHAN_INFO_SYNTAX
	INFO channel [ALL]
CHAN_INFO_HEADER
	    %s:
CHAN_INFO_FOUNDER
	        : %s (%s)
CHAN_INFO_NO_FOUNDER
	        : %s
CHAN_INFO_SUCCESSOR
	      : %s (%s)
CHAN_INFO_NO_SUCCESSOR
	      : %s
CHAN_INFO_DESCRIPTION
	    : %s
CHAN_INFO_ENTRYMSG
	   : %s
CHAN_INFO_TIME_REGGED
	     : %s
CHAN_INFO_LAST_USED
	       : %s
CHAN_INFO_LAST_TOPIC
	      topic: %s
CHAN_INFO_TOPIC_SET_BY
	    Topic   : %s
CHAN_INFO_URL
	            URL: %s
CHAN_INFO_EMAIL
	 E-mail : %s
CHAN_INFO_BANTYPE
	        Ban: %d
CHAN_INFO_OPTIONS
	        : %s
CHAN_INFO_OPT_KEEPTOPIC
	Topic 
CHAN_INFO_OPT_OPNOTICE
	  OP
CHAN_INFO_OPT_PEACE
	
CHAN_INFO_OPT_PRIVATE
	
CHAN_INFO_OPT_RESTRICTED
	   Access
CHAN_INFO_OPT_SECURE
	
CHAN_INFO_OPT_SECUREOPS
	    access   op  opers
CHAN_INFO_OPT_SECUREFOUNDER
	  
CHAN_INFO_OPT_SIGNKICK
	 kicks
CHAN_INFO_OPT_TOPICLOCK
	  Topic
CHAN_INFO_OPT_XOP
	xOP  
CHAN_INFO_OPT_NONE
	
CHAN_INFO_MODE_LOCK
	       : %s
CHAN_INFO_EXPIRE
	      Expires in: %s
CHAN_INFO_NO_EXPIRE
	     .

# LIST responses
CHAN_LIST_SYNTAX
	LIST pattern
CHAN_LIST_SERVADMIN_SYNTAX
	LIST pattern [FORBIDDEN] [NOEXPIRE]
CHAN_LIST_HEADER
	       %s:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	  - %d/%d  .
	
# CLIST responses
CHAN_INVITE_SYNTAX
	INVITE 

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN 
CHAN_UNBANNED
	 unban   %s.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC  [topic]

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR channel what
CHAN_CLEARED_BANS
	  bans    %s  .
CHAN_CLEARED_EXCEPTS
	  excepts    %s  .
CHAN_CLEARED_MODES
	  modes    %s  .
CHAN_CLEARED_OPS
	  Mode +o      %s.
CHAN_CLEARED_HOPS
	Mode +h has been cleared from channel %s.
CHAN_CLEARED_VOICES
	  Mode +v      %s.
CHAN_CLEARED_USERS
	    kick    %s.
CHAN_CLEARED_INVITES
	All invites on channel %s have been removed.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS 
CHAN_GETPASS_UNAVAILABLE
	  GETPASS         .
CHAN_GETPASS_PASSWORD_IS
	     %s  %s.
	
# SENDPASS responses
CHAN_GETKEY_SYNTAX
	GETKEY channel
CHAN_GETKEY_NOKEY
	The channel %s has no key.
CHAN_GETKEY_KEY
	Key for channel %s is %s.

# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS 
CHAN_SENDPASS_UNAVAILABLE
	  SENDPASS         .
CHAN_SENDPASS_SUBJECT
	    (%s)
CHAN_SENDPASS_HEAD
	,
CHAN_SENDPASS_LINE_1
	         %s  e-mail.
CHAN_SENDPASS_LINE_2
	   %s.   ,               e-mail.
CHAN_SENDPASS_LINE_3
	        mail,   .
CHAN_SENDPASS_LINE_4
	      MAIL!
CHAN_SENDPASS_LINE_5
	%s administrators.
CHAN_SENDPASS_OK
	   %s  .

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID  []
CHAN_FORBID_SYNTAX_REASON
	FORBID  
CHAN_FORBID_SUCCEEDED
	  %s .
CHAN_FORBID_FAILED
	      %s!

# Misc responses
CHAN_FORBID_REASON
	This channel has been forbidden.

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND channel [reason]
CHAN_SUSPEND_SYNTAX_REASON
	SUSPEND channel reason
CHAN_SUSPEND_SUCCEEDED
	Channel %s is now suspended.
CHAN_SUSPEND_FAILED
	Couldn't suspended channel %s!
CHAN_SUSPEND_REASON
	This channel has been suspended.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND channel
CHAN_UNSUSPEND_ERROR
	No # found in front of channel name.
CHAN_UNSUSPEND_SUCCEEDED
	Channel %s is now released.
CHAN_UNSUSPEND_FAILED
	Couldn't release channel %s!

# Misc responses
CHAN_EXCEPTED
	%s matches an except on %s and cannot be banned until the except have been removed.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	 1  .
MEMO_HAVE_NEW_MEMOS
	 %d  .
MEMO_TYPE_READ_LAST
	 %R%s READ LAST    .
MEMO_TYPE_READ_NUM
	 %R%s READ %d   .
MEMO_TYPE_LIST_NEW
	 %R%s LIST NEW        .
MEMO_AT_LIMIT
	:       (%d).               .
MEMO_OVER_LIMIT
	:          (%d).                 .
MEMO_X_MANY_NOTICE
	There are %d memos on channel %s.
MEMO_X_ONE_NOTICE
	There is %d memo on channel %s.
MEMO_NEW_X_MEMO_ARRIVED
	There is a new memo on channel %s.
	Type %R%s READ %s %d to read it.
MEMO_NEW_MEMO_ARRIVED
	     %s.
	 %R%s READ %d    .

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	  .
MEMO_X_HAS_NO_MEMOS
	%s   .
MEMO_DOES_NOT_EXIST
	 %d  !
MEMO_LIST_NOT_FOUND
	  .

# SEND responses
MEMO_SEND_SYNTAX
	SEND { | } 
MEMO_SEND_DISABLED
	,           .
MEMO_SEND_PLEASE_WAIT
	  %d      SEND .
MEMO_X_GETS_NO_MEMOS
	%s      .
MEMO_X_HAS_TOO_MANY_MEMOS
	%s         .
MEMO_SENT
	    %s.
	
# CANCEL responses
MEMO_MASS_SENT
	A massmemo has been sent to all registered users.
	
# CANCEL responses
MEMO_CANCEL_SYNTAX
	CANCEL { | }
MEMO_CANCEL_DISABLED
	,      .
MEMO_CANCEL_NONE
	   .
MEMO_CANCELLED
	       %s .

# LIST responses
MEMO_LIST_SYNTAX
	LIST [] [list | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	   .
MEMO_X_HAS_NO_NEW_MEMOS
	/ %s     .
MEMO_LIST_MEMOS
	   %s.     , : %R%s READ num
MEMO_LIST_NEW_MEMOS
	    %s.     , : %R%s READ num
MEMO_LIST_CHAN_MEMOS
	   %s.     , : %R%s READ %s num
MEMO_LIST_CHAN_NEW_MEMOS
	    %s.     , : %R%s READ %s num
MEMO_LIST_HEADER
	               /
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [] {list | LAST | NEW}
MEMO_HEADER
	 %d   %s (%s).     , : %R%s DEL %d
MEMO_CHAN_HEADER
	 %d  %s (%s).     , : %R%s DEL %s %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [] { | list | ALL}
MEMO_DELETED_NONE
	   .
MEMO_DELETED_ONE
	 %d .
MEMO_DELETED_SEVERAL
	 %s .
MEMO_DELETED_ALL
	   .

# SET responses
MEMO_CHAN_DELETED_ALL
	All memos for channel %s have been deleted.

# SET responses
MEMO_SET_SYNTAX
	SET  
MEMO_SET_DISABLED
	,   setting  .
MEMO_SET_UNKNOWN_OPTION
	 SET  %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s       logon            .
MEMO_SET_NOTIFY_LOGON
	%s    log on     away    .
MEMO_SET_NOTIFY_NEW
	%s          .
MEMO_SET_NOTIFY_OFF
	%s         .

# SET LIMIT responses
MEMO_SET_NOTIFY_MAIL
	You will now be informed about new memos via email.
MEMO_SET_NOTIFY_NOMAIL
	You will no longer be informed via email.
MEMO_SET_NOTIFY_INVALIDMAIL
	There's no email address set for your nick.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [] 
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [ | ] { | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	            .
MEMO_SET_LIMIT_FORBIDDEN
	      %s    .
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	         %d.
MEMO_SET_LIMIT_TOO_HIGH
	         %s   %d.
MEMO_SET_LIMIT_OVERFLOW
	     ;   %d .
MEMO_SET_YOUR_LIMIT
	     %d.
MEMO_SET_YOUR_LIMIT_ZERO
	       .
MEMO_UNSET_YOUR_LIMIT
	    .
MEMO_SET_LIMIT
	     %s   %d.
MEMO_SET_LIMIT_ZERO
	     %s   0.
MEMO_UNSET_LIMIT
	      %s.

# INFO responses
MEMO_INFO_SYNTAX
	INFO []
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [ | ]
MEMO_INFO_NO_MEMOS
	     .
MEMO_INFO_MEMO
	   1 .
MEMO_INFO_MEMO_UNREAD
	   1 memo,     .
MEMO_INFO_MEMOS
	   %d .
MEMO_INFO_MEMOS_ONE_UNREAD
	   %d ,    1   .
MEMO_INFO_MEMOS_SOME_UNREAD
	   %d ,    %d   .
MEMO_INFO_MEMOS_ALL_UNREAD
	   %d ;       .
MEMO_INFO_LIMIT
	    %d.
MEMO_INFO_HARD_LIMIT
	    %d,     .
MEMO_INFO_LIMIT_ZERO
	    0;       .
MEMO_INFO_HARD_LIMIT_ZERO
	    0;       .        .
MEMO_INFO_NO_LIMIT
	          .
MEMO_INFO_NOTIFY_OFF
	       .
MEMO_INFO_NOTIFY_ON
	       logon   .
MEMO_INFO_NOTIFY_RECEIVE
	       .
MEMO_INFO_NOTIFY_SIGNON
	      logon.
MEMO_INFO_X_NO_MEMOS
	%s    .
MEMO_INFO_X_MEMO
	%s  1 ..
MEMO_INFO_X_MEMO_UNREAD
	%s  1 ,      .
MEMO_INFO_X_MEMOS
	%s  %d .
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s  %d ,    1   .
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s  %d ,    %d   .
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s  %d ;       .
MEMO_INFO_X_LIMIT
	/ %s's     %d.
MEMO_INFO_X_HARD_LIMIT
	%s's    %d,     .
MEMO_INFO_X_NO_LIMIT
	%s    .
MEMO_INFO_X_NOTIFY_OFF
	%s      .
MEMO_INFO_X_NOTIFY_ON
	%s       logon    .
MEMO_INFO_X_NOTIFY_RECEIVE
	%s        .
MEMO_INFO_X_NOTIFY_SIGNON
	%s       logon.
	
###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
MEMO_MAIL_SUBJECT
	New memo
MEMO_MAIL_TEXT1
	Hi %s
MEMO_MAIL_TEXT2
	You've just received a new memo from %s. This is memo number %d.
MEMO_MAIL_TEXT3
	Memo Text:

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
MEMO_RSEND_PLEASE_WAIT
	Please wait %d seconds before using the RSEND command again.
MEMO_RSEND_DISABLED
	Sorry, RSEND has been disabled on this network.
MEMO_RSEND_SYNTAX
	RSEND {nick | channel} memo-text
MEMO_RSEND_NICK_MEMO_TEXT
	[auto-memo] The memo you sent has been viewed.
MEMO_RSEND_CHAN_MEMO_TEXT
	[auto-memo] The memo you sent to %s has been viewed.
MEMO_RSEND_USER_NOTIFICATION
	A notification memo has been sent to %s informing him/her you have
	read his/her memo.

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
MEMO_CHECK_SYNTAX
	CHECK nickname
MEMO_CHECK_NOT_READ
	The last memo you sent to %s (sent on %s) has not yet been read.
MEMO_CHECK_READ
	The last memo you sent to %s (sent on %s) has been read.
MEMO_CHECK_NO_MEMO
	Nick %s doesn't have a memo from you.

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
MEMO_NO_RSEND_SELF
	You can not request a receipt when sending a memo to yourself.

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
BOT_DOES_NOT_EXIST
	 Bot %s  .
BOT_NOT_ASSIGNED
	   assign  bot     .
	 %R%S HELP ASSIGN   .
BOT_NOT_ON_CHANNEL
	 Bot     %s.
	
# Kick reasons (must be a single line)
BOT_REASON_BADWORD
	     %s  !
BOT_REASON_BADWORD_GENTLE
	   !
BOT_REASON_BOLD
	      !
BOT_REASON_CAPS
	    !
BOT_REASON_COLOR
	     !
BOT_REASON_FLOOD
	    !
BOT_REASON_REPEAT
	   !
BOT_REASON_REVERSE
	     !
BOT_REASON_UNDERLINE
	     !
	
# !seen replies
BOT_SEEN_BOT
	 , %s!
BOT_SEEN_YOU
	    ,  %s?
BOT_SEEN_ON_CHANNEL
	%s       !
BOT_SEEN_ON_CHANNEL_AS
	%s       (as %s) ! 
BOT_SEEN_ON
	%s       %s.
BOT_SEEN_NEVER
	    %s    .
BOT_SEEN_UNKNOWN
	   %s  .

# BOT responses
BOT_BOT_SYNTAX
	BOT ADD nick user host real
	BOT CHANGE oldnick newnick [user [host [real]]]
	BOT DEL nick
BOT_BOT_ALREADY_EXISTS
	Bot %s  .
BOT_BOT_CREATION_FAILED
	,    bot .
BOT_BOT_READONLY
	,     bot  .
BOT_BOT_ADDED
	%s!%s@%s (%s)   bot  .
BOT_BOT_ANY_CHANGES
	       .
BOT_BOT_CHANGED
	Bot %s   %s!%s@%s (%s)
BOT_BOT_DELETED
	Bot %s .
	
# BOTLIST responses
BOT_BOTLIST_HEADER
	Bot :
BOT_BOTLIST_PRIVATE_HEADER
	Bots    IRC operators:
BOT_BOTLIST_FOOTER
	%d bots .
BOT_BOTLIST_EMPTY
	   bots   .
	  Services admin    !
	
# ASSIGN responses
BOT_ASSIGN_SYNTAX
	ASSIGN chan nick
BOT_ASSIGN_READONLY
	,   bot assignment  .
BOT_ASSIGN_ALREADY
	Bot %s is already assigned to channel %s.
BOT_ASSIGN_ASSIGNED
	 Bot %s    %s.
	
# UNASSIGN responses
BOT_UNASSIGN_SYNTAX
	UNASSIGN chan
BOT_UNASSIGN_UNASSIGNED
	  bot     %s  .
	
# INFO responses
BOT_INFO_SYNTAX
	INFO {chan | nick}
BOT_INFO_NOT_FOUND
	%s    bot   .
BOT_INFO_BOT_HEADER
	   bot %s:
BOT_INFO_BOT_MASK
	        : %s@%s
BOT_INFO_BOT_REALNAME
	    : %s
BOT_INFO_BOT_CREATED
	     : %s
BOT_INFO_BOT_USAGE
	     / : %d /
BOT_INFO_BOT_OPTIONS
	     : %s
BOT_INFO_OPT_PRIVATE
	
BOT_INFO_CHAN_HEADER
	    %s:
BOT_INFO_CHAN_BOT
	              Bot : %s
BOT_INFO_CHAN_BOT_NONE
	             bot :     .
BOT_INFO_CHAN_KICK_BADWORDS
	        kick : %s
BOT_INFO_CHAN_KICK_BADWORDS_BAN
	        kick : %s (%d kick(s) to ban)
BOT_INFO_CHAN_KICK_BOLDS
	          kick : %s
BOT_INFO_CHAN_KICK_BOLDS_BAN
	          kick : %s (%d kick(s) to ban)
BOT_INFO_CHAN_KICK_CAPS_ON
	           kick : %s (minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_BAN
	           kick : %s (%d kick(s) to ban; minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_OFF
	           kick : %s
BOT_INFO_CHAN_KICK_COLORS
	        kick : %s
BOT_INFO_CHAN_KICK_COLORS_BAN
	        kick : %s (%d kick(s) to ban)
BOT_INFO_CHAN_KICK_FLOOD_ON
	         kick : %s (%d lines in %ds)
BOT_INFO_CHAN_KICK_FLOOD_BAN
	         kick : %s (%d kick(s) to ban; %d lines in %ds)
BOT_INFO_CHAN_KICK_FLOOD_OFF
	         kick : %s
BOT_INFO_CHAN_KICK_REPEAT_ON
	        kick : %s (%d times)
BOT_INFO_CHAN_KICK_REPEAT_BAN
	        kick : %s (%d kick(s) to ban; %d times)
BOT_INFO_CHAN_KICK_REPEAT_OFF
	        kick : %s
BOT_INFO_CHAN_KICK_REVERSES
	      kick : %s
BOT_INFO_CHAN_KICK_REVERSES_BAN
	     kick : %s (%d kick(s) to ban)
BOT_INFO_CHAN_KICK_UNDERLINES
	    kick : %s
BOT_INFO_CHAN_KICK_UNDERLINES_BAN
	    kick : %s (%d kick(s) to ban)
BOT_INFO_ACTIVE
	
BOT_INFO_INACTIVE
	
BOT_INFO_CHAN_OPTIONS
	             : %s
BOT_INFO_OPT_DONTKICKOPS
	  Ops
BOT_INFO_OPT_DONTKICKVOICES
	  Voices
BOT_INFO_OPT_FANTASY
	
BOT_INFO_OPT_GREET
	
BOT_INFO_OPT_NOBOT
	 bot
BOT_INFO_OPT_SYMBIOSIS
	
BOT_INFO_OPT_NONE
	
	
# SET responses
BOT_SET_SYNTAX
	SET channel option settings
BOT_SET_DISABLED
	,   bot  .
BOT_SET_UNKNOWN
	  %s.
	 %R%S HELP SET   .
	
# SET DONTKICKOPS messages
BOT_SET_DONTKICKOPS_SYNTAX
	SET channel DONTKICKOPS {ON|OFF}
BOT_SET_DONTKICKOPS_ON
	 Bot    kick  ops   %s.
BOT_SET_DONTKICKOPS_OFF
	 Bot   kick  ops   %s.
	
# SET DONTKICKVOICES messages
BOT_SET_DONTKICKVOICES_SYNTAX
	SET channel DONTKICKVOICES {ON|OFF}
BOT_SET_DONTKICKVOICES_ON
	 Bot    kick  voices   %s.
BOT_SET_DONTKICKVOICES_OFF
	 Bot   kick  voices   %s.

# SET FANTASY messages
BOT_SET_FANTASY_SYNTAX
	SET channel FANTASY {ON|OFF}
BOT_SET_FANTASY_ON
	 Fantasy    ON   %s.
BOT_SET_FANTASY_OFF
	 Fantasy    OFF   %s.
	
# SET GREET messages
BOT_SET_GREET_SYNTAX
	SET channel GREET {ON|OFF}
BOT_SET_GREET_ON
	    ON   %s.
BOT_SET_GREET_OFF
	    OFF   %s.
	
# SET NOBOT
BOT_SET_NOBOT_SYNTAX
	SET channel NOBOT {ON|OFF}
BOT_SET_NOBOT_ON
	 Bot   ON   %s.
BOT_SET_NOBOT_OFF
	 Bot   OFF   %s.

# SET PRIVATE
BOT_SET_PRIVATE_SYNTAX
	SET channel PRIVATE {ON|OFF}
BOT_SET_PRIVATE_ON
	   bot %s   ON.
BOT_SET_PRIVATE_OFF
	   bot %s   OFF.

# SET SYMBIOSIS
BOT_SET_SYMBIOSIS_SYNTAX
	SET channel SYMBIOSIS {ON|OFF}
BOT_SET_SYMBIOSIS_ON
	    ON   %s.
BOT_SET_SYMBIOSIS_OFF
	    OFF   %s.
	
# KICK responses
BOT_KICK_SYNTAX
	KICK channel option {ON|OFF} [settings]
BOT_KICK_DISABLED
	,   kicker  .
BOT_KICK_UNKNOWN
	  %s.
	 %R%S HELP KICK   .
BOT_KICK_BAD_TTB
	%s       o ban.

BOT_KICK_BADWORDS_ON
	 Bot     kick  .   BADWORDS 
	       .
BOT_KICK_BADWORDS_ON_BAN
	 Bot     kick  ,     ban   
	%d kicks    .   BADWORDS 
	       .
BOT_KICK_BADWORDS_OFF
	 Bot    kick   .
BOT_KICK_BOLDS_ON
	 Bot    kick  .
BOT_KICK_BOLDS_ON_BAN
	 Bot   kick  ,    ban    
	%d kicks    .
BOT_KICK_BOLDS_OFF
	 Bot    kick   .
BOT_KICK_CAPS_ON
	 Bot   kick  (   
	%d   %d%%   ).
BOT_KICK_CAPS_ON_BAN
	 Bot   kick  (   
	%d   %d%%   ),   
	 ban   %d kicks    .
BOT_KICK_CAPS_OFF
	 Bot    kick  .
BOT_KICK_COLORS_ON
	 Bot   kick  .
BOT_KICK_COLORS_ON_BAN
	 Bot   kick  ,    ban   %d 
	kicks    .
BOT_KICK_COLORS_OFF
	 Bot    kick   .
BOT_KICK_FLOOD_ON
	 Bot   kick   (%d   %d ).
BOT_KICK_FLOOD_ON_BAN
	 Bot   kick   (%d   %d ),  
	  ban   %d kicks    .
BOT_KICK_FLOOD_OFF
	 Bot    kick   .
BOT_KICK_REPEAT_ON
	 Bot   kick   (   %d 
	  ).
BOT_KICK_REPEAT_ON_BAN
	 Bot   kick   (   %d 
	  ),    ban   %d 
	kicks    .
BOT_KICK_REPEAT_OFF
	 Bot    kick   .
BOT_KICK_REVERSES_ON
	 Bot   kick  reserves.
BOT_KICK_REVERSES_ON_BAN
	 Bot   kick  reverses,    ban   %d 
	kicks    .
BOT_KICK_REVERSES_OFF
	 Bot    kick  reverses .
BOT_KICK_UNDERLINES_ON
	 Bot   kick   .
BOT_KICK_UNDERLINES_ON_BAN
	 Bot   kick   ,    ban   %d 
	kicks    .
BOT_KICK_UNDERLINES_OFF
	 Bot    kick    .
	
# BADWORDS messages
BOT_BADWORDS_SYNTAX
	BADWORDS channel {ADD|DEL|LIST|CLEAR} [word | entry-list] [SINGLE|START|END]
BOT_BADWORDS_DISABLED
	,   bad words  .
BOT_BADWORDS_REACHED_LIMIT
	,     %d     .
BOT_BADWORDS_ALREADY_EXISTS
	%s   %s  .
BOT_BADWORDS_ADDED
	%s        %s.
BOT_BADWORDS_NO_SUCH_ENTRY
	     (#%d)       %s.
BOT_BADWORDS_NOT_FOUND
	%s         %s.
BOT_BADWORDS_NO_MATCH
	          %s.
BOT_BADWORDS_DELETED
	%s          %s.
BOT_BADWORDS_DELETED_ONE
	 1    %s   .
BOT_BADWORDS_DELETED_SEVERAL
	 %d    %s ,    .
BOT_BADWORDS_LIST_EMPTY
	      %s  .
BOT_BADWORDS_LIST_HEADER
	       %s :
	                                
BOT_BADWORDS_LIST_FORMAT
	  %3d   %-30s %s
BOT_BADWORDS_CLEAR
	      .

# SAY responses
BOT_SAY_SYNTAX
	SAY channel text

# ACT responses
BOT_ACT_SYNTAX
	ACT channel text

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_EXCEPT
	User matches channel except.

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_BAD_NICK
	Bot Nicks may only contain valid nick characters.
BOT_BAD_HOST
	Bot Hosts may only contain valid host characters.
BOT_BAD_IDENT
	Bot Idents may only contain valid characters.
BOT_LONG_IDENT
	Bot Idents may only contain 9 characters.
###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	      .   servers   ?
OPER_BOUNCY_MODES_U_LINE
	      .   servers' U:    ?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL message

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	 STATS  %s..
OPER_STATS_CURRENT_USERS
	   : %d (%d ops)
OPER_STATS_MAX_USERS
	 : %d (%s)
# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal preference
# is to only give resolution to the nearest minute when uptime is one hour
# or more, but just add a %d to get seconds as well.
OPER_STATS_UPTIME_DHMS
	    %d , %02d:%02d
OPER_STATS_UPTIME_1DHMS
	    %d , %02d:%02d
OPER_STATS_UPTIME_HMS
	    %d , %d 
OPER_STATS_UPTIME_HM1S
	    %d , %d 
OPER_STATS_UPTIME_H1MS
	    %d , %d 
OPER_STATS_UPTIME_H1M1S
	    %d , %d 
OPER_STATS_UPTIME_1HMS
	    %d , %d 
OPER_STATS_UPTIME_1HM1S
	    %d , %d 
OPER_STATS_UPTIME_1H1MS
	    %d , %d 
OPER_STATS_UPTIME_1H1M1S
	    %d , %d 
OPER_STATS_UPTIME_MS
	    %d , %d 
OPER_STATS_UPTIME_M1S
	    %d , %d 
OPER_STATS_UPTIME_1MS
	    %d , %d 
OPER_STATS_UPTIME_1M1S
	    %d , %d 
OPER_STATS_BYTES_READ
	 Bytes   : %5d kB
OPER_STATS_BYTES_WRITTEN
	 Bytes : %5d kB
OPER_STATS_USER_MEM
	          : %6d , %5d kB
OPER_STATS_CHANNEL_MEM
	       : %6d , %5d kB
OPER_STATS_GROUPS_MEM
	NS      : %6d , %5d kB
OPER_STATS_ALIASES_MEM
	NS Aliases    : %6d , %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ      : %6d , %5d kB
OPER_STATS_BOTSERV_MEM
	BotServ       : %6d , %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ      : %6d , %5d kB
OPER_STATS_SESSIONS_MEM
	Sessions      : %6d , %5d kB
OPER_STATS_AKILL_COUNT
	   AKILLs: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	   AKILL: %d 
OPER_STATS_AKILL_EXPIRE_DAY
	   AKILL: 1 
OPER_STATS_AKILL_EXPIRE_HOURS
	   AKILL: %d 
OPER_STATS_AKILL_EXPIRE_HOUR
	   AKILL: 1 
OPER_STATS_AKILL_EXPIRE_MINS
	   AKILL: %d 
OPER_STATS_AKILL_EXPIRE_MIN
	   AKILL: 1 
OPER_STATS_AKILL_EXPIRE_NONE
	   AKILL:   
OPER_STATS_SGLINE_COUNT
	   SGLINEs: %d
OPER_STATS_SGLINE_EXPIRE_DAYS
	   SGLINE: %d 
OPER_STATS_SGLINE_EXPIRE_DAY
	   SGLINE: 1 
OPER_STATS_SGLINE_EXPIRE_HOURS
	   SGLINE: %d 
OPER_STATS_SGLINE_EXPIRE_HOUR
	   SGLINE: 1 
OPER_STATS_SGLINE_EXPIRE_MINS
	   SGLINE: %d 
OPER_STATS_SGLINE_EXPIRE_MIN
	   SGLINE: 1 
OPER_STATS_SGLINE_EXPIRE_NONE
	   SGLINE:   
OPER_STATS_SQLINE_COUNT
	   SQLINEs: %d
OPER_STATS_SQLINE_EXPIRE_DAYS
	   SQLINE: %d 
OPER_STATS_SQLINE_EXPIRE_DAY
	   SQLINE: 1 
OPER_STATS_SQLINE_EXPIRE_HOURS
	   SQLINE: %d 
OPER_STATS_SQLINE_EXPIRE_HOUR
	   SQLINE: 1 
OPER_STATS_SQLINE_EXPIRE_MINS
	   SQLINE: %d 
OPER_STATS_SQLINE_EXPIRE_MIN
	   SQLINE: 1 
OPER_STATS_SQLINE_EXPIRE_NONE
	   SQLINE:   
OPER_STATS_SZLINE_COUNT
	   SZLINEs: %d
OPER_STATS_SZLINE_EXPIRE_DAYS
	   SZLINE: %d 
OPER_STATS_SZLINE_EXPIRE_DAY
	   SZLINE: 1 
OPER_STATS_SZLINE_EXPIRE_HOURS
	   SZLINE: %d 
OPER_STATS_SZLINE_EXPIRE_HOUR
	   SZLINE: 1 
OPER_STATS_SZLINE_EXPIRE_MINS
	   SZLINE: %d 
OPER_STATS_SZLINE_EXPIRE_MIN
	   SZLINE: 1 
OPER_STATS_SZLINE_EXPIRE_NONE
	   SZLINE:   
OPER_STATS_RESET
	  .

# MODE responses
OPER_STATS_UPLINK_SERVER
	Uplink server: %s
OPER_STATS_UPLINK_CAPAB
	Uplink capab: %s
OPER_STATS_UPLINK_SERVER_COUNT
	Servers found: %d

# MODE responses
OPER_MODE_SYNTAX
	MODE channel modes

# CLEARMODES responses
OPER_UMODE_SYNTAX
	UMODE nick modes

# OLINE responses
OPER_UMODE_SUCCESS
	Changed usermodes of %s.
OPER_UMODE_CHANGED
	%s changed your usermodes.

# OLINE responses
OPER_OLINE_SYNTAX
	OLINE nick flags
OPER_OLINE_SUCCESS
	An O:Line with the flags %s has been added for %s.

# CLEARMODES responses
OPER_OLINE_IRCOP
	You are now an IRC Operator.

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES channel [ALL]
OPER_CLEARMODES_DONE
	  modes   bans     %s.
OPER_CLEARMODES_ALL_DONE
	  modes     %s.


# KICK responses
OPER_KICK_SYNTAX
	KICK channel user reason
	
# ADMIN responses
OPER_SVSNICK_SYNTAX
	SVSNICK nick newnick 
OPER_SVSNICK_NEWNICK
	The nick %s is now being changed to %s.
	
# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD|DEL|LIST|CLEAR} [nick | entry-list]
OPER_ADMIN_SKELETON
	    skeleton mode;   ADMIN   .
OPER_ADMIN_EXISTS
	/ %s      .
OPER_ADMIN_REACHED_LIMIT
	,         %d.
OPER_ADMIN_ADDED
	%s     .
OPER_ADMIN_NOT_FOUND
	%s      .
OPER_ADMIN_NO_MATCH
	      .
OPER_ADMIN_DELETED
	%s      .
OPER_ADMIN_DELETED_ONE
	 1      .
OPER_ADMIN_DELETED_SEVERAL
	 %d      .
OPER_ADMIN_LIST_EMPTY
	     .
OPER_ADMIN_LIST_HEADER
	      :
	    
OPER_ADMIN_LIST_FORMAT
	  %3d   %s
OPER_ADMIN_CLEAR
	    .
OPER_ADMIN_MOVED
	%s has been moved to Services Administrators list.

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD|DEL|LIST|CLEAR} [nick | entry-list]
OPER_OPER_SKELETON
	    skeleton mode;   OPER   .
OPER_OPER_EXISTS
	%s        operator.
OPER_OPER_REACHED_LIMIT
	,        %d operators.
OPER_OPER_ADDED
	%s       operator.
OPER_OPER_NOT_FOUND
	%s         operator.
OPER_OPER_NO_MATCH
	        opers.
OPER_OPER_DELETED
	%s       operators.
OPER_OPER_DELETED_ONE
	 1      operators.
OPER_OPER_DELETED_SEVERAL
	 %d      operators.
OPER_OPER_LIST_EMPTY
	   operators  .
OPER_OPER_LIST_HEADER
	   operators :
	     
OPER_OPER_LIST_FORMAT
	  %3d   %s
OPER_OPER_CLEAR
	   operators .
OPER_OPER_MOVED
	%s has been moved to Services Operators list.

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | CLEAR} [[+expiry] {mask | entry-list} [reason]]
OPER_AKILL_EXISTS
	%s     AKILL.
OPER_AKILL_ALREADY_COVERED
	%s      %s.
OPER_AKILL_REACHED_LIMIT
	,     %d AKILLs.
OPER_AKILL_NO_NICK
	:    AKILL     ;       .
OPER_AKILL_ADDED
	%s    AKILL.
OPER_AKILL_CHANGED
	   / %s 
OPER_AKILL_NOT_FOUND
	%s     AKILL.
OPER_AKILL_NO_MATCH
	     AKILL.
OPER_AKILL_DELETED
	%s     AKILL.
OPER_AKILL_DELETED_ONE
	 1     AKILL.
OPER_AKILL_DELETED_SEVERAL
	 %d     AKILL.
OPER_AKILL_LIST_EMPTY
	  AKILL  .
OPER_AKILL_LIST_HEADER
	   AKILL  :
	                                   
OPER_AKILL_LIST_FORMAT
	  %3d   %-32s  %s
OPER_AKILL_VIEW_HEADER
	   AKILL  :
# number, mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_AKILL_CLEAR
	  AKILL .
	
# SGLINE responses
OPER_CHANKILL_SYNTAX
	CHANKILL [+expiry] {#channel} [reason]
# SGLINE responses
OPER_SGLINE_SYNTAX
	SGLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+expiry] {mask | entry-list}[:reason]]
OPER_SGLINE_UNSUPPORTED
	,   SGLINE       .
OPER_SGLINE_EXISTS
	%s     SGLINE.
OPER_SGLINE_ALREADY_COVERED
	%s      %s.
OPER_SGLINE_REACHED_LIMIT
	,     %d SGLINEs.
OPER_SGLINE_ADDED
	%s    SGLINE.
OPER_SGLINE_CHANGED
	   / %s .
OPER_SGLINE_NOT_FOUND
	%s     SGLINE.
OPER_SGLINE_NO_MATCH
	     SGLINE.
OPER_SGLINE_DELETED
	%s     SGLINE.
OPER_SGLINE_DELETED_ONE
	 1     SGLINE.
OPER_SGLINE_DELETED_SEVERAL
	 %d     SGLINE.
OPER_SGLINE_LIST_EMPTY
	  SGLINE  .
OPER_SGLINE_LIST_HEADER
	    SGLINE   :
	                                   
OPER_SGLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SGLINE_VIEW_HEADER
	Current SGLINE list:
# number, mask, set-by, set-time, expires, reason
OPER_SGLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SGLINE_CLEAR
	  SGLINE .

# SQLINE responses
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+expiry] {mask | entry-list} [reason]]
OPER_SQLINE_CHANNELS_UNSUPPORTED
	  Channel SQLINEs     IRCd ,     .
OPER_SQLINE_EXISTS
	%s     SQLINE.
OPER_SQLINE_ALREADY_COVERED
	%s      %s.
OPER_SQLINE_REACHED_LIMIT
	,     %d SQLINEs.
OPER_SQLINE_ADDED
	%s    SQLINE.
OPER_SQLINE_CHANGED
	   / %s .
OPER_SQLINE_NOT_FOUND
	%s     SQLINE.
OPER_SQLINE_NO_MATCH
	     SQLINE.
OPER_SQLINE_DELETED
	%s     SQLINE.
OPER_SQLINE_DELETED_ONE
	 1     SQLINE.
OPER_SQLINE_DELETED_SEVERAL
	 %d     SQLINE.
OPER_SQLINE_LIST_EMPTY
	  SQLINE  .
OPER_SQLINE_LIST_HEADER
	    SQLINE   :
	                                  
OPER_SQLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SQLINE_VIEW_HEADER
	    SQLINE   :
# number, mask, set-by, set-time, expires, reason
OPER_SQLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SQLINE_CLEAR
	  SQLINE .

# SZLINE responses
OPER_SZLINE_SYNTAX
	SZLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+expiry] {mask | entry-list} [reason]]
OPER_SZLINE_UNSUPPORTED
	,   SLINE       .
OPER_SZLINE_EXISTS
	%s     SZLINE.
OPER_SZLINE_ALREADY_COVERED
	%s      %s.
OPER_SZLINE_REACHED_LIMIT
	,     %d SZLINEs.
OPER_SZLINE_ONLY_IPS
	:     IP    SZLINE.
OPER_SZLINE_ADDED
	%s    SZLINE.
OPER_SZLINE_CHANGED
	   / %s .
OPER_SZLINE_NOT_FOUND
	%s     SZLINE.
OPER_SZLINE_NO_MATCH
	     SZLINE.
OPER_SZLINE_DELETED
	%s     SZLINE.
OPER_SZLINE_DELETED_ONE
	 1     SZLINE.
OPER_SZLINE_DELETED_SEVERAL
	 %d     SZLINE.
OPER_SZLINE_LIST_EMPTY
	  SZLINE  .
OPER_SZLINE_LIST_HEADER
	    SZLINE   :
	                                    
OPER_SZLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SZLINE_VIEW_HEADER
	    SZLINE   :
# number, mask, set-by, set-time, expires, reason
OPER_SZLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SZLINE_CLEAR
	  SZLINE .

# SET responses
OPER_SET_SYNTAX
	SET option setting
OPER_SET_IGNORE_ON
	  Ignore  .
OPER_SET_IGNORE_OFF
	  Ignore  .
OPER_SET_IGNORE_ERROR
	   IGNORE    ON  OFF.
OPER_SET_READONLY_ON
	 Services    .
OPER_SET_READONLY_OFF
	 Services    -.
OPER_SET_READONLY_ERROR
	   READONLY    ON  OFF.
OPER_SET_LOGCHAN_ON
	Services is now reporting log messages to %s.
OPER_SET_LOGCHAN_OFF
	Services is no longer reporting log messages to a channel.
OPER_SET_LOGCHAN_ERROR
	Setting for LOGCHAN must be ON or OFF and LogChannel must be defined.
OPER_SET_DEBUG_ON
	 Services    debug .
OPER_SET_DEBUG_OFF
	 Services    -debug .
OPER_SET_DEBUG_LEVEL
	 Services    debug  ( %d).
OPER_SET_DEBUG_ERROR
	   DEBUG    ON, OFF,    .
OPER_SET_NOEXPIRE_ON
	 Services       .
OPER_SET_NOEXPIRE_OFF
	 Services      .
OPER_SET_NOEXPIRE_ERROR
	   NOEXPIRE    ON  OFF.
OPER_SET_UNKNOWN_OPTION
	  %s.
OPER_SET_SQL_ON
	SQL code will be used.
OPER_SET_SQL_OFF
	SQL code will not be used.
OPER_SET_SQL_ERROR
	Setting for SQL must be ON or OFF.
OPER_SET_SQL_ERROR_INIT
	Error during init of SQL, check your logs to correct.
OPER_SET_SQL_ERROR_DISABLED
	SQL is not configured for this network. Please edit the
	configuration file (services.conf).
OPER_SET_LIST_OPTION_ON
	%s is enable
OPER_SET_LIST_OPTION_OFF
	%s is disabled

# NOOP responses
OPER_NOOP_SYNTAX
	NOOP {SET|REVOKE} server
OPER_NOOP_SET
	  O:  %s  .
OPER_NOOP_REVOKE
	  O:  %s  .

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE servername [reason]

# RAW responses
OPER_JUPE_HOST_ERROR
	Please use a valid server name when juping
	
# RAW responses
OPER_RAW_SYNTAX
	RAW text

# UPDATE responses
OPER_UPDATING
	 Update   .
	
# RELOAD responses
OPER_RELOAD
	   ,conf file  reloaded,.

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN not defined;     .    \2configure\2 script   recompile  Services      RESTART.

# LISTIGNORE responses
OPER_IGNORE_SYNTAX
	Syntax: IGNORE {ADD|DEL|LIST|CLEAR} [time] [nick]
OPER_IGNORE_VALID_TIME
	You have to enter a valid number as time.
OPER_IGNORE_TIME_DONE
	%s will now be ignored for %s.
OPER_IGNORE_PERM_DONE
	%s will now permanently be ignored.
OPER_IGNORE_DEL_DONE
	%s will no longer be ignored.
OPER_IGNORE_LIST
	  ignore   :
OPER_IGNORE_LIST_NOMATCH
	%s not found on ignore list.
OPER_IGNORE_LIST_EMPTY
	  ignore    .

# KILLCLONES responses
OPER_IGNORE_LIST_CLEARED
	Ignore list has been cleared.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES nick
OPER_KILLCLONES_UNKNOWN_NICK
	      %s.
	
# CHANLIST responses
OPER_CHANLIST_HEADER
	 :
	                      Topic
OPER_CHANLIST_HEADER_USER
	%s channel list:
	                      Topic
OPER_CHANLIST_RECORD
	%-20s  %4d +%-6s %s
OPER_CHANLIST_END
	  .
	
# USERLIST responses
OPER_USERLIST_HEADER
	 :
	                 
OPER_USERLIST_HEADER_CHAN
	%s  :
	                 
OPER_USERLIST_RECORD
	%-20s %s@%s
OPER_USERLIST_END
	  .

# CACHE responses
OPER_SUPER_ADMIN_ON
	You are now a SuperAdmin
OPER_SUPER_ADMIN_OFF
	You are no longer a SuperAdmin
OPER_SUPER_ADMIN_SYNTAX
	Setting for SuperAdmin must be ON or OFF.
OPER_SUPER_ADMIN_WALL_ON
	%s is now a Super-Admin
OPER_SUPER_ADMIN_WALL_OFF
	%s is no longer a Super-Admin

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_SUPER_ADMIN_ONLY
	Only Super-Admins can use this command.

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_STAFF_LIST_HEADER
	On Level Nick

# DefCon Messages

OPER_STAFF_FORMAT
	 %c %s  %s
OPER_STAFF_AFORMAT
	 %c %s  %s [%s]

# DefCon Messages

OPER_DEFCON_SYNTAX
	Syntax: DEFCON [1|2|3|4|5]
OPER_DEFCON_DENIED
	This service is temporarly disabled, please try again later
OPER_DEFCON_NO_CONF
	The Defcon system must be enabled in the services.conf file
OPER_DEFCON_CHANGED
	Services are now at DEFCON %d
OPER_DEFCON_WALL
	%s Changed the DEFCON level to %d
DEFCON_GLOBAL
	The Defcon Level is now at Level: %d

# Modules strings

OPER_MODULE_LOADED
	Module %s loaded
OPER_MODULE_UNLOADED
	Module %s unloaded
OPER_MODULE_LOAD_FAIL
	Unable to load module %s
OPER_MODULE_REMOVE_FAIL
	Unable to remove module %s
OPER_MODULE_NO_UNLOAD
	This module can not be unloaded.
OPER_MODULE_LOAD_SYNTAX
	MODLOAD FileName
OPER_MODULE_UNLOAD_SYNTAX
	MODUNLOAD FileName
OPER_MODULE_LIST_HEADER
	Current Module list:
OPER_MODULE_LIST
	Module: %s [%s] [%s]
OPER_MODULE_LIST_FOOTER
	%d Modules loaded.
OPER_MODULE_INFO_LIST
	Module: %s Version: %s Author: %s loaded: %s
OPER_MODULE_CMD_LIST
	Providing command: %R%s %s
OPER_MODULE_MSG_LIST
	Providing IRCD handler for: %s
OPER_MODULE_NO_LIST
	No modules currently loaded
OPER_MODULE_NO_INFO
	No information about module %s is available
OPER_MODULE_INFO_SYNTAX
	MODINFO FileName

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
MODULE_HELP_HEADER
	The following commands have been loaded by a module:

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [params]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+ ]   	
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL { | }
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE  
OPER_EXCEPTION_DISABLED
	 Session limiting    .
OPER_EXCEPTION_ALREADY_PRESENT
	  %s     exception.
OPER_EXCEPTION_TOO_MANY
	  Session-limit exception  full!
OPER_EXCEPTION_ADDED
	Session limit   %s   %d.
OPER_EXCEPTION_MOVED
	Exception  %s (#%d)    %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	   (#%d)   session-limit exception.
OPER_EXCEPTION_NOT_FOUND
	%s     session-limit exception.
OPER_EXCEPTION_NO_MATCH
	     session-limit exception.
OPER_EXCEPTION_DELETED
	%s     session-limit exception.
OPER_EXCEPTION_DELETED_ONE
	 1     session-limit exception.
OPER_EXCEPTION_DELETED_SEVERAL
	 %d     session-limit exception.
OPER_EXCEPTION_LIST_HEADER
	    Session Limit Exception   :
# mask, limit
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	  Limit  Host
# mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (by %s on %s; %s)
	    Limit: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	 session limit.      integer greater        %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	 hostmask.   hostmasks      usernames.
OPER_EXCEPTION_EXISTS
	%s already exists on the EXCEPTION list.
OPER_EXCEPTION_CHANGED
	Exception for %s has been updated to %d.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST limit | VIEW host}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST 
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_DISABLED
	  Session limiting  .
OPER_SESSION_INVALID_THRESHOLD
	 threshold value.       1.
OPER_SESSION_NOT_FOUND
	%s     session.
OPER_SESSION_LIST_HEADER
	Hosts    %d sessions:
OPER_SESSION_LIST_COLHEAD
	Sessions  Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	 host %s    %d sessions    %d.

# EXCEPTION help

OPER_HELP_EXCEPTION
	: EXCEPTION ADD [+expiry] mask limit reason
	        EXCEPTION DEL {mask | list}
	        EXCEPTION MOVE num position
	        EXCEPTION LIST [mask | list]
	        EXCEPTION VIEW [mask | list]
	
	  Services admins      hosts 
	     -   , 
	   shell servers, to carry more than the default number
	of clients at a time.   host    session limit,
	  clients         host  
	-.   -, n ,
	 /NOTICE   %S.        configuration.
	    
	EXCEPTION ADD   hostname  Exception list.
	,  nick!user@host  user@host    ! 
	  host masks,  box.host.dom  *.host.dom, 
	      sessions     
	user names   account.        
	   .      sessions   host
	     .       host   
	  session limit.    AKILL   
	        expiry.
	EXCEPTION DEL        exception.
	EXCEPTION MOVE   exception   .
	EXCEPTION LIST and EXCEPTION VIEW      
	exceptions;     ,     .
	EXCEPTION VIEW   ,     
	    exception,  ,        .
	    
	   client  ""   exception
	    host.
	    
	    .

OPER_HELP_SESSION
	: SESSION LIST threshold
	        SESSION VIEW host
	
	        session.
	
	SESSION LIST   hosts   threshold sessions.
	 threshold        1.   
	         session hosts. 
	SESSION VIEW       specific
	host -   session   session limit.
	       wildcards.
	    
	  EXCEPTION help       session
	limiting       session limits  specific hosts  groups.
	    
	    .

###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_STAFF
	Syntax: STAFF

	Displays all Services Staff nicks along with level
	and on-line status.

OPER_HELP_DEFCON
	Syntax: DEFCON [1|2|3|4|5]

	The defcon system can be used to implement a pre-defined
	set of restrictions to services useful during an attemtped
	attack on the network.

OPER_HELP_DEFCON_NO_NEW_CHANNELS
	* No new channel registrations
OPER_HELP_DEFCON_NO_NEW_NICKS
	* No new nick registrations
OPER_HELP_DEFCON_NO_MLOCK_CHANGE
	* No MLOCK changes
OPER_HELP_DEFCON_FORCE_CHAN_MODES
	* Force Chan Modes (%s) to be set on all channels
OPER_HELP_DEFCON_REDUCE_SESSION
	* Use the reduced session limit of %d
OPER_HELP_DEFCON_NO_NEW_CLIENTS
	* Kill any NEW clients connecting
OPER_HELP_DEFCON_OPER_ONLY
	* Ignore any non-opers with message
OPER_HELP_DEFCON_SILENT_OPER_ONLY
	* Silently ignore non-opers
OPER_HELP_DEFCON_AKILL_NEW_CLIENTS
	* AKILL any new clients connecting


###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_DEFCON_NO_NEW_MEMOS
	* No new memos sent
OPER_HELP_CHANKILL
	Syntax: CHANKILL [+expiry] channel reason

	Puts an AKILL for every nick on the specified channel. It
	uses the entire and complete real ident@host for every nick,
	then enforces the AKILL. 

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[   - %s] %s
NEWS_OPER_TEXT
	[  Opers - %s] %s
NEWS_RANDOM_TEXT
	[     - %s] %s

NEWS_LOGON_SYNTAX
	: LOGONNEWS {ADD|DEL|LIST} [|]
NEWS_LOGON_LIST_HEADER
	:
NEWS_LOGON_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_LOGON_LIST_NONE
	    .
NEWS_LOGON_ADD_SYNTAX
	: LOGONNEWS ADD 
NEWS_LOGON_ADD_FULL
	     !
NEWS_LOGON_ADDED
	       (#%d).
NEWS_LOGON_DEL_SYNTAX
	: LOGONNEWS DEL { | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	   #%d  !
NEWS_LOGON_DELETED
	     #%d .
NEWS_LOGON_DEL_NONE
	      !
NEWS_LOGON_DELETED_ALL
	      .

NEWS_OPER_SYNTAX
	: OPERNEWS {ADD|DEL|LIST} [|]	
NEWS_OPER_LIST_HEADER
	  Opers:
NEWS_OPER_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_OPER_LIST_NONE
	     opers.
NEWS_OPER_ADD_SYNTAX
	: OPERNEWS ADD 
NEWS_OPER_ADD_FULL
	   !
NEWS_OPER_ADDED
	      opers  (#%d).
NEWS_OPER_DEL_SYNTAX
	: OPERNEWS DEL { | ALL}
NEWS_OPER_DEL_NOT_FOUND
	  #%d    !
NEWS_OPER_DELETED
	  #%d .
NEWS_OPER_DEL_NONE
	       !
NEWS_OPER_DELETED_ALL
	     opers .

NEWS_RANDOM_SYNTAX
	: RANDOMNEWS {ADD|DEL|LIST} [|]
NEWS_RANDOM_LIST_HEADER
	   :
NEWS_RANDOM_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_RANDOM_LIST_NONE
	  .
NEWS_RANDOM_ADD_SYNTAX
	: RANDOMNEWS ADD 
NEWS_RANDOM_ADD_FULL
	   !
NEWS_RANDOM_ADDED
	      (#%d).
NEWS_RANDOM_DEL_SYNTAX
	: RANDOMNEWS DEL { | ALL}
NEWS_RANDOM_DEL_NOT_FOUND
	    #%d  !
NEWS_RANDOM_DELETED
	    #%d .
NEWS_RANDOM_DEL_NONE
	     !
NEWS_RANDOM_DELETED_ALL
	   .

NEWS_HELP_LOGON
	: LOGONNEWS ADD 
	        LOGONNEWS DEL { | ALL}
	        LOGONNEWS LIST
	
	        .
	     ,     
	(    ,      flood.
	    ,        ).
	    
	LOGONNEWS LIST     IRC operator   
	    .  ADD  DEL    
	   (services admins).

NEWS_HELP_OPER
	: OPERNEWS ADD 
	        OPERNEWS DEL { | ALL}
	        OPERNEWS LIST
	
	        opers.   
	    oper ( /OPER ),   
	  .  (       
	    flood.      
	,         .)
	    
	OPERNEWS LIST      IRC operators.
	       .  ADD  DEL   
	   .

NEWS_HELP_RANDOM
	: RANDOMNEWS ADD 
	        RANDOMNEWS DEL { | ALL}
	        RANDOMNEWS LIST
	
	  ,         .
	     ,  (  )  
	      .
	
	RANDOMNEWS LIST      IRC operators  
	  .  ADD  DEL    
	   (Services admins).

###########################################################################
#
# HelpServ help message
#
###########################################################################

HELP_HELP
	%S          
	 .       HELP 
	    ()   :

	%R%s HELP
	           

	%R%s HELP
	             
	      .

	%R%s HELP
	             off-line 

HELP_HELP_BOT

	%R%s HELP
	            bot   

HELP_HELP_HOST

	%R%s HELP
	     for information on setting up nick vHosts

###########################################################################
#
# NickServ help messages
#
###########################################################################
NICK_HELP_CMD_CONFIRM
	    CONFIRM    Confirm a nickserv auth code
NICK_HELP_CMD_RESEND
	    RESEND     Resend a nickserv auth code

NICK_HELP_CMD_REGISTER
	    REGISTER     
NICK_HELP_CMD_GROUP
	    GROUP         
NICK_HELP_CMD_IDENTIFY
	    IDENTIFY        
NICK_HELP_CMD_ACCESS
	    ACCESS          
NICK_HELP_CMD_SET
	    SET         ,     
NICK_HELP_CMD_SASET
	    SASET      Set SET-options on another nickname
NICK_HELP_CMD_DROP
	    DROP         
NICK_HELP_CMD_RECOVER
	    RECOVER             
NICK_HELP_CMD_RELEASE
	    RELEASE        ,  RECOVER
NICK_HELP_CMD_SENDPASS
	    SENDPASS     ?       
NICK_HELP_CMD_GHOST
	    GHOST      Disconnects a "ghost" IRC session using your nick
NICK_HELP_CMD_ALIST
	    ALIST      List channels you have access on
NICK_HELP_CMD_GLIST
	    GLIST      Lists all nicknames in your group
NICK_HELP_CMD_INFO
	    INFO       Displays information about a given nickname
NICK_HELP_CMD_LIST
	    LIST       List all registered nicknames that match a given pattern
NICK_HELP_CMD_LOGOUT
	    LOGOUT     Reverses the effect of the IDENTIFY command
NICK_HELP_CMD_STATUS
	    STATUS     Returns the owner status of the given nickname
NICK_HELP_CMD_UPDATE
	    UPDATE     Updates your current status, i.e. it checks for new memos
NICK_HELP_CMD_GETPASS
	    GETPASS          
	               (     )
NICK_HELP_CMD_GETEMAIL
	    GETEMAIL   Matches and returns all users that registered using given email
NICK_HELP_CMD_FORBID
	    FORBID       ,      
	               ,    kill
NICK_HELP_CMD_SUSPEND
	    SUSPEND    Suspend a given nick
NICK_HELP_CMD_UNSUSPEND
	    UNSUSPEND  Unsuspend a given nick

NICK_HELP
	O %S      ,
	      .
	  ,       
	;    ,  %R%S ^_command^_.
	      ,
	%R%S HELP ^_command^_.
	
NICK_HELP_FOOTER
	:        
	   ,     
	  .        
	  ""     
	.     %S  , ,
	    .
	
NICK_HELP_EXPIRES
	
	          
	  , ..   
	  %d    .

NICK_HELP_REGISTER
	: REGISTER password [email]
	
	      %S,   .
	  ,     
	SET  ACCESS        .
	           
	   -       
	.  (  case matters!  ANOPE, Anope,  
	anope    !)
	
	     :
	
	          .   ,
	        .
	        
	 ;) ,   ,  %S       .
	,     , '
	          5 .
	,        .
	    
	  email        
	  email    .   ',  
	      .
	   ;   e-mail    
	  .
	    
	         ,
	         
	   ,    
	  .      
	  ,  %R%S HELP GROUP.
	    
NICK_HELP_GROUP
	: GROUP  
	
	            
	  .      
	,   .
	
	      ,  
	 memos,       
	     ,   !
	     
	       .   
	        ,
	          
	    ,    
	    .
	    
	         
	    .    
	,         
	     . 
	%R%S HELP IDENTIFY   .   
	       .
	    
	        -  
	          
	  .         
	 (     )      
	     .
	    
	       .      .
	    
	:            
	.
	
NICK_HELP_IDENTIFY
	: IDENTIFY 
	
	  %S        .
	      ,    
	    .       
	          ,
	   REGISTER .
	
NICK_HELP_UPDATE
	Syntax: UPDATE

	Updates your current status, i.e. it checks for new memos,
	sets needed chanmodes (ModeonID) and updates your vhost and
	your userflags (lastseentime, etc).
	
NICK_HELP_LOGOUT
	: LOGOUT
	
	     IDENTIFY, 
	            
	. ,   ,         
	    .
	
NICK_HELP_DROP
	: DROP []
	
	      %S   .    
	       .
	
	        
	   .
	
	     ,      
	      
	with your password (%R%S HELP IDENTIFY for more
	.)
	    
NICK_HELP_ACCESS
	: ACCESS ADD ^_^_
	    ACCESS DEL ^_^_
	    ACCESS LIST
	
	        .
	        
	   %S     
	 .      
	   ,   
	  %S      IDENTIFY.
	
	:
	
	    ACCESS ADD anyone@*.bepeg.com
	             ID anyone
	             bepeg.com.
	
	    ACCESS DEL anyone@*.bepeg.com
	           .
	    
	    ACCESS LIST
	            .
	    
NICK_HELP_SET
	: SET option parameters
	
	    .      :
	
	    DISPLAY        
	    PASSWORD        
	    LANGUAGE        
	                      
	    URL          URL    
	    EMAIL         e-mail    
	    ICQ           ICQ    
	    GREET             
	    KILL       /    
	    SECURE     /   
	    PRIVATE         
	                       %R%S LIST
	    HIDE            
	    MSG              
	    AUTOOP     Should services op you automatically.    
	
	     ,   
	     (  ,
	%R%S HELP IDENTIFY).
	
	 %R%S HELP SET    
	   .

NICK_HELP_SET_DISPLAY
	: SET DISPLAY -display
	
	           
	.           .

NICK_HELP_SET_PASSWORD
	: SET PASSWORD -
	
	          
	.

NICK_HELP_SET_LANGUAGE
	: SET LANGUAGE 
	
	          
	( ,           ).
	            
	 :
	

NICK_HELP_SET_URL
	: SET URL url
	
	       URL   .  
	 URL            
	       INFO.

NICK_HELP_SET_EMAIL
	: SET EMAIL 
	
	   E-mail        .
	           
	     INFO.
	
NICK_HELP_SET_ICQ
	: SET ICQ number
	
	         ICQ.   
	              
	       INFO.
	
NICK_HELP_SET_GREET
	: SET GREET message
	
	      , 
	             
	  GREET   ,       
	   access  . 
	
NICK_HELP_SET_KILL
	: SET KILL {ON | QUICK | IMMED | OFF}
	
	      
	    .   
	  ,    
	     ,    
	     ,     
	   IRC   %S.
	
	  QUICK,    20  
	      ,     60.
	  IMMED,      
	           
	 ;       
	  .  ,   
	       .

NICK_HELP_SET_SECURE
	: SET SECURE {ON | OFF}
	
	  %S    on  off   
	   ,      
	     ,
	          access.
	  ,     access,  %S
	   auto-kill      KILL.

NICK_HELP_SET_PRIVATE
	: SET PRIVATE {ON | OFF}
	
	/   
	 %S    .     
	PRIVATE        
	      LIST  %S.
	(,    , 
	     ,  
	 INFO)

NICK_HELP_SET_HIDE
	: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	      
	       %S INFO, 
	 .       e-mail
	user@host mask (USERMASK), and last quit message (QUIT).
	 (EMAIL),       
	(USERMASK),     (QUIT).
	         
	  (OFF)    (ON).
	
NICK_HELP_SET_MSG
	: SET MSG {ON | OFF}
	
	          Services  
	  .     MSG,  Services  
	 ,     
	(notices). 
	
NICK_HELP_SET_AUTOOP
	Syntax: SET AUTOOP {ON | OFF}
	
	Sets whether you will be opped automatically. Set to ON to 
	allow ChanServ to op you automatically when entering channels.

NICK_HELP_SASET
	Syntax: SASET nickname option parameters.
	
	Sets various nickname options.  option can be one of:
	
	    DISPLAY    Set the display of the group in Services
	    PASSWORD   Set the nickname password
	    URL        Associate a URL with the nickname
	    EMAIL      Associate an E-mail address with the nickname
	    ICQ        Associate an ICQ number with the nickname
	    GREET      Associate a greet message with the nickname
	    KILL       Turn protection on or off
	    SECURE     Turn nickname security on or off
	    PRIVATE    Prevent the nickname from appearing in a
	                   %R%S LIST
	    HIDE       Hide certain pieces of nickname information
	    MSG        Change the communication method of Services
	    NOEXPIRE   Prevent the nickname from expiring
	
	Type %R%S HELP SASET option for more information
	on a specific option. The options will be set on the given
	nickname. 
	
	Limited to Services admins.

NICK_HELP_SASET_DISPLAY
	Syntax: SASET nickname DISPLAY new-display
	
	Changes the display used to refer to the nickname group in 
	Services. The new display MUST be a nick of the group.
	
	Limited to Services admins.

NICK_HELP_SASET_PASSWORD
	Syntax: SET nickname PASSWORD new-password
	
	Changes the password used to identify as the nick's	owner.
	
	Limited to Services admins.

NICK_HELP_SASET_URL
	Syntax: SASET nickname URL url
	
	Associates the given URL with the nickname.  This URL
	will be displayed whenever someone requests information
	on the nick with the INFO command.
	
	Limited to Services admins.

NICK_HELP_SASET_EMAIL
	Syntax: SASET nickname EMAIL address
	
	Associates the given E-mail address with the nickname.
	
	Limited to Services admins.
	
NICK_HELP_SASET_ICQ
	Syntax: SASET nickname ICQ number
	
	Associates the given ICQ number with the nickname.  This 
	number will be displayed whenever someone requests 
	information on the nick with the INFO command.
	
	Limited to Services admins.
	
NICK_HELP_SASET_GREET
	Syntax: SASET nickname GREET message
	
	Makes the given message the greet of the nickname, that
	will be displayed when joining a channel that has GREET
	option enabled, provided that the user has the necessary 
	access on it.
	
	Limited to Services admins.

NICK_HELP_SASET_KILL
	Syntax: SASET nickname KILL {ON | QUICK | IMMED | OFF}
	
	Turns the automatic protection option for the nick
	on or off.  With protection on, if another user
	tries to take the nick, they will be given one minute to
	change to another nick, after which %S will forcibly change
	their nick.
	
	If you select QUICK, the user will be given only 20 seconds
	to change nicks instead of the usual 60.  If you select
	IMMED, user's nick will be changed immediately without being
	warned first or given a chance to change their nick; please
	do not use this option unless necessary.  Also, your
	network's administrators may have disabled this option.
	
	Limited to Services admins.

NICK_HELP_SASET_SECURE
	Syntax: SASET nickname SECURE {ON | OFF}
	
	Turns %S's security features on or off for your
	nick.  With SECURE set, you must enter your password
	before you will be recognized as the owner of the nick,
	regardless of whether your address is on the access
	list.  However, if you are on the access list, %S
	will not auto-kill you regardless of the setting of the
	KILL option.
	
	Limited to Services admins.

NICK_HELP_SASET_PRIVATE
	Syntax: SASET nickname PRIVATE {ON | OFF}
	
	Turns %S's privacy option on or off for the nick.
	With PRIVATE set, the nickname will not appear in
	nickname lists generated with %S's LIST command.
	(However, anyone who knows the nickname can still get
	information on it using the INFO command.)
	
	Limited to Services admins.

NICK_HELP_SASET_HIDE
	Syntax: SASET nickname HIDE {EMAIL | STATUS | USERMASK | QUIT} {ON | OFF}
	
	Allows you to prevent certain pieces of information from
	being displayed when someone does a %S INFO on the
	nick.  You can hide the E-mail address (EMAIL), last seen
	user@host mask (USERMASK), the services access status
	(STATUS) and  last quit message (QUIT).
	The second parameter specifies whether the information should
	be displayed (OFF) or hidden (ON).
	
	Limited to Services admins.
	
NICK_HELP_SASET_MSG
	Syntax: SASET nickname MSG {ON | OFF}
	
	Allows you to choose the way Services are communicating with 
	the given user. With MSG set, Services will use messages,
	else they'll use notices.
	
	Limited to Services admins.

NICK_HELP_SASET_NOEXPIRE
	Syntax: SASET nickname NOEXPIRE {ON | OFF}
	
	Sets whether the given nickname will expire.  Setting this
	to ON prevents the nickname from expiring.
	
	Limited to Services admins.

NICK_HELP_SASET_AUTOOP
	Syntax: SASET nickname AUTOOP {ON | OFF}
	
	Sets whether the given nickname will be opped automatically.
	Set to ON to allow ChanServ to op you automatically when joining
	channels.
	
	Limited to Services admins.

NICK_HELP_RECOVER
	: RECOVER nickname [password]
	
	         
	  .      ,  
	        
	%S       
	      
	.
	
	    ,  %S  
	         
	      .   	
	 IRC servers     .  
	 ,      
	          
	 .     ,  
	   .  ,
	   RELEASE (%R%S HELP RELEASE)
	      .
	
	     RECOVER  
	,       
	 /WHOIS       ,
	         .
	
NICK_HELP_RELEASE
	: RELEASE  []
	
	       
	%S '       
	 RECOVER.  ,  
	   ;      
	.
	
	     RELEASE  
	,       
	 /WHOIS       ,
	         .
	
NICK_HELP_GHOST
	: GHOST  []
	
	  ""     .
	""       
	,   IRC server     
	  .  ,     
	  modem  ""       
	internet ,    IRC.
	
	     GHOST   ,
	        /WHOIS
	      ,   
	      .
	
NICK_HELP_INFO
	: INFO  [ALL]
	
	       , 
	   ,     
	     .    
	       
	   ALL  ,  
	  ,      .

NICK_HELP_LIST
	: LIST 
	
	    ,   
	    , nick!user@host   .
	     PRIVATE , 
	 .
	
	:
	
	    LIST *!joeuser@foo.com
	              
	      joeuser@foo.com.
	
	    LIST *Bot*!*@*
	             
	           Bot (   ).
	
	    LIST *!*@*.bar.org
	               
	            bar.org.

NICK_HELP_ALIST
	Syntax: ALIST [level]
	
	Lists all channels you have access on. Optionally, you can specify
	a level in XOP or ACCESS format. The resulting list will only 
	include channels where you have the given level of access.

	Examples:
	    ALIST Founder
	        Lists all channels where you have Founder
	    access.

	    ALIST AOP
	        Lists all channels where you have AOP access 
	    or greater.

	    ALIST 10
	        Lists all channels where you have level 10 
	    access or greater.
	
	Channels that have the NOEXPIRE option set will be prefixed by 
	an exclamation mark.
	
NICK_HELP_GLIST
	: GLIST
	
	        .

NICK_HELP_STATUS
	: STATUS ()...
	
	         
	  ,     .
	      :
	
	     -
	
	         ,
	     -  
	  :
	
	    0 -           
	    1 -        
	    2 -          
	    3 -            
	
	        ; 
	  . If no nickname is given, your status
	will be returned.

NICK_HELP_SENDPASS
	: SENDPASS 
	
	      the e-mail.
	          
	      .
	
	  IRC operators        .
	
	           .

NICK_HELP_CONFIRM
	Syntax: CONFIRM passcode
	
	This is the second step of nickname registration process.
	You must perform this command in order to get your nickname
	registered with %S. The passcode (or called auth code also)
	is sent to your e-mail address in the first step of the
	registration process. For more information about the first
	stage of the registration process, type: %R%S HELP REGISTER
	
NICK_SERVADMIN_HELP
	 Services admins ()       
	        ,   
	    access     (%R%S ACCESS LIST nick).
	
NICK_SERVADMIN_HELP_LOGOUT
	: LOGOUT [ [REVALIDATE]]
	
	  ,      IDENTIFY () 
	        .
	,   ,        .
	    
	   ,       .   
	REVALIDATE,        .
	     () Services admins.
	
NICK_SERVADMIN_HELP_DROP
	: DROP []
	
	  ,       
	%S   ..
	
	  ,       .
	             
	   .          
	  () Services admins.
	
NICK_SERVADMIN_HELP_INFO
	
	 Services admins     ALL   
	 .

NICK_SERVADMIN_HELP_LIST
	: LIST pattern [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
	
	           
	pattern,   nick!user@host.     PRIVATE
	    () Services admins.   
	 NOEXPIRE    !        
	  () Services admins.
	    
	:
	
	    LIST *!joeuser@foo.com
	                joeuser@foo.com.
	
	    LIST *Bot*!*@*
	             Bot.
	        
	    LIST * NOEXPIRE
	                no-expire.
	        
NICK_SERVADMIN_HELP_ALIST
	Syntax: ALIST [nickname] [level]
	
	With no parameters, lists channels you have access on. With
	one parameter, lists channels that nickname has access 
	on. With two parameters lists channels that nickname has 
	level access or greater on.

	This use limited to Services admins.

NICK_SERVADMIN_HELP_GLIST
	: GLIST []
	
	  ,       
	  .
	    
	  ,        
	  .   Services admins 
	   .
	
NICK_SERVADMIN_HELP_GETPASS
	: GETPASS 
	
	      .   
	   ,       
	          
	    WALLOPS/GLOBOPS.
	
	   Services admins.
	
	          .

NICK_SERVADMIN_HELP_GETEMAIL
	Syntax: GETEMAIL user@emailhost

	Returns the matching nicks that used given email. Note that
	you can not use wildcards for either user or emailhost. Whenever
	this command is used, a message including the person who issued
	the command and the email it was used on will be logged.

	Limited to Services admins.

NICK_SERVADMIN_HELP_FORBID
	: FORBID  []
	
	         
	.         .
	
	  ,      .
	
	   Services admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

NICK_SERVADMIN_HELP_SUSPEND
	Syntax: SUSPEND nickname reason / UNSUSPEND nickname

	SUSPENDs / UNSUSPENDs a nickname from being identified to
	
	Limited to Services admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

NICK_SERVADMIN_HELP_UNSUSPEND
	Syntax: UNSUSPEND nickname

	UNSUSPENDS a nickname from being used.

	Limited to Services admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################
CHAN_HELP_CMD_GETPASS
	    GETPASS         
CHAN_HELP_CMD_FORBID
	    FORBID       ,     
CHAN_HELP_CMD_SUSPEND
	    SUSPEND    Prevent a channel from being used preserving
	               channel data and settings
CHAN_HELP_CMD_UNSUSPEND
	    UNSUSPEND  Releases a suspended channel
CHAN_HELP_CMD_STATUS
	    STATUS        access level   
	               
CHAN_HELP_CMD_REGISTER
	    REGISTER     
CHAN_HELP_CMD_IDENTIFY
	    IDENTIFY      
CHAN_HELP_CMD_SET
	    SET             
	                	
CHAN_HELP_CMD_AOP
	    AOP            AOP 
CHAN_HELP_CMD_SOP
	    SOP            SOP 
CHAN_HELP_CMD_ACCESS
	    ACCESS          
CHAN_HELP_CMD_LEVELS
	    LEVELS          
CHAN_HELP_CMD_AKICK
	    AKICK          
CHAN_HELP_CMD_DROP
	    DROP           
CHAN_HELP_CMD_SENDPASS
	    SENDPASS        
CHAN_HELP_CMD_BAN
	    BAN        Bans a selected nick on a channel
CHAN_HELP_CMD_CLEAR
	    CLEAR      Tells ChanServ to clear certain settings on a channel
CHAN_HELP_CMD_DEVOICE
	    DEVOICE    Devoices a selected nick on a channel
CHAN_HELP_CMD_GETKEY
	    GETKEY     Returns the key of the given channel
CHAN_HELP_CMD_INFO
	    INFO       Lists information about the named registered channel
CHAN_HELP_CMD_INVITE
	    INVITE     Tells ChanServ to invite you or a given nick into a channel
CHAN_HELP_CMD_KICK
	    KICK       Kicks a selected nick from a channel
CHAN_HELP_CMD_LIST
	    LIST       Lists all registered channels matching the given pattern
CHAN_HELP_CMD_LOGOUT
	    LOGOUT     This command will logout the selected nickname
CHAN_HELP_CMD_OP
	    OP         Gives Op status to a selected nick on a channel
CHAN_HELP_CMD_TOPIC
	    TOPIC      Manipulate the topic of the specified channel
CHAN_HELP_CMD_UNBAN
	    UNBAN      Remove all bans preventing you from entering a channel
CHAN_HELP_CMD_VOICE
	    VOICE      Voices a selected nick on a channel
CHAN_HELP_CMD_VOP
	    VOP        Maintains the VOP (VOicePeople) list for a channel
CHAN_HELP_CMD_DEHALFOP
	    DEHALFOP   Dehalfops a selected nick on a channel
CHAN_HELP_CMD_DEOWNER
	    DEOWNER    Removes your owner status on a channel
CHAN_HELP_CMD_DEPROTECT
	    DEPROTECT  Deprotects a selected nick on a channel
CHAN_HELP_CMD_HALFOP
	    HALFOP     Halfops a selected nick on a channel
CHAN_HELP_CMD_HOP
	    HOP        Maintains the HOP (HalfOP) list for a channel
CHAN_HELP_CMD_OWNER
	    OWNER      Gives you owner status on channel
CHAN_HELP_CMD_PROTECT
	    PROTECT    Protects a selected nick on a channel
CHAN_HELP_CMD_ADMIN
	    ADMIN      Protects a selected nick on a channel
CHAN_HELP_CMD_DEADMIN
	    DEADMIN    Deprotects a selected nick on a channel
CHAN_HELP_CMD_DEOP
	    DEOP       Deops a selected nick on a channel

CHAN_HELP
	 %S       
	   .   %S  
	      "" 
	,       
	 .    , 
	.     , 
	%R%S .      
	 ,  %R%S HELP .
	 
	
CHAN_HELP_EXPIRES
	
	:      %d 
	(     access    
	     )   .

CHAN_HELP_REGISTER
	: REGISTER   
	
	       %S.  
	    ,    
	       
	.       
	IDENTIFY        
	   .    ,
	     ,   	
	      .
	
	   ,   "" .
	   ,     
	 ;  	%S     
	    ,   
	  .   ACCESS command.
	(%R%S HELP ACCESS)        
	 ,     .
	    
	:     ,   
	    .      ,
	%R%s HELP    .

CHAN_HELP_IDENTIFY
	: IDENTIFY  
	
	   %S  founder   .
	         
	.             
	  .
	
CHAN_HELP_LOGOUT
	: LOGOUT  
	
	          
	   .
	
	   founder  ,    log out ,
	     log out   .

CHAN_HELP_DROP
	: DROP 
	
	   ,    founder.  
	    founder,   IDENTIFY    drop.

CHAN_HELP_SET
	: SET   
	
	  founder         
	   .
	
	 :
	
	    FOUNDER         founder  
	    SUCCESSOR       successor  
	    PASSWORD          founder
	    DESC              
	    URL             URL   
	    EMAIL           E-mail   
	    ENTRYMSG              
	                         
	    BANTYPE           ban     Services
	    MLOCK           Modes  
	    KEEPTOPIC        topic     
	    OPNOTICE              OP/DEOP 
	         
	    PEACE             "" 
	    PRIVATE               LIST
	    RESTRICTED           access 
	    SECURE          %S , 
	    SECUREOPS        access   op
	    SECUREFOUNDER   founder   
	    SIGNKICK      . kicks       KICK
	    TOPICLOCK      Topic       TOPIC
	    XOP             ON   AOP/SOP,  off  access
	
	 %R%S HELP    
	   .

CHAN_HELP_SET_FOUNDER
	: SET  FOUNDER 
	
	  founder  .       
	.

CHAN_HELP_SET_SUCCESSOR
	: SET  SUCCESSOR 
	
	  successor  .      founder
	   (drop)       .
	 successor     founder  .
	 ,  successor    ,
	   (%d),    ,    
	successor.         .
	
CHAN_HELP_SET_PASSWORD
	: SET  PASSWORD 
	
	        founder 
	.

CHAN_HELP_SET_DESC
	: SET  DESC 
	
	    ,      
	LIST  INFO.

CHAN_HELP_SET_URL
	: SET  URL [url]
	
	  URL   .    URL 
	        
	   INFO.      ,
	   URL     .

CHAN_HELP_SET_EMAIL
	: SET  EMAIL []
	
	   E-mail   .
	        
	     ,    INFO.
	    ,    E-mail
	   .

CHAN_HELP_SET_ENTRYMSG
	: SET  ENTRYMSG []
	
	           /notice
	()     .      ,
	      ,     .

CHAN_HELP_SET_BANTYPE
	: SET  BANTYPE -ban
	
	    ban,        
	     ban    ( akick).
	
	   ban   0  3  :
	
	0:  ban     *!user@host
	1:  ban     *!*user@host
	2:  ban     *!*@host
	3:  ban     *!*user@*.domain

CHAN_HELP_SET_KEEPTOPIC
	: SET  KEEPTOPIC {ON | OFF}
	
	     topic retention  .
	  topic retention  on,  topic  
	    %S        
	 ,       .
	
CHAN_HELP_SET_TOPICLOCK
	: SET  KEEPTOPIC {ON | OFF}
	
	      topic  .
	   topic  on,  %S       
	 topic      TOPIC .
	
CHAN_HELP_SET_MLOCK
	: SET  MLOCK modes
	    
	    modes   .  %S
	     modes   
	      ( ).   modes
	    : i, k, l, m, n, p, s,  t.
	     modes   ,   
	  .
	
	  modes         
	/MODE.   modes    +    modes  
	  - .
	    
	:     mode   ,
	    ,    
	   RESTRICTED    (
	HELP SET RESTRICTED),    
	    ,      !
	
	:
	
	    SET # MLOCK +nt-iklps
	          modes n  t,    modes i,
	        k, l, p  s.  mode m,     
	        .
	
	    SET # MLOCK +knst-ilmp my-key
	          modes k, n, s  t,   
	        modes i, l, m  p.       
	          "my-key".
	
	    SET # MLOCK +
	            modes.    modes 
	              
	    .

CHAN_HELP_SET_PEACE
	: SET  PEACE {ON | OFF}
	
	     peace  .
	   peace  on,       kick,
	ban    op       
	level         %S.

CHAN_HELP_SET_PRIVATE
	: SET  PRIVATE {ON | OFF}
	
	     private   .
	   private ,     
	       %R%S LIST.

CHAN_HELP_SET_RESTRICTED
	: SET  RESTRICTED {ON | OFF}
	
	    restricted access  
	.     restricted access ,  
	   access  ,     
	kick  ban   .
	
CHAN_HELP_SET_SECURE
	: SET  SECURE {ON | OFF}
	
	       %S 
	 .     SECURE,    
	       %s   
	   ,        
	   .

CHAN_HELP_SET_SECUREOPS
	: SET  SECUREOPS {ON | OFF}
	
	      
	  .      , 
	      ,     op.
	
CHAN_HELP_SET_SECUREFOUNDER
	: SET  SECUREFOUNDER {ON | OFF}
	
	      founder   .
	     founder,    founder 
	   drop ()  ,     , 
	  founder   successor,       
	   %S.
	    
CHAN_HELP_SET_SIGNKICK
	: SET  SIGNKICK {ON | LEVEL | OFF}
	
	     signed kicks 
	.      SIGNKICK,  kicks  
	  %S KICK command will have the nick that used the
	    .
	
	  LEVEL,     level   
	  SIGNKICK level      
	kicks signed.  %R%S HELP LEVELS   . 

CHAN_HELP_SET_XOP
	: SET  XOP {ON | OFF}
	
	     xOP system   .
	    XOP,   
	 AOP/SOP/VOP,      
	   .    ACCESS.
	    
	 :     xOP , 
	  access.  access        
	  xOP ,      
	   xOP !
	    
	  xOP system    access system
	    .

CHAN_HELP_SET_OPNOTICE
	: SET  OPNOTICE {ON | OFF}
	
	      op   .
	    op,  %S   notice  ops 
	 ,       OP, DEOP, AKICK  
	ACCESS      .
	
CHAN_HELP_AOP
	: AOP  ADD 
	        AOP  DEL { |  | }
	        AOP  LIST [ | ]
	        AOP  CLEAR
	
	  AOP (AutoOP)   .   AOP 
	        opped   ,
	  unban  invite     ,     
	       ,   .
	    
	  AOP ADD      AOP.
	    
	  AOP DEL       AOP.
	     -,     .
	(      LIST.)
	
	  AOP LIST    AOP.    
	 ,         .
	  list   -,       
	.          .
	 :

	   AOP # LIST 2-5,7-9
	          AOP     
	       2  5  7  9.
	            
	  AOP CLEAR        AOP.
	    
	  AOP ADD  AOP DEL   
	SOPs  ,    AOP CLEAR    
	  founder  . ,    
	   AOP LIST.
	
	          , 
	        access list.  
	%R%S HELP ACCESS       access list,
	 %R%S HELP SET XOP         
	access list  xOP list .

CHAN_HELP_HOP
	: HOP  ADD 
	        HOP  DEL { | - | list}
	    HOP  LIST [ | list]	        
	        HOP  CLEAR
	
	   HOP (HalfOP)  .   HOP 
	        halfopped  
	 .
	
	  HOP ADD     	HOP.
	    
	  HOP DEL       HOP.
	      -,  
	 .  (      LIST.)
	
	  HOP LIST    HOP.      
	         .
	  list   -,       
	.         .
	
	:
	
	   HOP # LIST 2-5,7-9
	          HOP     
	       2  5  7  9.
	            
	  HOP CLEAR       HOP.
	    
	  HOP ADD, HOP DEL  HOP LIST   
	  AOPs(    AOP access)  , 
	   HOP CLEAR      
	founder  .
	
	          , 
	        access list.  
	%R%S HELP ACCESS       access list,
	 %R%S HELP SET XOP         
	access list  xOP list .

CHAN_HELP_SOP
	: SOP  ADD 
	    SOP  DEL { | - | list}
	        SOP  LIST [ | list]
	        SOP  CLEAR
	
	   SOP (SuperOP)  .   SOP 
	          AOP,
	     AutoKick,     
	BadWord  ,        
	,  .
	
	  SOP ADD      SOP.
	    
	 e SOP DEL       SOP.
	       -,   
	. (   LIST.)
	
	  SOP LIST    SOP.     
	 ,         
	.    list   -,     
	  .        
	 .::

	   SOP # LIST 2-5,7-9
	          SOP    
	       2  5  7  9..
	      
	  SOP CLEAR       SOP.
	    
	  SOP ADD, SOP DEL  SOP LIST   
	 founder  .     AOP 
	   SOP LIST.
	
	          , 
	        access list.  
	%R%S HELP ACCESS       access list,
	 %R%S HELP SET XOP         
	access list  xOP list .

CHAN_HELP_VOP
	: VOP  ADD 
	        VOP  DEL { | - | list}
	        VOP  LIST [ | list]
	        VOP  CLEAR
	
	   VOP (VOicePeople)  .  
	  VOP       voiced    
	voice      .
	    
	  VOP ADD     	VOP.
	    
	  VOP DEL       VOP.
	      -,  
	 .  (      LIST.)
	
	  VOP LIST    VOP.     
	,         .
	  list   -,       
	.          .
	
	:
	
	   VOP # LIST 2-5,7-9
	          VOP    
	       2  5  7  9.
	      
	  VOP CLEAR       VOP.
	    
	  VOP ADD, VOP DEL  VOP LIST   
	     AOP  ,    VOP CLEAR 
	    founder  .
	
	          , 
	        access list.  
	%R%S HELP ACCESS       access list,
	 %R%S HELP SET XOP         
	access list  xOP list .

CHAN_HELP_ACCESS
	: ACCESS  ADD  
	    ACCESS  DEL { | - | list}	        
	        ACCESS  LIST [ | list]
	        ACCESS  CLEAR
	
	  access   .    access
	     op   
	access     %S   .   
	    access  ,   .
	%R%S HELP ACCESS LEVELS    
	.         access 
	 access 0,   levels  default     
	  0     ,  access 0   auto-deop.
	
	  ACCESS ADD       
	 (level).            
	          (level).
	    
	  ACCESS DEL       access.
	       -,    .
	(     LIST.)
	
	  ACCESS LIST    access.     
	 ,          .
	  list   -,       .
	        .
	
	:

	   ACCESS # LIST 2-5,7-9
	          access    
	       2  5  7  9.
	      
	  ACCESS CLEAR       access.
	
CHAN_HELP_ACCESS_LEVELS
	User access levels
	
	 default,   access  (levels)   :
	
	   Founder   Full access  %S   ; 
	                     opping    .  
	                           founder
	                     (      ACCESS
	                         founder).
	        10      AKICK;  opping.
	         5    opping..
	         3    voicing.
	         0     ;    op  
	                     ops (      secure-ops).
	        <0       op.
	
	   (levels)   ,      ,
	   LEVELS;  %R%S HELP LEVELS 
	.

CHAN_HELP_AKICK
	: AKICK  ADD  []
	        AKICK  STICK 
	        AKICK  UNSTICK 
	        AKICK  DEL 
	        AKICK  LIST []
	        AKICK  VIEW []
	        AKICK  ENFORCE
	        AKICK  CLEAR
	
	       .
	        ,
	    ,  %S      
	(ban/kick).
	    
	  AKICK ADD    
	    .     
	  ,       kick  .
	     "You have been banned 
	from the channel" ("      ").
	
	  AKICK STICK   bans   
	 .        ban,  %S
	   .      
	 .
	
	  AKICK UNSTICK    AKICK STICK,
	       ban   .
	    
	  AKICK DEL    
	,     .   ALL 
	     .      bans 
	     .    
	 .
	
	  AKICK LIST     ,
	        
	    .
	
	  AKICK VIEW       
	AKICK LIST.
	
	  AKICK ENFORCE   %S   
	 AKICK          
	   AKICK.
	
	  AKICK CLEAR       
	 akick.

CHAN_HELP_LEVELS
	: LEVELS  SET  
	        LEVELS  {DIS | DISABLE} 
	    LEVELS  LIST
	        LEVELS  RESET
	
	  LEVELS      
	   access levels    .
	   ,     access level 
	   %S.  (  SET FOUNDER  SET PASSWORD
	    founder.)
	    
	  LEVELS SET     access level ().
	  LEVELS DISABLE ( DIS  )
	          access
	  founder  .
	   LEVELS LIST   levels ()     
	.
	  LEVELS RESET   levels ()   
	default levels (),    levels      (
	  HELP ACCESS LEVELS).
	
	             levels, 
	  HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	  feature/function .  ,
	 levels ()  AUTODEOP  NOJOIN    levels,
	       levels.

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	: INFO  [ALL]
	
	        ,
	  founder,    ,   
	 ,    mode,  .
	    ALL  
	         successor. 
	    
	 default,   ALL       
	founder access   .

CHAN_HELP_LIST
	: LIST pattern
	
	             .
	(     PRIVATE  .)

CHAN_HELP_OP
	: OP [# []]
	
	    op        .
	      op   .
	       , 8   op
	     ,     
	   .(  access)
	
	 default,      AOPs     
	  (level) 5 access     level op/deop.

CHAN_HELP_DEOP
	: DEOP [# []]
	
	    deop        .
	    ,   deop   .
	       , 8  deop   
	     ,     
	   .(  access)
	
	 default,      AOPs     
	  (level) 5 access     level op/deop.
	
CHAN_HELP_VOICE
	: VOICE [# []]
	
	    voice        .
	      voice   .
	       , 8  voice   
	     ,     
	   .(  access)
	
	 default,   AOPs      level 5 access 
	   ,    VOPs     level 3 
	     voice   .

CHAN_HELP_DEVOICE
	: DEVOICE [# []]
	
	    devoice        .
	      devoice   .
	       , 8   devoice
	     ,     
	    (  access).
	
	 default,   AOPs      level 5 access 
	   ,    VOPs     level 3 
	     devoice   .
	
CHAN_HELP_HALFOP
	: HALFOP [# []]
	
	    halfop        .
	      halfop   .
	       , 8   halfop
	     ,     
	    (  access).
	
	 default,   AOPs      level 5 access 
	  access  ,    HOPs     level 4 
	     halfop   .

CHAN_HELP_DEHALFOP
	: DEHALFOP [# []]
	
	    dehalfop        .
	      dehalfop   .
	       , 8   dehalfop
	     ,      
	    (  access).
	
	 default,   AOPs      level 5 access 
	  access  ,    HOPs     level 4 
	     dehalfop   .
	
CHAN_HELP_PROTECT
	: PROTECT [# []]
	
	           .
	        .
	       , 8  
	     ,     
	    (  access).
	
	 default,    founder,   SOPs     
	level () 10         .

CHAN_HELP_DEPROTECT
	: DEPROTECT [# []]
	
	             
	.             .
	       , 8     
	     ,     
	    (  access).
	
	 default,    founder,   SOPs     
	level () 10            .

CHAN_HELP_OWNER
	: OWNER [#]
	
	  owner status   (  founder).    
	,    owner status      , 
	     .
	
	     founder access  .

CHAN_HELP_DEOWNER
	: DEOWNER [#]
	
	      owner. 
	 
	     founder access  .
	
	
CHAN_HELP_INVITE
	: INVITE 
	
	   %S         .  
	
	 default,    AOPs      level 5 
	  .
	
CHAN_HELP_UNBAN
	: UNBAN 
	
	   %S     bans      .
	    
	 default,    AOPs     level 5 
	  .
	    
CHAN_HELP_KICK
	: KICK [# [ []]]
	
	 kick       .    ,
	  kick .      ,
	  kick            
	(access).
	    
	 default,    AOPs     level 5 access 
	   .

CHAN_HELP_BAN
	: BAN [# [ []]]
	
	 ban       .    ,
	  ban .      ,
	  ban            
	(access).
	    
	 default,    AOPs     level 5 access 
	   .

CHAN_HELP_TOPIC
	: TOPIC  [topic]
	
	   %S    topic    .
	  topic  ,    topic
	 .          
	SET TOPICLOCK.  %R%S HELP SET TOPICLOCK
	  .
	
	 default,       founder access 
	. 

CHAN_HELP_CLEAR
	: CLEAR   
	
	   %S        .   
	       :
	
	     MODES       modes    ( clears
	                  modes i,k,l,m,n,p,s,t).
	     BANS        bans   .
	     EXCEPTS     excepts   .
	     OPS        channel-operator status (mode +o) 
	                    channel operators.
	     HOPS     Removes channel-halfoperator status (mode +h) from
	                  all channel halfoperators, if supported.
	     VOICES     "voice" status (mode +v)   .
	     USERS     (kicks)      .
	
	 default, ,      founder access 
	.
	
CHAN_HELP_GETKEY
	: GETKEY 
	
	      .   
	    bots / scripts. 
	      :
	
	KEY <> <>
	
	  " "     .
	
CHAN_HELP_SENDPASS
	: SENDPASS 
	
	       e-mail address
	 founder .      
	     .
	
	   IRC operators   .
	
	         .

CHAN_SERVADMIN_HELP
	
	 Services admins     ,    
	   ,     access, AKICK,
	  level  .
	
CHAN_SERVADMIN_HELP_LOGOUT
	: LOGOUT  []
	
	   ,  founder      founder   
	     (no-identify).
	    
	  founder  ,   log out ,
	    .
	
	  Services admin,    log out 
	        founder     founder
	 . ,       
	;     log out    (identified)
	  .
	
CHAN_SERVADMIN_HELP_DROP
	: DROP 
	
	-   .    Services admins
	       ,     
	  .

CHAN_SERVADMIN_HELP_SET
	
	 Services admins     NOEXPIRE , 
	      .
	,  Services admins        
	       .

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	: SET  NOEXPIRE {ON | OFF}
	
	            ,  
	       
	   .
	
	  Services admins    .

CHAN_SERVADMIN_HELP_INFO
	
	 Services admins      ALL  
	.

CHAN_SERVADMIN_HELP_LIST
	: LIST pattern [FORBIDDEN] [NOEXPIRE]
	
	          .
	   PRIVATE     Services admins.
	   NOEXPIRE    !      
	,    Services admins.
	
	   FORBIDDEN  NOEXPIRE,      
	  FORBIDden   NOEXPIRE.
	             
	,    FORBIDden     NOEXPIRE.
	      Services admins.

CHAN_SERVADMIN_HELP_GETPASS
	: GETPASS 
	
	    .   
	   ,     
	           
	     WALLOPS/GLOBOPS.
	
	   Services admins.
	
CHAN_SERVADMIN_HELP_FORBID
	: FORBID  []
	
	          
	.          (drop).
	
	     .
	
	   Services admins.
	
CHAN_SERVADMIN_HELP_SUSPEND
	Syntax: SUSPEND channel [reason]
	
	Disallows anyone from registering or using the given
	channel.  May be cancelled by using the UNSUSPEND
	command to preserve all previous channel data/settings.
	
	Reason may be required on certain networks.
	
	Limited to Services admins.

CHAN_SERVADMIN_HELP_UNSUSPEND
	Syntax: UNSUSPEND channel
	
	Releases a suspended channel. All data and settings
	are preserved from before the suspension.
	
	Limited to Services admins.

CHAN_SERVADMIN_HELP_STATUS
	: STATUS  
	
	   access level   
	  .       :
	
	    STATUS   access-level
	
	  ,     :
	
	    STATUS ERROR -
	
	   Services admins.

###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP_CMD_SEND
	    SEND           
MEMO_HELP_CMD_CANCEL
	    CANCEL      
MEMO_HELP_CMD_LIST
	    LIST        
MEMO_HELP_CMD_READ
	    READ       
MEMO_HELP_CMD_DEL
	    DEL        
MEMO_HELP_CMD_SET
	    SET        
MEMO_HELP_CMD_INFO
	    INFO   Displays information about your memos
MEMO_HELP_CMD_RSEND
	    RSEND  Sends a memo and requests a read receipt
MEMO_HELP_CMD_CHECK
	    CHECK  Checks if last memo to a nick was read
MEMO_HELP_CMD_SENDALL
	    SENDALL  Send a memo to all registered users
MEMO_HELP_CMD_STAFF
	    STAFF  Send a memo to all opers/admins

MEMO_HELP_HEADER
	 %S       
	 IRC        
	  (     ,
	 )   (*).
	         
	     .
	
	   %S :
	

MEMO_HELP_ADMIN
	not used.
MEMO_HELP_OPER
	not used.
MEMO_HELP_FOOTER
	
	 %R%S HELP    
	    .
	
	(*) ',      
	    10   ,      
	    .       
	    LEVELS  %s.

MEMO_HELP_SEND
	: SEND { | }  
	
	       ,    
	  -.        ,
	memo-text.  When sending to a nickname, the recipient will
	          .
	      ,    .
	    
MEMO_HELP_CANCEL
	: CANCEL { | }
	
	          ,
	      ,       
	 .
	
MEMO_HELP_LIST
	: LIST [] [list | NEW]
	
	    .    NEW, 
	    ( -).     
	   "*"	      
	.        ,
	   :
	
	   LIST 2-5,7-9
	        2  5  7  9.

MEMO_HELP_READ
	: READ [] { | list | LAST | NEW}
	
	         .    LAST
	      .   
	NEW         .  ,
	     .        
	,  :
	
	    2-5,7-9
	            2   5  7   9.

MEMO_HELP_DEL
	: DEL [] { | list | LAST | ALL}
	
	     .     
	   . :
	    
	If LAST is given, the last memo will be deleted.
	  ALL,      .
	
	:
	
	   DEL 1
	         .( 1).
	
	   DEL 2-5,7-9
	           2  5  7  9.

MEMO_HELP_SET
	: SET  
	
	     .
	      :
	    
	    NOTIFY            
	                       (  )
	    LIMIT            
	                      
	
	 %R%S HELP SET    
	   .

MEMO_HELP_SET_NOTIFY
	: SET NOTIFY {ON | LOGON | NEW | OFF}	
	
	         :
	
	    ON               log on,
	                   /AWAY,     
	               .
	    LOGON             log
	               on      /AWAY.
	    NEW              
	                .
	    OFF             .
	
	  ON  , LOGON   NEW .

MEMO_HELP_SET_LIMIT
	: SET LIMIT [] 
	
	        
	     .     0, 
	      .    
	      %d.

MEMO_HELP_INFO
	: INFO []
	
	       , 
	    ,      .
	  ,        .
	
MEMO_SERVADMIN_HELP_SET_LIMIT
	: SET LIMIT [ | ] { | NONE} [HARD]
	
	          
	   .      0  
	       .    NONE
	       .    
	  ,      .
	    
	 HARD       .   
	 HARD     ,  
	     
	(        HARD).
	    
	     SET LIMIT    
	 Services admins.         
	            .
	       %d ,    
	 hard limit.
	
MEMO_SERVADMIN_HELP_INFO
	: INFO [ | ]
	
	  ,      
	  ,      ,  
	    .
	
	   ,     
	 .
	
	   ,      
	 .         Services
	admins.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_STAFF
	Syntax: STAFF memo-text

	Sends all services staff a memo containing memo-text.
	Note: If you have opers on both the oper list and the
	admin list they will recive the memo twice.  The same
	applies for oper's on the Root list as well as other
	lists.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_SENDALL
	Syntax: SENDALL memo-text

	Sends all registered users a memo containing memo-text.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_RSEND
	Syntax: RSEND {nick | channel} memo-text
	
	Sends the named nick or channel a memo containing
	memo-text.  When sending to a nickname, the recipient will
	receive a notice that he/she has a new memo.  The target
	nickname/channel must be registered.
	Once the memo is read by its recepient, an automatic notification
	memo will be sent to the sender informing him/her that the memo
	has been read.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_CHECK
	Syntax: CHECK nick
	
	Checks whether the _last_ memo you sent to nick has been read
	or not. Note that this does only work with nicks, not with chans.

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP_CMD_GLOBAL
	    GLOBAL           
OPER_HELP_CMD_STATS
	    STATS            Services   
OPER_HELP_CMD_OPER
	    OPER            Services operator
OPER_HELP_CMD_ADMIN
	    ADMIN           Services admin
OPER_HELP_CMD_STAFF
	    STAFF       Display Services staff and online status
OPER_HELP_CMD_MODE
	    MODE         modes    
OPER_HELP_CMD_KICK
	    KICK             
OPER_HELP_CMD_CLEARMODES
	    CLEARMODES    modes   
OPER_HELP_CMD_KILLCLONES
	    KILLCLONES          host
OPER_HELP_CMD_AKILL
	    AKILL        ip    AKILL
OPER_HELP_CMD_SGLINE
	    SGLINE       ip   SGLINE
OPER_HELP_CMD_SQLINE
	    SQLINE       ip   SQLINE
OPER_HELP_CMD_SZLINE
	    SZLINE       ip   SZLINE
OPER_HELP_CMD_CHANLIST
	    CHANLIST       
OPER_HELP_CMD_USERLIST
	    USERLIST       
OPER_HELP_CMD_LOGONNEWS
	    LOGONNEWS            
	         
OPER_HELP_CMD_RANDOMNEWS
	    RANDOMNEWS          
	                         
OPER_HELP_CMD_OPERNEWS
	    OPERNEWS            
	         oper
OPER_HELP_CMD_SESSION
	    SESSION          host sessions
OPER_HELP_CMD_EXCEPTION
	    EXCEPTION       session-limit exception
OPER_HELP_CMD_NOOP
	    NOOP            O:   server 
	                    
OPER_HELP_CMD_JUPE
	    JUPE        "Jupiter"  server
OPER_HELP_CMD_IGNORE
	    IGNORE      Modify the Services ignore list
OPER_HELP_CMD_SET
	    SET             Services
OPER_HELP_CMD_RELOAD
	    RELOAD        services' configuration 
OPER_HELP_CMD_UPDATE
	    UPDATE        Services ( ) 
	                      update   
OPER_HELP_CMD_RESTART
	    RESTART            Services
OPER_HELP_CMD_QUIT
	    QUIT            Services     
OPER_HELP_CMD_SHUTDOWN
	    SHUTDOWN        Services    
	        
OPER_HELP_CMD_DEFCON
	    DEFCON      Manipulate the DefCon system
OPER_HELP_CMD_CHANKILL
	    CHANKILL    Kill all users on a specific channel
OPER_HELP_CMD_OLINE
	    OLINE       Give Operflags to a certain user
OPER_HELP_CMD_UMODE
	    UMODE       Change a user's modes
OPER_HELP_CMD_SVSNICK
	    SVSNICK     Forcefully change a user's nickname
OPER_HELP_CMD_MODLOAD
	    MODLOAD     Load a module
OPER_HELP_CMD_MODUNLOAD
	    MODUNLOAD   Un-Load a module
OPER_HELP_CMD_MODINFO
	    MODINFO     Info about a loaded module
OPER_HELP_CMD_MODLIST
	    MODLIST     List loaded modules

OPER_HELP
	   %S ::

OPER_HELP_LOGGED
	:      %S  !

OPER_HELP_GLOBAL
	: GLOBAL 
	
	  IRCops         
	.          %s.
	
OPER_HELP_STATS
	: STATS [AKILL | ALL | RESET]
	
	  ,       
	IRCops     (   Services),   
	        Services ,  
	   Services   .
	
	
	   AKILL,    .
	
	AKILL   default  .
	
	The RESET option currently resets the maximum user count
	to the number of users currently present on the network.
	
	UPTIME may be used as a synonym for STATS.

OPER_HELP_OPER
	: OPER ADD 
	        OPER DEL { | - | }
	        OPER LIST [ | ]
	        OPER CLEAR
	
	     Services admins     
	    Services operator.        
	Services operator           %s
	     Services operator.
	
	  OPER ADD     
	 Services operator.
	
	  OPER DEL       
	 Services operator.       - , 
	   .  (      LIST.)
	
	  OPER LIST     Services operator.  
	   ,        
	        ;  :
	

	   OPER LIST 2-5,7-9
	        Services operator  	       
	             2  5  7  9.
	      
	  OPER CLEAR      
	Services operator.
	
	 IRC operator      OPER LIST.
	      Services admins.

OPER_HELP_ADMIN
	: ADMIN ADD 
	        ADMIN DEL { | - | }
	        ADMIN LIST [ | ]
	        ADMIN CLEAR
	
	  Services root      
	   Services admin.        
	   Services admin         
	%s       Services admin.
	
	  ADMIN ADD      
	Services admin.
	
	  ADMIN DEL       
	Services admin.       - ,
	   .  (      LIST.)
	
	  ADMIN LIST     Services operator.  
	   ,         
	 .      -,     
	;  :
	
	   ADMIN LIST 2-5,7-9
	          Services operator      
	         2  5  7  9..
	      
	  ADMIN CELAR      
	Services admin.
	
	K IRC operator      ADMIN LIST.
	      Services root.

OPER_HELP_IGNORE
	Syntax: IGNORE {ADD|DEL|LIST} [time] [nick]

	Allows Services Admins to make Services ignore an user for
	a certain time or until the next restart. The default time
	format is seconds. You can specify it by using units. Valid
	units are: s for seconds, m for minutes, h for hours and
	d for days. Combinations of these units are not permitted. To 
	make Services permanently ignore the user type 0 as time.

OPER_HELP_MODE
	: MODE  modes
	
	  Services operators    modes  .
	       /MODE.
	    
	   Services operators.

OPER_HELP_UMODE
	Syntax: UMODE user modes
	
	Allows Services admins to set user modes for any user.
	Parameters are the same as for the standard /MODE
	command.
	
	Limited to Services admins.

OPER_HELP_OLINE
	Syntax: OLINE user flags
	
	Allows Services admins to give Operflags to any user.
	Flags have to be prefixed with a "+" or a "-". To
	remove all flags simply type a "-" instead of any flags.

	Limited to Services admins.

OPER_HELP_CLEARMODES
	: CLEARMODES  [ALL]
	
	   binary modes (i,k,l,m,n,p,s,t)   bans  
	.     ALL ,     ops 
	voices (+o  +v modes)  .
	
	   Services operators.

OPER_HELP_KICK
	: KICK   
	
	  IRCops   kick     .
	       /KICK.
	   kick     
	IRCop   ;  :
	
	*** SpamMan has been kicked off channel #my_channel by %S (Alcan (Flood))
	
	   Services operators.

OPER_HELP_SVSNICK
	Syntax: SVSNICK nick newnick
	
	Forcefully changes a user's nickname from nick to newnick.
	
	Limited to Services admins

OPER_HELP_AKILL
	: AKILL ADD [+expiry]  
	        AKILL DEL { | - | }
	        AKILL LIST [ | ]
	        AKILL VIEW [ | ]
	        AKILL CLEAR
	
	  Services operators     AKILL.  
	             AKILL,
	 Services           (server)  
	  KILL,    servers   .  
	ban (K-line)       .
	    
	  AKILL ADD    user@host    AKILL
	              AKILL.
	 expiry       , d 
	(), h (),  m ().   ( 
	1h30m)   .       
	 default     (  +30   30 
	).      AKILL    ,  +0.
	  usermask   +,       
	       default.  
	     AKILL      
	STATS AKILL.
	
	  AKILL DEL       .  
	AKILL  .        -
	    .  (      LIST.)
	
	  AKILL LIST      AKILL.
	    ,       
	  .        -      
	,
	:

	   AKILL LIST 2-5,7-9
	            2  5  7 
	       9   AKILL.
	      
	  AKILL VIEW      AKILL LIST, 
	     AKILL,    , 
	  ,    user@host   .

	  _AKILL CLEAR_       AKILL.

	   Services operators.	
	    
OPER_HELP_SGLINE
	: SGLINE ADD [+expiry] :
	    SGLINE DEL { | - | }
	        SGLINE LIST [ | ]
	        SGLINE VIEW [ | ]
	        SGLINE CLEAR
	
	 Services operators      SGLINE.  
	         SGLINE , 
	Services      .
	    
	  SGLINE ADD       SGLINE
	        .
	 expiry       , d 
	(), h (),  m ().   ( 
	1h30m)   .       
	 default     (  +30   30 
	).      SGLINE    ,  +0.
	usermask   +,       
	       default.  
	     SGLINE      
	STATS AKILL.
	:    -    ,
	       .
	
	  SGLINE DEL      
	SGLINE list  .       - , 
	 .  (   LIST.) 
	    
	  SGLINE LIST      SGLINE.  
	    ,       
	  
	      -      ,
	:

	   SGLINE LIST 2-5,7-9
	            2  5  7 
	       9   SGLINE.
	      
	  SGLINE VIEW      SGLINE LIST,  
	     SGLINE,    ,   
	,    realname    .
	
	  SGLINE CLEAR        SGLINE.
	
	   Services operators.

OPER_HELP_SQLINE
	: SQLINE ADD [+expiry]  
	    SQLINE DEL { | - | }
	        SQLINE LIST [ | ]
	        SQLINE VIEW [ | ]
	        SQLINE CLEAR
	
	 Services operators      SQLINE.  
	          SQLINE 
	 Services           
	 (  servers).
	
	       #,  services  
	         .( IRCds 
	   ).
	
	  SQLINE ADD      SQLINE	
	    (    ).
	 expiry       , d 
	(), h (),  m ().   ( 
	1h30m)   .       
	 default     (  +30   30 
	).      SQLINE    ,  +0.  
	usermask   +,        
	       default.  
	     SQLINE      
	STATS AKILL.
	
	  SQLINE DEL      
	SQLINE list  .       - , 
	 .  (   LIST.) 
	    
	  SQLINE LIST      SQLINE.  
	    ,       
	         -     
	.
	:

	   SQLINE LIST 2-5,7-9
	            2  5  7 
	       9   SQLINE.
	      
	  SQLINE VIEW      SQLINE LIST,  
	     SQLINE,    ,   
	,    realname    .
	
	  SQLINE CLEAR      SQLINE.
	
	   Services operators.

OPER_HELP_SZLINE
	: SZLINE ADD [+expiry]  
	        SZLINE DEL { | - | }
	        SZLINE LIST [ | ]
	        SZLINE VIEW [ | ]
	        SZLINE CLEAR
	
	 Services operators      SZLINE.  
	    IP          SZLINE 
	 Services       .
	( ,   IP  PTR RR  ).
	
	  SZLINE ADD   IP    SZLINE
	   (    ).
	 expiry       , d 
	(), h (),  m ().   ( 
	1h30m)   .       
	 default     (  +30   30 
	).      SZLINE    ,  +0.
	usermask   +,       
	       default.  
	     SZLINE      e
	STATS AKILL.
	
	  SZLINE DEL      
	SZLINE list  .       - , 
	 .  (   LIST.) 
	    
	  SZLINE LIST      SZLINE.  
	    ,       
	  .        - 
	    ,
	::

	   SZLINE LIST 2-5,7-9
	            2  5  7 
	       9   SZLINE.
	      
	  SZLINE VIEW      SZLINE LIST,  
	     SZLINE,    ,   
	,    realname    .
	
	  SZLINE CLEAR       SZLINE.
	
	   Services operators.

OPER_HELP_SET
	: SET option setting
	
	      Services.  
	  :
	    READONLY      read-only  read-write mode
	    LOGCHAN    Report log messages to a channel
	    DEBUG          debug mode
	    NOEXPIRE       no expire mode
	    SUPERADMIN Activate or deactivate super-admin mode
	    SQL   	 Activate or deactivate sql mode
	    IGNORE     Activate or deactivate ignore mode
	    LIST       List the options
	
	   Services admins.

OPER_HELP_SET_READONLY
	: SET READONLY {ON | OFF}
	
	  read-only mode on  off.   read-only mode, normal
	users          Services,
	    access lists, klp.  IRCops
	me    Services     
	Services'   AKILL   drop ( )  
	  ,      
	       read-only mode     
	Services   .
	    
	       -line 
	-readonly.

OPER_HELP_SET_LOGCHAN
	Syntax: SET LOGCHAN {ON | OFF}

	With this setting on, Services will send its logs to a specified
	channel as well as the log file. LogChannel must also be defined
	in the Services configuration file for this setting to be of any
	use.

	Note: This can have strong security implications if your log
	channel is not properly secured.

OPER_HELP_SET_DEBUG
	: SET DEBUG {ON | OFF | num}
	
	  debug mode on  off.   debug mode,   data 
	   Services   debugging
	   log .    _num_ 
	 debug mode ,  debugging level 
	 num.
	
	       -line 	
	-debug.
	
OPER_HELP_SET_NOEXPIRE
	: SET NOEXPIRE {ON | OFF}
	
	  no expire mode on  off.   no expire mode, ,
	, akills  exceptions      
	    .
	
	       -line 
	-noexpire.

OPER_HELP_SET_SUPERADMIN
	Syntax: SET SUPERADMIN {ON | OFF}

	Setting this will grant you extra privlages such as the
	ability to be "founder" on all channel's etc...

	This opion is _NOT_ persistant, and should only be used when
	needed, and set back to OFF when no longer needed.

OPER_HELP_SET_SQL
	Syntax: SET SQL {ON | OFF}

	Setting this will toggle Anope's from usage of SQL, this should
	be used to disable and enable SQL should your SQL server go down
	while services are running.

OPER_HELP_SET_IGNORE
	Syntax: SET IGNORE {ON | OFF}

	Setting this will toggle Anope's usage of the IGNORE system 
	on or off.

OPER_HELP_SET_LIST
	Syntax: SET LIST

	Display the various OperServ settings

OPER_HELP_NOOP
	: NOOP SET server
	        NOOP REVOKE server
	
	  NOOP SET    O:   
	server   kill   IRCops      
	  rehashing  server. 
	    
	  NOOP REVOKE     O:    
	      server.
	
	:  server    
	Services.
	
	   Services admins.

OPER_HELP_JUPE
	: JUPE server []
	
	  Services  jupiter   server --  ,  
	  "server"    Services   
	  server   .   jupe
	      SQUIT.     
	   server  ;
	,     
	text "Juped by <>",    
	   jupitered  server.
	
	   Services admins.

OPER_HELP_RAW
	: RAW 
	
	    server    
	Services  .       
	       
	.          
	    !
	    
	   Services admins.

OPER_HELP_UPDATE
	: UPDATE
	
	xei    Services   update     
	      .
	    
	   Services admins.
	
OPER_HELP_RELOAD
	: RELOAD
	
	    Services    configuration .
	         
	 Services ( Services' ,   session 
	limitation, .)
	    
	   Services admins.

OPER_HELP_QUIT
	: QUIT
	
	    Services   ( );  
	  ( ).       
	         databases
	    (    save).
	  ,    SHUTDOWN.
	    
	   Services admins.

OPER_HELP_SHUTDOWN
	: SHUTDOWN
	
	    Services         
	.
	
	   Services admins.

OPER_HELP_RESTART
	: RESTART
	
	    Services        
	 (      
	   ).
	
	   Services admins.	

OPER_HELP_KILLCLONES
	: KILLCLONES 
	
	 Kills   -     . 
	 AKILL,   *@host,  
	.  wallops      , 
	 host      (killed). 
	        .
	    
	   Services operators.
	
OPER_HELP_CHANLIST
	: CHANLIST [{ | } [SECRET]]	
	
	          
	  IRC ,     .
	    
	  ,         .
	            
	.    SECRET        
	   +s  +p mode.
	    
	   Services admins.

OPER_HELP_USERLIST
	: USERLIST [{ | } [INVISIBLE]]
	
	          
	online  IRC ,       .
	    
	   ,       
	     (     !user@host).
	   ,         
	.   INVISIBLE,    +i flag  .
	    
	   Services admins.

OPER_HELP_MODLOAD
	Syntax: MODLOAD FileName

	This command loads the module named FileName from the modules
	directory.

	Limited to Services Roots.

OPER_HELP_MODUNLOAD
	Syntax: MODUNLOAD FileName

	This command unloads the module named FileName from the modules
	directory.

	Limited to Services Roots.

OPER_HELP_MODINFO
	Syntax: MODINFO FileName

	This command lists information about the specified loaded module

	Limited to Services Roots.

OPER_HELP_MODLIST
	Syntax: MODLIST

	Lists all currently loaded modules.

	Limited to Services Roots.


###########################################################################
#
# BotServ help messages
#
###########################################################################

BOT_HELP_CMD_BOTLIST
	BOTLIST               bots
BOT_HELP_CMD_ASSIGN
	ASSIGN                bot     
BOT_HELP_CMD_SET
	SET                    bot
BOT_HELP_CMD_KICK
	KICK                     " "
BOT_HELP_CMD_BADWORDS
	BADWORDS               
BOT_HELP_CMD_ACT
	ACT                Makes the bot do the equivalent of a "/me" command
BOT_HELP_CMD_INFO
	INFO               Allows you to see BotServ information about a channel or a bot
BOT_HELP_CMD_SAY
	SAY                Makes the bot say the given text on the given channel
BOT_HELP_CMD_UNASSIGN
	UNASSIGN           Unassigns a bot from a channel
BOT_HELP_CMD_BOT
	BOT                    bot  

BOT_HELP
	 %S     bot    .
	          
	  bots          
	  bots  . 
	    ,     
	%R%S command.    
	  %R%S HELP command. 
	    
BOT_HELP_FOOTER
	 Bot        
	%d ().
	
BOT_HELP_BOTLIST
	: BOTLIST
	
	      bots   .
	
BOT_HELP_ASSIGN
	: ASSIGN  
	
	       bot     . 
	         .
	    
BOT_HELP_UNASSIGN
	: UNASSIGN 
	
	       bot      .
	,   bot       ,
	        .
	    
BOT_HELP_INFO
	: INFO { | }
	
	      %S        bot.
	     ,      
	   kickers.      ,
	      bot.
	    
BOT_HELP_SET
	: SET   
	
	    bot.      :
	
	    DONTKICKOPS        ops     kick   bot
	    DONTKICKVOICES     voices     kick   bot
	    GREET              
	    FANTASY            fantaisist
	    SYMBIOSIS          bot     bot
	
	 %R%S HELP SET    
	   .
	
	:  access       
	level SET.
	
BOT_HELP_SET_DONTKICKOPS
	: SET  DONTKICKOPS {ON|OFF}
	
	     op   .
	  ,  ops    kick   bot
	       NOKICK level.
	
BOT_HELP_SET_DONTKICKVOICES
	: SET  DONTKICKVOICES {ON|OFF}
	
	     voices   .
	  ,  voices    kick   bot
	       NOKICK level.
	
BOT_HELP_SET_FANTASY
	: SET  FANTASY {ON|OFF}
	
	     fantasy  .
	  ,      
	!op, !deop, !voice, !devoice,!kick, !kb, !unban, !seen
	  (     
	       ,    ) 
	    
	        fantaisist
	      level   
	FANTASIA   level   
	( ,    !op,      
	access   OPDEOP level).
	
BOT_HELP_SET_GREET
	: SET  GREET {ON|OFF}
	
	     greet  .
	  ,  bot     
	      ,    
	  access  .

BOT_HELP_SET_SYMBIOSIS
	: SET  SYMBIOSIS {ON|OFF}
	
	     symbiosis  .
	  ,  bot    
	normal   %s  ,   MODEs,
	KICKs,      .

BOT_HELP_KICK
	: KICK   
	
	  bot       kick  " ".
	    :
	
	    BOLDS           bot    kick  
	        
	    BADWORDS        bot    kick  
	        
	    CAPS            bot    kick  
	         
	    COLORS          bot    kick  
	         
	    FLOOD           bot    kick  
	           
	    REPEAT          bot    kick  
	         
	    REVERSES        bot    kick  
	       (   modes)
	    UNDERLINES      bot    kick  
	         
	
	 %R%S HELP KICK    
	  .
	
	:  access       
	level SET.

BOT_HELP_KICK_BOLDS
	: KICK  BOLDS {ON|OFF} [ttb]

	   kick  .  
	,   kick   bolds (
	).

	 ttb            kick
	  ban.      ttb
	      .

BOT_HELP_KICK_COLORS
	: KICK  COLORS {ON|OFF} [ttb]

	   kick   .  ,
	     kick    .

	 ttb            kick
	  ban.      ttb
	      .

BOT_HELP_KICK_REVERSES
	: KICK  REVERSES {ON|OFF} [ttb]

	   kick       
	  .
	
	 ttb            kick
	  ban.      ttb
	      .

BOT_HELP_KICK_UNDERLINES
	: KICK  UNDERLINES {ON|OFF} [ttb]

	   kick   . 
	,      kick  
	 .

	 ttb            kick
	  ban.      ttb
	      .

BOT_HELP_KICK_CAPS
	: KICK  CAPS {ON|OFF} [ttb [min []]]

	   kick   . 
	,      kick  
	 .

	 bot   kick      min 
	    %%    
	  (  ,  default   10 
	 25%%).

	 ttb            kick
	  ban.      ttb
	      .

BOT_HELP_KICK_FLOOD
	: KICK  FLOOD {ON|OFF} [ttb [ln [secs]]]

	   kick   . 
	,      kick  
	   .     
	    ln   secs 
	(  ,  default  6   10 ).
	
	 ttb            kick
	  ban.      ttb
	      .

BOT_HELP_KICK_REPEAT
	: KICK # REPEAT {ON|OFF} [ttb [num]]

	   kick   . 
	,      kick  
	  ,   num,    
	  (   num,  defaults   3).

	 ttb            kick
	  ban.      ttb
	      .

BOT_HELP_KICK_BADWORDS
	: KICK # BADWORDS {ON|OFF} [ttb]

	   kick   .  ,
	 bot   kick          .
	
	           
	BADWORDS.  %R%S HELP BADWORDS 
	 .

	 ttb            kick
	  ban.      ttb
	      .
	
BOT_HELP_BADWORDS
	: BADWORDS  ADD  [SINGLE | START | END]
	        BADWORDS  DEL { | - | list}
	        BADWORDS  LIST [ | list]
	        BADWORDS  CLEAR
	
	  bad words   .   bad
	words        kick,
	  bad words kick  .   ,
	 %R%S HELP KICK BADWORDS.
	
	  BADWORDS ADD      
	badword.      (SINGLE),   
	kick.       (START)    
	kick        .      
	    (END)   kick      
	 /.         kick
	      .
	    
	  BADWORDS DEL       	badwords.
	       -,      
	(      LIST.)
	
	  BADWORDS LIST       .   
	 ,        .
	:
	
	   BADWORDS # LIST 2-5,7-9
	               2  5 
	      7  9.
	      
	  BADWORDS CLEAR       
	badword.

BOT_HELP_SAY
	: SAY  
	
	  bot             
	.

BOT_HELP_ACT
	: ACT  
	
	  bot  ,    "/me"
	     .


BOT_SERVADMIN_HELP_BOT
	: BOT ADD  ID host  
	        BOT CHANGE -ick - [ID [host [ ]]]
	    BOT DEL 	        
	
	   Services admins  , ,  
	   bots         
	    .
	    
	  BOT ADD   bot  , ID,
	hostname   .       
	  ,   .
	  BOT CHANGE      , ID, hostname
	    bot       ( 
	   ).
	  BOT DEL   bot    bot.  
	
	:    bot     
	 . ,       
	     bot,   kill.

BOT_SERVADMIN_HELP_SET
	
	       Services admins:
	
	    NOBOT              bot   assign    
	    PRIVATE            bot   assigned   IRC operators

BOT_SERVADMIN_HELP_SET_NOBOT
	: SET  NOBOT {ON|OFF}
	
	        unassignable (   bot).  
	 bot   assigned  ,   unassigned
	,      .
	
	   Services admins.

BOT_SERVADMIN_HELP_SET_PRIVATE
	: SET -bot PRIVATE {ON|OFF}
	
	     bot  assigned  
	     IRC operators.
	
	   Services admins.
HOST_EMPTY
	The vhost list is empty.
HOST_ENTRY
	#%d Nick:%s, vhost:%s (%s - %s)
HOST_IDENT_ENTRY
	#%d Nick:%s, vhost:%s@%s (%s - %s)
HOST_SET
	vhost for %s set to %s.
HOST_IDENT_SET
	vhost for %s set to %s@%s.
HOST_SETALL
	vhost for group %s set to %s.
HOST_DELALL
	vhosts for group %s have been removed.
HOST_DELALL_SYNTAX
	Syntax: DELALL <nick>.
HOST_IDENT_SETALL
	vhost for group %s set to %s@%s.
HOST_SET_ERROR
	Error! A vhost can only contain A-Z, a-z, 0-9, '.' and '-'.
HOST_SET_IDENT_ERROR
	A vhost ident must be in the format of a valid ident
HOST_SET_TOOLONG
	Error! The vhost is too long, please use a host shorter than %d characters.
HOST_SET_IDENTTOOLONG
	Error! The Ident is too long, please use an ident shorter than %d characters.
HOST_NOREG
	User %s not found in the nickserv db.
HOST_SET_SYNTAX
	Syntax %R%s set <nick> <hostmask>.
HOST_SETALL_SYNTAX
	Syntax %R%s setall <nick> <hostmask>.
HOST_DENIED
	Access Denied.
HOST_NOT_ASSIGNED
	Please contact an Operator to get a vhost assigned to this nick.
HOST_ACTIVATED
	Your vhost of %s is now activated.
HOST_IDENT_ACTIVATED
	Your vhost of %s@%s is now activated.
HOST_ID
	Please identify to services first.
HOST_NOT_REGED
	You need to register before a vhost can be assigned to you.
HOST_DEL
	vhost for %s removed.
HOST_DEL_SYNTAX
	Syntax: %R%s del <nick>.

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_OFF_UNREAL
	Your vhost was removed. To re-enable the standard host cloaking, type /mode %s +%s
HOST_NO_VIDENT
	Your IRCD does not support vIdent's, if this is incorrect, please report this as a possible bug

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_GROUP
	All vhost's in the group %s have been set to %s
HOST_IDENT_GROUP
	All vhost's in the group %s have been set to %s@%s

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_LIST_FOOTER
	Displayed all records (Count: %d)
HOST_LIST_RANGE_FOOTER
	Displayed records from %d to %d
HOST_LIST_KEY_FOOTER
	Displayed records matching key %s (Count: %d)

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_HELP_CMD_ON
	    ON          Activates your assigned vhost

HOST_HELP_CMD_OFF
	    OFF         Deactivates your assigned vhost

HOST_HELP_CMD_GROUP
	    GROUP       Syncs the vhost for all nicks in a group

HOST_HELP_CMD_SET
	    SET         Set the vhost of another user

HOST_HELP_CMD_SETALL
	    SETALL      Set the vhost for all nicks in a group

HOST_HELP_CMD_DEL
	    DEL         Delete the vhost of another user

HOST_HELP_CMD_DELALL
	    DELALL      Delete the vhost for all nicks in a group

HOST_HELP_CMD_LIST
	    LIST        Displays one or more vhost entries.

HOST_OPER_HELP
	not used.

HOST_ADMIN_HELP
	not used.

HOST_HELP
	%S commands:

HOST_HELP_ON
	Syntax: ON

	Activates the vhost currently assigned to the nick in use.
	When you use this command any user who performs a /whois
	on you will see the vhost instead of your real IP address.

HOST_HELP_SET
	Syntax: SET <nick> <hostmask>.

	Sets the vhost for the given nick to that of the given
	hostmask.  If your IRCD supports vIdents, then using
	SET <nick> <ident>@<hostmask> set idents for users as 
	well as vhosts.

	Limited to Services operators.

HOST_HELP_DELALL
	Syntax: DELALL <nick>.

	Deletes the vhost for all nick's in the same group as
	that of the given nick.

	Limited to Host Removers.


HOST_HELP_SETALL
	Syntax: SETALL <nick> <hostmask>.

	Sets the vhost for all nicks in the same group as that
	of the given nick.  If your IRCD supports vIdents, then
	using SETALL <nick> <ident>@<hostmask> will set idents
	for users as well as vhosts.

	* NOTE, this will not update the vhost for any nick's
	added to the group after this command was used.

	Limited to Services operators.

HOST_HELP_OFF
	Syntax: OFF

	Deactivates the vhost currently assigned to the nick in use.
	When you use this command any user who performs a /whois
	on you will see your real IP address.

HOST_HELP_DEL
	Syntax: DEL <nick>

	Deletes the vhost assigned to the given nick from the
	database.

	Limited to Services operators.

HOST_HELP_LIST
	Syntax: LIST [<key>|<#X-Y>]

	This command lists registered vhosts to the operator
	if a Key is specified, only entries whos nick or vhost match
	the pattern given in <key> are displayed e.g. Rob* for all
	entries beginning with "Rob"

	If a #X-Y style is used, only entries between the range of X
	and Y will be displayed, e.g. #1-3 will display the first 3
	nick/vhost entries.

	The list uses the value of NSListMax as a hard limit for the
	number of items to display to a operator at any 1 time.

	Limited to Services operators.

HOST_HELP_GROUP
	Syntax: GROUP
	
	This command allows users to set the vhost of thier
	CURRENT nick to be the vhost for all nicks in the same
	group.

OPER_SVSNICK_UNSUPPORTED
	Sorry, SVSNICK is not available on this network.

OPER_SQLINE_UNSUPPORTED
	Sorry, SQLINE is not available on this network.

OPER_SVSO_UNSUPPORTED
	Sorry, OLINE is not available on this network.

OPER_UMODE_UNSUPPORTED
	Sorry, UMODE is not available on this network.

OPER_SUPER_ADMIN_NOT_ENABLED
	SuperAdmin setting not enabled in services.conf

