# Portuguese language file.
#
# (C) 2003-2007 Anope Team
# Contact us at info@anope.org
#
# Please read COPYING and README for furhter details.
#
# Based on the original code of Epona by Lara.
# Based on the original code of Services by Andy Church.
#
# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, let us know
# (dev@anope.org) which message is causing a problem and I'll see
# what I can do.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# services.conf).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.
###########################################################
## Translation fully reviewed/completed/updated
## by Ricardo at 01/16/2005.
###
## Traduo totalmente revista/completada/atualizada
## por Ricardo em 16/01/2005.
## Atualizaes/Updates:
## * SVN 564 - 01/31/2005.
## * SVN 611 - 03/08/2005.
## * SVN 815 - 05/27/2005.
###########################################################
###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Portugus (Portuguese)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%d %b %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %d %b %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%d %b %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Dom
	Seg
	Ter
	Qua
	Qui
	Sex
	Sb
# %A
STRFTIME_DAYS_LONG
	Domingo
	Segunda
	Tera
	Quarta
	Quinta
	Sexta
	Sbado
# %b
STRFTIME_MONTHS_SHORT
	Jan
	Fev
	Mar
	Abr
	Mai
	Jun
	Jul
	Ago
	Set
	Out
	Nov
	Dez
# %B
STRFTIME_MONTHS_LONG
	Janeiro
	Fevereiro
	Maro
	Abril
	Maio
	Junho
	Julho
	Agosto
	Setembro
	Outubro
	Novembro
	Dezembro


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	, 


# Various error messages.
USER_RECORD_NOT_FOUND
	Erro interno - no foi possvel processar seu pedido.
UNKNOWN_COMMAND
	Comando desconhecido: %s.
UNKNOWN_COMMAND_HELP
	Comando desconhecido %s. Digite %R%s HELP para ajuda.
SYNTAX_ERROR
	Sintaxe: %s
MORE_INFO
	Digite %R%s HELP %s para maiores informaes.
NO_HELP_AVAILABLE
	Nenhuma ajuda disponvel para %s.
OBSOLETE_COMMAND
	Este comando no  mais usado; use %s.

BAD_USERHOST_MASK
	A mscara deve ser no formato user@host.
BAD_EXPIRY_TIME
	Tempo de expirao invlido.
USERHOST_MASK_TOO_WIDE
	Mscara %s  muito grande; por favor seja mais especfico.

SERVICE_OFFLINE
	%s no est conectado no momento.
READ_ONLY_MODE
	Ateno: Os services esto no modo somente leitura; as mudanas no sero salvas!
PASSWORD_INCORRECT
	Senha incorreta.
INVALID_TARGET
	"/msg %s" is no longer supported.  Use "/msg %s@%s" or "/%s" instead.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Acesso negado.
PERMISSION_DENIED
	Permisso negada.
RAW_DISABLED
	A opo RAW est desabilitada. Se realmente precisar, deve desabilitar a opo DisableRaw na configurao dos Services.

MORE_OBSCURE_PASSWORD
	Por favor tente novamente com uma senha mais difcil. No use TAB ou espaos.
PASSWORD_TRUNCATED
	Ateno: Sua senha foi reduzida a %d caracteres.

NICK_NOT_REGISTERED
	Seu nick no est registrado.
NICK_NOT_REGISTERED_HELP
	Seu nick no est registrado. Digite %R%s HELP para maiores informaes sobre como registrar o nick.
NICK_X_IS_SERVICES
	Nick %s  parte dos Services desta Rede.
NICK_X_NOT_REGISTERED
	Nick %s no est registrado.
NICK_X_IN_USE
	Nick %s est atualmente em uso.
NICK_X_NOT_IN_USE
	Nick %s no est sendo usado.
NICK_X_NOT_ON_CHAN
	%s no est atualmente no canal %s.
NICK_X_FORBIDDEN
	Nick %s no pode ser registrado ou usado.
NICK_X_FORBIDDEN_OPER
	Nick %s foi bloqueado por %s:
	%s
NICK_X_ILLEGAL
	Nick %s  um nick ilegal e no pode ser usado.
NICK_X_TRUNCATED
	Nick %s foi truncado para %d caracteres.
NICK_X_SUSPENDED
	Nick %s est atualmente suspenso.
CHAN_X_NOT_REGISTERED
	O canal %s no est registrado.
CHAN_X_NOT_IN_USE
	O canal %s no existe.
CHAN_X_FORBIDDEN
	O canal %s no pode ser registrado ou usado.
CHAN_X_FORBIDDEN_OPER
	Canal %s foi bloqueado por %s:
	%s
CHAN_X_SUSPENDED
	             Suspenso: [%s] %s
NICK_IDENTIFY_REQUIRED
	Identificao de senha requerida para usar este comando.
	Tente novamente aps digitar %R%s IDENTIFY senha.
CHAN_IDENTIFY_REQUIRED
	Identificao de senha requerida para usar este comando.
	Tente novamente aps digitar %R%s IDENTIFY %s senha.
	
MAIL_DISABLED
	Os services foram configurados para no enviar e-mail.
MAIL_INVALID
	E-mail para %s  invlido.
MAIL_X_INVALID
	%s no  um endereo de e-mail vlido.
MAIL_LATER
	No foi possvel enviar e-mail agora; tente novamente mais tarde.
MAIL_DELAYED
	Por favor aguarde %d segundos e tente novamente.
	
NO_REASON
	Sem motivo
UNKNOWN
	<desconhecido>

# Duration system
DURATION_DAY
	1 dia
DURATION_DAYS
	%d dias
DURATION_HOUR
	1 hora
DURATION_HOURS
	%d horas
DURATION_MINUTE
	1 minuto
DURATION_MINUTES
	%d minutos
DURATION_SECOND
	1 segundo
DURATION_SECONDS
	%d segundos
	
# Human readable expiration
NO_EXPIRE
	no expira
EXPIRES_SOON
	ir expirar na prxima atualizao do banco de dados
EXPIRES_M
	expira em %d minutos
EXPIRES_1M
	expira em %d minuto
EXPIRES_HM
	expira em %d horas, %d minutos
EXPIRES_H1M
	expira em %d horas, %d minuto
EXPIRES_1HM
	expira em %d hora, %d minutos
EXPIRES_1H1M
	expira em %d hora, %d minuto
EXPIRES_D
	expira em %d dias
EXPIRES_1D
	expira em %d dia

# Generic Footer message
END_OF_ANY_LIST
	Fim da lista de %s.

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
LIST_INCORRECT_RANGE
	Incorrect range specified. The correct syntax is #from-to.
CS_LIST_INCORRECT_RANGE
	To search for channels starting with #, search for the channel
	name without the #-sign prepended (anope instead of #anope).

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
HELP_LIMIT_SERV_OPER
	Limited to Services Operators.
HELP_LIMIT_SERV_ADMIN
	Limited to Services Administrators.
HELP_LIMIT_SERV_ROOT
	Limited to Services Roots.
HELP_LIMIT_IRC_OPER
	Limited to IRC Operators.
HELP_LIMIT_HOST_SETTER
	Limited to Host Setters.
HELP_LIMIT_HOST_REMOVER
	Limited to Host Removers.


###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Este nick foi registrado por outra pessoa.  Por favor escolha outro.
	(Se este for seu nick, digite %R%s IDENTIFY senha.)
NICK_IS_SECURE
	Este nick est registrado e protegido.  Se este for seu
	nick, digite %R%s IDENTIFY senha.  Caso contrrio,
	por favor escolha outro nick.
NICK_MAY_NOT_BE_USED
	Este nick no pode ser usado.  Por favor escolha outro.
FORCENICKCHANGE_IN_1_MINUTE
	Se voc no mudar seu nick em 1 minuto, eu irei mud-lo.
FORCENICKCHANGE_IN_20_SECONDS
	Se voc no mudar seu nick em 20 segundos, eu irei mud-lo.
FORCENICKCHANGE_NOW
	Este nick  registrado; voc no pode us-lo.
FORCENICKCHANGE_CHANGING
	Seu nick est sendo mudado para %s.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER senha [email]
NICK_REGISTER_SYNTAX_EMAIL
	REGISTER senha email
NICK_REGISTRATION_DISABLED
	Desculpe, registros de nick esto temporariamente desativados.
NICK_REGISTRATION_FAILED
	Desculpe, registro de nick falhou.
NICK_REG_PLEASE_WAIT
	Por favor espere %d segundos antes de usar o comando REGISTER novamente.
NICK_CANNOT_BE_REGISTERED
	O nick %s no pode ser registrado.
NICK_ALREADY_REGISTERED
	O nick %s j est registrado!
NICK_REGISTERED
	O nick %s foi registrado em sua conta: %s
NICK_REGISTERED_NO_MASK
	Nick %s registrado.
NICK_PASSWORD_IS
	Sua senha  %s - guarde ela para uso posterior.
NICK_REG_DELAY
	Voc deve estar conectado h mais de %d segundos para registrar seu nick.

# GROUP responses
NICK_GROUP_SYNTAX
	GROUP alvo senha
NICK_GROUP_DISABLED
	Desculpe, o comando GROUP est temporariamente desativado.
NICK_GROUP_FAILED
	Desculpe, o comando GROUP falhou.
NICK_GROUP_PLEASE_WAIT
	Por favor espere %d segundos antes de usar o comando GROUP novamente.
NICK_GROUP_CHANGE_DISABLED
	Seu nick j est registrado; digite %R%s DROP primeiro.
NICK_GROUP_SAME
	Voc j  um membro do grupo %s.
NICK_GROUP_TOO_MANY
	Existem muitos nicks no grupo de %s; liste-os e remova alguns.
	Digite %R%s HELP GLIST e %R%s HELP DROP para
	mais informaes.
NICK_GROUP_JOINED
	Voc  agora um membro do grupo %s.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY senha
NICK_IDENTIFY_FAILED
	Desculpe, a identificao falhou.
NICK_IDENTIFY_SUCCEEDED
	Senha aceita - voc est agora reconhecido.
NICK_IDENTIFY_EMAIL_REQUIRED
	Voc deve agora setar um e-mail para seu nick.
	Este e-mail permitir que voc receba sua senha por ele
	caso voc se esquea dela.
NICK_IDENTIFY_EMAIL_HOWTO
	Digite %R%S SET EMAIL e-mail para setar seu e-mail.
	Sua privacidade  respeitada; seu e-mail no ser dado
	para terceiros.
	
# LOGOUT responses
NICK_ALREADY_IDENTIFIED
	Voc j est identificado.

# UPDATE responses
NICK_UPDATE_SUCCESS
	Status atualizado (memos, vhost, chmodes, flags).
	
# LOGOUT responses
NICK_LOGOUT_SYNTAX
	LOGOUT
NICK_LOGOUT_SUCCEEDED
	Seu nick foi desconectado.
NICK_LOGOUT_X_SUCCEEDED
	O nick %s foi desconectado.

# DROP responses
NICK_LOGOUT_SERVICESADMIN
	Impossvel fazer logout em %s porque ele  um Administrador dos Services.

# DROP responses
NICK_DROP_DISABLED
	Desculpe, o comando DROP est temporariamente desativado.
NICK_DROPPED
	O registro do seu nick foi cancelado.
NICK_X_DROPPED
	O nick %s foi desregistrado.

# SET responses
NICK_SET_SYNTAX
	SET opes parmetros
NICK_SET_SERVADMIN_SYNTAX
	SET [nick] opes parmetros
NICK_SET_DISABLED
	Desculpe, a opo SET est temporariamente desativada.
NICK_SET_UNKNOWN_OPTION
	Opo SET desconhecida: %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Opo SET desconhecida: %s, ou nick no registrado.
NICK_SET_OPTION_DISABLED
	Opo %s no pode ser usada nesta Rede.

# SET DISPLAY responses
NICK_SET_DISPLAY_INVALID
	O novo display deve ser um nick do seu grupo!
NICK_SET_DISPLAY_CHANGED
	O novo display  agora %s.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Desculpe, no foi possvel alterar a senha.
NICK_SET_PASSWORD_CHANGED
	Senha alterada.
NICK_SET_PASSWORD_CHANGED_TO
	Senha alterada para %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE nmero
NICK_SET_LANGUAGE_UNKNOWN
	Nmero de linguagem desconhecida %d. Digite %R%s HELP SET LANGUAGE para uma lista das linguagens disponveis.
NICK_SET_LANGUAGE_CHANGED
	Linguagem alterada para Portugus.

# SET URL responses
NICK_SET_URL_CHANGED
	URL alterada para %s.
NICK_SET_URL_UNSET
	URL removida.

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	E-mail alterado para %s.
NICK_SET_EMAIL_UNSET
	E-mail removido.
NICK_SET_EMAIL_UNSET_IMPOSSIBLE
	Voc no pode remover o e-mail nesta Rede.
	
# SET ICQ responses
NICK_SET_ICQ_CHANGED
	Nmero de ICQ alterado para %s.
NICK_SET_ICQ_UNSET
	Nmero de ICQ removido.
NICK_SET_ICQ_INVALID
	%s no  um nmero vlido.
	
# SET GREET responses
NICK_SET_GREET_CHANGED
	Mensagem de entrada alterada para %s.
NICK_SET_GREET_UNSET
	Mensagem de entrada removida.

# SET PROTECT responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	Proteo de KILL est agora ATIVADA.
NICK_SET_KILL_QUICK
	Proteo de KILL est agora ATIVADA, com tempo de espera reduzido.
NICK_SET_KILL_IMMED
	Proteo de KILL est agora ATIVADA, sem tempo de espera.
NICK_SET_KILL_IMMED_DISABLED
	O comando IMMED no est disponvel nesta Rede.
NICK_SET_KILL_OFF
	Proteo de KILL est agora DESATIVADA.

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	Opo SECURE est agora ATIVADA.
NICK_SET_SECURE_OFF
	Opo SECURE est agora DESATIVADA.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	Opo PRIVATE est agora ATIVADA.
NICK_SET_PRIVATE_OFF
	Opo PRIVATE est agora DESATIVADA.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | STATUS | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Seu e-mail est agora escondido do comando %s INFO.
NICK_SET_HIDE_EMAIL_OFF
	Seu e-mail ir agora aparecer no comando %s INFO.
NICK_SET_HIDE_MASK_ON
	Seu ltimo endereo usado (user@host) est agora escondido do comando %s INFO.
NICK_SET_HIDE_MASK_OFF
	Seu ltimo endereo usado (user@host) ir agora aparecer no comando %s INFO.
NICK_SET_HIDE_QUIT_ON
	Sua ltima mensagem de sada est agora escondida do comando %s INFO.
NICK_SET_HIDE_QUIT_OFF
	Sua ltima mensagem de sada ir agora aparecer no comando %s INFO.
NICK_SET_HIDE_STATUS_ON
	Seu status de acesso nos Services est agora escondido do comando %s INFO.
NICK_SET_HIDE_STATUS_OFF
	Seu status de acesso nos Services ir agora aparecer no comando %s INFO.
	
# SET MSG responses
NICK_SET_MSG_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_MSG_ON
	Os services iro agora respond-lo atravs de mensagens.
NICK_SET_MSG_OFF
	Os services iro agora respond-lo atravs de notices.

# SET AUTOOP responses
NICK_SET_AUTOOP_SYNTAX
	SET AUTOOP {ON | OFF}
NICK_SET_AUTOOP_ON
	Services will now autoop you in channels.
NICK_SET_AUTOOP_OFF
	Services will no longer autoop you in channels.

# SET NOEXPIRE responses
NICK_SASET_SYNTAX
	SASET nickname option parameters
NICK_SASET_DISABLED
	Sorry, nickname option setting is temporarily disabled.
NICK_SASET_UNKNOWN_OPTION
	Unknown SASET option %s.
NICK_SASET_BAD_NICK
	Nickname %s not registered.
NICK_SASET_OPTION_DISABLED
	Option %s cannot be set on this network.

# SASET DISPLAY responses
NICK_SASET_DISPLAY_INVALID
	The new display for %s MUST be a nickname of the nickname group!
NICK_SASET_DISPLAY_CHANGED
	The new display is now %s.

# SASET PASSWORD responses
NICK_SASET_PASSWORD_FAILED
	Sorry, couldn't change password for %s.
NICK_SASET_PASSWORD_CHANGED
	Password for %s changed.
NICK_SASET_PASSWORD_CHANGED_TO
	Password for %s changed to %s.

# SASET LANGUAGE responses
NICK_SASET_URL_CHANGED
	URL for %s changed to %s.
NICK_SASET_URL_UNSET
	URL %s unset.

# SASET EMAIL responses
NICK_SASET_EMAIL_CHANGED
	E-mail address for %s changed to %s.
NICK_SASET_EMAIL_UNSET
	E-mail address for %s unset.
NICK_SASET_EMAIL_UNSET_IMPOSSIBLE
	You cannot unset the e-mail on this network.
	
# SASET ICQ responses
NICK_SASET_ICQ_CHANGED
	ICQ number for %s set to %s.
NICK_SASET_ICQ_UNSET
	ICQ number for %s unset.
NICK_SASET_ICQ_INVALID
	%s is not a valid number.
	
# SASET GREET responses
NICK_SASET_GREET_CHANGED
	Greet message for %s changed to %s.
NICK_SASET_GREET_UNSET
	Greet message for %s unset.

# SASET PROTECT responses
NICK_SASET_KILL_SYNTAX
	SASET nickname KILL {ON | QUICK | OFF}
NICK_SASET_KILL_IMMED_SYNTAX
	SASET nickname KILL {ON | QUICK | IMMED | OFF}
NICK_SASET_KILL_ON
	Protection is now ON for %s.
NICK_SASET_KILL_QUICK
	Protection is now ON for %s, with a reduced delay.
NICK_SASET_KILL_IMMED
	Protection is now ON for %s, with no delay.
NICK_SASET_KILL_IMMED_DISABLED
	The IMMED option is not available on this network.
NICK_SASET_KILL_OFF
	Protection is now OFF for %s.

# SASET SECURE responses
NICK_SASET_SECURE_SYNTAX
	SASET nickname SECURE {ON | OFF}
NICK_SASET_SECURE_ON
	Secure option is now ON for %s.
NICK_SASET_SECURE_OFF
	Secure option is now OFF for %s.

# SASET PRIVATE responses
NICK_SASET_PRIVATE_SYNTAX
	SASET nickname PRIVATE {ON | OFF}
NICK_SASET_PRIVATE_ON
	Private option is now ON for %s.
NICK_SASET_PRIVATE_OFF
	Private option is now OFF for %s.

# SASET HIDE responses
NICK_SASET_HIDE_SYNTAX
	SET nickname HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SASET_HIDE_EMAIL_ON
	The E-mail address of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_EMAIL_OFF
	The E-mail address of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_MASK_ON
	The last seen user@host mask of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_MASK_OFF
	The last seen user@host mask of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_QUIT_ON
	The last quit message of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_QUIT_OFF
	The last quit message of %s will now be shown in %s INFO displays.
NICK_SASET_HIDE_STATUS_ON
	The services access status of %s will now be hidden from %s INFO displays.
NICK_SASET_HIDE_STATUS_OFF
	The services access status of %s will now be shown in %s INFO displays.
	
# SASET MSG responses
NICK_SASET_MSG_SYNTAX
	SSAET nickname PRIVATE {ON | OFF}
NICK_SASET_MSG_ON
	Services will now reply to %s with messages.
NICK_SASET_MSG_OFF
	Services will now reply to %s with notices.

# SET NOEXPIRE responses
NICK_SASET_NOEXPIRE_SYNTAX
	SASET nickname NOEXPIRE {ON | OFF}
NICK_SASET_NOEXPIRE_ON
	Nick %s will not expire.
NICK_SASET_NOEXPIRE_OFF
	Nick %s will expire.

# ACCESS responses
NICK_SASET_AUTOOP_SYNTAX
	SASET nickname AUTOOP {ON | OFF}
NICK_SASET_AUTOOP_ON
	Services will now autoop %s in channels.
NICK_SASET_AUTOOP_OFF
	Services will no longer autoop %s in channels.


# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [mscara]
NICK_ACCESS_ALREADY_PRESENT
	A mscara %s j se encontra em sua lista de acesso.
NICK_ACCESS_REACHED_LIMIT
	Desculpe, voc pode ter somente %d entradas em sua lista de acesso.
NICK_ACCESS_ADDED
	%s adicionado em sua lista de acesso.
NICK_ACCESS_NOT_FOUND
	%s no foi encontrado em sua lista de acesso.
NICK_ACCESS_DELETED
	%s removido da sua lista de acesso.
NICK_ACCESS_LIST
	Lista de acesso:
NICK_ACCESS_LIST_X
	Lista de acesso para %s:
NICK_ACCESS_LIST_EMPTY
	Sua lista de acesso est vazia.
NICK_ACCESS_LIST_X_EMPTY
	Lista de acesso para %s est vazia.

# Status messages
NICK_STATUS_0
	STATUS %s 0
NICK_STATUS_1
	STATUS %s 1
NICK_STATUS_2
	STATUS %s 2
NICK_STATUS_3
	STATUS %s 3

# INFO responses
NICK_INFO_SYNTAX
	INFO nick [ALL]
NICK_INFO_REALNAME
	%s  %s
NICK_INFO_SERVICES_OPER
	%s  um Operador dos Services.
NICK_INFO_SERVICES_ADMIN
	%s  um Administrador dos Services.
NICK_INFO_SERVICES_ROOT
	%s  um Services Root Administrator.
NICK_INFO_ADDRESS
	   ltimo endereo visto: %s
NICK_INFO_ADDRESS_ONLINE
	          Est online em: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s est online neste momento.
NICK_INFO_TIME_REGGED
	        Hora de registro: %s
NICK_INFO_LAST_SEEN
	    ltimo horrio visto: %s
NICK_INFO_LAST_QUIT
	ltima mensagem de sada: %s
NICK_INFO_URL
	                     URL: %s
NICK_INFO_EMAIL
	                  E-mail: %s
NICK_INFO_VHOST
	                   vHost: %s
NICK_INFO_VHOST2
	                   vHost: %s@%s
NICK_INFO_ICQ
	                     ICQ: %d
NICK_INFO_GREET
	     Mensagem de entrada: %s
NICK_INFO_OPTIONS
	                  Opes: %s
NICK_INFO_EXPIRE
	               Expira em: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Proteo
NICK_INFO_OPT_SECURE
	Segurana
NICK_INFO_OPT_PRIVATE
	Privado
NICK_INFO_OPT_MSG
	Modo mensagem
NICK_INFO_OPT_AUTOOP
	Auto-op
NICK_INFO_OPT_NONE
	Nenhuma
NICK_INFO_NO_EXPIRE
	Este nick no ir expirar.
NICK_INFO_FOR_MORE
	Para informaes mais detalhadas, digite %R%s INFO %s ALL.

# LIST responses
NICK_INFO_SUSPENDED
	Este nick est atualmente suspenso, motivo: %s
NICK_INFO_SUSPENDED_NO_REASON
	Este nick est atualmente suspenso

# LIST responses
NICK_LIST_SYNTAX
	LIST opes
NICK_LIST_SERVADMIN_SYNTAX
	LIST opes [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
NICK_LIST_HEADER
	Lista de entradas com %s:
NICK_LIST_RESULTS
	Fim da listagem - %d/%d resultados mostrados.

# ALIST responses
NICK_ALIST_SYNTAX
	ALIST nick
NICK_ALIST_HEADER
	Canais nos quais voc tem acesso:
	  Nm  Canal                Nvel    Descrio
NICK_ALIST_HEADER_X
	Canais nos quais %s tem acesso:
	  Nm  Canal                Nvel    Descrio 
NICK_ALIST_XOP_FORMAT
	  %3d %c%-20s %-8s %s
NICK_ALIST_ACCESS_FORMAT
	  %3d %c%-20s %-8d %s
NICK_ALIST_FOOTER
	Fim da listagem - %d/%d resultados mostrados.

# GLIST responses
NICK_GLIST_HEADER
	Lista de nicks no grupo:
NICK_GLIST_HEADER_X
	Lista de nicks no grupo %s:
NICK_GLIST_FOOTER
	%d nicks no grupo.
NICK_GLIST_REPLY
	   %c%s
NICK_GLIST_REPLY_ADMIN
	   %c%s (expira em %s)

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER nick [senha]
NICK_NO_RECOVER_SELF
	Voc no pode usar o comando RECOVER em si mesmo!
NICK_RECOVERED
	Usurio que usava seu nick foi derrubado.
	%R%s RELEASE %s para liberar seu nick antes de um minuto.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE nick [senha]
NICK_RELEASE_NOT_HELD
	Nick %s no est em uso no momento.
NICK_RELEASED
	Seu nick foi derrubado e pode ser usado.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST nick [senha]
NICK_NO_GHOST_SELF
	Voc no pode usar o comando GHOST em si mesmo!
NICK_GHOST_KILLED
	Seu nick foi derrubado e pode ser usado.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS nick
NICK_GETPASS_UNAVAILABLE
	Comando GETPASS no disponvel: modo de encriptao ativado.
NICK_GETPASS_PASSWORD_IS
	Senha para %s  %s.

# GETEMAIL responses
NICK_GETEMAIL_SYNTAX
	GETEMAIL user@emailhost No use coringas!
NICK_GETEMAIL_EMAILS_ARE
	O nick %s usa o E-mail %s.
NICK_GETEMAIL_NOT_USED
	Nenhum email listado para %s.
	
# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS nick
NICK_SENDPASS_UNAVAILABLE
	Comando SENDPASS no disponvel: modo de encriptao ativado.
NICK_SENDPASS_SUBJECT
	Senha do nick (%s)
NICK_SENDPASS_HEAD
	Ol,
NICK_SENDPASS_LINE_1
	Voc pediu para que a senha do nick %s fosse enviada por e-mail.
NICK_SENDPASS_LINE_2
	A senha  %s. Por motivos de segurana, recomendamos que voc mude sua senha aps ler este e-mail.
NICK_SENDPASS_LINE_3
	Se voc no souba porque este e-mail lhe foi enviado, por favor ignore-o.
NICK_SENDPASS_LINE_4
	NO RESPONDA A ESTE E-MAIL!
NICK_SENDPASS_LINE_5
	Administradores %s.
NICK_SENDPASS_OK
	Senha para %s foi enviada.

# SUSPEND responses
NICK_SUSPEND_SYNTAX
	SUSPEND nick motivo
NICK_SUSPEND_SUCCEEDED
	Nick %s foi suspendido.
NICK_SUSPEND_FAILED
	Impossvel suspender o nick %s!

# UNSUSPEND responses
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND nick
NICK_UNSUSPEND_SUCCEEDED
	Nick %s foi liberado.
NICK_UNSUSPEND_FAILED
	Impossvel liberar o nick %s!

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID nick [motivo]
NICK_FORBID_SYNTAX_REASON
	FORBID nick motivo
NICK_FORBID_SUCCEEDED
	Nick %s est agora bloqueado.
NICK_FORBID_FAILED
	No foi possvel bloquear o nick %s!

# Nick Registration responses
NICK_REQUESTED
	Esse nick j foi solicitado, por favor verifique seu e-mail pelo passcode
NICK_REG_RESENT
	Seu passcode foi re-enviado para %s.
NICK_REG_UNABLE
	Nick NO registrado, por favor tente novamente mais tarde.
NICK_IS_PREREG
	Esse nick est aguardando um cdigo de verificao por e-mail antes de completar o registro.
NICK_ENTER_REG_CODE
	O passcode foi enviado para %s, por favor digite %R%s confirm <passcode> para completar o registro.
NICK_CONFIRM_NOT_FOUND
	O primeiro passo do registro deve ter expirado, por favor use %R%s register <senha> <email> primeiro.
NICK_CONFIRM_INVALID
	Um passcode invlido foi digitado, por favor verifique o e-mail e tente novamente
NICK_REG_MAIL_SUBJECT
	Registro de nick (%s)
NICK_REG_MAIL_HEAD
	Ol,
NICK_REG_MAIL_LINE_1
	Voc solicitou o registro do seguinte nick: %s.
NICK_REG_MAIL_LINE_2
	Por favor digite %R%s confirm %s para completar o registro.
NICK_REG_MAIL_LINE_3
	Se voc no sabe porque este e-mail lhe foi enviado, por favor ignore-o com sigilo.
NICK_REG_MAIL_LINE_4
	POR FAVOR NO RESPONDA A ESTE E-MAIL!
NICK_REG_MAIL_LINE_5
	Administradores %s.
NICK_GETPASS_PASSCODE_IS
	Passcode para %s  %s.
NICK_FORCE_REG
	Nick %s confirmado

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Modo +o automtico
CHAN_LEVEL_AUTOVOICE
	Modo +v automtico
CHAN_LEVEL_AUTOHALFOP
	Modo +h automtico
CHAN_LEVEL_AUTOPROTECT
	Modo +a automtico
CHAN_LEVEL_AUTODEOP
	Modo -o automtico
CHAN_LEVEL_NOJOIN
	Entrada no canal no permitida
CHAN_LEVEL_INVITE
	Permitido o uso do comando INVITE
CHAN_LEVEL_AKICK
	Permitido o uso do comando AKICK
CHAN_LEVEL_SET
	Permitido o uso do comando SET (no inclui as opes FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	Permitido o uso do comando CLEAR
CHAN_LEVEL_UNBAN
	Permitido o uso do comando UNBAN
CHAN_LEVEL_OPDEOP
	Permitido o uso do comando OP/DEOP
CHAN_LEVEL_ACCESS_LIST
	Permitido visualizar a lista de acesso
CHAN_LEVEL_ACCESS_CHANGE
	Permitido modificar a lista de acesso
CHAN_LEVEL_MEMO
	Permitido listar/ler memos do canal
CHAN_LEVEL_ASSIGN
	Permitido associar/desassociar um bot a/de um canal
CHAN_LEVEL_BADWORDS
	Permitido o uso do comando BADWORDS
CHAN_LEVEL_NOKICK
	Nunca ser kickado pelos motivos dos Kickers do bot
CHAN_LEVEL_FANTASIA
	Permitido o uso do comando FANTASY de bots
CHAN_LEVEL_SAY
	Permitido o uso dos comandos SAY e ACT
CHAN_LEVEL_GREET
	Mensagem de entrada
CHAN_LEVEL_VOICEME
	Permitido usar o comando (DE)VOICE em si mesmo
CHAN_LEVEL_VOICE
	Permitido o uso dos comandos VOICE/DEVOICE
CHAN_LEVEL_GETKEY
	Permitido o uso do comando GETKEY
CHAN_LEVEL_OPDEOPME
	Permitido usar o comando (DE)OP em si mesmo
CHAN_LEVEL_HALFOPME
	Permitido usar o comando (DE)HALFOP em si mesmo
CHAN_LEVEL_HALFOP
	Permitido o uso dos comandos HALFOP/DEHALFOP
CHAN_LEVEL_PROTECTME
	Permitido usar o comando (DE)PROTECT em si mesmo
CHAN_LEVEL_PROTECT
	Permitido o uso dos comandos PROTECT/DEPROTECT
CHAN_LEVEL_KICKME
	Permitido usar o comando KICK em si mesmo
CHAN_LEVEL_KICK
	Permitido o uso do comando KICK
CHAN_LEVEL_SIGNKICK
	Sem assinatura no kick quando a opo SIGNKICK LEVEL estiver em uso
CHAN_LEVEL_BANME
	Permitido o uso do comando BAN em si mesmo
CHAN_LEVEL_BAN
	Permitido o uso do comando BAN
CHAN_LEVEL_TOPIC
	Permitido o uso do comando TOPIC
CHAN_LEVEL_INFO
	Permitido o uso do comando INFO com a opo ALL

# Automatic responses
CHAN_IS_REGISTERED
	Este canal foi registrado com o %s.
CHAN_NOT_ALLOWED_OP
	Voc no tem permisso para ser operador no canal %s.
CHAN_MAY_NOT_BE_USED
	Este canal no pode ser usado.
CHAN_NOT_ALLOWED_TO_JOIN
	Voc no tem permisso para permanecer neste canal.

# REGISTER responses
CHAN_X_INVALID
	Channel %s is not a valid channel.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER canal senha descrio
CHAN_REGISTER_DISABLED
	Desculpe, o registro de canais est temporariamente desativado.
CHAN_REGISTER_NOT_LOCAL
	Canais locais no podem ser registrados.
CHAN_MUST_REGISTER_NICK
	Voc deve registrar seu nick primeiro.  Digite %R%s HELP para maiores informaes sobre registro de nick.
CHAN_MUST_IDENTIFY_NICK
	Por favor se identifique com o %s primeiro, usando o comando:
	%R%s IDENTIFY senha
CHAN_MAY_NOT_BE_REGISTERED
	O canal %s no pode ser registrado.
CHAN_ALREADY_REGISTERED
	O canal %s j est registrado!
CHAN_MUST_BE_CHANOP
	Voc deve ser no mnimo um operador para registrar o canal.
CHAN_REACHED_CHANNEL_LIMIT
	Desculpe, voc j alcanou o limite de %d canais registrados.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Desculpe, voc j ultrapassou o limite de %d canais registrados.
CHAN_REGISTRATION_FAILED
	Desculpe, o registro falhou.
CHAN_REGISTERED
	O canal %s est registrado sob seu nick: %s
CHAN_PASSWORD_IS
	A senha do seu canal  %s - guarde ela para uso posterior.
CHAN_REGISTER_NONE_CHANNEL
	Voc tentou registrar um canal no existente: %s
CHAN_SYMBOL_REQUIRED
	Por favor use o smbolo # quando tentar registrar

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY canal senha
CHAN_IDENTIFY_FAILED
	Desculpe, a identificao falhou.
CHAN_IDENTIFY_SUCCEEDED
	Senha aceita - voc est sendo reconhecido agora como dono do %s.

# LOGOUT responses
CHAN_LOGOUT_SYNTAX
	LOGOUT canal nick
CHAN_LOGOUT_SERVADMIN_SYNTAX
	LOGOUT canal [nick]
CHAN_LOGOUT_SUCCEEDED
	Usurio %s foi desconectado do canal %s.
CHAN_LOGOUT_ALL_SUCCEEDED
	Todos os usurios registrados foram desconectados do canal %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP canal
CHAN_DROP_DISABLED
	Desculpe, o comando DROP est temporariamente desativado.
CHAN_DROPPED
	O canal %s foi desregistrado.

# SET responses
CHAN_SET_SYNTAX
	SET canal opes parmetros
CHAN_SET_DISABLED
	Desculpe, o comando SET est temporariamente desativado.
CHAN_SET_UNKNOWN_OPTION
	Comando SET %s desconhecido.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s possui muitos canais registrados.
CHAN_FOUNDER_CHANGED
	Founder do canal %s alterado para %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Successor do canal %s alterado para %s.
CHAN_SUCCESSOR_UNSET
	Successor do canal %s removido.
CHAN_SUCCESSOR_IS_FOUNDER
	%s no pode ser o successor do canal %s porque ele  o founder.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Desculpe, a mudana de senha falhou.
CHAN_PASSWORD_CHANGED
	A senha do %s foi alterada.
CHAN_PASSWORD_CHANGED_TO
	A senha do %s foi alterada para %s.

# SET DESC responses
CHAN_DESC_CHANGED
	Descrio do canal %s alterada para %s.

# SET URL responses
CHAN_URL_CHANGED
	URL do canal %s alterada para %s.
CHAN_URL_UNSET
	URL do canal %s removida.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	E-mail do canal %s alterado para %s.
CHAN_EMAIL_UNSET
	E-mail do canal %s removido.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Mensagem de entrada para o canal %s alterada.
CHAN_ENTRY_MSG_UNSET
	Mensagem de entrada para o canal %s removida.
	
# SET BANTYPE responses
CHAN_SET_BANTYPE_INVALID
	%s no  um ban vlido.
CHAN_SET_BANTYPE_CHANGED
	Tipo de ban para o canal %s  agora #%d.

# SET MLOCK responses
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Modo %c desconhecido e ignorado.
CHAN_SET_MLOCK_IMPOSSIBLE_CHAR
	Modo %c ignorado porque voc no pode trav-lo.
CHAN_SET_MLOCK_L_REQUIRED
	Voc deve travar o modo +l para poder travar o modo +L.
CHAN_SET_MLOCK_K_REQUIRED
	Voc deve travar o modo +i para poder travar o modo +K.
CHAN_MLOCK_CHANGED
	Modo MLOCK no canal %s alterado para %s.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET canal KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Reteno de tpico para %s est agora ATIVADA.
CHAN_SET_KEEPTOPIC_OFF
	Reteno de tpico para %s est agora DESATIVADA.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET canal TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Trava de tpico para %s est agora ATIVADA.
CHAN_SET_TOPICLOCK_OFF
	Trava de tpico para %s est agora DESATIVADA.

# SET PEACE responses
CHAN_SET_PEACE_SYNTAX
	SET canal PEACE {ON | OFF}
CHAN_SET_PEACE_ON
	Opo Peace para %s est agora ATIVADA.
CHAN_SET_PEACE_OFF
	Opo Peace para %s est agora DESATIVADA.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET canal PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Opo Private para %s est agora ATIVADA.
CHAN_SET_PRIVATE_OFF
	Opo Private para %s est agora DESATIVADA.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET canal SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Opo Secure OPs para %s est agora ATIVADA.
CHAN_SET_SECUREOPS_OFF
	Opo Secure OPs para %s est agora DESATIVADA.
	
# SET SECUREFOUNDER responses
CHAN_SET_SECUREFOUNDER_SYNTAX
	SET canal SECUREFOUNDER {ON | OFF}
CHAN_SET_SECUREFOUNDER_ON
	Opo Secure Founder para %s est agora ATIVADA.
CHAN_SET_SECUREFOUNDER_OFF
	Opo Secure Founder para %s est agora DESATIVADA.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET canal RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Opo de acesso restrito para %s est agora ATIVADA.
CHAN_SET_RESTRICTED_OFF
	Opo de acesso restrito para %s est agora DESATIVADA.

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET canal SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Opo Secure para %s est agora ATIVADA.
CHAN_SET_SECURE_OFF
	Opo Secure para %s est agora DESATIVADA.
	
# SET SIGNKICK responses
CHAN_SET_SIGNKICK_SYNTAX
	SET canal SIGNKICK {ON | LEVEL | OFF}
CHAN_SET_SIGNKICK_ON
	Opo Signed Kicks para %s est agora ATIVADA.
CHAN_SET_SIGNKICK_LEVEL
	Opo Signed Kicks para %s est agora ATIVADA, mas depende
	do nvel de acesso do usurio que est usando o comando.
CHAN_SET_SIGNKICK_OFF
	Opo Signed Kicks para %s est agora DESATIVADA.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET canal OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Opo Op-notice para %s est agora ATIVADA.
CHAN_SET_OPNOTICE_OFF
	Opo Op-notice para %s est agora DESATIVADA.

# SET XOP responses
CHAN_SET_XOP_SYNTAX
	SET canal XOP {ON | OFF}
CHAN_SET_XOP_ON
	Sistema de acesso xOP para %s est agora ATIVADO.
CHAN_SET_XOP_OFF
	Sistema de acesso xOP para %s est agora DESATIVADO.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET canal NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	O canal %s no ir expirar.
CHAN_SET_NOEXPIRE_OFF
	O canal %s ir expirar.

# xOP messages
CHAN_XOP_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d entradas de AOP/SOP/VOP em um canal.
CHAN_XOP_LIST_FORMAT
	  %3d  %s
CHAN_XOP_ACCESS
	Voc no pode usar este comando. Ao invs, use o comando ACCESS.
	Digite %R%s HELP ACCESS para mais informao.
CHAN_XOP_NOT_AVAILABLE
	xOP system is not available.

# AOP messages
CHAN_AOP_SYNTAX
	AOP canal {ADD|DEL|LIST|CLEAR} [nick | entrada]
CHAN_AOP_DISABLED
	Desculpe, a modificao da lista de AOP est temporariamente desabilitada.
CHAN_AOP_NICKS_ONLY
	Lista de AOP do canal s pode conter nicks registrados.
CHAN_AOP_ADDED
	%s adicionado  lista de AOP do %s.
CHAN_AOP_MOVED
	%s movido para a lista de AOP do %s.
CHAN_AOP_NO_SUCH_ENTRY
	Entrada (#%d) no encontrada na lista de AOP do %s.
CHAN_AOP_NOT_FOUND
	Nick %s no encontrado na lista de AOP do %s.
CHAN_AOP_NO_MATCH
	Resultado no encontrado na lista de AOP do %s.
CHAN_AOP_DELETED
	%s deletado da lista de AOP do %s.
CHAN_AOP_DELETED_ONE
	Deletada 1 entrada da lista de AOP do %s.
CHAN_AOP_DELETED_SEVERAL
	Deletadas %d entradas da lista de AOP do %s.
CHAN_AOP_LIST_EMPTY
	Lista de AOP do canal %s est vazia.
CHAN_AOP_LIST_HEADER
	Lista de AOP para %s:
	  Nm  Nick
CHAN_AOP_CLEAR
	Lista de AOP do canal %s foi limpa.

# HOP messages
CHAN_HOP_SYNTAX
	HOP canal {ADD|DEL|LIST|CLEAR} [nick | entrada]
CHAN_HOP_DISABLED
	Desculpe, a modificao da lista de HOP est temporariamente desabilitada.
CHAN_HOP_NICKS_ONLY
	Lista de HOP do canal s pode conter nicks registrados.
CHAN_HOP_ADDED
	%s adicionado  lista de HOP do %s.
CHAN_HOP_MOVED
	%s movido para a lista de HOP do %s.
CHAN_HOP_NO_SUCH_ENTRY
	Entrada (#%d) no encontrada na lista de HOP do %s.
CHAN_HOP_NOT_FOUND
	Nick %s no encontrado na lista de HOP do %s.
CHAN_HOP_NO_MATCH
	Resultado no encontrado na lista de HOP do %s.
CHAN_HOP_DELETED
	%s deletado da lista de HOP do %s.
CHAN_HOP_DELETED_ONE
	Deletada 1 entrada da lista de HOP do %s.
CHAN_HOP_DELETED_SEVERAL
	Deletadas %d entradas da lista de HOP do %s.
CHAN_HOP_LIST_EMPTY
	Lista de HOP do canal %s est vazia.
CHAN_HOP_LIST_HEADER
	Lista de HOP para %s:
	  Nm  Nick
CHAN_HOP_CLEAR
	Lista de HOP do canal %s foi limpa.

# SOP messages
CHAN_SOP_SYNTAX
	SOP canal {ADD|DEL|LIST|CLEAR} [nick | entrada]
CHAN_SOP_DISABLED
	Desculpe, a modificao da lista de SOP est temporariamente desabilitada.
CHAN_SOP_NICKS_ONLY
	Lista de SOP do canal s pode conter nicks registrados.
CHAN_SOP_ADDED
	%s adicionado  lista de SOP do %s.
CHAN_SOP_MOVED
	%s movido para a lista de SOP do %s.
CHAN_SOP_NO_SUCH_ENTRY
	Entrada (#%d) no encontrada na lista de SOP do %s.
CHAN_SOP_NOT_FOUND
	Nick %s no encontrado na lista de SOP do %s.
CHAN_SOP_NO_MATCH
	Resultado no encontrado na lista de SOP do %s.
CHAN_SOP_DELETED
	%s deletado da lista de SOP do %s.
CHAN_SOP_DELETED_ONE
	Deletada 1 entrada da lista de SOP do %s.
CHAN_SOP_DELETED_SEVERAL
	Deletadas %d entradas da lista de SOP do %s.
CHAN_SOP_LIST_EMPTY
	Lista de SOP do canal %s est vazia.
CHAN_SOP_LIST_HEADER
	Lista de SOP para %s:
	  Nm  Nick
CHAN_SOP_CLEAR
	Lista de SOP do canal %s foi limpa.

# VOP messages
CHAN_VOP_SYNTAX
	VOP canal {ADD|DEL|LIST|CLEAR} [nick | entrada]
CHAN_VOP_DISABLED
	Desculpe, a modificao da lista de VOP est temporariamente desabilitada.
CHAN_VOP_NICKS_ONLY
	Lista de VOP do canal s pode conter nicks registrados.
CHAN_VOP_ADDED
	%s adicionado  lista de VOP do %s.
CHAN_VOP_MOVED
	%s movido para a lista de VOP do %s.
CHAN_VOP_NO_SUCH_ENTRY
	Entrada (#%d) no encontrada na lista de VOP do %s.
CHAN_VOP_NOT_FOUND
	Nick %s no encontrado na lista de VOP do %s.
CHAN_VOP_NO_MATCH
	Resultado no encontrado na lista de VOP do %s.
CHAN_VOP_DELETED
	%s deletado da lista de VOP do %s.
CHAN_VOP_DELETED_ONE
	Deletada 1 entrada da lista de VOP do %s.
CHAN_VOP_DELETED_SEVERAL
	Deletadas %d entradas da lista de VOP do %s.
CHAN_VOP_LIST_EMPTY
	Lista de VOP do canal %s est vazia.
CHAN_VOP_LIST_HEADER
	Lista de VOP para %s:
	  Nm  Nick
CHAN_VOP_CLEAR
	Lista de VOP do canal %s foi limpa.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS canal {ADD|DEL|LIST|CLEAR} [nick [nvel] | lista-entradas]
CHAN_ACCESS_XOP
	Voc no pode usar este comando.
	Ao invs, use os comandos VOP, HOP, AOP e SOP.
	Digite %R%s HELP comando para mais informao.
CHAN_ACCESS_XOP_HOP
	You can't use this command. 
	Use the AOP, SOP, HOP and VOP commands instead.
	Type %R%s HELP command for more information.
CHAN_ACCESS_DISABLED
	Desculpe, o registro de canais est temporariamente desativado.
CHAN_ACCESS_LEVEL_NONZERO
	O nvel de acesso deve ser diferente de zero.
CHAN_ACCESS_LEVEL_RANGE
	O nvel de acesso deve ser entre %d e %d inclusive.
CHAN_ACCESS_NICKS_ONLY
	A lista de acesso do canal deve conter apenas nicks registrados.
CHAN_ACCESS_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d entradas na lista de acesso do canal.
CHAN_ACCESS_LEVEL_UNCHANGED
	Nvel de acesso para %s no %s no alterado %d.
CHAN_ACCESS_LEVEL_CHANGED
	Nvel de acesso para %s no %s alterado para %d.
CHAN_ACCESS_ADDED
	%s adicionado  lista de acesso do %s com o nvel %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Nenhuma entrada com (#%d) encontrada na lista de acesso do %s.
CHAN_ACCESS_NOT_FOUND
	%s no foi encontrado na lista de acesso do %s.
CHAN_ACCESS_NO_MATCH
	Resultado no encontrado na lista de acesso do %s.
CHAN_ACCESS_DELETED
	%s removido da lista de acesso do %s.
CHAN_ACCESS_DELETED_ONE
	Removida 1 entrada da lista de acesso do %s.
CHAN_ACCESS_DELETED_SEVERAL
	Removidas %d entradas da lista de acesso do %s.
CHAN_ACCESS_LIST_EMPTY
	Lista de acesso do canal %s est vazia.
CHAN_ACCESS_LIST_HEADER
	Lista de acesso para %s:
	  Num   Nv  Nick
CHAN_ACCESS_LIST_FOOTER
	Fim da lista de acesso.
CHAN_ACCESS_LIST_XOP_FORMAT
	  %3d   %s  %s
CHAN_ACCESS_LIST_AXS_FORMAT
	  %3d  %4d  %s
CHAN_ACCESS_CLEAR
	Lista de acesso do canal %s apagada.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK canal {ADD|STICK|UNSTICK|DEL|LIST|VIEW|ENFORCE|CLEAR} [nick-ou-mscara] [motivo]
CHAN_AKICK_DISABLED
	Desculpe, o comando AKICK est temporariamente desativado.
CHAN_AKICK_ALREADY_EXISTS
	%s j existe na lista de akick do %s.
CHAN_AKICK_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d akicks na lista do canal.
CHAN_AKICK_ADDED
	%s adicionado  lista de akick do %s.
CHAN_AKICK_NO_SUCH_ENTRY
	Nenhuma entrada com (#%d) na lista de akick do %s.
CHAN_AKICK_NOT_FOUND
	%s no encontrado na lista de akick do %s.
CHAN_AKICK_NO_MATCH
	Nenhum resultado encontrado na lista de akick do %s.
CHAN_AKICK_STUCK
	%s est agora sempre ativo no canal %s.
CHAN_AKICK_UNSTUCK
	%s no est mais sempre ativo no canal %s.
CHAN_AKICK_DELETED
	%s removido da lista de akick do %s.
CHAN_AKICK_DELETED_ONE
	Removida 1 entrada da lista de akick do %s.
CHAN_AKICK_DELETED_SEVERAL
	Removidas %d entradas da lista de akick do %s.
CHAN_AKICK_LIST_EMPTY
	Lista de akick do %s vazia.
CHAN_AKICK_LIST_HEADER
	Lista de akick para %s:
CHAN_AKICK_LIST_FORMAT
	  %3d %s %s
CHAN_AKICK_VIEW_FORMAT
	%3d %s (por %s em %s)
	    %s
CHAN_AKICK_VIEW_FORMAT_STUCK
	%3d %s (stuck) (por %s em %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	AKICK ENFORCE para %s terminado; %d usurios afetados.
CHAN_AKICK_CLEAR
	Lista de akick do canal %s foi limpa.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS canal {SET | DIS[ABLE] | LIST | RESET} [item [nvel]]
CHAN_LEVELS_XOP
	Este comando no tem utilidade neste modo.
CHAN_LEVELS_RANGE
	O nvel deve ser entre %d e %d inclusive.
CHAN_LEVELS_CHANGED
	Nvel para %s no canal %s alterado para %d.
CHAN_LEVELS_UNKNOWN
	Level %s desconhecido. Digite %R%s HELP LEVELS DESC para uma lista de Levels vlidos.
CHAN_LEVELS_DISABLED
	%s desabilitado no canal %s.
CHAN_LEVELS_LIST_HEADER
	Opes de nvel de acesso para o canal %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (desabilitado)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (founder apenas)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	Nveis de acesso para o %s redefinidos para o padro.

# Status Messages
CHAN_STATUS_SYNTAX
	STATUS ERROR Erro de sintaxe. Use a sintaxe STATUS canal nick.
CHAN_STATUS_NOT_REGGED
	STATUS ERROR Canal %s no est registrado
CHAN_STATUS_FORBIDDEN
	STATUS ERROR Canal %s forbidado
CHAN_STATUS_NOTONLINE
	STATUS ERROR Nick %s no est online
CHAN_STATUS_INFO
	STATUS %s %s %d

# INFO responses
CHAN_INFO_SYNTAX
	INFO canal [ALL]
CHAN_INFO_HEADER
	Informaes do canal %s:
CHAN_INFO_FOUNDER
	             Fundador: %s (%s)
CHAN_INFO_NO_FOUNDER
	             Fundador: %s
CHAN_INFO_SUCCESSOR
	             Sucessor: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	             Sucessor: %s
CHAN_INFO_DESCRIPTION
	            Descrio: %s
CHAN_INFO_ENTRYMSG
	  Mensagem de entrada: %s
CHAN_INFO_TIME_REGGED
	           Registrado: %s
CHAN_INFO_LAST_USED
	           ltimo uso: %s
CHAN_INFO_LAST_TOPIC
	        ltimo tpico: %s
CHAN_INFO_TOPIC_SET_BY
	           Tpico por: %s
CHAN_INFO_URL
	                  URL: %s
CHAN_INFO_EMAIL
	               E-mail: %s
CHAN_INFO_BANTYPE
	          Tipo de ban: %d
CHAN_INFO_OPTIONS
	               Opes: %s
CHAN_INFO_OPT_KEEPTOPIC
	Reteno de tpico
CHAN_INFO_OPT_OPNOTICE
	Op-notice
CHAN_INFO_OPT_PEACE
	Paz
CHAN_INFO_OPT_PRIVATE
	Privado
CHAN_INFO_OPT_RESTRICTED
	Acesso restrito
CHAN_INFO_OPT_SECURE
	Seguro
CHAN_INFO_OPT_SECUREOPS
	OPs Seguros
CHAN_INFO_OPT_SECUREFOUNDER
	Founder Seguro
CHAN_INFO_OPT_SIGNKICK
	Kicks assinados
CHAN_INFO_OPT_TOPICLOCK
	Trava de tpico
CHAN_INFO_OPT_XOP
	Sistema de acesso xOP
CHAN_INFO_OPT_NONE
	Nenhuma
CHAN_INFO_MODE_LOCK
	        Trava de modo: %s
CHAN_INFO_EXPIRE
	            Expira em: %s
CHAN_INFO_NO_EXPIRE
	Este canal no ir expirar.

# LIST responses
CHAN_LIST_SYNTAX
	LIST padro
CHAN_LIST_SERVADMIN_SYNTAX
	LIST padro [FORBIDDEN] [SUSPENDED] [NOEXPIRE]
CHAN_LIST_HEADER
	Lista de entradas com %s:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	Fim da lista - %d/%d resultados mostrados.
	
# INVITE responses
CHAN_INVITE_SYNTAX
	INVITE canal

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN canal
CHAN_UNBANNED
	Voc no est mais banido do %s.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC canal [tpico]

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR canal opo
CHAN_CLEARED_BANS
	Todos os bans do canal %s foram removidos.
CHAN_CLEARED_EXCEPTS
	Todos os excepts do canal %s foram removidos.
CHAN_CLEARED_MODES
	Todos os modos no canal %s foram removidos.
CHAN_CLEARED_OPS
	Modo +o foi retirado do canal %s.
CHAN_CLEARED_HOPS
	Modo +h foi retirado do canal %s.
CHAN_CLEARED_VOICES
	Modo +v foi retirado do canal %s.
CHAN_CLEARED_USERS
	Todos os usurios foram kickados do canal %s.
CHAN_CLEARED_INVITES
	Todos os Invites do canal %s foram removidos.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS canal
CHAN_GETPASS_UNAVAILABLE
	Comando GETPASS indisponvel: modo de encriptao em uso.
CHAN_GETPASS_PASSWORD_IS
	Senha do canal %s  %s.
	
# GETKEY responses
CHAN_GETKEY_SYNTAX
	GETKEY canal
CHAN_GETKEY_NOKEY
	O canal %s no tem key.
CHAN_GETKEY_KEY
	A Key do canal %s  %s.

# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS canal
CHAN_SENDPASS_UNAVAILABLE
	Comando SENDPASS indisponvel: modo de encriptao em uso.
CHAN_SENDPASS_SUBJECT
	Senha do canal (%s)
CHAN_SENDPASS_HEAD
	Ol,
CHAN_SENDPASS_LINE_1
	Voc pediu para receber a senha do canal %s por e-mail.
CHAN_SENDPASS_LINE_2
	A senha  %s. Por motivos de segurana, recomendamos que voc mude a senha assim que receber este e-mail.
CHAN_SENDPASS_LINE_3
	Se voc no sabe porque este e-mail lhe foi enviado, por favor ignore-o.
CHAN_SENDPASS_LINE_4
	POR FAVOR NO RESPONDA ESTE E-MAIL!
CHAN_SENDPASS_LINE_5
	Administradores do %s.
CHAN_SENDPASS_OK
	Senha do canal %s foi enviada.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID canal [motivo]
CHAN_FORBID_SYNTAX_REASON
	FORBID canal motivo
CHAN_FORBID_SUCCEEDED
	Canal %s est agora bloqueado.
CHAN_FORBID_FAILED
	No foi possvel bloquear o canal %s!

# Misc responses
CHAN_FORBID_REASON
	Este canal foi forbidado.

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND canal [motivo]
CHAN_SUSPEND_SYNTAX_REASON
	SUSPEND canal motivo
CHAN_SUSPEND_SUCCEEDED
	Canal %s est agora suspenso.
CHAN_SUSPEND_FAILED
	Impossvel suspender o canal %s!
CHAN_SUSPEND_REASON
	Este canal foi suspenso.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND canal
CHAN_UNSUSPEND_ERROR
	No foi encontrado "#" em frente ao nome do canal.
CHAN_UNSUSPEND_SUCCEEDED
	Canal %s est agora liberado.
CHAN_UNSUSPEND_FAILED
	Impossvel liberar canal %s!

# Misc responses
CHAN_EXCEPTED
	%s combina com uma Except no %s e no pode ser banido at que a Except sej removida.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Voc tem 1 novo memo.
MEMO_HAVE_NEW_MEMOS
	Voc tem %d novos memos.
MEMO_TYPE_READ_LAST
	Digite %R%s READ LAST para ler.
MEMO_TYPE_READ_NUM
	Digite %R%s READ %d para ler.
MEMO_TYPE_LIST_NEW
	Digite %R%s LIST NEW para listar.
MEMO_AT_LIMIT
	Ateno: Voc atingiu seu nmero mximo de memos (%d). No ser possvel receber novos memos enquanto voc no apagar alguns.
MEMO_OVER_LIMIT
	Ateno: Voc ultrapassou seu nmero mximo de memos (%d). No ser possvel receber novos memos enquanto voc no apagar alguns.
MEMO_X_MANY_NOTICE
	Existem %d memos para o canal %s.
MEMO_X_ONE_NOTICE
	Existe %d memo para o canal %s.
MEMO_NEW_X_MEMO_ARRIVED
	Foi recebido um novo memo para o canal %s.
	Digite %R%s READ %s %d para ler.
MEMO_NEW_MEMO_ARRIVED
	Voc recebeu um novo memo de %s.
	Digite %R%s READ %d para ler.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	Voc no possui memos.
MEMO_X_HAS_NO_MEMOS
	%s no possui memos.
MEMO_DOES_NOT_EXIST
	Memo %d no existe!
MEMO_LIST_NOT_FOUND
	Nenhum memo encontrado.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {nick | canal} texto
MEMO_SEND_DISABLED
	Desculpe, o envio de memos est temporariamente desabilitado.
MEMO_SEND_PLEASE_WAIT
	Por favor aguarde %d segundos antes de usar o comando SEND novamente.
MEMO_X_GETS_NO_MEMOS
	%s no pode receber memos.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s possui muitos memos atualmente e no pode receber mais nenhum.
MEMO_SENT
	Memo enviado para %s.
MEMO_MASS_SENT
	Uma mensagem global foi enviada a todos os usurios registrados.
	
# CANCEL responses
MEMO_CANCEL_SYNTAX
	CANCEL {nick | canal}
MEMO_CANCEL_DISABLED
	Desculpe, o comando CANCEL est temporariamente desativado.
MEMO_CANCEL_NONE
	Nenhum memo foi cancelado.
MEMO_CANCELLED
	ltimo memo enviado para %s foi cancelado.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [canal] [list | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Voc no possui novos memos.
MEMO_X_HAS_NO_NEW_MEMOS
	%s no possui novos memos.
MEMO_LIST_MEMOS
	Memos para %s. Para ler, digite: %R%s READ nm
MEMO_LIST_NEW_MEMOS
	Novos memos para %s. Para ler, digite: %R%s READ nm
MEMO_LIST_CHAN_MEMOS
	Memos para %s. Para ler, digite: %R%s READ %s nm
MEMO_LIST_CHAN_NEW_MEMOS
	Novos memos para %s. Para ler, digite: %R%s READ %s nm
MEMO_LIST_HEADER
	 Nm  Remetente            Data/Hora
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [canal] {list | LAST | NEW}
MEMO_HEADER
	Memo %d de %s (%s). Para apagar, digite: %R%s DEL %d
MEMO_CHAN_HEADER
	Memo %d de %s (%s). Para apagar, digite: %R%s DEL %s %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [canal] {nm | list | ALL}
MEMO_DELETED_NONE
	Nenhum memo apagado.
MEMO_DELETED_ONE
	Memo %d foi apagado.
MEMO_DELETED_SEVERAL
	Memos %s foram apagados.
MEMO_DELETED_ALL
	Todos os seus memos foram apagados.
MEMO_CHAN_DELETED_ALL
	Todos os memos para o canal %s foram apagados.

# SET responses
MEMO_SET_SYNTAX
	SET opo parmetros
MEMO_SET_DISABLED
	Desculpe, a opo SET est temporariamente desativada.
MEMO_SET_UNKNOWN_OPTION
	Comando SET desconhecido: %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s ir agora notific-lo de novos memos quando voc conectar, quando eles lhe forem enviados ou quando desativar o /AWAY.
MEMO_SET_NOTIFY_LOGON
	%s ir agora notific-lo de novos memos quando voc conectar ou quando desativar o /AWAY.
MEMO_SET_NOTIFY_NEW
	%s ir agora notific-lo de novos memos quando eles lhe forem enviados.
MEMO_SET_NOTIFY_OFF
	%s no ir mais notific-lo de novos memos.
MEMO_SET_NOTIFY_MAIL
	Voc ser notificado sobre novos memos por email.
MEMO_SET_NOTIFY_NOMAIL
	Voc no ser mais notificado por email.
MEMO_SET_NOTIFY_INVALIDMAIL
	No h endereo de email ajustado para o seu nick.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [canal] limite
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [usurio | canal] {limite | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	Voc no tem permisso para mudar seu limite de memos.
MEMO_SET_LIMIT_FORBIDDEN
	O limite de memos para %s no pode ser mudado.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	Voc no pode colocar seu limite de memos maior que %d.
MEMO_SET_LIMIT_TOO_HIGH
	Voc no pode colocar o limite de memos para %s maior que %d.
MEMO_SET_LIMIT_OVERFLOW
	Limite de memos muito grande; limitando em %d.
MEMO_SET_YOUR_LIMIT
	Seu limite de memo  agora de %d.
MEMO_SET_YOUR_LIMIT_ZERO
	Voc no poder mais receber memos.
MEMO_UNSET_YOUR_LIMIT
	Seu limite de memos foi desativado.
MEMO_SET_LIMIT
	Limite de memos para %s  agora de %d.
MEMO_SET_LIMIT_ZERO
	Limite de memos para %s  agora de 0.
MEMO_UNSET_LIMIT
	Limite de memos desativado para %s.

# INFO responses
MEMO_INFO_SYNTAX
	INFO [canal]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [nick | canal]
MEMO_INFO_NO_MEMOS
	Voc no possui nenhum memo atualmente.
MEMO_INFO_MEMO
	Voc possui atualmente 1 memo.
MEMO_INFO_MEMO_UNREAD
	Voc possui atualmente 1 memo, e este ainda no foi lido.
MEMO_INFO_MEMOS
	Voc possui atualmente %d memos.
MEMO_INFO_MEMOS_ONE_UNREAD
	Voc possui atualmente %d memos, dos quais 1 no foi lido.
MEMO_INFO_MEMOS_SOME_UNREAD
	Voc possui atualmente %d memos, dos quais %d no foram lidos.
MEMO_INFO_MEMOS_ALL_UNREAD
	Voc possui atualmente %d memos; dos quais nenhum foi lido.
MEMO_INFO_LIMIT
	Seu limite de memos  de %d.
MEMO_INFO_HARD_LIMIT
	Seu limite de memos  de %d, e no pode ser alterado.
MEMO_INFO_LIMIT_ZERO
	Seu limite de memos  de 0; voc no pode receber novos memos.
MEMO_INFO_HARD_LIMIT_ZERO
	Seu limite de memos  de 0; voc no pode receber novos memos. Voc no pode alterar esse limite.
MEMO_INFO_NO_LIMIT
	Voc no possui limite de memos que pode guardar.
MEMO_INFO_NOTIFY_OFF
	Voc ser notificado de novos memos.
MEMO_INFO_NOTIFY_ON
	Voc ser notificado de novos memos quando conectar e quando eles forem enviados.
MEMO_INFO_NOTIFY_RECEIVE
	Voc ser notificado de novos memos quando eles forem enviados.
MEMO_INFO_NOTIFY_SIGNON
	Voc ser notificado de novos memos quando conectar.
MEMO_INFO_X_NO_MEMOS
	%s no possui nenhum memo atualmente.
MEMO_INFO_X_MEMO
	%s possui atualmente 1 memo.
MEMO_INFO_X_MEMO_UNREAD
	%s possui atualmente 1 memo, e ainda no foi lido.
MEMO_INFO_X_MEMOS
	%s possui atualmente %d memos.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s possui atualmente %d memos, dos quais 1 no foi lido.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s possui atualmente %d memos, dos quais %d no foram lidos.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s possui atualmente %d memos; dos quais nenhum foi lido.
MEMO_INFO_X_LIMIT
	Limite de memos para %s  de %d.
MEMO_INFO_X_HARD_LIMIT
	Limite de memos para %s  de %d, e no pode ser alterado.
MEMO_INFO_X_NO_LIMIT
	%s no possui limite de memos.
MEMO_INFO_X_NOTIFY_OFF
	%s no  notificado de novos memos.
MEMO_INFO_X_NOTIFY_ON
	%s  notificado de novos memos quando conecta e quando eles so enviados.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s  notificado de novos memos quando eles so enviados.
MEMO_INFO_X_NOTIFY_SIGNON
	%s  notificado de novos memos quando conecta.
	
# Memo2Mail responses
MEMO_MAIL_SUBJECT
	Novo memo
MEMO_MAIL_TEXT1
	Ol %s
MEMO_MAIL_TEXT2
	Voc recebeu um novo memo de %s. Este  seu memo nmero %d.
MEMO_MAIL_TEXT3
	Mensagem do memo:

# RSEND responses
MEMO_RSEND_PLEASE_WAIT
	Por favor aguarde %d segundos antes de usar o comando RSEND novamente.
MEMO_RSEND_DISABLED
	Desculpe, RSEND foi desabilitado nesta rede.
MEMO_RSEND_SYNTAX
	RSEND {nick | canal} mensagem
MEMO_RSEND_NICK_MEMO_TEXT
	[Auto-Memo] O memo que voc enviou foi lido.
MEMO_RSEND_CHAN_MEMO_TEXT
	[Auto-Memo] O memo que voc enviou para %s foi lido.
MEMO_RSEND_USER_NOTIFICATION
	Um memo de notificao foi enviado para %s informando que voc leu seu memo.

# CHECK responses
MEMO_CHECK_SYNTAX
	CHECK nick
MEMO_CHECK_NOT_READ
	O ltimo memo que voc enviou para %s (enviado em %s) ainda no foi lido.
MEMO_CHECK_READ
	O ltimo memo que voc enviou para %s (enviado em %s) foi lido.
MEMO_CHECK_NO_MEMO
	O nick %s no possui nenhum memo seu.
MEMO_NO_RSEND_SELF
	Voc no pode pedir uma notificao ao enviar uma mensagem a si prprio.

###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
BOT_DOES_NOT_EXIST
	Bot %s no existe.
BOT_NOT_ASSIGNED
	Voc precisa primeiro associar um bot ao canal antes de usar este comando.
	Digite %R%S HELP ASSIGN para maiores informaes.
BOT_NOT_ON_CHANNEL
	Bot no est no canal %s.
	
# Kick reasons (must be a single line)
BOT_REASON_BADWORD
	No use a palavra %s neste canal!
BOT_REASON_BADWORD_GENTLE
	Cuidado com suas palavras!
BOT_REASON_BOLD
	No use negritos neste canal!
BOT_REASON_CAPS
	Desligue o CAPS LOCK!
BOT_REASON_COLOR
	No use cores neste canal!
BOT_REASON_FLOOD
	Pare de floodar!
BOT_REASON_REPEAT
	Pare de ficar repetindo!
BOT_REASON_REVERSE
	Por favor no use reversos no canal!
BOT_REASON_UNDERLINE
	No use sublinhados neste canal!
	
# !seen replies
BOT_SEEN_BOT
	Voc me encontrou, %s!
BOT_SEEN_YOU
	Procurando por si mesmo %s?
BOT_SEEN_ON_CHANNEL
	%s est no canal neste momento!
BOT_SEEN_ON_CHANNEL_AS
	%s est no canal neste momento (como %s) ! 
BOT_SEEN_ON
	%s foi visto aqui pela ltima vez %s atrs.
BOT_SEEN_NEVER
	Eu nunca vi %s neste canal.
BOT_SEEN_UNKNOWN
	Eu no sei quem  %s.

# BOT responses
BOT_BOT_SYNTAX
	
	BOT ADD nick user host real
	BOT CHANGE nickantigo nicknovo [user [host [real]]]
	BOT DEL nick
BOT_BOT_ALREADY_EXISTS
	Bot %s j existe.
BOT_BOT_CREATION_FAILED
	Desculpe, criao do bot falhou.
BOT_BOT_READONLY
	Desculpe, comando CHANGE temporariamente desativado.
BOT_BOT_ADDED
	%s!%s@%s (%s) adicionado  lista de bots.
BOT_BOT_ANY_CHANGES
	A informao antiga  igual a nova.
BOT_BOT_CHANGED
	Bot %s foi alterado para %s!%s@%s (%s)
BOT_BOT_DELETED
	Bot %s foi removido.
	
# BOTLIST responses
BOT_BOTLIST_HEADER
	Lista de bots:
BOT_BOTLIST_PRIVATE_HEADER
	Bots reservados aos Operadores de IRC:
BOT_BOTLIST_FOOTER
	%d bots disponveis.
BOT_BOTLIST_EMPTY
	No existem bots disponveis no momento.
	Pea a um Administrador dos Services para criar mais bots!
	
# ASSIGN responses
BOT_ASSIGN_SYNTAX
	ASSIGN canal nick
BOT_ASSIGN_READONLY
	Desculpe, mas o comando ASSIGN est temporariamente desativado.
BOT_ASSIGN_ALREADY
	Bot %s j est associado ao canal %s.
BOT_ASSIGN_ASSIGNED
	Bot %s foi associado ao canal %s.
	
# UNASSIGN responses
BOT_UNASSIGN_SYNTAX
	UNASSIGN canal
BOT_UNASSIGN_UNASSIGNED
	No possui mais nenhum bot associado ao canal %s.
	
# INFO responses
BOT_INFO_SYNTAX
	INFO {canal | nick}
BOT_INFO_NOT_FOUND
	%s no  um bot vlido ou um canal registrado.
BOT_INFO_BOT_HEADER
	Informaes do bot %s:
BOT_INFO_BOT_MASK
	       Mscara: %s@%s
BOT_INFO_BOT_REALNAME
	      RealName: %s
BOT_INFO_BOT_CREATED
	        Criado: %s
BOT_INFO_BOT_USAGE
	      Usado em: %d canal(is)
BOT_INFO_BOT_OPTIONS
	        Opes: %s
BOT_INFO_OPT_PRIVATE
	Privado
BOT_INFO_CHAN_HEADER
	Informaes do canal %s:
BOT_INFO_CHAN_BOT
	           Nick do bot: %s
BOT_INFO_CHAN_BOT_NONE
	           Nick do bot: nenhum associado no momento.
BOT_INFO_CHAN_KICK_BADWORDS
	     Kick por palavro: %s
BOT_INFO_CHAN_KICK_BADWORDS_BAN
	     Kick por palavro: %s (%d kick(s) para banir)
BOT_INFO_CHAN_KICK_BOLDS
	      Kick por negrito: %s
BOT_INFO_CHAN_KICK_BOLDS_BAN
	      Kick por negrito: %s (%d kick(s) para banir)
BOT_INFO_CHAN_KICK_CAPS_ON
	         Kick por Caps: %s (mnimo %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_BAN
	         Kick por Caps: %s (%d kick(s) para banir; mnimo %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_OFF
	         Kick por Caps: %s
BOT_INFO_CHAN_KICK_COLORS
	        Kick por cores: %s
BOT_INFO_CHAN_KICK_COLORS_BAN
	        Kick por cores: %s (%d kick(s) para banir)
BOT_INFO_CHAN_KICK_FLOOD_ON
	        Kick por flood: %s (%d linhas em %ds)
BOT_INFO_CHAN_KICK_FLOOD_BAN
	        Kick por flood: %s (%d kick(s) para banir; %d linhas em %ds)
BOT_INFO_CHAN_KICK_FLOOD_OFF
	        Kick por flood: %s
BOT_INFO_CHAN_KICK_REPEAT_ON
	    Kick por repetio: %s (%d vezes)
BOT_INFO_CHAN_KICK_REPEAT_BAN
	    Kick por repetio: %s (%d kick(s) para banir; %d vezes)
BOT_INFO_CHAN_KICK_REPEAT_OFF
	    Kick por repetio: %s
BOT_INFO_CHAN_KICK_REVERSES
	     Kick por reversos: %s
BOT_INFO_CHAN_KICK_REVERSES_BAN
	     Kick por reversos: %s (%d kick(s) para banir)
BOT_INFO_CHAN_KICK_UNDERLINES
	   Kick por sublinhado: %s
BOT_INFO_CHAN_KICK_UNDERLINES_BAN
	   Kick por sublinhado: %s (%d kick(s) para banir)
BOT_INFO_ACTIVE
	ativado
BOT_INFO_INACTIVE
	desativado
BOT_INFO_CHAN_OPTIONS
	                Opes: %s
BOT_INFO_OPT_DONTKICKOPS
	Proteo de OPs
BOT_INFO_OPT_DONTKICKVOICES
	Proteo de Voices
BOT_INFO_OPT_FANTASY
	Fantasia
BOT_INFO_OPT_GREET
	Mensagem de entrada
BOT_INFO_OPT_NOBOT
	Sem bot
BOT_INFO_OPT_SYMBIOSIS
	Simbiose
BOT_INFO_OPT_NONE
	Nenhuma
	
# SET responses
BOT_SET_SYNTAX
	SET canal opes configuraes
BOT_SET_DISABLED
	Desculpe, o comando SET est temporariamente desativado.
BOT_SET_UNKNOWN
	Opo desconhecida: %s.
	Digite %R%S HELP SET para maiores informaes.
	
# SET DONTKICKOPS messages
BOT_SET_DONTKICKOPS_SYNTAX
	SET canal DONTKICKOPS {ON|OFF}
BOT_SET_DONTKICKOPS_ON
	Bot no ir kickar OPs no canal %s.
BOT_SET_DONTKICKOPS_OFF
	Bot ir kickar OPs no canal %s.
	
# SET DONTKICKVOICES messages
BOT_SET_DONTKICKVOICES_SYNTAX
	SET canal DONTKICKVOICES {ON|OFF}
BOT_SET_DONTKICKVOICES_ON
	Bot no ir kickar voices no canal %s.
BOT_SET_DONTKICKVOICES_OFF
	Bot ir kickar voices no canal %s.

# SET FANTASY messages
BOT_SET_FANTASY_SYNTAX
	SET canal FANTASY {ON|OFF}
BOT_SET_FANTASY_ON
	Modo Fantasia est agora ATIVADO no canal %s.
BOT_SET_FANTASY_OFF
	Modo Fantasia est agora DESATIVADO no canal %s.
	
# SET GREET messages
BOT_SET_GREET_SYNTAX
	SET canal GREET {ON|OFF}
BOT_SET_GREET_ON
	Modo mensagem de entrada est agora ATIVADO no canal %s.
BOT_SET_GREET_OFF
	Modo mensagem de entrada est agora DESATIVADO no canal %s.
	
# SET NOBOT
BOT_SET_NOBOT_SYNTAX
	SET canal NOBOT {ON|OFF}
BOT_SET_NOBOT_ON
	Modo NOBOT est agora ATIVADO no canal %s.
BOT_SET_NOBOT_OFF
	Modo NOBOT est agora DESATIVADO no canal %s.
	
# SET SYMBIOSIS
BOT_SET_PRIVATE_SYNTAX
	SET canal PRIVATE {ON|OFF}
BOT_SET_PRIVATE_ON
	Modo Privado do bot %s est agora ATIVADO.
BOT_SET_PRIVATE_OFF
	Modo Privado do bot %s est agora DESATIVADO.

# SET SYMBIOSIS
BOT_SET_SYMBIOSIS_SYNTAX
	SET canal SYMBIOSIS {ON|OFF}
BOT_SET_SYMBIOSIS_ON
	Modo SYMBIOSIS est agora ATIVADO no canal %s.
BOT_SET_SYMBIOSIS_OFF
	Modo SYMBIOSIS est agora DESATIVADO no canal %s.
	
# KICK responses
BOT_KICK_SYNTAX
	KICK canal opes {ON|OFF} [configuraes]
BOT_KICK_DISABLED
	Desculpe, as configuraes do kicker esto temporariamente desativadas.
BOT_KICK_UNKNOWN
	Opo desconhecida: %s.
	Digite %R%S HELP KICK para maiores informaes.
BOT_KICK_BAD_TTB
	%s no pode ser colocado como tempo para ban.

BOT_KICK_BADWORDS_ON
	O bot ir agora kickar por palavres. Use o comando
	BADWORDS para adicionar ou remover um palavro.
BOT_KICK_BADWORDS_ON_BAN
	O bot ir agora kickar por palavres, e ir setar um ban 
	aps %d kicks no mesmo usurio. Use o comando BADWORDS
	para adicionar ou remover um palavro.
BOT_KICK_BADWORDS_OFF
	O bot no ir mais kickar por palavres.
BOT_KICK_BOLDS_ON
	O bot ir agora kickar por negritos.
BOT_KICK_BOLDS_ON_BAN
	O bot ir agora kickar por negritos, e ir setar um ban 
	aps %d kicks no mesmo usurio.
BOT_KICK_BOLDS_OFF
	O bot no ir mais kickar por negritos.
BOT_KICK_CAPS_ON
	O bot ir agora kickar por caps (deve ter no mnimo
	%d caracteres e %d%% na mensagem inteira).
BOT_KICK_CAPS_ON_BAN
	O bot ir agora kickar por caps (deve ter no mnimo
	%d caracteres e %d%% na mensagem inteira), e ir setar
	um ban aps %d kicks no mesmo usurio.
BOT_KICK_CAPS_OFF
	O bot no ir mais kickar por caps.
BOT_KICK_COLORS_ON
	O bot ir agora kickar por cores.
BOT_KICK_COLORS_ON_BAN
	O bot ir agora kickar por cores, e ir setar um ban aps %d 
	kicks no mesmo usurio.
BOT_KICK_COLORS_OFF
	O bot no ir mais kickar por cores.
BOT_KICK_FLOOD_ON
	O bot ir agora kickar por flood (%d linhas em %d segundos).
BOT_KICK_FLOOD_ON_BAN
	O bot ir agora kickar por flood (%d linhas em %d segundos), e 
	setar um ban aps %d kicks no mesmo usurio.
BOT_KICK_FLOOD_OFF
	O bot no ir mais kickar por flood.
BOT_KICK_REPEAT_ON
	O bot ir agora kickar por repetio (usurios que escreverem
	%d vezes a mesma coisa).
BOT_KICK_REPEAT_ON_BAN
	O bot ir agora kickar por repetio (usurios que escreverem
	%d vezes a mesma coisa), e ir setar um ban aps %d 
	kicks no mesmo usurio.
BOT_KICK_REPEAT_OFF
	O bot no ir mais kickar por repetio.
BOT_KICK_REVERSES_ON
	O bot ir agora kickar por reversos.
BOT_KICK_REVERSES_ON_BAN
	O bot ir agora kickar por reversos, e ir setar um ban aps %d 
	kicks no mesmo usurio.
BOT_KICK_REVERSES_OFF
	O bot no ir mais kickar por reversos.
BOT_KICK_UNDERLINES_ON
	O bot ir agora kickar por sublinhados.
BOT_KICK_UNDERLINES_ON_BAN
	O bot ir agora kickar por sublinhados, e ir setar um ban aps %d 
	kicks no mesmo usurio.
BOT_KICK_UNDERLINES_OFF
	O bot no ir mais kickar por sublinhados.
	
# BADWORDS messages
BOT_BADWORDS_SYNTAX
	BADWORDS canal {ADD|DEL|LIST|CLEAR} [palavra | lista] [SINGLE|START|END]
BOT_BADWORDS_DISABLED
	Desculpe, o comando BADWORDS est temporariamente desatvado.
BOT_BADWORDS_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d palavres em sua lista.
BOT_BADWORDS_ALREADY_EXISTS
	%s j existe na lista de palavres do %s.
BOT_BADWORDS_ADDED
	%s adicionado na lista de palavres do %s.
BOT_BADWORDS_NO_SUCH_ENTRY
	Entrada no encontrada (#%d) na lista de palavres do %s.
BOT_BADWORDS_NOT_FOUND
	%s no foi encontrado na lista de palavres do %s.
BOT_BADWORDS_NO_MATCH
	Nenhum resultado correspondente encontrado na lista do %s.
BOT_BADWORDS_DELETED
	%s removido da lista de palavres do %s.
BOT_BADWORDS_DELETED_ONE
	Removida 1 entrada da lista de palavres do %s.
BOT_BADWORDS_DELETED_SEVERAL
	Removidas %d entradas da lista de palavres do %s.
BOT_BADWORDS_LIST_EMPTY
	Lista de palvres do %s est vazia.
BOT_BADWORDS_LIST_HEADER
	Lista de palavres do %s:
	  Nm   Palavra                        Tipo
BOT_BADWORDS_LIST_FORMAT
	  %3d   %-30s %s
BOT_BADWORDS_CLEAR
	Lista de palavres est agora vazia.

# SAY responses
BOT_SAY_SYNTAX
	SAY canal texto

# ACT responses
BOT_ACT_SYNTAX
	ACT canal texto

BOT_EXCEPT
	Usurio combina com Except do canal.

BOT_BAD_NICK
	O Nick do bot deve conter apenas caracteres vlidos a Nicks.
BOT_BAD_HOST
	O Host do bot deve conter apenas caracteres vlidos a Hosts.
BOT_BAD_IDENT
	A Identd do bot deve conter apenas caracteres vlidos.
BOT_LONG_IDENT
	Bot Idents may only contain 9 characters.

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Os Services no conseguiram alterar os modos. Seus servidores esto configurados corretamente?
OPER_BOUNCY_MODES_U_LINE
	Os Services no conseguiram alterar os modos. As U:lines dos seus servidores esto configuradas corretamente?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL mensagem

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Opo STATS desconhecida: %s.
OPER_STATS_CURRENT_USERS
	Usurios atuais: %d (%d ops)
OPER_STATS_MAX_USERS
	Mximo atingido: %d (%s)

# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal preference
# is to only give resolution to the nearest minute when uptime is one hour
# or more, but just add a %d to get seconds as well.
OPER_STATS_UPTIME_DHMS
	Services ativos %d dias, %02d:%02d
OPER_STATS_UPTIME_1DHMS
	Services ativos %d dia, %02d:%02d
OPER_STATS_UPTIME_HMS
	Services ativos %d horas, %d minutos
OPER_STATS_UPTIME_HM1S
	Services ativos %d horas, %d minutos
OPER_STATS_UPTIME_H1MS
	Services ativos %d horas, %d minuto
OPER_STATS_UPTIME_H1M1S
	Services ativos %d horas, %d minuto
OPER_STATS_UPTIME_1HMS
	Services ativos %d hora, %d minutos
OPER_STATS_UPTIME_1HM1S
	Services ativos %d hora, %d minutos
OPER_STATS_UPTIME_1H1MS
	Services ativos %d hora, %d minuto
OPER_STATS_UPTIME_1H1M1S
	Services ativos %d hora, %d minuto
OPER_STATS_UPTIME_MS
	Services ativos %d minutos, %d segundos
OPER_STATS_UPTIME_M1S
	Services ativos %d minutos, %d segundo
OPER_STATS_UPTIME_1MS
	Services ativos %d minuto, %d segundos
OPER_STATS_UPTIME_1M1S
	Services ativos %d minuto, %d segundo
OPER_STATS_BYTES_READ
	Bytes lidos   : %5d kB
OPER_STATS_BYTES_WRITTEN
	Bytes escritos: %5d kB
OPER_STATS_USER_MEM
	Usurios      : %6d registros, %5d kB
OPER_STATS_CHANNEL_MEM
	Canais        : %6d registros, %5d kB
OPER_STATS_GROUPS_MEM
	Grupos NS     : %6d registros, %5d kB
OPER_STATS_ALIASES_MEM
	Nicks NS      : %6d registros, %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ      : %6d registros, %5d kB
OPER_STATS_BOTSERV_MEM
	BotServ       : %6d registros, %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ      : %6d registros, %5d kB
OPER_STATS_SESSIONS_MEM
	Sesses       : %6d registros, %5d kB
OPER_STATS_AKILL_COUNT
	Nmero atual de AKILLs: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Tempo atual de expirao de akill: %d dias
OPER_STATS_AKILL_EXPIRE_DAY
	Tempo atual de expirao de akill: 1 dia
OPER_STATS_AKILL_EXPIRE_HOURS
	Tempo atual de expirao de akill: %d horas
OPER_STATS_AKILL_EXPIRE_HOUR
	Tempo atual de expirao de akill: 1 hora
OPER_STATS_AKILL_EXPIRE_MINS
	Tempo atual de expirao de akill: %d minutos
OPER_STATS_AKILL_EXPIRE_MIN
	Tempo atual de expirao de akill: 1 minuto
OPER_STATS_AKILL_EXPIRE_NONE
	Tempo atual de expirao de akill: No expira
OPER_STATS_SGLINE_COUNT
	Nmero atual de SGLINEs: %d
OPER_STATS_SGLINE_EXPIRE_DAYS
	Tempo atual de expirao de SGLINE: %d dias
OPER_STATS_SGLINE_EXPIRE_DAY
	Tempo atual de expirao de SGLINE: 1 dia
OPER_STATS_SGLINE_EXPIRE_HOURS
	Tempo atual de expirao de SGLINE: %d horas
OPER_STATS_SGLINE_EXPIRE_HOUR
	Tempo atual de expirao de SGLINE: 1 hora
OPER_STATS_SGLINE_EXPIRE_MINS
	Tempo atual de expirao de SGLINE: %d minutos
OPER_STATS_SGLINE_EXPIRE_MIN
	Tempo atual de expirao de SGLINE: 1 minuto
OPER_STATS_SGLINE_EXPIRE_NONE
	Tempo atual de expirao de SGLINE: No expira
OPER_STATS_SQLINE_COUNT
	Nmero atual de SQLINEs: %d
OPER_STATS_SQLINE_EXPIRE_DAYS
	Tempo atual de expirao de SQLINE: %d dias
OPER_STATS_SQLINE_EXPIRE_DAY
	Tempo atual de expirao de SQLINE: 1 dia
OPER_STATS_SQLINE_EXPIRE_HOURS
	Tempo atual de expirao de SQLINE: %d horas
OPER_STATS_SQLINE_EXPIRE_HOUR
	Tempo atual de expirao de SQLINE: 1 hora
OPER_STATS_SQLINE_EXPIRE_MINS
	Tempo atual de expirao de SQLINE: %d minutos
OPER_STATS_SQLINE_EXPIRE_MIN
	Tempo atual de expirao de SQLINE: 1 minuto
OPER_STATS_SQLINE_EXPIRE_NONE
	Tempo atual de expirao de SQLINE: No expira
OPER_STATS_SZLINE_COUNT
	Nmero atual de SZLINEs: %d
OPER_STATS_SZLINE_EXPIRE_DAYS
	Tempo atual de expirao de SZLINE: %d dias
OPER_STATS_SZLINE_EXPIRE_DAY
	Tempo atual de expirao de SZLINE: 1 dia
OPER_STATS_SZLINE_EXPIRE_HOURS
	Tempo atual de expirao de SZLINE: %d horas
OPER_STATS_SZLINE_EXPIRE_HOUR
	Tempo atual de expirao de SZLINE: 1 hora
OPER_STATS_SZLINE_EXPIRE_MINS
	Tempo atual de expirao de SZLINE: %d minutos
OPER_STATS_SZLINE_EXPIRE_MIN
	Tempo atual de expirao de SZLINE: 1 minuto
OPER_STATS_SZLINE_EXPIRE_NONE
	Tempo atual de expirao de SZLINE: No expira
OPER_STATS_RESET
	Resetar estatsticas.

# MODE responses
OPER_STATS_UPLINK_SERVER
	Uplink server: %s
OPER_STATS_UPLINK_CAPAB
	Uplink capab: %s
OPER_STATS_UPLINK_SERVER_COUNT
	Servers found: %d

# MODE responses
OPER_MODE_SYNTAX
	MODE canal modos

# UMODE respondes
OPER_UMODE_SYNTAX
	UMODE nick modos
OPER_UMODE_SUCCESS
	Modos do usurio %s alterados.
OPER_UMODE_CHANGED
	%s alterou seus modos de usurio.

# OLINE responses
OPER_OLINE_SYNTAX
	OLINE nick flags
OPER_OLINE_SUCCESS
	As Operflags %s foram adicionadas para %s.
OPER_OLINE_IRCOP
	Voc agora  um Operador de IRC.

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES canal [ALL]
OPER_CLEARMODES_DONE
	Modos binrios e bans removidos do canal %s.
OPER_CLEARMODES_ALL_DONE
	Todos os modos foram removidos do canal %s.


# KICK responses
OPER_KICK_SYNTAX
	KICK canal usurio motivo
	
# ADMIN responses
OPER_SVSNICK_SYNTAX
	SVSNICK nick novonick 
OPER_SVSNICK_NEWNICK
	O nick %s est sendo alterado para %s.
	
# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD|DEL|LIST|CLEAR} [nick | lista]
OPER_ADMIN_SKELETON
	Services esto no modo esqueleto; o comando ADMIN no est disponvel.
OPER_ADMIN_EXISTS
	%s j est na lista de Administradores dos Services.
OPER_ADMIN_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d Administradores dos Services.
OPER_ADMIN_ADDED
	%s adicionado  lista de Administradores dos Services.
OPER_ADMIN_NOT_FOUND
	%s no encontrado na lista de Administradores dos Services.
OPER_ADMIN_NO_MATCH
	Nenhum resultado encontrado na lista de Administradores dos Services.
OPER_ADMIN_DELETED
	%s removido da lista de Administradores dos Services.
OPER_ADMIN_DELETED_ONE
	Removida 1 entrada da lista de Administradores dos Services.
OPER_ADMIN_DELETED_SEVERAL
	Removidas %d entradas da lista de Administradores dos Services.
OPER_ADMIN_LIST_EMPTY
	A lista de Administradores dos Services est vazia.
OPER_ADMIN_LIST_HEADER
	Lista de Administradores dos Services:
	  Nm   Nick
OPER_ADMIN_LIST_FORMAT
	  %3d   %s
OPER_ADMIN_CLEAR
	Lista de Administradores dos Services foi apagada.
OPER_ADMIN_MOVED
	%s foi movido para a lista de Administradores dos Services.

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD|DEL|LIST|CLEAR} [nick | lista]
OPER_OPER_SKELETON
	Services esto no modo esqueleto; o comando OPER no est disponvel.
OPER_OPER_EXISTS
	%s j est na lista de Operadores dos Services.
OPER_OPER_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d Operadores dos Services.
OPER_OPER_ADDED
	%s adicionado  lista de Operadores dos Services.
OPER_OPER_NOT_FOUND
	%s no encontrado na lista de Operadores dos Services.
OPER_OPER_NO_MATCH
	Nenhum resultado equivalente na lista de Operadores dos Services.
OPER_OPER_DELETED
	%s removido da lista de Operadores dos Services.
OPER_OPER_DELETED_ONE
	Removida 1 entrada da lista de Operadores dos Services.
OPER_OPER_DELETED_SEVERAL
	Removidas %d entradas da lista de Operadores dos Services.
OPER_OPER_LIST_EMPTY
	A lista de Operadores dos Services est vazia.
OPER_OPER_LIST_HEADER
	Lista de Operadores dos Services:
	  Nm   Nick
OPER_OPER_LIST_FORMAT
	  %3d   %s
OPER_OPER_CLEAR
	A lista de Operadores dos Services foi apagada.
OPER_OPER_MOVED
	%s foi movido para a lista de Operadores dos Services.

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | CLEAR} [[+tempo] {mscara | lista} [motivo]]
OPER_AKILL_EXISTS
	%s j se encontra na lista de AKILL.
OPER_AKILL_ALREADY_COVERED
	%s j est coberto pelo AKILL %s.
OPER_AKILL_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d AKILLs.
OPER_AKILL_NO_NICK
	Lembrete: As mscaras de AKILL no devem conter o nick; tenha certeza de que voc no incluiu o nick na mscara.
OPER_AKILL_ADDED
	%s adicionado  lista de AKILL.
OPER_AKILL_CHANGED
	Tempo de expirao para %s alterado.
OPER_AKILL_NOT_FOUND
	%s no encontrado na lista de AKILL.
OPER_AKILL_NO_MATCH
	Nenhum resultado equivalente na lista de AKILL.
OPER_AKILL_DELETED
	%s removido da lista de AKILL.
OPER_AKILL_DELETED_ONE
	Removida 1 entrada da lista de AKILL.
OPER_AKILL_DELETED_SEVERAL
	Removidas %d entradas da lista de AKILL.
OPER_AKILL_LIST_EMPTY
	A lista de AKILL est vazia.
OPER_AKILL_LIST_HEADER
	Lista de AKILL atual:
	  Nm   Mscara                           Motivo
OPER_AKILL_LIST_FORMAT
	  %3d   %-32s  %s
OPER_AKILL_VIEW_HEADER
	Lista de AKILL atual:
# number, mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_FORMAT
	%3d  %s (por %s em %s; %s)
	      %s
OPER_AKILL_CLEAR
	Lista de AKILL apagada.
OPER_CHANKILL_SYNTAX
	CHANKILL [+tempo] {#canal} [motivo]

# SGLINE responses
OPER_SGLINE_SYNTAX
	SGLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+tempo] {mscara | lista}[:motivo]]
OPER_SGLINE_UNSUPPORTED
	Desculpe, SGLINE no est disponvel nesta Rede.
OPER_SGLINE_EXISTS
	%s j existe na lista de SGLINE.
OPER_SGLINE_ALREADY_COVERED
	%s j est coberto por %s.
OPER_SGLINE_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d SGLINEs.
OPER_SGLINE_ADDED
	%s adicionado  lista de SGLINE.
OPER_SGLINE_CHANGED
	Tempo de expirao para %s aterado.
OPER_SGLINE_NOT_FOUND
	%s no encontrado na lista de SGLINE.
OPER_SGLINE_NO_MATCH
	Nenhum resultado equivalente na lista de SGLINE.
OPER_SGLINE_DELETED
	%s removido da lista de SGLINE.
OPER_SGLINE_DELETED_ONE
	Removida 1 entrada da lista de SGLINE.
OPER_SGLINE_DELETED_SEVERAL
	Removidas %d entradas da lista de SGLINE.
OPER_SGLINE_LIST_EMPTY
	A lista de SGLINE est vazia.
OPER_SGLINE_LIST_HEADER
	Lista de SGLINE atual:
	  Nm   Mscara                           Motivo
OPER_SGLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SGLINE_VIEW_HEADER
	Lista de SGLINE atual:
# number, mask, set-by, set-time, expires, reason
OPER_SGLINE_VIEW_FORMAT
	%3d  %s (por %s em %s; %s)
	      %s
OPER_SGLINE_CLEAR
	A lista de SGLINE foi apagada.

# SZLINE responses
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+tempo] {mscara | lista} [motivo]]
OPER_SQLINE_CHANNELS_UNSUPPORTED
	SQLINEs de canal no so suportadas por este IRCd, ento voc no pode us-las.
OPER_SQLINE_EXISTS
	%s j existe na lista de SQLINE.
OPER_SQLINE_ALREADY_COVERED
	%s j est coberto por %s.
OPER_SQLINE_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d SQLINEs.
OPER_SQLINE_ADDED
	%s adicionado  lista de SQLINE.
OPER_SQLINE_CHANGED
	Tempo de expirao para %s alterado.
OPER_SQLINE_NOT_FOUND
	%s no encontrado na lista de SQLINE.
OPER_SQLINE_NO_MATCH
	Nenhum resultado equivalente na lista de SQLINE.
OPER_SQLINE_DELETED
	%s removido da lista de SQLINE.
OPER_SQLINE_DELETED_ONE
	Removida 1 entrada da lista de SQLINE.
OPER_SQLINE_DELETED_SEVERAL
	Removidas %d entradas da lista de SQLINE.
OPER_SQLINE_LIST_EMPTY
	A lista de SQLINE est vazia.
OPER_SQLINE_LIST_HEADER
	Lista de SQLINE atual:
	  Nm   Mscara                           Motivo
OPER_SQLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SQLINE_VIEW_HEADER
	Lista de SQLINE atual:
# number, mask, set-by, set-time, expires, reason
OPER_SQLINE_VIEW_FORMAT
	%3d  %s (por %s em %s; %s)
	      %s
OPER_SQLINE_CLEAR
	A lista de SQLINE foi apagada.

# SZLINE responses
OPER_SZLINE_SYNTAX
	SZLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+tempo] {mscara | lista} [motivo]]
OPER_SZLINE_UNSUPPORTED
	Desculpe, SZLINE no est disponvel nesta Rede.
OPER_SZLINE_EXISTS
	%s j existe na lista de SZLINE.
OPER_SZLINE_ALREADY_COVERED
	%s j est coberto por %s.
OPER_SZLINE_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d SZLINEs.
OPER_SZLINE_ONLY_IPS
	Lembrete: voc pode apenas adicionar endereos de IP para a lista de SZLINE.
OPER_SZLINE_ADDED
	%s adicionado  lista de SZLINE.
OPER_SZLINE_CHANGED
	Tempo de expirao para %s alterado.
OPER_SZLINE_NOT_FOUND
	%s no foi encontrado na lista de SZLINE.
OPER_SZLINE_NO_MATCH
	Nenhum resultado equivalente na lista de SZLINE.
OPER_SZLINE_DELETED
	%s removido da lista de SZLINE.
OPER_SZLINE_DELETED_ONE
	Removida 1 entrada da lista de SZLINE.
OPER_SZLINE_DELETED_SEVERAL
	Removidas %d entradas da lista de SZLINE.
OPER_SZLINE_LIST_EMPTY
	A lista de SZLINE est vazia.
OPER_SZLINE_LIST_HEADER
	Lista atual de SZLINE:
	  Nm   Mscara                           Motivo
OPER_SZLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SZLINE_VIEW_HEADER
	Lista atual de SZLINE:
# number, mask, set-by, set-time, expires, reason
OPER_SZLINE_VIEW_FORMAT
	%3d  %s (por %s em %s; %s)
	      %s
OPER_SZLINE_CLEAR
	A lista de SZLINE foi apagada.

# SET responses
OPER_SET_SYNTAX
	SET opo configurao
OPER_SET_IGNORE_ON
	Opo IGNORE ser usada.
OPER_SET_IGNORE_OFF
	Opo IGNORE no ser usada.
OPER_SET_IGNORE_ERROR
	Configurao do IGNORE deve ser ON ou OFF.
OPER_SET_READONLY_ON
	Services esto agora no modo somente leitura.
OPER_SET_READONLY_OFF
	Services esto agora no modo leitura e gravao.
OPER_SET_READONLY_ERROR
	Configurao do READONLY deve ser ON ou OFF.
OPER_SET_LOGCHAN_ON
	Services esto enviando o log no canal %s.
OPER_SET_LOGCHAN_OFF
	Services deixando de enviar o log.
OPER_SET_LOGCHAN_ERROR
	Configurao do LOGCHAN deve ser ON ou OFF e LogChan deve estar definido.
OPER_SET_DEBUG_ON
	Services esto agora no modo debug.
OPER_SET_DEBUG_OFF
	Services no esto mais no modo debug.
OPER_SET_DEBUG_LEVEL
	Services esto agora no modo debug (nvel %d).
OPER_SET_DEBUG_ERROR
	Configurao do DEBUG deve ser ON, OFF, ou um nmero positivo.
OPER_SET_NOEXPIRE_ON
	Services esto agora no modo no expira.
OPER_SET_NOEXPIRE_OFF
	Services esto agora no modo expira.
OPER_SET_NOEXPIRE_ERROR
	Opo NOEXPIRE deve ser ON ou OFF.
OPER_SET_UNKNOWN_OPTION
	Opo desconhecida: %s.
OPER_SET_SQL_ON
	Cdigo SQL ser usado.
OPER_SET_SQL_OFF
	Cdigo SQL no ser usado.
OPER_SET_SQL_ERROR
	Ajuste para SQL deve ser ON ou OFF.
OPER_SET_SQL_ERROR_INIT
	Erro durante inicializao de SQL, verifique seus logs para corrigir.
OPER_SET_SQL_ERROR_DISABLED
	SQL no est configurada para esta rede. Por favor, edite o
	arquivo de configurao (services.conf).
OPER_SET_LIST_OPTION_ON
	%s est ativada
OPER_SET_LIST_OPTION_OFF
	%s est desativada

# NOOP responses
OPER_NOOP_SYNTAX
	NOOP {SET|REVOKE} servidor
OPER_NOOP_SET
	Todas as O:lines do servidor %s foram removidas.
OPER_NOOP_REVOKE
	Todas as O:lines do servidor %s foram resetadas.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE servidor [motivo]
OPER_JUPE_HOST_ERROR
	Por favor, use um nome de servidor vlido quando estiver "jupando".
	
# RAW responses
OPER_RAW_SYNTAX
	RAW texto

# UPDATE responses
OPER_UPDATING
	Atualizando banco de dados.
	
# RELOAD responses
OPER_RELOAD
	Arquivos de configurao dos Services foram recarregados.

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN no definido; no foi possvel reiniciar. Rode novamente o \2configure\2 e recompile os services para habilitar o comando RESTART.

# LISTIGNORE responses
OPER_IGNORE_SYNTAX
	Sintaxe: IGNORE {ADD|DEL|LIST|CLEAR} [tempo] [nick]
OPER_IGNORE_VALID_TIME
	Voc precisa digitar um nmero vlido como tempo.
OPER_IGNORE_TIME_DONE
	%s agora ser ignorado por %s.
OPER_IGNORE_PERM_DONE
	%s agora ser permanentemente ignorado.
OPER_IGNORE_DEL_DONE
	%s no ser mais ignorado.
OPER_IGNORE_LIST
	Lista de Ignore dos Services:
OPER_IGNORE_LIST_NOMATCH
	%s no encontrado na lista de Ignore.
OPER_IGNORE_LIST_EMPTY
	Lista de Ignore dos Services vazia.

# KILLCLONES responses
OPER_IGNORE_LIST_CLEARED
	Lista de Ignore foi apagada.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES nick
OPER_KILLCLONES_UNKNOWN_NICK
	No foi possvel encontrar o nick %s.
	
# CHANLIST responses
OPER_CHANLIST_HEADER
	Lista de canais:
	Nome              Usurios Tpico
OPER_CHANLIST_HEADER_USER
	Lista de canais do %s:
	Nome              Usurios Tpico
OPER_CHANLIST_RECORD
	%-20s  %4d %s
OPER_CHANLIST_END
	Fim da listagem.
	
# USERLIST responses
OPER_USERLIST_HEADER
	Lista de usurios:
	Nick                 Mscara
OPER_USERLIST_HEADER_CHAN
	Lista de usurios do %s:
	Nick                 Mscara
OPER_USERLIST_RECORD
	%-20s %s@%s
OPER_USERLIST_END
	Fim da listagem.

OPER_SUPER_ADMIN_ON
	Voc  agora um Super-Admin
OPER_SUPER_ADMIN_OFF
	Voc no  mais um Super-Admin
OPER_SUPER_ADMIN_SYNTAX
	Configurao de SuperAdmin deve ser ON ou OFF (deve estar habilitada no services.conf).
OPER_SUPER_ADMIN_WALL_ON
	%s  agora um Super-Admin
OPER_SUPER_ADMIN_WALL_OFF
	%s no  mais um Super-Admin
OPER_SUPER_ADMIN_ONLY
	Apenas Super-Admins podem usar este comando.
OPER_STAFF_LIST_HEADER
	On Nvel Nick
OPER_STAFF_FORMAT
	 %c %s  %s
OPER_STAFF_AFORMAT
	 %c %s  %s [%s]

# DefCon Messages

OPER_DEFCON_SYNTAX
	Sintaxe: DEFCON [1|2|3|4|5]
OPER_DEFCON_DENIED
	Este servio est temporariamente desabilitado, por favor tente novamente mais tarde
OPER_DEFCON_NO_CONF
	O sistema Defcon deve estar habilitado no arquivo services.conf
OPER_DEFCON_CHANGED
	Services esto agora em DEFCON %d
OPER_DEFCON_WALL
	%s alterou o Nvel do DEFCON para %d
DEFCON_GLOBAL
	O Nvel do Defcon est agora no Nvel: %d

# Modules strings

OPER_MODULE_LOADED
	Mdulo %s carregado
OPER_MODULE_UNLOADED
	Mdulo %s descarregado
OPER_MODULE_LOAD_FAIL
	Impossvel carregar o mdulo %s
OPER_MODULE_REMOVE_FAIL
	Impossvel remover o mdulo %s
OPER_MODULE_NO_UNLOAD
	This module can not be unloaded.
OPER_MODULE_LOAD_SYNTAX
	MODLOAD NomeDoArquivo
OPER_MODULE_UNLOAD_SYNTAX
	MODUNLOAD NomeDoArquivo
OPER_MODULE_LIST_HEADER
	Lista de Mdulos atual:
OPER_MODULE_LIST
	Mdulo: %s [%s] [%s]
OPER_MODULE_LIST_FOOTER
	%d mdulos carregados.
OPER_MODULE_INFO_LIST
	Mdulo: %s Verso: %s Autor: %s Carregado: %s
OPER_MODULE_CMD_LIST
	Comando fornecido: /%s %s
OPER_MODULE_MSG_LIST
	Fornecendo IRCd handler para: %s
OPER_MODULE_NO_LIST
	Nenhum mdulo carregado atualmente.
OPER_MODULE_NO_INFO
	Nenhuma informao sobre o mdulo %s est disponvel.
OPER_MODULE_INFO_SYNTAX
	MODINFO NomeDoArquivo

MODULE_HELP_HEADER
	Os seguintes comandos foram carregados por um mdulo:

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [parmetros]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+tempo] mscara limite motivo
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {mscara | lista}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE nm posio
OPER_EXCEPTION_DISABLED
	Opo de limite de sesses desabilitada.
OPER_EXCEPTION_ALREADY_PRESENT
	Mscara %s j presente na lista de limite de sesses.
OPER_EXCEPTION_TOO_MANY
	Lista de limite de sesses est cheia!
OPER_EXCEPTION_ADDED
	Limite de sesses para %s  agora de %d.
OPER_EXCEPTION_MOVED
	Sesso para %s (#%d) alterada para a posio %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	Nenhuma entrada equivalente (#%d) na lista de limite de sesses.
OPER_EXCEPTION_NOT_FOUND
	%s no encontrado na lista de limite de sesses.
OPER_EXCEPTION_NO_MATCH
	Nenhum resultado encontrado na lista de limite de sesses.
OPER_EXCEPTION_DELETED
	%s removido da lista de limite de sesses.
OPER_EXCEPTION_DELETED_ONE
	Removida 1 entrada da lista de limite de sesses.
OPER_EXCEPTION_DELETED_SEVERAL
	Removidas %d entradas da lista de limite de sesses.
OPER_EXCEPTION_LIST_HEADER
	Atual lista de Limite de sesses:
# mask, limit
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	Nm  Limite  Host
# mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (por %s em %s; %s)
	    Limite: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Limite de sesso invlida. O limite deve ser um nmero inteiro maior ou igual a zero e menor que %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	Mscara invlida. Apenas mscaras (hosts) so vlidas como excees aos limites de sesses. Nick ou username no so vlidos.
OPER_EXCEPTION_EXISTS
	%s j existe na lista de EXCEPTION.
OPER_EXCEPTION_CHANGED
	Exceo para %s foi atualizada para %d.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST limite | VIEW host}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST limite
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_DISABLED
	Limite de sesses est desativado.
OPER_SESSION_INVALID_THRESHOLD
	Nmero invlido. Deve ser um nmero inteiro maior que 1.
OPER_SESSION_NOT_FOUND
	%s no encontrado na lista de Limite de Sesses.
OPER_SESSION_LIST_HEADER
	Hosts com pelo menos %d sesses:
OPER_SESSION_LIST_COLHEAD
	Sesses  Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	O host %s possui atualmente %d sesses com um limite de %d.


# EXCEPTION help

OPER_HELP_EXCEPTION
	Sintaxe: EXCEPTION ADD [+tempo] mscara limite motivo
	         EXCEPTION DEL {mscara | lista}
	         EXCEPTION MOVE nm posio
	         EXCEPTION LIST [mscara | lista]
	         EXCEPTION VIEW [mscara | lista]
	
	Permite que os Administradores dos Services manipulem a lista
	de hosts que tenham limite de conexes especificados - deixando 
	certos hosts, como shell de servidores, conectar mais que o
	nmero padro de conexes simultneas. Uma vez um host atingindo
	um limite de conexo, todos os clientes que tentem conectar 
	daquele host sero expulsos ("killados").

	Antes do usurio ser expulso ("killado"), ele ser notificado
	via /NOTICE do %S com um tpico de ajuda sobre limitao
	de conexes.
	
	EXCEPTION ADD adiciona a mscara fornecida  lista de excees.
	Note que as mscaras nick!user@host e user@host so
	invlidas. S nomes reais de hosts, como mail.dominio.com e 
	*.dominio.com, so permitidos porque a limitao de
	conexo no utiliza o nick ou ident para bloquear o acesso. 
	
	EXCEPTION DEL remove a mscara especificada da Lista de
	excees.
	EXCEPTION MOVE move uma exceo de nmero nm para uma
	posio dada. As excees que estavam na faixa onde houve
	alterao sero todas movidas para cima ou para baixo conforme
	for o deslocamento necessrio.
	EXCEPTION LIST ou EXCEPTION VIEW mostram todas as 
	excees atuais vlidas; se uma mscara  dada como parmetro
	opcional, a lista  limitada as excees que so compatveis
	com a mscara dada. A diferenca  que EXCEPTION VIEW 
	 mais detalhado, mostrando o nome da pessoa que adicionou 
	a exceo, o seu limite de conexes, o motivo, a mscara do
	host, a data e o tempo de validade.
	
	Note que um cliente que conecte vai usar a primeira exceo
	que for compatvel com o seu host. Listas de excees muito
	grandes e mscaras de hosts muito abrangentes certamente
	iro degradar a eficcia de funcionamento ("performance")
	dos services.
	
	Limitado aos Administradores dos Services.

OPER_HELP_SESSION
	Sintaxe: SESSION LIST nmero
	         SESSION VIEW host
	
	Permite que os Administradores dos Services vejam a lista de
	conexes.
	
	SESSION LIST lista mscaras de hosts com pelo menos 
	nmero conexes permitidas.
	O limite deve ser um nmero maior que 1. Isto deve prevenir 
	a listagem de muitos hosts com um limite de conexes 
	limitado a 1.
	SESSION VIEW mostra informaes detalhadas sobre um host
	especfico, incluindo o nmero de conexes atual e o limite
	A mscara dada em host no deve incluir wildcards.
	
	Veja a ajuda sobre EXCEPTION para mais informaes sobre
	o limite de conexes e como especificar limites de conexes
	para certos hosts e grupos de hosts.
	
	Limitado aos Administradores dos Services.

OPER_HELP_STAFF
	Sintaxe: STAFF

	Exibe todos os nicks da Staff dos Services juntamente com seus
	nveis e status on-line.

OPER_HELP_DEFCON
	Sintaxe: DEFCON [1|2|3|4|5]

	O sistema Defcon pode ser usado para implementar um conjunto
	pr-definido de restries aos Services, til durante uma
	tentativa de ataque  Rede.

OPER_HELP_DEFCON_NO_NEW_CHANNELS
	* Impedido o registro de novos canais
OPER_HELP_DEFCON_NO_NEW_NICKS
	* Impedido o registro de novos nicks
OPER_HELP_DEFCON_NO_MLOCK_CHANGE
	* Impedida a mudana de MLOCK
OPER_HELP_DEFCON_FORCE_CHAN_MODES
	* Fora os Modos de Canal (%s) a serem setados em todos os canais
OPER_HELP_DEFCON_REDUCE_SESSION
	* Usa o limite de sesses reduzido de %d
OPER_HELP_DEFCON_NO_NEW_CLIENTS
	* Killa quaisquer NOVOS clientes conectando
OPER_HELP_DEFCON_OPER_ONLY
	* Ignora quaisquer no-opers com mensagem
OPER_HELP_DEFCON_SILENT_OPER_ONLY
	* Silenciosamente ignora no-opers
OPER_HELP_DEFCON_AKILL_NEW_CLIENTS
	* AKILLA quaisquer novos clientes conectando
OPER_HELP_DEFCON_NO_NEW_MEMOS
	* Impede o envio de novos memos
OPER_HELP_CHANKILL
	Sintaxe: CHANKILL [+tempo] canal motivo

	Adiciona um AKILL para cada nick no canal especificado. Isso
	usa por completo todo o host real ident@host para cada nick;
	em seguida, fora o AKILL.

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Logon News - %s] %s
NEWS_OPER_TEXT
	[Oper News - %s] %s

NEWS_RANDOM_TEXT
	[Random News - %s] %s

NEWS_LOGON_SYNTAX
	LOGONNEWS {ADD|DEL|LIST} [texto|nm]
NEWS_LOGON_LIST_HEADER
	Logon News itens:
NEWS_LOGON_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_LOGON_LIST_NONE
	No existem logon news.
NEWS_LOGON_ADD_SYNTAX
	LOGONNEWS ADD texto
NEWS_LOGON_ADD_FULL
	Lista de logon news est cheia!
NEWS_LOGON_ADDED
	Adicionado novo logon news (#%d).
NEWS_LOGON_DEL_SYNTAX
	LOGONNEWS DEL {nm | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Logon news no encontrado #%d!
NEWS_LOGON_DELETED
	Logon news removido #%d.
NEWS_LOGON_DEL_NONE
	Nenhum logon news para remover!
NEWS_LOGON_DELETED_ALL
	Todos os logon news foram removidos.

NEWS_OPER_SYNTAX
	OPERNEWS {ADD|DEL|LIST} [texto|nm]
NEWS_OPER_LIST_HEADER
	Oper News itens:
NEWS_OPER_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_OPER_LIST_NONE
	No existe nenhum oper news.
NEWS_OPER_ADD_SYNTAX
	OPERNEWS ADD texto
NEWS_OPER_ADD_FULL
	Lista de oper news est cheia!
NEWS_OPER_ADDED
	Adicionado novo OperNews (#%d).
NEWS_OPER_DEL_SYNTAX
	OPERNEWS DEL {nm | ALL}
NEWS_OPER_DEL_NOT_FOUND
	OperNews no encontrado #%d!
NEWS_OPER_DELETED
	OperNews removido #%d.
NEWS_OPER_DEL_NONE
	Nenhum OperNews para remover!
NEWS_OPER_DELETED_ALL
	Todos os OperNews foram removidos.

NEWS_RANDOM_SYNTAX
	RANDOMNEWS {ADD|DEL|LIST} [texto|nm]
NEWS_RANDOM_LIST_HEADER
	Random News itens:
NEWS_RANDOM_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_RANDOM_LIST_NONE
	No h RandomNews.
NEWS_RANDOM_ADD_SYNTAX
	RANDOMNEWS ADD texto
NEWS_RANDOM_ADD_FULL
	A lista de News est cheia!
NEWS_RANDOM_ADDED
	Adicionada novo item RandomNews (#%d).
NEWS_RANDOM_DEL_SYNTAX
	RANDOMNEWS DEL {nm | ALL}
NEWS_RANDOM_DEL_NOT_FOUND
	RandomNews item #%d no encontrado!
NEWS_RANDOM_DELETED
	RandomNews item #%d deletado.
NEWS_RANDOM_DEL_NONE
	Nenhum item RandomNews para deletar!
NEWS_RANDOM_DELETED_ALL
	Todos os itens RandomNews deletados.

NEWS_HELP_LOGON
	Sintaxe: LOGONNEWS ADD texto
	         LOGONNEWS DEL {nm | ALL}
	         LOGONNEWS LIST
	
	Edita ou mostra a lista de logon news. Quando um usurio
	se conecta  rede, estas mensagens so enviadas para ele.
	(No entanto, no mais que trs mensagens sero enviadas
	simultaneamente para evitar flood. Se houver mais que trs
	mensagens novas, apenas as mais novas sero mostradas.)
	
	LOGONNEWS LIST pode ser usado por qualquer Operador
	para listar as mensagens atuais. ADD e DEL s podem
	ser usados pelos Administradores dos Services.

NEWS_HELP_OPER
	Sintaxe: OPERNEWS ADD texto
	         OPERNEWS DEL {nm | ALL}
	         OPERNEWS LIST
	
	Edita ou mostra a lista de oper news. Quando um usurio
	se torna operador (pelo comando /OPER), estas mensagens
	lhe sero enviadas. (No entanto, no mais que trs
	mensagens sero enviadas simultaneamente para evitar
	flood. Se houver mais que trs mensagens novas, apenas
	as trs mais novas sero mostradas).
	
	OPERNEWS LIST pode ser usado por qualquer Operador
	para listar as oper news. ADD e DEL s podem ser usados
	pelos Administradores dos Services.

NEWS_HELP_RANDOM
	Sintaxe: RANDOMNEWS ADD texto
	         RANDOMNEWS DEL {nm | ALL}
	         RANDOMNEWS LIST
	
	Edita ou mostra a lista de random news. Quando um usurio
	se conecta  rede, uma (apenas uma) das random news ser
	aleatriamente escolhida e enviada a ele.
	
	RANDOMNEWS LIST pode ser usado por qualquer Operador
	para listar as random news. ADD e DEL s podem ser usados
	pelos Administradores dos Services.

###########################################################################
#
# HelpServ help message
#
###########################################################################

HELP_HELP
	%S  um services criado para dar informaes sobre
	os Services. Os tpicos de ajuda so enviados pelo 
	comando HELP dos outros clientes dos Services:

	%R%s HELP
	     para informaes sobre como registrar nicks

	%R%s HELP
	     para informaes sobre como registrar e controlar canais

	%R%s HELP
	     para informaes sobre como enviar mensagens para
	     usurios que no estejam conectados no momento

HELP_HELP_BOT

	%R%s HELP
	     para informaes sobre como colocar um bot em seu canal

HELP_HELP_HOST

	%R%s HELP
	     para informao sobre como ajustar vHosts em nicks

###########################################################################
#
# NickServ help messages
#
###########################################################################
NICK_HELP_CMD_CONFIRM
	    CONFIRM    Confirma um cdigo de autorizao do NickServ
NICK_HELP_CMD_RESEND
	    RESEND     Reenvia um cdigo de autorizao do NickServ
NICK_HELP_CMD_REGISTER
	    REGISTER   Registra um nick
NICK_HELP_CMD_GROUP
	    GROUP      Se junta a um grupo
NICK_HELP_CMD_IDENTIFY
	    IDENTIFY   Identifica seu nick com sua senha
NICK_HELP_CMD_ACCESS
	    ACCESS     Modifica a lista de endereos autorizados
NICK_HELP_CMD_SET
	    SET        Ajusta opes, incluindo proteo de kill
NICK_HELP_CMD_SASET
	    SASET      Set SET-options on another nickname
NICK_HELP_CMD_DROP
	    DROP       Cancela o registro de um nick
NICK_HELP_CMD_RECOVER
	    RECOVER    Derruba usurio que esteja usando seu nick
NICK_HELP_CMD_RELEASE
	    RELEASE    Retoma a custdia do seu nick aps um RECOVER
NICK_HELP_CMD_SENDPASS
	    SENDPASS   Esqueceu sua senha? Tente isto
NICK_HELP_CMD_GHOST
	    GHOST      Termina uma sesso "fantasma" de IRC que esteja usando seu nick
NICK_HELP_CMD_ALIST
	    ALIST      Lista todos os canais nos quais voc tem acesso
NICK_HELP_CMD_GLIST
	    GLIST      Lista todos os nicks do seu grupo
NICK_HELP_CMD_INFO
	    INFO       Mostra informaes sobre algum nick registrado
NICK_HELP_CMD_LIST
	    LIST       Lista todos os nicks registrados que combinam com o padro fornecido
NICK_HELP_CMD_LOGOUT
	    LOGOUT     Reverte o efeito do comando IDENTIFY
NICK_HELP_CMD_STATUS
	    STATUS     Retorna o status do owner de um determinado nick
NICK_HELP_CMD_UPDATE
	    UPDATE     Atualiza seu status atual, ou seja, verifica novos memos
NICK_HELP_CMD_GETPASS
	    GETPASS    Recupera a senha de um determinado nick
NICK_HELP_CMD_GETEMAIL
	    GETEMAIL   Encontra e retorna todos os usurios que se
	                   registraram usando o email fornecido
NICK_HELP_CMD_FORBID
	    FORBID     Previne um nick de ser usado ou registrado
NICK_HELP_CMD_SUSPEND
	    SUSPEND    Suspende o nick fornecido
NICK_HELP_CMD_UNSUSPEND
	    UNSUSPEND  Libera o nick fornecido

NICK_HELP
	%S permite que voc "registre" um nick e evita que outras
	pessoas o utilizem. Os seguintes comandos permitem o
	registro e a manuteno dos nicks; para utiliz-los, digite
	%R%S comando. Para mais informaes sobre um
	comando especfico, digite %R%S HELP comando.
	
NICK_HELP_FOOTER
	NOTA: Este servio tem a inteno de prover um modo para
	que usurios do IRC no tenham sua identidade comprometida.
	Isto NO  voltado para facilitar "roubo" dos nicks ou
	outras atitudes mau intencionadas. O abuso do %S
	resultar em, no mnimo, perda do(s) nick(s) abusivo(s). 
	
NICK_HELP_EXPIRES
	
	Nicks que no estejam mais sendo usados esto sujeitos 
	a expirarem automaticamente, ou seja, eles sero apagados
	aps %d dias sem serem usados.

NICK_HELP_REGISTER
	Sintaxe: REGISTER senha [email]
	
	Registra seu nick no banco de dados do %S. Uma vez
	que seu nick est registrado, voc pode usar os comandos
	SET e ACCESS para configurar as opes do seu nick como
	voc preferir depois. Certifique-se de lembrar sua senha
	durante o registro, voc precisar dela para fazer alteraes
	no seu nick futuramente.
	(Lembre-se que maisculas diferem, como:  ANOPE, Anope e 
	anope so senhas diferentes!)
	
	Sugestes ao escolher sua senha:
	
	As senhas no devem ser de fcil adivinhao. Por exemplo,
	usar seu nome como senha  uma pssima idia. Utilizar seu
	nick como senha  uma idia muito pior e, de fato, o %S
	no permitir isso. Da mesma maneira, senhas curtas so
	vulnerveis a testes de erro-e-acerto, ento voc deve
	escolher uma senha com pelo menos 5 caracteres. Finalmente,
	o caractere "ESPAO" no pode ser usado em senhas.
	
	O parmetro email  opcional e servir para setar um
	email para seu nick. Entretanto, o email pode ser obrigatrio
	em algumas Redes de IRC.
	Sua privacidade  respeitada; este e-mail nunca ser dado
	para terceiros.
	
	Este comando servir tambm para criar um GRUPO para o seu
	nick, e ir permitir que voc registre outros nicks e divida
	as mesmas configuraes, os mesmos memos e os mesmos 
	privilgios em canais. Para maiores informaes neste recurso,
	digite %R%S HELP GROUP.
	
NICK_HELP_GROUP
	Sintaxe: GROUP alvo senha
	
	Este comando faz seu nick entrar no grupo de um nick alvo.
	A senha  a senha do nick alvo.
	
	Entrando em um grupo permitir a voc compartilhar suas
	configuraes, memos e privilgios em canais com todos os
	nicks do grupo.
	
	Um grupo existe por quanto tempo for necessrio. Isso
	significa que mesmo se um nick do grupo for desregistrado,
	voc no perder os recursos compartilhados citados acima,
	durante o tempo em que houver pelo menos um nick restando
	no grupo.
	
	Voc pode usar este comando mesmo se no ainda no tiver
	registrado seu nick. Se seu nick j estiver registrado,
	voc precisar identific-lo antes de usar este comando.
	Digite %R%S HELP IDENTIFY para mais informao; talvez
	isso no seja possvel em algumas redes.
	
	 recomendvel usar este comando com nicks no-registrados,
	pois eles sero automaticamente registrados ao usar o comando.
	Voc pode usar isto com um nick registrado (para alterar seu
	grupo) apenas se for permitido na rede.
	
	Voc s pode estar em um grupo por vez. Mesclar grupos no 
	possvel.
	
	Ateno: todos os nicks do grupo tero a mesma senha.

NICK_HELP_IDENTIFY
	Sintaxe: IDENTIFY senha
	
	Identifica voc ao %S como sendo dono do nick.
	Muitos comandos exigem que voc se identifique com este
	comando antes de voc us-los. A senha deve ser a mesma que
	voc enviou com o comando REGISTER.
	
NICK_HELP_UPDATE
	Sintaxe: UPDATE

	Atualiza seu status atual, ou seja, checa por novos memos,
	seta modos de canal necessrios (ModeonID) e atualiza seu
	vHost e suas flags de usurio (ltimo horrio visto etc).
	
NICK_HELP_LOGOUT
	Sintaxe: LOGOUT
	
	Este comando reverte o efeito do comando IDENTIFY, ou seja,
	faz com que voc no seja mais reconhecido como o verdadeiro
	dono do nick. Note, entretanto, que ele no pedir que voc se
	identifique novamente.

NICK_HELP_DROP
	Sintaxe: DROP [nick]
	
	Sem parmetros, cancela o registro de seu nick no banco
	de dados do %S. Um nick que foi desregistrado  livre para
	qualquer um que queira registr-lo.

	Voc pode tambm desregistrar um nick de seu grupo
	especificando-o com o parmetro nick.
	
	Para voc usar este comando, ser necessrio que primeiro
	voc se identifique usando sua senha (%R%S HELP IDENTIFY 
	para maiores informaes).

NICK_HELP_ACCESS
	Sintaxe: ACCESS ADD mscara
	         ACCESS DEL mscara
	         ACCESS LIST
	
	Modifica ou mostra a lista de acesso do seu nick. Esta 
	a lista de endereos a qual ser automaticamente reconhecida
	pelo %S como as permitidas a usarem seu nick. Se voc
	quer usar um nick de um endereo diferente, voc deve usar o
	comando IDENTIFY para identificar-se ao %S
	
	Exemplos:
	
	    ACCESS ADD nick@*.provedor.com.br
	        Permite o acesso do usurio nick de qualquer
	        mquina com o domnio provedor.com.br.
	
	    ACCESS DEL nick@*.provedor.com.br
	        Reverte o comando anterior
	
	    ACCESS LIST
	        Mostra a lista de acesso atual.

NICK_HELP_SET
	Sintaxe: SET opo parmetros
	
	Ajusta vrias opes de nick. A opo pode ser:
	
	    DISPLAY    Mostra o seu grupo nos Services
	    PASSWORD   Ajusta a senha do seu nick
	    LANGUAGE   Ajusta a linguagem dos Services quando
	                   mensagens so enviadas  voc
	    URL        Associa um endereo URL com seu nick
	    EMAIL      Associa um endereo de e-mail ao seu nick
	    ICQ        Associa um nmero de ICQ ao seu nick
	    GREET      Associa uma mensgem de entrada ao seu nick
	    KILL       Ativa/Desativa a proteo de kill para o seu nick
	    SECURE     Ativa/Desativa os recursos de segurana para o seu nick
	    PRIVATE    Previne seu nick de aparecer em um %R%S LIST
	    HIDE       Esconde certas informaes sobre seu nick
	    MSG        Altera o mtodo de comunicao dos Services
	    AUTOOP     Should services op you automatically.    
	
	Para usar este comando, voc deve primeiro se identificar
	com sua senha (%R%S HELP IDENTIFY para maiores
	informaes).
	
	Digite %R%S HELP SET opo para maiores informaes
	sobre um comando especfico.

NICK_HELP_SET_DISPLAY
	Sintaxe: SET DISPLAY novo-display
	
	Altera o display usado como referncia ao nome do seu grupo 
	nos Services. O novo display DEVE ser um nick do seu grupo.

NICK_HELP_SET_PASSWORD
	Sintaxe: SET PASSWORD nova-senha
	
	Muda a senha de seu nick.

NICK_HELP_SET_LANGUAGE
	Sintaxe: SET LANGUAGE nmero
	
	Muda a linguagem que os Services usam ao enviar mensagens
	para voc (por exemplo, quando responde um comando que voc
	emite). A linguagem Portugus, assim como outras, pode
	apresentar algumas diferenas da linguagem Ingls (English),
	j que Ingls  a linguagem oficial destes Services.
	O nmero deve ser escolhido da seguinte lista de lnguas:
	

NICK_HELP_SET_URL
	Sintaxe: SET URL url
	
	Associa uma dada URL ao seu nick. Esta URL ser mostrada
	sempre que alguem solicitar informao sobre seu nick
	atravs do comando INFO.

NICK_HELP_SET_EMAIL
	Sintaxe: SET EMAIL endereo
	
	Associa um endereo de email designado ao seu nick. Este
	endereo ser sempre mostrado quando algum solicitar
	informao sobre seu nick atraves do comando INFO.
	O email especificado tambm  usado para enviar sua senha
	caso seja perdida. Caso no tenha nenhum endereo para seu
	nick ou o mesmo seje invlido, no ser possvel recuperar
	a senha perdida.
	
NICK_HELP_SET_ICQ
	Sintaxe: SET ICQ nmero
	
	Associa um nmero de ICQ ao seu nick. Este nmero
	ser sempre mostrado quando algum solicitar 
	informao sobre seu nick atravs do comando INFO.
	
NICK_HELP_SET_GREET
	Sintaxe: SET GREET mensagem
	
	Faz com que a mensagen escolhida se torne a sua mensagem
	de entrada que aparecer sempre quando voc entrar em um canal
	que tenha a opo GREET habilitada, e tambm tenha acesso a isto.

NICK_HELP_SET_KILL
	Sintaxe: SET KILL {ON | QUICK | IMMED | OFF}
	
	Possibilita a proteo de KILL do seu nick. Com a proteo
	de KILL acionada, se outro usurio tentar tomar seu nick,
	ser dado 1 minuto para este mudar de nick; aps isso, ser
	forado pelo %S a trocar de nick, ou ser desconectado da
	rede (esse ltimo no acontece em todas elas).
	
	Se voc selecionar QUICK, ser dado ao usurio somente 20
	segundos para mudar de nick ao invs do usual (60 segundos).
	Se voc selecionar a opo IMMED, o nick ser mudado
	imediatamente sem mesmo ser avisado antes;  recomendado
	no usar essa opo, a no ser que seja necessrio. Pode
	acontecer do Administrador da Rede desabilitar essa opo.

NICK_HELP_SET_SECURE
	Sintaxe: SET SECURE {ON | OFF}
	
	Torna os recursos de segurana do %S ativados (ON) ou
	desativados (OFF) sobre o seu nick. Com o SECURE acionado
	voc deve entrar com sua senha antes de ser reconhecido como
	usurio do nick, independentemente do fato do seu endereo
	constar na lista de acesso. Entretanto, se voc est na
	lista de acesso, o %S no ir dar auto-kill em voc de
	acordo com os ajustes da opo KILL.

NICK_HELP_SET_PRIVATE
	Sintaxe: SET PRIVATE {ON | OFF}
	
	Torna a opo de privacidade do %S sobre o seu nick
	em ativada (ON) ou desativada (OFF). Com o PRIVATE ativado,
	seu nick no aparecer nas listagens de nicks geradas com
	o comando %S's LIST. (Entretando, algum que sabe do seu
	nick ainda pode obter informaes usando o comando INFO).

NICK_HELP_SET_HIDE
	Sintaxe: SET HIDE {EMAIL | STATUS | USERMASK | QUIT} {ON | OFF}
	
	Permite que voc previna que certas informaes sejam
	mostradas quando algum usa %S INFO no seu nick. Voc pode
	esconder seu endereo de e-mail (EMAIL), ltima mscara vista
	user@host (USERMASK), seu status de acesso aos Services
	(STATUS) e sua ltima mensagem de sada (QUIT).
	O segundo parmetro especifica quando a informao deve ser
	mostrada (OFF) ou escondida (ON).
	
NICK_HELP_SET_MSG
	Sintaxe: SET MSG {ON | OFF}
	
	Permite que voc escolha a forma que os Services devem se 
	comunicar com voc. Com MSG acionado, os Services iro usar
	mensagems, caso contrrio, usaro notices. 

NICK_HELP_SET_AUTOOP
	Syntax: SET AUTOOP {ON | OFF}
	
	Sets whether you will be opped automatically. Set to ON to 
	allow ChanServ to op you automatically when entering channels.

NICK_HELP_SASET
	Syntax: SASET nickname option parameters.
	
	Sets various nickname options.  option can be one of:
	
	    DISPLAY    Set the display of the group in Services
	    PASSWORD   Set the nickname password
	    URL        Associate a URL with the nickname
	    EMAIL      Associate an E-mail address with the nickname
	    ICQ        Associate an ICQ number with the nickname
	    GREET      Associate a greet message with the nickname
	    KILL       Turn protection on or off
	    SECURE     Turn nickname security on or off
	    PRIVATE    Prevent the nickname from appearing in a
	                   %R%S LIST
	    HIDE       Hide certain pieces of nickname information
	    MSG        Change the communication method of Services
	    NOEXPIRE   Prevent the nickname from expiring
	
	Type %R%S HELP SASET option for more information
	on a specific option. The options will be set on the given
	nickname. 
	
	Limited to Services admins.

NICK_HELP_SASET_DISPLAY
	Syntax: SASET nickname DISPLAY new-display
	
	Changes the display used to refer to the nickname group in 
	Services. The new display MUST be a nick of the group.
	
	Limited to Services admins.

NICK_HELP_SASET_PASSWORD
	Syntax: SET nickname PASSWORD new-password
	
	Changes the password used to identify as the nick's	owner.
	
	Limited to Services admins.

NICK_HELP_SASET_URL
	Syntax: SASET nickname URL url
	
	Associates the given URL with the nickname.  This URL
	will be displayed whenever someone requests information
	on the nick with the INFO command.
	
	Limited to Services admins.

NICK_HELP_SASET_EMAIL
	Syntax: SASET nickname EMAIL address
	
	Associates the given E-mail address with the nickname.
	
	Limited to Services admins.
	
NICK_HELP_SASET_ICQ
	Syntax: SASET nickname ICQ number
	
	Associates the given ICQ number with the nickname.  This 
	number will be displayed whenever someone requests 
	information on the nick with the INFO command.
	
	Limited to Services admins.
	
NICK_HELP_SASET_GREET
	Syntax: SASET nickname GREET message
	
	Makes the given message the greet of the nickname, that
	will be displayed when joining a channel that has GREET
	option enabled, provided that the user has the necessary 
	access on it.
	
	Limited to Services admins.

NICK_HELP_SASET_KILL
	Syntax: SASET nickname KILL {ON | QUICK | IMMED | OFF}
	
	Turns the automatic protection option for the nick
	on or off.  With protection on, if another user
	tries to take the nick, they will be given one minute to
	change to another nick, after which %S will forcibly change
	their nick.
	
	If you select QUICK, the user will be given only 20 seconds
	to change nicks instead of the usual 60.  If you select
	IMMED, user's nick will be changed immediately without being
	warned first or given a chance to change their nick; please
	do not use this option unless necessary.  Also, your
	network's administrators may have disabled this option.
	
	Limited to Services admins.

NICK_HELP_SASET_SECURE
	Syntax: SASET nickname SECURE {ON | OFF}
	
	Turns %S's security features on or off for your
	nick.  With SECURE set, you must enter your password
	before you will be recognized as the owner of the nick,
	regardless of whether your address is on the access
	list.  However, if you are on the access list, %S
	will not auto-kill you regardless of the setting of the
	KILL option.
	
	Limited to Services admins.

NICK_HELP_SASET_PRIVATE
	Syntax: SASET nickname PRIVATE {ON | OFF}
	
	Turns %S's privacy option on or off for the nick.
	With PRIVATE set, the nickname will not appear in
	nickname lists generated with %S's LIST command.
	(However, anyone who knows the nickname can still get
	information on it using the INFO command.)
	
	Limited to Services admins.

NICK_HELP_SASET_HIDE
	Syntax: SASET nickname HIDE {EMAIL | STATUS | USERMASK | QUIT} {ON | OFF}
	
	Allows you to prevent certain pieces of information from
	being displayed when someone does a %S INFO on the
	nick.  You can hide the E-mail address (EMAIL), last seen
	user@host mask (USERMASK), the services access status
	(STATUS) and  last quit message (QUIT).
	The second parameter specifies whether the information should
	be displayed (OFF) or hidden (ON).
	
	Limited to Services admins.
	
NICK_HELP_SASET_MSG
	Syntax: SASET nickname MSG {ON | OFF}
	
	Allows you to choose the way Services are communicating with 
	the given user. With MSG set, Services will use messages,
	else they'll use notices.
	
	Limited to Services admins.

NICK_HELP_SASET_NOEXPIRE
	Syntax: SASET nickname NOEXPIRE {ON | OFF}
	
	Sets whether the given nickname will expire.  Setting this
	to ON prevents the nickname from expiring.
	
	Limited to Services admins.

NICK_HELP_SASET_AUTOOP
	Syntax: SASET nickname AUTOOP {ON | OFF}
	
	Sets whether the given nickname will be opped automatically.
	Set to ON to allow ChanServ to op you automatically when joining
	channels.
	
	Limited to Services admins.

NICK_HELP_RECOVER
	Sintaxe: RECOVER nick [senha]
	
	Permite que voc recupere seu nick se algum o tiver
	tomado; isso faz o mesmo que o %S faz automaticamente
	se algum "rouba" um nick protegido com kill.
	
	Quando voc usa este comando, o %S trar um falso
	usurio online com o mesmo nick de quem o est usando.
	Isto causar uma desconexo pelo servidor de IRC do outro
	usurio. O falso usurio ficar online por 1 minuto para
	assegurar que o outro usurio no reconecte imediatamente;
	Durante este minuto, voc pode reivindicar seu nick.
	Alternativamente, use o comando RELEASE
	(%R%S HELP RELEASE) para retomar seu nick mais 
	rapidamente.
	
	Para usar o comando RECOVER em um nick, seu endereo
	atual como mostrado no /WHOIS deve estar na lista de acesso
	do nick, voc deve estar identificado e estar no grupo daquele
	nick, ou voc deve fornecer a senha correta para o nick.

NICK_HELP_RELEASE
	Sintaxe: RELEASE nick [senha]
	
	Instrui o %S a remover qualquer espera no seu nick
	causada pelo kill automtico de proteo ou pelo uso do
	comando RECOVER. Por padro, essa espera dura 1 minuto;
	este comando libera o seu nick mais cedo.
	
	Para usar o comando RELEASE em um nick, seu endereo
	atual como mostrado no /WHOIS deve estar na lista de acesso 
	do nick, voc deve estar identificado e estar no grupo daquele
	nick, ou voc deve fornecer a senha correta para o nick.

NICK_HELP_GHOST
	Sintaxe: GHOST nick [senha]
	 
	Termina uma sesso "fantasma" de IRC que esteja usando seu
	nick. A sesso "fantasma"  aquela que no est realmente
	conectada, mas que o servidor de IRC acredita estar ainda
	ativa por qualquer razo. Isso acontece normalmente se seu
	computador travar ou se sua conexo com a internet ou modem
	cair por um perodo curto de tempo enquanto voc est no IRC.
	
	Para usar o comando GHOST em um nick, seu endereo
	atual como mostrado no /WHOIS deve estar na lista de acesso 
	do nick, voc deve estar identificado e estar no grupo daquele
	nick, ou voc deve fornecer a senha correta para o nick.

NICK_HELP_INFO
	Sintaxe: INFO nick [ALL]
	
	Mostra a informao sobre o nick dado, como o dono do nick,
	ltimo endereo utilizado e horrio, e opes. Se voc est
	identificado para o nick que voc est obtendo informaes
	e a opo ALL  especificada, ser mostrado a voc toda
	informao possvel; independente de haver opes para esconder.

NICK_HELP_LIST
	Sintaxe: LIST padro
	
	Lista todos os nicks registrados que combinam com o padro
	fornecido no formato nick!ident@host. Nicks com a opo
	PRIVATE ligada no sero mostrados.
	
	Exemplos:
	
	    LIST *!ident@servidor.com.br
	        Lista todos os nicks de *!ident@servidor.com.br.
	
	    LIST *Bot*!*@*
	        Lista todos os nicks registrados com Bot em seus
	        idents (insensvel a maisculas).
	
	    LIST *!*@*.bar.org
	        Lista todos os nicks possudos por usurios do domnio
	        bar.org

NICK_HELP_ALIST
	Sintaxe: ALIST [nvel]
	
	Lista todos os canais nos quais voc tem acesso. Opcionalmente,
	voc pode especificar um nvel no formato XOP ou ACCESS. A lista
	de resultado inclui apenas os canais nos quais voc tem o nvel
	de acesso fornecido.
	
	Exemplos:
	ALIST Founder
	     Lista todos os canais nos quais voc tem acesso de Founder.
	
	ALIST AOP
	     Lista todos os canais nos quais voc tem acesso AOP ou maior.
	
	ALIST 10
	    Lista todos os canais nos quais voc tem nvel 10 de acesso ou maior.
	
	Canais com a opo NOEXPIRE sero prefixados por uma exclamao.
	
NICK_HELP_GLIST
	Sintaxe: GLIST
	
	Lista todos os nicks do grupo.

NICK_HELP_STATUS
	Sintaxe: STATUS nick...
	
	Retorna se o usurio que est usando um determinado nick
	 reconhecio como dono do nick. 
	A resposta tem este formato:
	
	    nick cdigo-de-status
	
	onde nick  o nick enviado com o comando, e
	cdigo-de-status  um dos seguintes:
	
	    0 - usurio no est conectado ou o nick no est registrado
	    1 - usurio no reconhecido como dono do nick
	    2 - usurio reconhecido como dono s pela lista de acesso
	    3 - usurio reconhecido como dono via identificao por senha
	
	At 16 nicks podem ser enviados com cada comando; o resto ser
	ignorado. Se nenhum nick for fornecido, seu status ser exibido.
	
NICK_HELP_SENDPASS
	Sintaxe: SENDPASS nick
	
	Envia a senha do nick em questo para o endereo de email
	ajustado no nick. Esse comando  bem til em se falando
	de senhas perdidas.
	
	Poder ser limitado a Operadores de IRC em algumas redes.
	
	Este comando no est disponvel quando estiver usando encriptao.

NICK_HELP_CONFIRM
	Syntax: CONFIRM passcode
	
	This is the second step of nickname registration process.
	You must perform this command in order to get your nickname
	registered with %S. The passcode (or called auth code also)
	is sent to your e-mail address in the first step of the
	registration process. For more information about the first
	stage of the registration process, type: %R%S HELP REGISTER

NICK_SERVADMIN_HELP
	Os Administradores dos Services podem ainda usar o DROP em qualquer nick
	sem ser necessrio se identificar como dono dele, e podem ver a lista de
	acesso de qualquer nick (%R%S ACCESS LIST nick).

NICK_SERVADMIN_HELP_LOGOUT
	Sintaxe: LOGOUT [nick [REVALIDATE]]
	
	Sem nenhum parmetro, reverte o efeito do comando IDENTIFY,
	ou seja, faz com que voc no seja mais reconhecido como o
	verdadeiro dono do nick. Note, entretanto, que ele no pedir
	que voc se identifique novamente.
	
	Com um parmetro, far o mesmo para o nick determinado. Se voc
	especificar REVALIDATE tambm, os Services iro pedir que o nick
	em questo se identifique novamente. 
	
	Comando limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_DROP
	Sintaxe: DROP [nick]
	
	Sem parmetros, cancela o registro de seu nick no banco de
	dados do %S.
	
	Com parmetros, cancela o registro do nick especificado
	do banco de dados. Voc pode desregistrar qualquer nick DE
	SEU GRUPO sem nenhum privilgio especial, mas desregistrar
	QUALQUER nick  restrito aos Administradores dos Services.

NICK_SERVADMIN_HELP_INFO
	
	Administradores de Services podem usar o parmetro ALL com qualquer nick.

NICK_SERVADMIN_HELP_LIST
	Sintaxe: LIST padro [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
	
	Lista todos os nicks registrados que combinem com o padro
	fornecido (formato nick!ident@host). Nicks com opo PRIVATE
	sero somente exibidos para os Administradores dos Services.
	Nicks com opo NOEXPIRE ajustada tero um ! preposto ao nick
	na lista quando for a pedido de Administrador dos Services.
	
	Se as opes FORBIDDEN, NOEXPIRE ou UNCONFIRMED so fornecidas, apenas
	nicks que so, respectivamente, FORBIDados, UNCONFIRMED ou tm a opo
	NOEXPIRE ativa, sero exibidos. Se todas as trs opes forem fornecidas,
	todos os trs tipos de nicks sero exibidos. Estas opes so limitas aos
	Administradores dos Services.
	
	Exemplos:
	
	     LIST *!ident@servidor.com.br
	        Lista todos os nicks de *!ident@servidor.com.br.
	
	     LIST *Bot*!*@*
	        Lista todos os nicks registrados com Bot em seus nomes.
	
	     LIST * NOEXPIRE
	        Lista todos os nicks registrados cujos registros foram
	        ajustados para no expirar.

NICK_SERVADMIN_HELP_ALIST
	Sintaxe: ALIST [nick] [nvel]
	
	Sem parmetros, lista os canais nos quais voc tem acesso. Com
	um parmetro, lista os canais nos quais nick tem acesso.
	Com dois parmetros lista os canais nos quais nick tem
	no mnimo o nvel de acesso especificado.
	
	Este uso  limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_GLIST
	Sintaxe: GLIST [nick]
	
	Sem nenhum parmetro, lista todos os nicks no seu grupo.
	Com um parmetro, lista todos os nicks no grupo determinado.
	
	Este comando  limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_GETPASS
	Sintaxe: GETPASS nick
	
	Mostra a senha de um nick especificado.
	Note que sempre que este comando for usado, uma mensagem
	incluindo o nick da pessoa que emitiu o comando e o nick
	no qual foi usado sero gravados e enviados para WALLOPS/GLOBOPS.
	
	Este comando no fica disponvel quando a encriptao est habilitada.
	
	Limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_GETEMAIL
	Sintaxe: GETEMAIL usurio@emailhost
	
	Retorna os nicks que utilizam o email dado. Observe que
	voc no pode usar coringas para usurio nem para emailhost.
	Sempre que este comando for usado, uma mensagem incluindo a pessoa
	que emitiu o comando e o email no qual foi usado sero gravados.
	
	Limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_FORBID
	Sintaxe: FORBID nick [motivo]
	
	No permite que um nick seja registrado ou usado por
	ningum. Pode ser cancelado desregistrando o nick.
	
	Em algumas redes, um motivo  necessrio.
	
	Limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_SUSPEND
	Sintaxe: SUSPEND nick motivo

	SUSPENDE um nick, impedindo-o de ser usado.

	Limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_UNSUSPEND
	Sintaxe: UNSUSPEND nick

	LIBERA um nick suspendido, permitindo que seja usado.

	Limitado aos Administradores dos Services.

###########################################################################
#
# ChanServ help messages
#
###########################################################################
CHAN_HELP_CMD_GETPASS
	    GETPASS    Recupera a senha de um canal
CHAN_HELP_CMD_FORBID
	    FORBID     Previne um canal de ser registrado/usado
CHAN_HELP_CMD_SUSPEND
	    SUSPEND    Previne um canal de ser registrado/usado,
	               preservando os dados do canal e suas configuraes
CHAN_HELP_CMD_UNSUSPEND
	    UNSUSPEND  Libera um canal suspenso
CHAN_HELP_CMD_STATUS
	    STATUS     Fornece o atual nvel de acesso de um usurio em um canal
CHAN_HELP_CMD_REGISTER
	    REGISTER   Registra um canal
CHAN_HELP_CMD_IDENTIFY
	    IDENTIFY   Identifica seu nick
CHAN_HELP_CMD_SET
	    SET        Ajusta as opes e informaes do canal
CHAN_HELP_CMD_AOP
	    AOP        Modifica a lista de AOP (AutoOP) de um canal
CHAN_HELP_CMD_SOP
	    SOP        Modifica a lista de SOP (SuperOP) de um canal
CHAN_HELP_CMD_ACCESS
	    ACCESS     Modifica a lista de usurios privilegiados
CHAN_HELP_CMD_LEVELS
	    LEVELS     Redefine os nveis de acesso
CHAN_HELP_CMD_AKICK
	    AKICK      Faz a manuteno da Lista de Autokick
CHAN_HELP_CMD_DROP
	    DROP       Cancela o registro de um canal
CHAN_HELP_CMD_SENDPASS
	    SENDPASS   Ajuda para recuperar senhas
CHAN_HELP_CMD_BAN
	    BAN        Bane o nick selecionado em um canal
CHAN_HELP_CMD_CLEAR
	    CLEAR      Diz ao ChanServ para remover certos ajustes de um canal
CHAN_HELP_CMD_DEVOICE
	    DEVOICE    Retira o status de Voice de um nick no canal
CHAN_HELP_CMD_GETKEY
	    GETKEY     Retorna a key (do modo +k) do canal fornecido
CHAN_HELP_CMD_INFO
	    INFO       Mostra informaes sobre algum canal registrado
CHAN_HELP_CMD_INVITE
	    INVITE     Pede ao ChanServ para convidar voc ou um nick fornecido para um canal
CHAN_HELP_CMD_KICK
	    KICK       Kicka (expulsa) um nick de um canal
CHAN_HELP_CMD_LIST
	    LIST       Lista todos os canais registrados que combinam com o padro fornecido
CHAN_HELP_CMD_LOGOUT
	    LOGOUT     Desconecta um determinado nick
CHAN_HELP_CMD_OP
	    OP         Atribui status de OP a um nick no canal
CHAN_HELP_CMD_TOPIC
	    TOPIC      Modifica o tpico de um canal
CHAN_HELP_CMD_UNBAN
	    UNBAN      Remove todos os bans permitindo que voc entre em um canal
CHAN_HELP_CMD_VOICE
	    VOICE      Atribui status de Voice a um nick no canal
CHAN_HELP_CMD_VOP
	    VOP        Modifica a lista de VOP (VOicePeople) de um canal
CHAN_HELP_CMD_DEHALFOP
	    DEHALFOP   Retira o status de HalfOP de um nick no canal
CHAN_HELP_CMD_DEOWNER
	    DEOWNER    Retira seu status de Owner no canal
CHAN_HELP_CMD_DEPROTECT
	    DEPROTECT  Desprotege um determinado nick no canal
CHAN_HELP_CMD_HALFOP
	    HALFOP     Atribui status de HalfOP a um nick no canal
CHAN_HELP_CMD_HOP
	    HOP        Modifica a lista de HOP (HalfOP) de um canal
CHAN_HELP_CMD_OWNER
	    OWNER      Concede-lhe status de Owner no canal
CHAN_HELP_CMD_PROTECT
	    PROTECT    Protege um determinado nick no canal
CHAN_HELP_CMD_ADMIN
	    ADMIN      Protege um determinado nick no canal
CHAN_HELP_CMD_DEADMIN
	    DEADMIN    Desprotege um determinado nick no canal
CHAN_HELP_CMD_DEOP
	    DEOP       Retira o status de OP de um nick no canal

CHAN_HELP
	%S permite que voc registre e controle vrios
	aspectos do canal. %S pode prevenir o "take over"
	do canal por usurios maliciosos, limitando quem possui
	o privilgio de OP do canal. Os comandos disponveis
	esto listados abaixo; para us-los, digite
	%R%S comando. Para mais informaes sobre
	um comando especfico, digite %R%S HELP comando.
	
	
CHAN_HELP_EXPIRES
	
	Note que qualquer canal no utilizado por %d dias
	(entenda como se nenhum usurio da lista de acesso
	desse canal entrar neste perodo de tempo) ter
	automaticamente cancelado o seu registro.

CHAN_HELP_REGISTER
	Sintaxe: REGISTER canal senha descrio
	
	Registra um canal no banco de dados do %S sob seu nick. 
	Para utilizar este comando, voc deve primeiro ser OP
	do canal que est tentando registrar.
	
	A senha  usada com o comando IDENTIFY para permitir
	que outras pessoas faam alteraes nas configuraes do
	canal. O ltimo parmetro, que deve ser includo,  uma
	descrio geral da finalidade do canal.
	
	Quando voc registra um canal, voc  gravado como "fundador"
	do mesmo. Ao fundador do canal  permitido alterar todas as
	configuraes do mesmo; %S ir dar automaticamente ao fundador
	privilgios de Operador de Canal quando ele entrar no canal.
	Veja o comando ACCESS (%R%S HELP ACCESS) para
	informao sobre como liberar uma parte dos seus privilgios
	a outros usurios do canal.
	
	IMPORTANTE: Para registrar um canal, voc deve antes ter
	registrado seu nick. Se ainda no tiver seu nick registrado,
	digite %R%s HELP para mais informaes de como faz-lo.

CHAN_HELP_IDENTIFY
	Sintaxe: IDENTIFY canal senha
	
	Identifica voc no %S como fundador do canal fornecido.
	Muitos comandos exigem que voc use este comando antes
	de us-los. A senha dever ser a mesma usada por voc
	no comando REGISTER.
	
CHAN_HELP_LOGOUT
	Sintaxe: LOGOUT canal nick
	
	Este comando faz com que um determinado nick seja des-identificado
	do canal, fazendo com que seja necessrio ele se identificar
	novamente para recuperar seu acesso.
	
	Se voc for o Founder do canal, pode usar este comando em
	qualquer usurio e em si mesmo.

CHAN_HELP_DROP
	Sintaxe: DROP canal
	
	Cancela o registro do canal. So poder ser usado pelo
	fundador do canal, que primeiramente dever estar
	identificado com o NickServ.

CHAN_HELP_SET
	Sintaxe: SET canal opo parmetros
	
	Permite ao fundador do canal ajustar as vrias opes do
	canal e outras informaes.
	
	Opes disponveis:
	
	    FOUNDER       Ajusta o fundador do canal
	    SUCCESSOR     Ajusta o sucessor do canal
	    PASSWORD      Ajusta a senha do founder
	    DESC          Ajusta a descrio do canal
	    URL           Associa uma URL a um canal
	    EMAIL         Associa um E-mail a um canal
	    ENTRYMSG      Ajusta a mensagem que deve ser mandada
	                    aos usurios quando eles entram no canal
	    BANTYPE       Ajusta como os Services devem fazer o ban
	    MLOCK         Liga ou desliga a trava dos modos do canal
	    KEEPTOPIC     Mantem o tpico quando o canal no est em uso
	    TOPICLOCK     O tpico pode ser mudado apenas com o comando TOPIC
	    PEACE         Regula o uso de comandos crticos
	    PRIVATE       Esconde o canal do comando LIST
	    RESTRICTED    Acesso restrito ao canal
	    SECURE        Ativa os recursos de segurana do %S
	    SECUREOPS     Controle rigoroso do status de OP
	    SECUREFOUNDER Controle rigoroso do status de Fundador do Canal
	    SIGNKICK      Assinatura dos kicks feitos pelo comando KICK
	    OPNOTICE      Envia uma notice quando os comandos OP/DEOP so usados
	    XOP           Altera o sistema de privilgio de usurio
	
	Digite %R%S HELP SET opo para maiores informaes
	sobre uma opo em particular.

CHAN_HELP_SET_FOUNDER
	Sintaxe: SET canal FOUNDER nick
	
	Muda o fundador do canal. O novo nick deve estar
	registrado.

CHAN_HELP_SET_SUCCESSOR
	Sintaxe: SET canal SUCCESSOR nick
	
	Altera o sucessor de um canal. Se o nick do founder expirar
	ou for dropado enquanto o canal ainda estiver registrado,
	o sucessor se tornar o novo founder do canal.
	No entanto, se o sucessor possuir muitos canais registrados
	(%d), o canal ser dropado, como se nenhum sucessor tivesse
	sido ajustado. O novo nick dever estar registrado.

CHAN_HELP_SET_PASSWORD
	Sintaxe: SET canal PASSWORD senha
	
	Ajusta a senha utilizada para identificao do
	fundador do canal.

CHAN_HELP_SET_DESC
	Sintaxe: SET canal DESC descrio
	
	Ajusta a descrio para o canal, que so mostradas com
	os comandos LIST e INFO.

CHAN_HELP_SET_URL
	Sintaxe: SET canal URL [url]
	
	Associa uma URL ao canal. Esta URL ser mostrada
	sempre que alguem solicitar informao sobre o canal
	com o comando INFO. Se nenhum parmetro for fornecido,
	apaga qualquer URL atualmente designada para o canal.

CHAN_HELP_SET_EMAIL
	Sintaxe: SET canal EMAIL [endereo]
	
	Associa um endereo de e-mail fornecido ao canal.
	Este endereo ser mostrado sempre que alguem solicitar
	informao sobre o canal com o comando INFO. Se nenhum
	parmetro for fornecido, apaga qualquer endereo de e-mail
	do canal.

CHAN_HELP_SET_ENTRYMSG
	Sintaxe: SET canal ENTRYMSG [mensagem]
	
	Ajusta a mensagem na qual ser enviada via /notice para
	os usurios quando eles entrarem no canal. Se nenhum
	parmetro  fornecido, nenhuma mensagem ser enviada
	ao se entrar no canal.
	
CHAN_HELP_SET_BANTYPE
	Sintaxe: SET canal BANTYPE tipo-de-ban
	
	Seleciona o tipo de ban que ser usado sempre que os Services
	precisarem banir algum do seu canal.
	
	O tipo-de-ban  um nmero entre 0 e 3 que significa:
	
	0: ban na forma *!user@host
	1: ban na forma *!*user@host
	2: ban na forma *!*@host
	3: ban na forma *!*user@*.domain

CHAN_HELP_SET_KEEPTOPIC
	Sintaxe: SET canal KEEPTOPIC {ON|OFF}
	
	Ativa ou desativa a opo de reteno de tpico para
	um canal. Quando a reteno de tpico est acionada,
	o tpico para o canal ser lembrado pelo %S
	mesmo depois que os usurios deixarem o canal, e ser
	restaurado na prxima vez que o canal for reutilizado.

CHAN_HELP_SET_TOPICLOCK
	Sintaxe: SET canal TOPICLOCK {ON|OFF}
	
	Ativa ou desativa a opo de trava do tpico de um canal.
	Quando a trava do tpico est ativada, o %S no
	permitir a mudana do tpico do canal exceto pelo comando 
	TOPIC.

CHAN_HELP_SET_MLOCK
	Sintaxe: SET canal MLOCK modos
	
	Ajusta o parmetro da trava do modo para um canal. O
	%S permite que voc defina certos modos no canal
	a serem sempre ativo, desativos ou no travados.
	Os modos podem ser i, k, l, m, n, p, s, S, t
	entre outros.
	
	O parmetro modos  usado exatamente do mesmo modo
	que o comando /MODE, ou seja, modos seguidos de + so
	travados como ativos, e modos seguidos de - so travados
	como desativos. Note, no entanto, que ao contrrio do
	comando /MODE, cada uso do SET MLOCK ir remover
	todos os modos anteriormente travados antes de travar
	os novos.
	
	Cuidado: Se voc trava uma senha, como no segundo exemplo
	abaixo, voc deveria tambm ajustar a opo RESTRICTED para
	o canal (veja HELP SET RESTRICTED), ou qualquer
	usurio que entrar no canal que est vazio ser capaz de ver a senha!
	
	Exemplos:
	
	    SET #canal MLOCK +nt-iklps
	        Trava os modos n e t ativados, e os modos i, k, l, p,
	        e s desligados. Modo m  livremente deixado para ser
	        ativo ou desativo (no travado).
	
	    SET #canal MLOCK +knst-ilmp minha-senha
	        Trava os modos k, n, s, t como ligados e os modos i,
	        l, m, p como desligados. Tambm trava a senha do canal
	        como "minha-senha".
	
	    SET #canal MLOCK +
	        Elimina a trava do modos; todos os modos do canal
	        ficam livres para ser ativos ou desativos.

CHAN_HELP_SET_PEACE
	Sintaxe: SET canal PEACE {ON | OFF}
	
	Ativa ou destiva a opo peace para um canal.
	Quando peace est ativada, um usurio no poder kickar,
	banir ou remover os modos no canal de um usurio que tenha
	nvel superior ou igual ao seu via comandos do %S.

CHAN_HELP_SET_PRIVATE
	Sintaxe: SET canal PRIVATE {ON|OFF}
	
	Ativa ou desativa a opo private para um canal. Quando
	private est ativada, um %R%S LIST no ir incluir
	o canal em qualquer listagem.

CHAN_HELP_SET_RESTRICTED
	Sintaxe: SET canal RESTRICTED {ON|OFF}
	
	Ativa ou desativa a opo de acesso restrito para um canal.
	Quando o acesso restrito estiver ativado, usurios que
	normalmente no possuem privilegios de OP no canal
	(usurios com nvel negativo de acesso e, se secure ops
	estiver ativado, usurios que no pertencem  lista de
	acesso) sero imediatamente kickados e banidos do canal.

CHAN_HELP_SET_SECURE
	Sintaxe: SET canal SECURE {ON|OFF}
	
	Ativa ou desativa os recursos de segurana do %S
	para um canal. Quando o SECURE estiver ativo, somente
	usurios que possuirem seus nicks registrados no %s
	e identificados com sua senha podero entrar no canal
	controlado pela lista de acesso.

CHAN_HELP_SET_SECUREOPS
	Sintaxe: SET canal SECUREOPS {ON|OFF}
	
	Ativa ou desativa a opo de segurana de ops para um canal.
	Quando secure ops estiver ativada, os usurios que no
	estiverem na lista de acesso no podero ter o status de OP.
	
CHAN_HELP_SET_SECUREFOUNDER
	Sintaxe: SET canal SECUREFOUNDER {ON | OFF}
	
	Ativa ou desativa a opo secure founder para um canal.
	Quando o secure founder est ligado, apenas o verdadeiro founder
	poder dar DROP no canal, mudar sua senha, seu founder e seu
	successor, e no aqueles que estiverem identificados no %S.
	
CHAN_HELP_SET_SIGNKICK
	Sintaxe: SET canal SIGNKICK {ON | LEVEL | OFF}
	
	Habilita ou desabilita a assinatura nos kicks para um
	canal. Quando o SIGNKICK est habilitado, kicks atravs
	do comando %S KICK tero o nick de quem usou o comando
	no motivo do kick.
	
	Se voc usar LEVEL, aqueles que tiverem um nvel igual ou 
	superior ao nvel do SIGNKICK no tero o nick aparecendo no 
	motivo. Veja %R%S HELP LEVELS para maiores informaes. 

CHAN_HELP_SET_XOP
	Sintaxe: SET canal XOP {ON | OFF}
	
	Ativa ou desativa o sistema de listas xOP para um canal.
	Quando XOP est ativado, voc deve usar os comandos
	AOP/SOP/VOP para poder dar privilgios aos usurios
	do canal, a no ser que voc deva usar o comando ACCESS.
	
	Nota tcnica: quando voc muda de lista de acesso para
	o sistema de listas xOP, sua definio de nveis e nveis
	de usurio sero alteradas, assim, voc no encontrar os
	mesmos valores se voc voltar ao sistema de acesso!
	
	Voc tambm deve verificar se seus usurios ficaram em uma
	lista xOP correta depois que voc mudou de sistema de acesso
	para listas xOP, porque a converso nem sempre  perfeita...
	de fato, no  recomendvel usar listas xOP caso tenha alterado
	suas definies de nvel com o comando LEVELS.
	
	Entretanto, mudar do sistema de listas xOP para sistema de lista
	de acesso no causa problemas.

CHAN_HELP_SET_OPNOTICE
	Sintaxe: SET canal OPNOTICE {ON | OFF}
	
	Ativa e desativa a opo Op-notice para um canal. Quando
	Op-notice estiver ativado, o %S enviar uma notice para
	o canal sempre que os comandos OP ou DEOP forem usados em um
	usurio no canal.

CHAN_HELP_AOP
	Sintaxe: AOP canal ADD nick
	         AOP canal DEL {nick | entrada | lista-entradas}
	         AOP canal LIST [mscara | lista-entradas]
	         AOP canal CLEAR
	
	Mantm a lista de AOP (AutoOP) para um canal. A lista
	de AOP d a um usurio os direitos de: receber OP
	automaticamente ao entrar no canal, de se desbanir ou convidar
	a si prprio se necessrio, de ter sua mensagem de entrada
	exibida ao entrar no canal, e assim por diante.
	
	O comando AOP ADD adiciona o nick fornecido  lista de AOP.
	
	O comando AOP DEL remove o nick fornecido da lista de AOP.
	Se uma lista de nmeros de entrada  fornecida, essas entradas
	so deletadas. (Veja o exemplo para LIST abaixo.)
	
	O comando AOP LIST exibe a lista de AOP. Se uma mscara
	 fornecida, apenas as entradas que combinarem com ela sero
	mostradas. Se uma lista de nmeros de entrada  fornecida,
	apenas essas entradas so mostradas; por exemplo:
	
	   AOP #canal LIST 2-5,7-9
	      Lista as entradas de AOP numeradas de 2 a 5 e de
	      7 a 9.
	
	O comando AOP CLEAR remove todas as entradas da lista de AOP.
	
	Os comandos AOP ADD e AOP DEL so limitados aos SOPs
	ou acima, enquanto o comando AOP CLEAR pode ser usado apenas
	pelo Fundador do canal. No entanto, qualquer usurio na lista de
	AOP pode usar o comando AOP LIST.
	
	Este comando pode ter sido desabilitado para seu canal
	e, nesse caso, voc precisa usar a lista de acesso. Veja
	%R%S HELP ACCESS para informaes sobre a lista
	de acesso, e %R%S HELP SET XOP para saber como
	escolher entre a lista de acesso e o sistema de listas xOP.

CHAN_HELP_HOP
	Sintaxe: HOP canal ADD nick
	         HOP canal DEL {nick | entrada | lista-entradas}
	         HOP canal LIST [mscara | lista-entradas]
	         HOP canal CLEAR
	
	Mantm a lista de HOP (HalfOP) para um canal. A lista
	de HOP d a um usurio o direito de receber HalfOP
	automaticamente ao entrar no canal.
	
	O comando HOP ADD adiciona o nick fornecido  lista de HOP.
	
	O comando HOP DEL remove o nick fornecido da lista de HOP.
	Se uma lista de nmeros de entrada  fornecida, essas entradas
	so deletadas. (Veja o exemplo para LIST abaixo.)
	
	O comando HOP LIST exibe a lista de HOP. Se uma mscara
	 fornecida, apenas as entradas que combinarem com ela sero
	mostradas. Se uma lista de nmeros de entrada  fornecida,
	apenas essas entradas so mostradas; por exemplo:
	
	   HOP #canal LIST 2-5,7-9
	      Lista as entradas de HOP numeradas de 2 a 5 e de
	      7 a 9.
	
	O comando HOP CLEAR remove todas as entradas da lista de HOP.
	
	Os comandos HOP ADD, HOP DEL e HOP LIST so limitados
	aos AOPs ou acima, enquanto o comando HOP CLEAR pode ser usado
	apenas pelo Fundador do canal.
	
	Este comando pode ter sido desabilitado para seu canal
	e, nesse caso, voc precisa usar a lista de acesso. Veja
	%R%S HELP ACCESS para informaes sobre a lista
	de acesso, e %R%S HELP SET XOP para saber como
	escolher entre a lista de acesso e o sistema de listas xOP.

CHAN_HELP_SOP
	Sintaxe: SOP canal ADD nick
	         SOP canal DEL {nick | entrada | lista-entradas}
	         SOP canal LIST [mscara | lista-entradas]
	         SOP canal CLEAR
	
	Mantm a lista de SOP (SuperOP) para um canal. A lista
	de SOP d a um usurio todos os direitos dados pela lista de
	AOP, e adiciona a isso os direitos de: usar as listas de AutoKick
	e BadWords, enviar e ler memos do canal, e assim por diante.
	
	O comando SOP ADD adiciona o nick fornecido  lista de SOP.
	
	O comando SOP DEL remove o nick fornecido da lista de SOP.
	Se uma lista de nmeros de entrada  fornecida, essas entradas
	so deletadas. (Veja o exemplo para LIST abaixo.)
	
	O comando SOP LIST exibe a lista de SOP. Se uma mscara
	 fornecida, apenas as entradas que combinarem com ela sero
	mostradas. Se uma lista de nmeros de entrada  fornecida,
	apenas essas entradas so mostradas; por exemplo:
	
	   SOP #canal LIST 2-5,7-9
	      Lista as entradas de SOP numeradas de 2 a 5 e de
	      7 a 9.
	
	O comando SOP CLEAR remove todas as entradas da lista de SOP.
	
	Os comandos SOP ADD, SOP DEL e SOP CLEAR so limitados
	ao Fundador do canal. No entanto, qualquer usurio na lista de AOP
	pode usar o comando SOP LIST.
	
	Este comando pode ter sido desabilitado para seu canal
	e, nesse caso, voc precisa usar a lista de acesso. Veja
	%R%S HELP ACCESS para informaes sobre a lista
	de acesso, e %R%S HELP SET XOP para saber como
	escolher entre a lista de acesso e o sistema de listas xOP.

CHAN_HELP_VOP
	Sintaxe: VOP canal ADD nick
	         VOP canal DEL {nick | entrada | lista-entradas}
	         VOP canal LIST [mscara | lista-entradas]
	         VOP canal CLEAR
	
	Mantm a lista de VOP (VOicePeople) para um canal. A lista
	de VOP permite a um usurio receber Voice automaticamente
	ao entrar no canal e dar Voice a si mesmo se no possuir.
	
	O comando VOP ADD adiciona o nick fornecido  lista de VOP.
	
	O comando VOP DEL remove o nick fornecido da lista de VOP.
	Se uma lista de nmeros de entrada  fornecida, essas entradas
	so deletadas. (Veja o exemplo para LIST abaixo.)
	
	O comando VOP LIST exibe a lista de VOP. Se uma mscara
	 fornecida, apenas as entradas que combinarem com ela sero
	mostradas. Se uma lista de nmeros de entrada  fornecida,
	apenas essas entradas so mostradas; por exemplo:
	
	   VOP #canal LIST 2-5,7-9
	      Lista as entradas de VOP numeradas de 2 a 5 e de
	      7 a 9.
	
	O comando VOP CLEAR remove todas as entradas da lista de VOP.
	
	Os comandos VOP ADD, VOP DEL e VOP LIST so limitados
	aos AOPs ou acima, enquanto o comando VOP CLEAR pode ser usado
	apenas pelo Fundador do canal.
	
	Este comando pode ter sido desabilitado para seu canal
	e, nesse caso, voc precisa usar a lista de acesso. Veja
	%R%S HELP ACCESS para informaes sobre a lista
	de acesso, e %R%S HELP SET XOP para saber como
	escolher entre a lista de acesso e o sistema de listas xOP.

CHAN_HELP_ACCESS
	Sintaxe: ACCESS canal ADD nick nvel
	         ACCESS canal DEL {nick | entrada | lista-entradas}
	         ACCESS canal LIST [mscara | lista-entradas]
	         ACCESS canal CLEAR
	
	Faz manuteno da lista de acesso de um canal. A lista
	de acesso especifica que usurios tem permisso para
	status de OP ou tem acesso aos comandos do %S em
	um canal. Nveis diferentes de usurios permitem acesso
	a diferentes subnveis de privilgios; %R%S HELP
	ACCESS LEVELS para mais informaes especficas. Por
	padro, qualquer nick no presente na lista de acesso
	possui nvel 0.
	
	O comando ACCESS ADD adiciona um nick ou mscara de um
	usurio na lista de acesso com o nvel especificado; se o
	nick ou mscara j estiver presente na lista, seu nvel de
	acesso ser alterado para o nvel especificado. O nvel
	especificado deve ser menor do que o do usurio que emitiu o
	comando, e se o nick j estiver na lista de acesso, o
	nvel de acesso atual desse nick deve ser menor que o nvel
	de acesso do usurio que emitiu o comando.
	
	O comando ACCESS DEL remove um nick especificado da lista
	de acesso. Se uma lista de nmeros  fornecida, essas
	entradas so apagadas. (Veja o exemplo para LIST abaixo.)
	
	O comando ACCESS LIST mostra a lista de acesso do canal.
	Se uma mscara for fornecida, somente aquelas entradas que
	combinarem com o padro especificado na mscara sero 
	mostradas. Se uma lista de nmeros  fornecida, somente
	essas entradas sero mostradas, por exemplo:
	
	ACCESS #canal LIST 2-5,7-9
	   Lista as entradas de acesso numeradas de 2 a 5 e de 7 a 9.
	
	O comando ACCESS CLEAR limpa todas as entradas da lista
	de acesso.

CHAN_HELP_ACCESS_LEVELS
	Nveis de Acesso do Usurio
	
	Por padro, os seguintes nveis de acesso so definidos:
	
	   Founder   Acesso total s funes do %S; OP automtico
	                  quando entrar no canal. Note que somente uma
	                  pessoa pode ter o status fundador (isto no pode
	                  ser dado usando o comando ACCESS).
	        10   Acesso ao comando AKICK; OP automtico.
	         5   OP automtico.
	         3   Voice automtico.
	         0   Sem privilgios especiais; pode se tornar OP
	                  atravs de outros OPs (a menos que secure-ops
	                  esteja ativada).
	        <0   No pode ser OP.
	
	Esses nveis podem ser mudados, ou adicionar novos, usando o
	comando LEVELS; digite %R%S HELP LEVELS para informaes.

CHAN_HELP_AKICK
	Sintaxe: AKICK canal ADD mscara [razo]
	         AKICK canal STICK mscara
	         AKICK canal UNSTICK mscara
	         AKICK canal DEL mscara
	         AKICK canal LIST [mscara]
	         AKICK canal VIEW [mscara]
	         AKICK canal ENFORCE
	         AKICK canal CLEAR
	
	Faz a manuteno da lista de AutoKick de um canal.
	Se um usurio que estiver na lista de AutoKick tentar
	entrar no canal, o %S banir este usurio do 
	canal, e depois kickar o usurio.
	
	O comando AKICK ADD adiciona o usurio especificado ou
	mscara na lista de AutoKick. Se uma razo  dada com
	o comando, esta razo ser usada quando o usurio for
	kickado; se no, a razo padro ser "Voc foi banido
	deste canal".
	
	O comando AKICK STICK bane permanentemente no canal
	a mscara fornecida. Se algum tentar remover o ban,
	%S ir automaticamente coloc-lo de volta. Voc
	no pode usar isto para nicks registrados.
	
	O comando AKICK UNSTICK cancela o efeito do comando
	AKICK STICK, assim voc poder remover o ban no canal.
	
	O comando AKICK DEL remove um nick ou mscara da lista
	de AutoKick. Isso, entretanto, no remove nenhum ban
	colocado pelo AutoKick; estes devem ser removidos
	manualmente.
	
	O comando AKICK LIST mostra a lista de AutoKick ou,
	opcionalmente, s os registros de AutoKick que se
	encaixam com o padro de uma mscara dada.
	
	O comando AKICK VIEW  uma verso mais completa do
	comando AKICK LIST.
	
	O comando AKICK ENFORCE obriga o %S a verificar
	a lista de AutoKicks para banir os usurios que sejam
	compatveis com alguma mscara da lista de AutoKick.
	
	O comando AKICK CLEAR limpa todas as entradas da lista
	de AutoKick.

CHAN_HELP_LEVELS
	Sintaxe: LEVELS canal SET tipo nvel
	         LEVELS canal {DIS | DISABLE} tipo
	         LEVELS canal LIST
	         LEVELS canal RESET
	
	O comando LEVELS permite ajuste detalhado sobre o
	significado dos nveis de acesso numricos usados pelos
	canais. Com esse comando, voc pode definir o nvel de
	acesso requerido pela maioria das funes do %S.
	(Os comandos SET FOUNDER e SET PASSWORD, assim como
	este comando, so sempre restritos ao Fundador do canal).
	
	LEVELS SET permite que o nvel de acesso para uma funo ou
	grupo de funes seja alterado. LEVELS DISABLE (ou DIS
	para encurtar) desabilita um recurso automtico ou no permite
	o acesso a funes para qualquer um que no seja o Fundador
	do canal. LEVELS LIST mostra os nveis atuais para cada
	funo ou para um grupo de funes. LEVELS RESET recoloca
	os nveis de acordo com o padro de um canal recm-criado
	(veja HELP ACCESS LEVELS).
	
	Para lista de recursos e funes cujos nveis podem ser
	ajustados, veja HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	Os seguintes nomes de recursos/funes so entendidos.
	Note que os nveis para AUTODEOP e NOJOIN so os nveis
	mximos, enquanto que todos os outros so nveis mnimos.

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	Sintaxe: INFO canal [ALL]
	
	Lista as informaes referentes ao canal registrado dado,
	incluindo seu fundador, data do registro, ltima vez que
	foi usado, descrio, e trava dos modos (se existirem).
	
	Se voc est identificado como fundador do canal que est
	solicitando informaes e a opo ALL  especificada,
	informaes sobre a mensagem de entrada e sobre o sucessor
	do canal tambm sero mostradas.

CHAN_HELP_LIST
	Sintaxe: LIST padro
	
	Lista todos os canais registrados que combinam com o padro
	fornecido. (Canais com opo PRIVATE ativada no sero listados).

CHAN_HELP_OP
	Sintaxe: OP #canal nick
	
	Atribui status de Operador ao nick dado em um determinado
	canal. Se no for fornecido um nick, o status ser atribudo
	a voc mesmo. Se nem canal nem nick forem fornecidos, o
	status ser atribudo a voc mesmo em todos os canais onde
	estiver, caso tenha nvel suficiente para usar o comando em
	cada um.
	
	Por padro,  limitado aos AOPs ou queles que possuem
	nvel de acesso 5 ou superior no canal.

CHAN_HELP_DEOP
	Sintaxe: DEOP #canal nick
	
	Remove o status de Operador do nick dado em um determinado
	canal. Se no for fornecido um nick, o status ser removido
	de voc mesmo. Se nem canal nem nick forem fornecidos, o
	status ser removido de voc mesmo em todos os canais onde
	estiver, caso tenha nvel suficiente para usar o comando em
	cada um.
	
	Por padro,  limitado aos AOPs ou queles que possuem
	nvel de acesso 5 ou superior no canal.

CHAN_HELP_VOICE
	Sintaxe: VOICE [#canal [nick]]
	
	Atribui status de Voice ao nick dado em um determinado
	canal. Se no for fornecido um nick, o status ser atribudo
	a voc mesmo. Se nem canal nem nick forem fornecidos, o
	status ser atribudo a voc mesmo em todos os canais onde
	estiver, caso tenha nvel suficiente para usar o comando em
	cada um.
	
	Por padro,  limitado aos AOPs ou queles que possuem
	nvel de acesso 5 ou superior no canal; ou aos VOPs ou
	queles que possuem nvel de acesso 3 ou superior, para
	atriburem o status a eles mesmos.

CHAN_HELP_DEVOICE
	Sintaxe: DEVOICE [#canal [nick]]
	
	Remove o status de Voice do nick dado em um determinado
	canal. Se no for fornecido um nick, o status ser removido
	de voc mesmo. Se nem canal nem nick forem fornecidos, o
	status ser removido de voc mesmo em todos os canais onde
	estiver, caso tenha nvel suficiente para usar o comando em
	cada um.
	
	Por padro,  limitado aos AOPs ou queles que possuem
	nvel de acesso 5 ou superior no canal; ou aos VOPs ou
	queles que possuem nvel de acesso 3 ou superior, para
	atriburem o status a eles mesmos.
	
CHAN_HELP_HALFOP
	Sintaxe: HALFOP [#canal [nick]]
	
	Atribui status de HalfOP ao nick dado em um determinado
	canal. Se no for fornecido um nick, o status ser atribudo
	a voc mesmo. Se nem canal nem nick forem fornecidos, o
	status ser atribudo a voc mesmo em todos os canais onde
	estiver, caso tenha nvel suficiente para usar o comando em
	cada um.
	
	Por padro,  limitado aos AOPs ou queles que possuem
	nvel de acesso 5 ou superior no canal; ou aos HOPs ou
	queles que possuem nvel de acesso 4 ou superior, para
	atriburem o status a eles mesmos.

CHAN_HELP_DEHALFOP
	Sintaxe: DEHALFOP [#canal [nick]]
	
	Remove o status de HalfOP do nick dado em um determinado
	canal. Se no for fornecido um nick, o status ser removido
	de voc mesmo. Se nem canal nem nick forem fornecidos, o
	status ser removido de voc mesmo em todos os canais onde
	estiver, caso tenha nvel suficiente para usar o comando em
	cada um.
	
	Por padro,  limitado aos AOPs ou queles que possuem
	nvel de acesso 5 ou superior no canal; ou aos HOPs ou
	queles que possuem nvel de acesso 4 ou superior, para
	atriburem o status a eles mesmos.

CHAN_HELP_PROTECT
	Sintaxe: PROTECT [#canal [nick]]
	
	Protege um determinado nick no canal. Se nick no for
	fornecido, isso ir lhe proteger. Sem nem canal nem nick
	forem fornecidos, ir lhe proteger em todos os canais em que
	voc estiver, caso voc tenha nvel suficiente para usar o
	comando em cada um.
	
	Por padro, limitado ao Founder, a SOPs ou queles com nvel
	10 ou superior no canal para se auto-protegerem.

CHAN_HELP_DEPROTECT
	Sintaxe: DEPROTECT [#canal [nick]]
	
	Desprotege um determinado nick no canal. Se nick no for
	fornecido, isso ir lhe desproteger. Sem nem canal nem nick
	forem fornecidos, ir lhe desproteger em todos os canais em que
	voc estiver, caso voc tenha nvel suficiente para usar o
	comando em cada um.
	
	Por padro, limitado ao Founder, a SOPs ou queles com nvel
	10 ou superior no canal para se auto-desprotegerem.

CHAN_HELP_OWNER
	Sintaxe: OWNER [#canal]
	
	Te concede status de owner no canal. Isso ir lhe
	proteger inclusive daqueles que possuem status "Protect".
	Se canal no for fornecido, ir lhe dar status de owner
	em todos os canais em que voc estiver, caso voc tenha
	nvel suficiente para usar o comando em cada um.
	
	Limitado queles que possuem acesso de Founder no canal.

CHAN_HELP_DEOWNER
	Sintaxe: DEOWNER [#canal]
	
	Remove seu status de owner no canal. Se canal no
	for fornecido, ir remover seu status de owner em todos os
	canais em que voc estiver, caso voc tenha nvel suficiente
	para usar o comando em cada um.
	
	Limitado queles que possuem acesso de Founder no canal.

CHAN_HELP_INVITE
	Sintaxe: INVITE #canal
	
	Manda o %S dar um invite em voc para o canal dado.

	Por padro,  limitado aos AOPs ou queles que possuem
	nvel de acesso 5 ou superior no canal.

CHAN_HELP_UNBAN
	Sintaxe: UNBAN #canal
	
	Diz ao %S para remover todos os bans permitindo que
	voc entre em um canal.
	
	Por padro,  limitado aos AOPs ou queles que possuem
	nvel de acesso 5 ou superior no canal.

CHAN_HELP_KICK
	Sintaxe: KICK [#canal [nick [motivo]]]
	
	Kicka (expulsa) um nick dado em um determinado canal.
	Se no for fornecido um nick, voc mesmo ser kickado.
	Se nem canal nem nick forem fornecidos, voc mesmo ser
	kickado em todos os canais onde estiver, caso tenha nvel
	suficiente para usar o comando em cada um.

	Por padro,  limitado aos AOPs ou queles que possuem
	nvel de acesso 5 ou superior no canal.

CHAN_HELP_BAN
	Sintaxe: BAN [#canal [nick [motivo]]]
	
	Bane o nick selecionado em um canal. Se o nick no  fornecido,
	ir banir voc. Se nem canal nem nick forem fornecidos,
	ir banir voc em todos os canais onde voc estiver, supondo que
	voc tem acesso para isso em cada canal.
	
	Por padro, limitado a AOPs ou queles com nvel de acesso 5 ou
	superior no canal.

CHAN_HELP_TOPIC
	Sintaxe: TOPIC canal [tpico]
	
	Manda %S ajustar o tpico do canal para o que foi especificado.
	Se tpico no  fornecido, ento um tpico vazio ser
	ajustado. Este comando  mais til se usado junto com a opo
	SET TOPICLOCK. Veja %R%S HELP SET TOPICLOCK
	para mais informao.
	
	Por padro, limitado queles que possuem acesso de Founder no canal.

CHAN_HELP_CLEAR
	Sintaxe: CLEAR canal opo
	
	Diz ao %S para remover certos ajustes de um canal.
	A opo pode ser uma das seguintes:
	
	     MODES    Recoloca todos os modos do canal, isto , remove
	                os modos i,k,l,m,n,p,s,t e recoloca os que esto
	                travados com MLOCK.
	     BANS     Remove todos os bans do canal.
	     EXCEPTS  Remove todos os excepts do canal.
	     OPS      Remove o status de Operador de canal (modo +o)
	                de todos os Operadores do canal.
	     HOPS     Remove o status de Half-Operador de canal (modo +h)
	                de todos os Half-Operadores do canal, se suportado.
	     VOICES   Remove o status "voice" (modo +v) de qualquer
	                pessoa que tenha esse modo.
	     USERS    Remove (kicka) todos os usurios do canal.
	
	Por padro, limitado queles que possuem acesso de Founder no canal.
	
CHAN_HELP_GETKEY
	Sintaxe: GETKEY canal
	
	Retorna a key (do modo +k) de um determinado canal. Este comando 
	geralmente usado por bots e/ou scripts, da seguinte forma:
	
	KEY <canal> <key>
	
	key  "NENHUMA KEY" se nenhuma key estiver gravada.
	
CHAN_HELP_SENDPASS
	Sintaxe: SENDPASS canal
	
	Envia a senha de um determinado canal para o fundador
	do mesmo, usando o e-mail gravado no nick dele. Este
	comando  realmente til quando se trata de senhas
	perdidas.
	
	Pode estar limitado aos Operadores de IRC em
	algumas Redes.
	
	Este comando s funciona se o modo de encriptao
	no estiver ligado.

CHAN_SERVADMIN_HELP
	
	Os Administradores dos Services podem tambm usar o comando
	DROP mesmo sem se identificarem como donos do canal, e podem
	tambm ver as listas de acesso, AKICK, e nveis de qualquer
	canal.
	
CHAN_SERVADMIN_HELP_LOGOUT
	Sintaxe: LOGOUT canal [nick]
	
	Este comando faz com que um determinado nick seja des-identificado
	do canal, fazendo com que seja necessrio ele se identificar
	novamente para recuperar seu acesso.
	
	Se voc for o Founder do canal, pode usar este comando em
	qualquer usurio e em si mesmo.
	
	Se voc for um Administrador dos Services, poder
	desconectar qualquer um de qualquer canal sem precisar
	ser o Founder dos mesmos. Alm disso, voc pode omitir
	o parmetro nick; com isso, ir des-identificar todos
	os usurios registrados do canal.

CHAN_SERVADMIN_HELP_DROP
	Sintaxe: DROP canal
	
	Cancela o registro de um canal. Somente Administradores dos
	Services podem cancelar canais que pertencem a outros usurios.

CHAN_SERVADMIN_HELP_SET
	
	Administradores dos Services tambm podem ajustar a opo 
	NOEXPIRE, fazendo com que canais sejam impedidos de ter 
	seu registro expirado. Services Root Administrators ainda
	podem ajustar opes para qualquer canal de outros usurios.

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Sintaxe: SET canal NOEXPIRE {ON | OFF}
	
	Determina se o canal poder ter seu registro expirado.
	Ajustando para ON, evita que o canal seja desregistrado
	por passar do tempo de expirao.
	
	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_INFO
	
	Administradores de Services podem usar o comando ALL com qualquer canal.

CHAN_SERVADMIN_HELP_LIST
	Sintaxe: LIST padro [FORBIDDEN] [SUSPENDED] [NOEXPIRE]
	
	Lista todos os canais registrados que combinam com o padro fornecido.
	Canais com opo PRIVATE ativada s sero mostrados aos
	Administradores dos Services. Canais com a opo NOEXPIRE ativada
	tero um ! preposto ao nome do canal na lista quando for a pedido
	de um Administrador dos Services.
	
	Se as opes FORBIDDEN, SUSPENDED ou NOEXPIRE so fornecidas, apenas
	canais que so, respectivamente, forbidados, suspendidos ou tm a opo
	NOEXPIRE ativa, sero exibidos. Se todas as trs opes forem fornecidas,
	todos os trs tipos de canais sero exibidos. Estas opes so limitas
	aos Administradores dos Services.

CHAN_SERVADMIN_HELP_GETPASS
	Sintaxe: GETPASS canal
	
	Retorna a senha do canal fornecido. Observe que sempre
	que este comando for usado, uma mensagem incluindo o nick da
	pessoa que emitiu o comando e o canal que foi dado sero
	gravados e enviados para WALLOPS/GLOBOPS.
	
	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_FORBID
	Sintaxe: FORBID canal [motivo]
	
	Proibe que qualquer pessoa registre e utilize o canal
	dado. Pode ser cancelado com o desregistro do canal.
	
	Um motivo pode ser necessrio em algumas redes.
	
	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_SUSPEND
	Sintaxe: SUSPEND canal [motivo]
	
	Proibe qualquer um de registrar ou usar o canal dado.
	Pode ser cancelado usando o comando UNSUSPEND para
	preservar todos os dados/configuraes anteriores do canal.
	
	Um motivo pode ser necessrio em algumas redes.
	
	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_UNSUSPEND
	Sintaxe: UNSUSPEND canal
	
	Libera um canal suspenso. Todos os dados e configuraes
	so preservados de antes da suspenso.
	
	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_STATUS
	Sintaxe: STATUS canal nick
	
	Retorna o nvel de acesso atual de um determinado nick em um
	determinado canal. A resposta ser no formato:
	
	    STATUS canal nick nvel-de-acesso
	
	Se um erro ocorrer, a resposta ser no formato:
	
	    STATUS ERROR mensagem-de-erro
	
	Limitado aos Administradores dos Services.

###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP_CMD_SEND
	    SEND     Envia uma mensagem para um nick ou para um canal
MEMO_HELP_CMD_CANCEL
	    CANCEL   Cancela o ltimo memo enviado por voc
MEMO_HELP_CMD_LIST
	    LIST     Lista suas mensagens
MEMO_HELP_CMD_READ
	    READ     L a(s) mensagem(ns)
MEMO_HELP_CMD_DEL
	    DEL      Apaga a(s) mensagem(ns)
MEMO_HELP_CMD_SET
	    SET      Ajusta opes relacionadas s mensagens
MEMO_HELP_CMD_INFO
	    INFO     Exibe informaes sobre suas mensagens
MEMO_HELP_CMD_RSEND
	    RSEND    Envia um memo e pede uma confirmao de leitura
MEMO_HELP_CMD_CHECK
	    CHECK    Verifica se o ltimo memo enviado para um nick foi lido
MEMO_HELP_CMD_SENDALL
	    SENDALL  Envia um memo para todos os usurios registrados
MEMO_HELP_CMD_STAFF
	    STAFF    Envia um memo para todos os opers/admins

MEMO_HELP_HEADER
	%S  um servio que permite aos usurios de IRC
	enviar curtas mensagens a outros usurios, mesmo
	que eles estejam conectados no momento ou no; ou
	a canais(*). Ambos, destinatrios e remetentes,
	devem possuir seus nicks (ou canais) registrados para
	que possam enviar uma mensagem (memo).
	Os comandos do %S so:
	
	
MEMO_HELP_ADMIN
	No usado.
MEMO_HELP_OPER
	No usado.
MEMO_HELP_FOOTER
	
	Digite %R%S HELP comando para ajuda em qualquer um
	dos comandos acima.
	
	(*) Por padro, qualquer usurio com pelo menos nvel 10 de acesso
	    em um canal pode ler os memos do canal. Isso pode ser mudado
	    com o comando %s LEVELS.

MEMO_HELP_SEND
	Sintaxe: SEND {nick | canal} mensagem
	
	Envia um memo ao nick ou ao canal determinado contendo
	a mensagem. Quando enviada para o destinatrio, este
	receber um aviso que possui uma nova mensagem. O nick/canal
	de destino dever estar registrado.
	
MEMO_HELP_CANCEL
	Sintaxe: CANCEL {nick | canal}
	
	Cancela a ltima mensagem enviada para um determinado nick ou
	canal, caso ela ainda no tenha sido lida no momento em que este
	comando for usado.

MEMO_HELP_LIST
	Sintaxe: LIST [canal] [list | NEW]
	
	Lista quaisquer mensagens que voc tiver. Com NEW, lista apenas
	as novas mensagens (no lidas). Mensagens no lidas so marcadas
	com "*"  esquerda do nmero. Voc tambm pode especificar uma
	lista de nmeros, como no exemplo abaixo:
	
	LIST 2-5,7-9
	   Lista mensagens numeradas de 2 a 5 e de 7 a 9.

MEMO_HELP_READ
	Sintaxe: READ [canal] {nm | list | LAST | NEW}
	
	Mostra as mensagens especificadas. Se LAST  fornecido, envia
	a voc a mensagem recebida mais recentemente. Se NEW  fornecido,
	envia a voc todas as suas novas mensagens. Caso contrrio, envia
	a voc a mensagem de nmero nm. Voc tambm pode fornecer uma
	lista de nmeros, como neste exemplo:
	
	READ 2-5,7-9
	   Mostra as mensagens numeradas de 2 a 5 e de 7 a 9.

MEMO_HELP_DEL
	Sintaxe: DEL [canal] {num | list | LAST | ALL}
	
	Apaga a(s) mensagem(ns) especificada(s). Voc pode fornecer
	vrios nmeros de mensagens ou seqncias de nmeros ao invs
	de um nico nmero, como no segundo exemplo abaixo.

	Se LAST  fornecido, a ltima mensagem ser apagada.
	Se ALL  fornecido, todas as suas mensagens sero apagadas.
	
	Exemplos:
	
	   DEL 1
	      Apaga sua primeira mensagem.
	
	   DEL 2-5,7-9
	      Apaga mensagens numeradas de 2 a 5 e de 7 a 9.

MEMO_HELP_SET
	Sintaxe: SET opo parmetros
	
	Ajusta vrias opes de mensagens. A opo pode ser uma dessas:
	
	    NOTIFY      Altera quando voc ser notificado sobre novas
	                    mensagens (s para nicks)
	    LIMIT       Ajusta o nmero mximo de mensagens que voc
	                    pode receber.
	
	Digite %R%S HELP SET opo, para mais informaes sobre
	uma opo especfica.

MEMO_HELP_SET_NOTIFY
	Sintaxe: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Altera quando voc ser notificado sobre novas mensagens:
	
	    ON      Voc ser notificado sobre mensagens quando voc
	                conectar, quando voltar de um /AWAY e quando
	                so enviadas a voc.
	    LOGON   Voc s ser notificado sobre mensagens quando voc
	                conectar ou quando voltar de um /AWAY.
	    NEW     Voc s ser notificado sobre mensagens quando elas
	                forem enviadas a voc.
	    OFF     Voc no receber nenhuma notificao sobre mensagens.
	
	ON  essencialmente a combinao de LOGON e NEW.

MEMO_HELP_SET_LIMIT
	Sintaxe: SET LIMIT [canal] limite
	
	Ajusta o nmero mximo de mensagens que voc (ou o canal fornecido)
	podem ter. Se voc ajustar para 0, ningum ser capaz de enviar
	mensagens para voc. Entretanto, voc no pode ajustar este
	limite para mais que %d.

MEMO_HELP_INFO
	Sintaxe: INFO [canal]
	
	Informa o nmero de mensagens que voc tem, quantas
	mensagens no foram lidas, e quantas mensagens no total
	voc pode receber. Com o parmetro, mostra a mesma
	informao para o canal fornecido.

MEMO_SERVADMIN_HELP_SET_LIMIT
	Sintaxe: SET LIMIT [usurio | canal] {limite | NONE} [HARD]
	
	Ajusta o nmero mximo de mensagens que um usurio ou canal podem
	ter. Ajustando o limite para 0, previne o usurio de receber
	qualquer mensagem; ajustando o limite em NONE permite que o
	usurio receba e mantenha quantas mensagens quiser. Se voc
	no fornecer o nick ou canal, seu prprio limite ser ajustado.
	
	Adicionando HARD previne que o usurio mude o limite.
	No adicionando HARD tem o efeito contrrio, permitindo
	que o usurio mude o limite (mesmo se um limite anterior
	foi ajustado com HARD).
	
	Este uso do comando SET LIMIT  limitado aos Administradores
	dos Services. Outros usurios somente ajustaro seus
	prprios limites ou de um canal onde tenham privilgios
	para isso, no podem remover seu prprio limite, no
	podem ajustar o limite acima de %d, e no podem ajustar
	um limite mximo (HARD).

MEMO_SERVADMIN_HELP_INFO
	Sintaxe: INFO [nick | canal]
	
	Sem um parmetro, informa o nmero de mensagens que voc
	tem, quantas mensagens ainda no foram lidas, e quantas
	mensagens no total voc pode receber.
	
	Com o parmetro do canal, mostra a mesma informao para
	o canal fornecido.
	
	Com o parmetro de nick, mostra a mesma informao para
	o nick fornecido. Esta derivao do comando  limitada aos
	Administradores dos Services.

MEMO_HELP_STAFF
	Sintaxe: STAFF mensagem
	
	Envia um memo a todos os membros da Staff dos Services
	contendo uma mensagem.
	Nota: Se voc tem acesso em ambas as listas de Oper e Admin
	ir receber o mesmo memo duas vezes. O mesmo se aplica a
	Operadores que estejam na lista de Root como em outra(s) tambm.

MEMO_HELP_SENDALL
	Sintaxe: SENDALL mensagem
	
	Envia um memo para todos os usurios registrados
	contendo uma mensagem.

MEMO_HELP_RSEND
	Sintaxe: RSEND {nick | canal} mensagem
	
	Envia para um nick ou canal um memo contendo uma
	mensagem. Quando enviar a um nick, o destinatrio receber
	um aviso de que ele tem um novo memo. O destino (nick/canal)
	deve ser registrado.
	Uma vez que o memo for lido pelo destinatrio, uma notificao
	automtica ser enviada ao remetente informando-o que o memo
	foi lido.

MEMO_HELP_CHECK
	Sintaxe: CHECK nick
	
	Verifica se o ltimo memo que voc enviou para nick
	foi lido ou no. Observe que isso s funciona com nicks,
	nunca com canais.

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP_CMD_GLOBAL
	    GLOBAL      Envia uma mensagem para todos usurios
OPER_HELP_CMD_STATS
	    STATS       Mostra estatsticas dos Services e da Rede
OPER_HELP_CMD_OPER
	    OPER        Modifica a lista de Operadores dos Services
OPER_HELP_CMD_ADMIN
	    ADMIN       Modifica lista de Administradores dos Services
OPER_HELP_CMD_STAFF
	    STAFF       Exibe os membros da Staff dos Services e seu status online
OPER_HELP_CMD_MODE
	    MODE        Muda o modo de um canal
OPER_HELP_CMD_KICK
	    KICK        Kicka um usurio de um canal
OPER_HELP_CMD_CLEARMODES
	    CLEARMODES  Limpa os modos de um canal
OPER_HELP_CMD_KILLCLONES
	    KILLCLONES  Derruba todos os usurios de um mesmo host
OPER_HELP_CMD_AKILL
	    AKILL       Manipula a lista de AKILL
OPER_HELP_CMD_SGLINE
	    SGLINE      Manipula a lista de SGLINE
OPER_HELP_CMD_SQLINE
	    SQLINE      Manipula a lista de SQLINE
OPER_HELP_CMD_SZLINE
	    SZLINE      Manipula a lista de SZLINE
OPER_HELP_CMD_CHANLIST
	    CHANLIST    Lista todos os canais em uso na Rede
OPER_HELP_CMD_USERLIST
	    USERLIST    Lista todos os usurios online na Rede
OPER_HELP_CMD_LOGONNEWS
	    LOGONNEWS   Define mensagens a serem mostradas na conexo
OPER_HELP_CMD_RANDOMNEWS
	    RANDOMNEWS  Define mensagens a serem mostradas ao azar na conexo
OPER_HELP_CMD_OPERNEWS
	    OPERNEWS    Define mensagens a serem mostradas a quem pega Oper
OPER_HELP_CMD_SESSION
	    SESSION     Mostra a lista de sesses de host
OPER_HELP_CMD_EXCEPTION
	    EXCEPTION   Modifica a lista de limite de sesses
OPER_HELP_CMD_NOOP
	    NOOP        Remove temporariamente todas as O:lines de um 
	                  servidor remotamente
OPER_HELP_CMD_JUPE
	    JUPE        Jupa um servidor
OPER_HELP_CMD_IGNORE
	    IGNORE      Modifica a lista de ignorados dos Services
OPER_HELP_CMD_SET
	    SET         Configura vrias opes globais dos Services
OPER_HELP_CMD_RELOAD
	    RELOAD      Recarrega o arquivo de configurao dos Services
OPER_HELP_CMD_UPDATE
	    UPDATE      Salva os dados atuais dos Services
OPER_HELP_CMD_RESTART
	    RESTART     Salva os dados e reinicia os Services
OPER_HELP_CMD_QUIT
	    QUIT        Termina os Services sem salvar os dados
OPER_HELP_CMD_SHUTDOWN
	    SHUTDOWN    Termina os Services salvando os dados
OPER_HELP_CMD_DEFCON
	    DEFCON      Manipula o sistema DefCon
OPER_HELP_CMD_CHANKILL
	    CHANKILL    Derruba todos os usurios de um canal especfico
OPER_HELP_CMD_OLINE
	    OLINE       D flags de Operador a um determinado usurio
OPER_HELP_CMD_UMODE
	    UMODE       Altera os modos de um usurio
OPER_HELP_CMD_SVSNICK
	    SVSNICK     Fora a mudana do nick de um usurio
OPER_HELP_CMD_MODLOAD
	    MODLOAD     Carrega um mdulo
OPER_HELP_CMD_MODUNLOAD
	    MODUNLOAD   Descarrega um mdulo
OPER_HELP_CMD_MODINFO
	    MODINFO     Informao sobre um mdulo carregado
OPER_HELP_CMD_MODLIST
	    MODLIST     Lista os mdulos carregados

OPER_HELP
	Comandos do %S:

OPER_HELP_LOGGED
	Aviso: Todos os comandos enviados para o %S so gravados!

OPER_HELP_GLOBAL
	Sintaxe: GLOBAL mensagens
	
	Permite que os IRCops enviem mensagens para todos os usurios
	da Rede. A mensagem ser enviada pelo nick %s.

OPER_HELP_STATS
	Sintaxe: STATS [AKILL | ALL | RESET]
	
	Sem nenhuma opo, mostra o nmero atual de usurios e
	IRCops online (excluindo Services), o nmero mximo de
	usurios online conectados simultaneamente desde que os
	Services foram iniciados na rede, e o tempo pelo qual os
	Services esto rodando sem interrupes.
	
	Com a opo AKILL, ser mostrado o tamanho atual da
	listas de AKILL e SQLINE e o tempo padro para um AKILL
	ou SQLINE expirar.
	
	A opo ALL est disponvel apenas para os Administradores
	dos Services, e mostra informaes sobre o consumo de memria
	dos Services. O uso deste comando pode congelar os Services
	por um curto perodo de tempo em redes grandes, ento no
	abuse deste comando!
	
	A opo RESET reinicia a contagem do mximo de usurios
	para o nmero de usurios atualmente conectados na rede.
	
	UPTIME pode ser usado como um sinnimo para STATS.

OPER_HELP_OPER
	Sintaxe: OPER ADD nick
	         OPER DEL {nick | entrada | lista-entradas}
	         OPER LIST [mscara | lista-entradas]
	         OPER CLEAR
	
	Permite aos Administradores dos Services adicionar ou remover
	nicks da lista de Operadores dos Services. O usurio que
	tem o nick na lista de Operadores dos Services e que est
	identificado no %s  capaz de acessar os comandos de
	Operador dos Services.
	
	O comando OPER ADD adiciona o nick fornecido na lista
	de Operadores dos Services.
	
	O comando OPER DEL remove o nick especificado da lista
	de Operadores dos Services. Se uma lista de nmeros de entrada
	 fornecida, essas entradas so apagadas. (Veja o exemplo
	para LIST abaixo.)
	
	O comando OPER LIST mostra a lista de Operadores dos
	Services. Se uma mscara for fornecida, somente aquelas
	entradas que combinarem com o padro especificado na
	mscara sero mostradas. Se uma lista de nmeros de entrada
	 fornecida, somente essas entradas sero mostradas;
	por exemplo:
	
	  OPER LIST 2-5,7-9
	     Lista as entradas de Operadores dos Services numeradas
	     de 2 a 5 e de 7 a 9.
	
	O comando OPER CLEAR limpa todas as entradas da lista
	de Operadores dos Services.
	
	Qualquer Operador de IRC pode usar o OPER LIST.
	Todos os outros usos do comando so limitados aos
	Administradores dos Services.

OPER_HELP_ADMIN
	Sintaxe: ADMIN ADD nick
	         ADMIN DEL {nick | entrada | lista-entradas}
	         ADMIN LIST [mscara | lista-entradas]
	         ADMIN CLEAR
	
	Permite aos Service Root Administrators adicionar ou remover
	nicks da lista de Administradores dos Services. O usurio que
	tem o nick na lista de Administradores dos Services e que est
	identificado no %s  capaz de acessar os comandos de
	Administradores dos Services.
	
	O comando ADMIN ADD adiciona o nick fornecido na lista
	de Administradores dos Services.
	
	O comando ADMIN DEL remove o nick especificado da lista
	de Administradores dos Services. Se uma lista de nmeros de
	entrada  fornecida, essas entradas so apagadas.
	(Veja o exemplo para LIST abaixo.)
	
	O comando ADMIN LIST mostra a lista de Administradores
	dos Services. Se uma mscara for fornecida, somente aquelas
	entradas que combinarem com o padro especificado na mscara
	sero mostradas. Se uma lista de nmeros de entrada  fornecida,
	somente essas entradas sero mostradas; por exemplo:
	
	  ADMIN LIST 2-5,7-9
	     Lista as entradas de Administradores dos Services numeradas
	     de 2 a 5 e de 7 a 9.
	
	O comando ADMIN CLEAR limpa todas as entradas da lista
	de Administradores dos Services.
	
	Qualquer Operador de IRC pode usar o ADMIN LIST.
	Todos os outros usos do comando so limitados aos
	Service Root Administrators.

OPER_HELP_IGNORE
	Sintaxe: IGNORE {ADD|DEL|LIST|CLEAR} [tempo] [nick]

	Permite aos Administradores dos Services fazer os Services
	ignorar um nick por um certo tempo ou at a prxima
	reinicializao. O formato de tempo padro  em segundos.
	Voc pode alterar esse formato usando unidades. Unidades
	vlidas: s para segundos, m para minutos, h para horas e
	d para dias. Combinaes dessas unidades no so permitidas.
	Para fazer os Services ignorarem permanentemente o usurio,
	digite 0 como tempo.

OPER_HELP_MODE
	Sintaxe: MODE canal modos
	
	Permite que os Operadores dos Services ajustem os modos de
	qualquer canal. Os parmetros so os mesmos do comando
	/MODE padro.
	
	Limitado aos Operadores dos Services.

OPER_HELP_UMODE
	Sintaxe: UMODE usurio modos
	
	Permite aos Administradores dos Services ajustar os
	modos de usurio para qualquer usurio. Os parmetros
	so os mesmos do comando /MODE padro.
	
	Limitado aos Super-Admins.

OPER_HELP_OLINE
	Sintaxe: OLINE usurio flags
	
	Permite aos Administradores dos Services dar flags de Oper
	a qualquer usurio. Flags devem ser prefixadas com "+" ou
	"-". Para remover todas as flags apenas digite um "-" em
	vez de usar alguma flag.

	Limitado aos Super-Admins.

OPER_HELP_CLEARMODES
	Sintaxe: CLEARMODES canal [ALL]
	
	Limpa todos os modos binrios (i,k,l,m,n,p,s,t) e bans de um
	canal. Se ALL  fornecido, limpa tambm todos os OPs e
	voices (modos +o e +v) de um canal.
	
	Limitado aos Operadores dos Services.

OPER_HELP_KICK
	Sintaxe: KICK canal usurio motivo
	
	Permite IRCops kickar um usurio de um canal.
	Os parmetros so os mesmos do comando /KICK padro.
	A mensagem do kick tem o nick do IRCop que enviou o
	comando KICK, por exemplo:
	
	*** Spam foi kickado do canal #canal pelo %S (Operador (Flood))
	
	Limitado aos Operadores dos Services.

OPER_HELP_SVSNICK
	Sintaxe: SVSNICK nick novo-nick
	
	Fora a mudana do nick de um usurio, de nick a novo-nick.
	
	Limitado aos Super-Admins.

OPER_HELP_AKILL
	Sintaxe: AKILL ADD [+tempo] mscara motivo
	         AKILL DEL {mscara | entrada | lista-entradas}
	         AKILL LIST [mscara | lista-entradas]
	         AKILL VIEW [mscara | lista-entradas]
	         AKILL CLEAR
	
	Permite que Operadores dos Services manipulem a lista de
	AKILL. Se um usurio que tenta conectar possui uma mscara
	prevista na lista de AKILL, os Services emitem um KILL para
	aquele usurio, em servidores que suportam, e instrui todos
	os servidores da rede a adicionar um ban (K-line) para a
	mscara do usurio encontrado.
	
	AKILL ADD adiciona uma mscara ident@host na lista de AKILL
	para um dado motivo (deve ser fornecido).
	Opcionalmente, um tempo para o akill expirar pode ser
	fornecido. O tempo precede a mscara ident@host, e 
	especificado como um nmero inteiro seguido por uma das
	seguintes unidades: d (dias), h (horas) ou m (minutos).
	Combinaes (como 1h30m) no so permitidas. Se uma unidade
	especfica no  includa, o padro  em dias (assim, +30
	significa 30 dias). Para adicionar um AKILL que no expira,
	use +0. Se a mscara a ser adicionada comear com um +,
	o tempo do AKILL deve ser fornecido, mesmo se esse tempo for igual
	ao padro. O tempo atual de expirao de AKILLs pode ser encontrado
	com o comando STATS AKILL.
	
	AKILL DEL remove uma dada mscara da lista de AKILL, se ela
	estiver presente. Se uma lista de nmeros de entrada for fornecida,
	essas entradas sero apagadas. (Veja o exemplo para LIST abaixo.)
	
	AKILL LIST mostra a lista de AKILL atual.
	Se uma mscara for fornecida, apenas as entradas que combinarem
	com a mscara sero exibidas. Se uma lista de nmeros de entrada
	for fornecida, apenas essas entradas sero exibidas; por exemplo:
	
	   AKILL LIST 2-5,7-9
	      Lista as entradas de AKILL numeradas de 2 a 5 e de 7 a 9.
	
	AKILL VIEW  uma verso mais detalhada do AKILL LIST,
	e mostrar quem adicionou o AKILL, a data em que foi adicionado,
	e quando ir expirar, como tambm a mscara (ident@host) e o motivo.
	
	AKILL CLEAR apaga todas as entradas da lista de AKILL.
	
	Limitado aos Operadores dos Services.
	
OPER_HELP_SGLINE
	Sintaxe: SGLINE ADD [+tempo] mscara:motivo
	         SGLINE DEL {mscara | entrada | lista-entradas}
	         SGLINE LIST [mscara | lista-entradas]
	         SGLINE VIEW [mscara | lista-entradas]
	         SGLINE CLEAR
	
	Permite que Operadores dos Services manipulem a lista de
	SGLINE. Se um usurio que tenta conectar possui um realname
	previsto na lista de SGLINE, os Services no permitiro que
	ele continue sua sesso de IRC.
	
	SGLINE ADD adiciona uma mscara realname na lista de SGLINE
	para um dado motivo (deve ser fornecido).
	Opcionalmente, um tempo pode ser fornecido. O tempo precede a
	mscara e  especificado como um nmero inteiro seguido por uma das
	seguintes unidades: d (dias), h (horas) ou m (minutos).
	Combinaes (como 1h30m) no so permitidas. Se uma unidade
	especfica no  includa, o padro  em dias (assim, +30
	significa 30 dias). Para adicionar um SGLINE que no expira,
	use +0. Se a mscara de realname a ser adicionada comear com
	um +, o tempo do SGLINE deve ser fornecido, mesmo se esse tempo
	for igual ao padro. O tempo atual de expirao de SGLINE pode ser
	encontrado com o comando STATS AKILL.
	Nota: devido ao fato da mscara de realname poder conter espaos,
	o separador entre ela e o motivo  um sinal de dois-pontos.
	
	SGLINE DEL remove uma dada mscara da lista de SGLINE, se ela
	estiver presente. Se uma lista de nmeros de entrada for fornecida,
	essas entradas sero apagadas. (Veja o exemplo para LIST abaixo.)
	
	SGLINE LIST mostra a lista de SGLINE atual.
	Se uma mscara for fornecida, apenas as entradas que combinarem
	com a mscara sero exibidas. Se uma lista de nmeros de entrada
	for fornecida, apenas essas entradas sero exibidas; por exemplo:
	
	   SGLINE LIST 2-5,7-9
	      Lista as entradas de SGLINE numeradas de 2 a 5 e de 7 a 9.
	
	SGLINE VIEW  uma verso mais detalhada do SGLINE LIST,
	e mostrar quem adicionou o SGLINE, a data em que foi adicionado,
	e quando ir expirar, como tambm a mscara realname e o motivo.
	
	SGLINE CLEAR apaga todas as entradas da lista de SGLINE.
	
	Limitado aos Operadores dos Services.

OPER_HELP_SQLINE
	Sintaxe: SQLINE ADD [+tempo] mscara motivo
	         SQLINE DEL {mscara | entrada | lista-entradas}
	         SQLINE LIST [mscara | lista-entradas]
	         SQLINE VIEW [mscara | lista-entradas]
	         SQLINE CLEAR
	
	Permite que Operadores dos Services manipulem a lista de
	SQLINE. Se um usurio que tenta conectar possui um nick
	previsto na lista de SQLINE, os Services no permitiro que
	ele continue sua sesso de IRC.
	
	SQLINE ADD adiciona uma mscara na lista de SQLINE
	para um dado motivo (deve ser fornecido).
	Opcionalmente, um tempo pode ser fornecido. O tempo precede a
	mscara e  especificado como um nmero inteiro seguido por uma das
	seguintes unidades: d (dias), h (horas) ou m (minutos).
	Combinaes (como 1h30m) no so permitidas. Se uma unidade
	especfica no  includa, o padro  em dias (assim, +30
	significa 30 dias). Para adicionar um SQLINE que no expira,
	use +0. Se a mscara a ser adicionada comear com um +,
	o tempo do SQLINE deve ser fornecido, mesmo se esse tempo for
	igual ao padro. O tempo atual de expirao de SQLINE pode ser
	encontrado com o comando STATS AKILL.
	
	SQLINE DEL remove uma dada mscara da lista de SQLINE, se ela
	estiver presente. Se uma lista de nmeros de entrada for fornecida,
	essas entradas sero apagadas. (Veja o exemplo para LIST abaixo.)
	
	SQLINE LIST mostra a lista de SQLINE atual.
	Se uma mscara for fornecida, apenas as entradas que combinarem
	com a mscara sero exibidas. Se uma lista de nmeros de entrada
	for fornecida, apenas essas entradas sero exibidas; por exemplo:
	
	   SQLINE LIST 2-5,7-9
	      Lista as entradas de SQLINE numeradas de 2 a 5 e de 7 a 9.
	
	SQLINE VIEW  uma verso mais detalhada do SQLINE LIST,
	e mostrar quem adicionou o SQLINE, a data em que foi adicionado,
	e quando ir expirar, como tambm a mscara e o motivo.
	
	SQLINE CLEAR apaga todas as entradas da lista de SQLINE.
	
	Limitado aos Operadores dos Services.

OPER_HELP_SZLINE
	Sintaxe: SZLINE ADD [+tempo] mscara motivo
	         SZLINE DEL {mscara | entrada | lista-entradas}
	         SZLINE LIST [mscara | lista-entradas]
	         SZLINE VIEW [mscara | lista-entradas]
	         SZLINE CLEAR
	
	Permite que Operadores dos Services manipulem a lista de
	SZLINE. Se um usurio que tenta conectar possui um IP
	previsto na lista de SZLINE, os Services no permitiro que
	ele continue sua sesso de IRC (e isso, mesmo se o IP possuir
	ou no um PTR RR).
	
	SZLINE ADD adiciona uma mscara de IP na lista de SZLINE
	para um dado motivo (deve ser fornecido).
	Opcionalmente, um tempo pode ser fornecido. O tempo precede a
	mscara e  especificado como um nmero inteiro seguido por uma das
	seguintes unidades: d (dias), h (horas) ou m (minutos).
	Combinaes (como 1h30m) no so permitidas. Se uma unidade
	especfica no  includa, o padro  em dias (assim, +30
	significa 30 dias). Para adicionar um SZLINE que no expira,
	use +0. Se a mscara a ser adicionada comear com um +,
	o tempo do SZLINE deve ser fornecido, mesmo se esse tempo for
	igual ao padro. O tempo atual de expirao de SZLINE pode ser
	encontrado com o comando STATS AKILL.
	
	SZLINE DEL remove uma dada mscara da lista de SZLINE, se ela
	estiver presente. Se uma lista de nmeros de entrada for fornecida,
	essas entradas sero apagadas. (Veja o exemplo para LIST abaixo.)
	
	SZLINE LIST mostra a lista de SZLINE atual.
	Se uma mscara for fornecida, apenas as entradas que combinarem
	com a mscara sero exibidas. Se uma lista de nmeros de entrada
	for fornecida, apenas essas entradas sero exibidas; por exemplo:
	
	   SZLINE LIST 2-5,7-9
	      Lista as entradas de SZLINE numeradas de 2 a 5 e de 7 a 9.
	
	SZLINE VIEW  uma verso mais detalhada do SZLINE LIST,
	e mostrar quem adicionou o SZLINE, a data em que foi adicionado,
	e quando ir expirar, como tambm a mscara IP e o motivo.
	
	SZLINE CLEAR apaga todas as entradas da lista de SZLINE.
	
	Limitado aos Operadores dos Services.

OPER_HELP_SET
	Sintaxe: SET opo seleo
	
	Ajusta vrias opes globais dos Services. Os nomes de opo
	atualmente definidas so:
	    READONLY    Ativa o modo read-only ou read-write
	    LOGCHAN     Ativa ou desativa envio de log a um canal
	    DEBUG       Ativa ou desativa o modo de depurao (debug)
	    NOEXPIRE    Ativa ou desativa o modo no-expira
	    SUPERADMIN  Ativa ou desativa o modo Super-Admin
	    SQL         Ativa ou desativa o modo SQL
	    IGNORE      Ativa ou desativa o modo Ignore
	    LIST        Lista as opes atuais
	
	Limitado aos Administradores dos Services.

OPER_HELP_SET_READONLY
	Sintaxe: SET READONLY {ON | OFF}
	
	Ativa ou desativa o modo read-only (somente leitura).
	No modo read-only, usurios normais no sero capazes de
	modificar nenhum dado nos Services, incluindo lista de acesso
	de canais e nicks etc. IRCops com privilgios suficientes
	nos Services sero capazes de modificar a lista de AKILL
	e de proibir ou cancelar o registro de canais ou nicks,
	embora quaisquer mudanas no sero salvas no banco de
	dados a menos que o modo read-only seja desativado antes
	dos Services serem terminados ou reiniciados.
	
	Esta opo  equivalente  opo da linha de comando
	-readonly.

OPER_HELP_SET_LOGCHAN
	Sintaxe: SET LOGCHAN {ON | OFF}
	
	Com esta opo ativada, os Services enviaro seus logs
	para um canal especificado. LogChannel deve estar definido
	na configurao dos Services para esta opo poder ser usada.
	
	Nota: Pode haver graves implicaes de segurana se o canal
	de log no estive devidamente seguro.

OPER_HELP_SET_DEBUG
	Sintaxe: SET DEBUG {ON | OFF | nmero}
	
	Ativa ou desativa o modo de depurao (debug). No modo de
	depurao, todos os dados enviados para os Services e vindos
	deles, assim como um nmero de outras mensagens de depurao
	so enviadas a um arquivo de log. Se nmero  fornecido,
	o modo de depurao  ativado, com nvel de depurao ajustado
	para nmero.
	
	Esta opo  equivalente  opo da linha de comando
	-debug.
	
OPER_HELP_SET_NOEXPIRE
	Sintaxe: SET NOEXPIRE {ON | OFF}
	
	Ativa ou desativa o modo NOEXPIRE. Se estiver ativado, os
	nicks, canais, akills e excees no iro expirar enquanto a 
	opo no for desativada.
	
	Esta opo  equivalente  opo da linha de comando
	-noexpire.

OPER_HELP_SET_SUPERADMIN
	Sintaxe: SET SUPERADMIN {ON | OFF}
	
	Ativando esta opo, lhe sero concedidos privilgios extras como a
	habilidade de ser "founder" em todos os canais etc.

	Esta opo no  permanente, e deve ser usada somente quando
	necessria, e desativada quando no for mais necessria.

OPER_HELP_SET_SQL
	Sintaxe: SET SQL {ON | OFF}
	
	Ajustando esta opo, far os Services usarem ou no SQL. Isso deve
	ser usado para ativar ou desativar SQL caso seu servidor SQL caia
	enquanto os Services estiverem rodando.

OPER_HELP_SET_IGNORE
	Sintaxe: SET IGNORE {ON | OFF}
	
	Ajustando esta opo, far os Services usarem ou no o sistema
	de IGNORE.

OPER_HELP_SET_LIST
	Sintaxe: SET LIST
	
	Exibe as vrias configuraes do OperServ.

OPER_HELP_NOOP
	Sintaxe: NOOP SET servidor
	         NOOP REVOKE servidor
	
	NOOP SET remove todas as O:lines do servidor
	especificado e killa todos os IRCops atualmente nele
	para prevenir que eles dem rehash no servidor (pois
	isto simplesmente cancela o efeito).

	NOOP REVOKE torna todas as O:lines removidas
	novamente disponveis no servidor especificado.

	Nota: O servidor no  checado como um todo
	pelos Services.
	
	Limitado aos Administradores dos Services.

OPER_HELP_JUPE
	Sintaxe: JUPE servidor [motivo]
	
	Diz aos Services para "jupar" um servidor -- isto , criar
	um falso servidor conectado aos Services que previne que o
	servidor real com aquele nome se conecte na rede. O jupe
	pode ser removido usando um SQUIT padro. Se um motivo
	 dado, ele  colocado no campo de informao do servidor;
	caso contrrio, o campo de informao do servidor ir conter
	o texto "Jupado por <nick>", mostrando o nick de quem mascarou
	o servidor.
	
	Limitado aos Administradores dos Services.

OPER_HELP_RAW
	Sintaxe: RAW texto
	
	Envia uma srie de texto diretamente ao servidor onde os
	Services esto conectados. Este comando tem vrias
	limitaes de uso, e pode criar destruio e problemas na
	rede se for usado inadequadamente. NO USE ESTE COMANDO
	a menos que voc tenha absoluta certeza do que est fazendo!
	
	Limitado aos Administradores dos Services.

OPER_HELP_UPDATE
	Sintaxe: UPDATE
	
	Faz com que os Services atualizem o banco de dados logo que
	voc envia este comando.
	
	Limitado aos Administradores dos Services.
	
OPER_HELP_RELOAD
	Sintaxe: RELOAD
	
	Faz com que os Services recarreguem seu arquivo de configurao. 
	Repare que, para algumas mudanas terem efeito, ser necessrio
	que os Services sejam reiniciados.
	
	Limitado aos Administradores dos Services.

OPER_HELP_QUIT
	Sintaxe: QUIT
	
	Faz com que desligue os Services imediatamente; o banco de
	dados no  salvo. Este comando no deve ser usado a menos
	que haja um dano da cpia do banco de dados na memria e por
	isso eles no devam ser salvos. Para desligar normalmente,
	use o comando SHUTDOWN.
	
	Limitado aos Administradores dos Services.

OPER_HELP_SHUTDOWN
	Sintaxe: SHUTDOWN
	
	Salva o banco de dados dos Services e os desliga.
	
	Limitado aos Administradores dos Services.

OPER_HELP_RESTART
	Sintaxe: RESTART
	
	Salva o banco de dados dos Services e os reinicia.
	(sai e roda imediatamente o executvel).
	
	Limitado aos Administradores dos Services.

OPER_HELP_KILLCLONES
	Sintaxe: KILLCLONES nick
	
	Expulsa ("killa") todos os usurios que tenham os mesmos
	hosts que o nick especificado, adicionando um AKILL temporrio
	no formato *@host para prevenir que os usurios indesejados
	reconectem imediatamente. Uma mensagem em WallOps  tambm
	enviada para indicar quem usou o comando, quais hosts foram
	afetados e quantos usurios foram expulsos ("killados").
	 usado para remover vrios clones da rede.
	
	Limitado aos Operadores dos Services.
	
OPER_HELP_CHANLIST
	Sintaxe: CHANLIST [{padro | nick} [SECRET]]
	
	Lista todos os canais em uso na Rede, sejam eles registrados ou no.
	
	Se um padro  fornecido, listar apenas canais que combinem com
	ele. Se um nick  fornecido, listar apenas canais que o usurio
	estiver usando. Se SECRET  especificado, listar apenas canais
	combinando com o padro e que tenham modo +s ou +p.
	
	Limitado aos Administradores dos Services.
	
OPER_HELP_USERLIST
	Sintaxe: USERLIST [{padro | canal} [INVISIBLE]]
	
	Lista todos os usurios online na Rede, tenham eles nicks
	registrados ou no.
	
	Se um padro  fornecido, listar apenas usurios que combinem
	com ele (deve estar no formato nick!ident@host). Se um canal 
	fornecido, listar apenas usurios que esto no canal dado.
	estiver usando. Se INVISIBLE  especificado, listar apenas usurios
	que tenham o modo +i.
	
	Limitado aos Administradores dos Services.
	
OPER_HELP_MODLOAD
	Sintaxe: MODLOAD NomeDoArquivo
	
	Este comando carrega o mdulo chamado NomeDoArquivo
	do diretrio de mdulos.
	
	Limitado aos Service Root Administrators.
	
OPER_HELP_MODUNLOAD
	Sintaxe: MODUNLOAD NomeDoArquivo

	Este comando descarrega o mdulo chamado NomeDoArquivo
	do diretrio de mdulos.

	Limitado aos Service Root Administrators.
	
OPER_HELP_MODINFO
	Sintaxe: MODINFO NomeDoArquivo
	
	Este comando lista informaes sobre um mdulo carregado.
	
	Limitado aos Service Root Administrators.
	
OPER_HELP_MODLIST
	Sintaxe: MODLIST
	
	Lista todos os mdulos atualmente carregados.
	
	Limitado aos Service Root Administrators.
	

###########################################################################
#
# BotServ help messages
#
###########################################################################
BOT_HELP_CMD_BOTLIST
	    BOTLIST            Lista os bots disponveis
BOT_HELP_CMD_ASSIGN
	    ASSIGN             Associa um bot ao canal
BOT_HELP_CMD_SET
	    SET                Configura as opes do bot
BOT_HELP_CMD_KICK
	    KICK               Configura os kickers
BOT_HELP_CMD_BADWORDS
	    BADWORDS           Configura os palavres
BOT_HELP_CMD_ACT
	    ACT                Faz com que o bot faa o mesmo que o comando "/me"
BOT_HELP_CMD_INFO
	    INFO               Permite que voc veja informaes do BotServ sobre um canal ou bot
BOT_HELP_CMD_SAY
	    SAY                Faz com que o bot diga determinado texto no canal dado
BOT_HELP_CMD_UNASSIGN
	    UNASSIGN           Desassocia um bot de um canal
BOT_HELP_CMD_BOT
	    BOT                Mantm a lista de bots da Rede

BOT_HELP
	%S permite que voc tenha um bot no seu canal.
	Foi criado para usurios que no tem como hospedar
	ou configurar um bot, ou para Redes que no permitem
	aos usurios terem um bot. Os comandos disponveis 
	esto listados abaixo; para us-los, digite
	%R%S comando. Para informaes mais especficas
	sobre um comando, digite %R%S HELP comando.
	
BOT_HELP_FOOTER
	O bot ir entrar no canal sempre que tiver ao menos %d usurio(s) nele.
	
BOT_HELP_BOTLIST
	Sintaxe: BOTLIST
	
	Lista todos os bots disponveis nesta Rede.
	
BOT_HELP_ASSIGN
	Sintaxe: ASSIGN canal nick
	
	Associa um bot escolhido pelo nick a um canal.
	Voc poder ento configurar o bot para o canal de acordo
	com as suas necessidades.
	
BOT_HELP_UNASSIGN
	Sintaxe: UNASSIGN canal
	
	Desassocia um bot de um canal. Quando voc usa este comando,
	o bot no ir entrar mais no canal. Entretando, ser mantida
	a configurao do bot para aquele canal, para que voc possa
	sempre poder associ-lo quele canal mais tarde sem ter que
	configurar tudo novamente.
	
BOT_HELP_INFO
	Sintaxe: INFO {canal | nick}
	
	Permite que voc veja informaes do %S sobre um
	canal ou bot. Se a opo for um canal, ento voc ter
	informaes tais como kickers ativos. Se tiver sido um nick,
	voc ter informaes sobre o bot, como o horrio de criao
	ou nmero de canais onde ele est.
	
BOT_HELP_SET
	Sintaxe: SET canal opo parmetros
	
	Configura as opes do bot. A opo pode ser:
	
	    DONTKICKOPS      Protege os OPs contra kicks
	    DONTKICKVOICES   Protege os voices contra kicks
	    GREET            Habilita a mensagem de entrada
	    FANTASY          Habilita os comandos Fantasia
	    SYMBIOSIS        Permite que o bot seja um bot real
	
	Digite %R%S HELP SET opo para maiores informaes
	sobre uma opo especfica.
	
	Aviso: o acesso a este comando  controlado pelo ajuste
	dos nveis de acesso do canal.
	
BOT_HELP_SET_DONTKICKOPS
	Sintaxe: SET canal DONTKICKOPS {ON|OFF}
	
	Ativa ou desativa o modo de proteo de OPs em um canal.
	Quando estiver ativado, os OPs no sero kickados pelo bot,
	mesmo se eles no se enquadram no nvel de NOKICK.
	
BOT_HELP_SET_DONTKICKVOICES
	Sintaxe: SET canal DONTKICKVOICES {ON|OFF}
	
	Ativa ou desativa o modo de proteo de voices em um canal.
	Quando estiver ativado, os voices no sero kickados pelo bot,
	mesmo se eles no se enquadram no nvel de NOKICK.
	
BOT_HELP_SET_FANTASY
	Sintaxe: SET canal FANTASY {ON|OFF}
	
	Ativa ou desativa o modo fantasia em um canal.
	Quando estiver ativado, os usurios podero usar
	comandos como !op, !deop, !voice, !devoice,
	!kick, !kb, !unban, !seen em um canal. Em algumas
	redes, mais comandos podem estar disponveis, tais
	como: !owner, !deowner, !protect, !deprotect,
	!halfop, !dehalfop.
	
	Note que os usurios que quiserem usar esses 
	comandos DEVEM ter um nvel suficiente tanto para
	o nvel FANTASIA quanto para outro, dependendo
	do comando usado (por exemplo, para usar !op, o 
	usurio deve ter acesso aos comandos OP e DEOP).

BOT_HELP_SET_GREET
	Sintaxe: SET canal GREET {ON|OFF}
	
	Ativa ou desativa o modo greet em um canal.
	Quando ativado, o bot ir mostrar mensagens de
	entrada dos usurios quando eles entrarem no
	canal, caso tenham nvel de acesso suficiente.

BOT_HELP_SET_SYMBIOSIS
	Sintaxe: SET canal SYMBIOSIS {ON|OFF}
	
	Ativa ou desativa o modo symbiosis em um canal.
	Quando ativado, o bot far tudo aquilo que 
	normalmente  feito pelo %s nos canais, como as 
	mudanas de modos, kicks e, inclusive, a mensagem
	de entrada (entrymsg).

BOT_HELP_KICK
	Sintaxe: KICK canal opo parmetros
	
	Configura os kicks do bot. A opo pode ser uma dessas:
	
	    BOLDS         Selecione para o bot kickar por negrito
	    BADWORDS      Selecione para o bot kickar por palavres
	    CAPS          Selecione para o bot kickar por caps
	    COLORS        Selecione para o bot kickar por cores
	    FLOOD         Selecione para o bot kickar por flood
	    REPEAT        Selecione para o bot kickar por repetio
	    REVERSES      Selecione para o bot kickar por reversos
	    UNDERLINES    Selecione para o bot kickar por sublinhado
	
	Digite %R%S HELP KICK opo para maiores informaes
	sobre uma opo especfica.
	
	Nota: o acesso a esse comando  controlado pelo ajuste
	dos nveis de acesso do canal.
	
BOT_HELP_KICK_BOLDS
	Sintaxe: KICK canal BOLDS {ON|OFF} [ttb]
	
	Ativa ou desativa o kick por negrito. Quando ativado
	o bot ir kickar os usurios que usarem negrito.
	
	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido. No fornea ttb para desabilitar
	o sistema de ban que foi uma vez ativado.
	
BOT_HELP_KICK_COLORS
	Sintaxe: KICK canal COLORS {ON|OFF} [ttb]
	
	Ativa ou desativa o kick por cores. Quando ativado
	o bot ir kickar os usurios que usarem cores.
	
	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido. No fornea ttb para desabilitar
	o sistema de ban que foi uma vez ativado.
	
BOT_HELP_KICK_REVERSES
	Sintaxe: KICK canal REVERSES {ON|OFF} [ttb]
	
	Ativa ou desativa o kick por reverso. Quando ativado
	o bot ir kickar os usurios que usarem reverso.
	
	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido. No fornea ttb para desabilitar
	o sistema de ban que foi uma vez ativado.
	
BOT_HELP_KICK_UNDERLINES
	Sintaxe: KICK canal UNDERLINES {ON|OFF} [ttb]
	
	Ativa ou desativa o kick por sublinhado. Quando ativado
	o bot ir kickar os usurios que usarem sublinhado.
	
	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido. No fornea ttb para desabilitar
	o sistema de ban que foi uma vez ativado.
	
BOT_HELP_KICK_CAPS
	Sintaxe: KICK canal CAPS {ON|OFF} [ttb [mnimo [porcentagem]]]
	
	Ativa ou desativa o kick por caps. Quando ativado
	o bot ir kickar os usurios que usarem CAPS (maisculas).
	
	O bot ir kickar apenas se usarem pelo menos um mnimo de
	caps e eles constiturem pelo menos porcentagem%% do total 
	do texto (se no for especificado, o padro  10 caracteres
	e 25%%).
	
	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido. No fornea ttb para desabilitar
	o sistema de ban que foi uma vez ativado.
	
BOT_HELP_KICK_FLOOD
	Sintaxe: KICK canal FLOOD {ON|OFF} [ttb [linhas [segs]]]
	
	Ativa ou desativa o kick por flood. Quando ativado o
	o bot ir kickar por flood no canal desde que sejam
	pelo menos linhas linhas em segs segundos.
	(se no for especificado, o padro  6 linhas em
	10 segundos).
	
	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido. No fornea ttb para desabilitar
	o sistema de ban que foi uma vez ativado.
	
BOT_HELP_KICK_REPEAT
	Sintaxe: KICK canal REPEAT {ON|OFF} [ttb [nm]]
	
	Ativa ou desativa o kick por repetio. Quando ativado
	o bot ir kickar os usurios que fizerem repeties (onde
	nm  o nmero de repeties para kick; se no for fornecido,
	o padro  3).
	
	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido. No fornea ttb para desabilitar
	o sistema de ban que foi uma vez ativado.
	
BOT_HELP_KICK_BADWORDS
	Sintaxe: KICK canal BADWORDS {ON|OFF} [ttb]
	
	Ativa ou desativa o kick por palavres. Quando ativado
	o bot ir kickar usurios que disserem determinadas
	palavras no canal.
	
	Voc pode definir os palavres para um canal usando o
	comando BADWORDS. Digite %R%S HELP BADWORDS para
	maiores informaes.
	
	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido. No fornea ttb para desabilitar
	o sistema de ban que foi uma vez ativado.
	
BOT_HELP_BADWORDS
	Sintaxe: BADWORDS canal ADD palavra [SINGLE | START | END]
	         BADWORDS canal DEL {palavra | nm-entrada | lista}
	         BADWORDS canal LIST [mscara | lista]
	         BADWORDS canal CLEAR
	
	Faz a manuteno da lista de palavres em um canal.
	Essa lista determina quais so as palavras que devero
	ser motivo de kick em um canal quando a opo BADWORDS
	estiver ativada. Para maiores informaes, digite
	%R%S HELP KICK BADWORDS.
	
	O comando BADWORDS ADD adiciona a palavra na lista
	de palavres. A opo SINGLE, quando especificada, s
	kicka o usurio se ele escrever a palavra inteira.
	A opo START, quando especificada, ir kickar o usurio
	que escrever uma palavra que comece com a palavra.
	A opo END se tiver sido especificada s kicka o usurio
	que escrever uma palavra que termine com a palavra.
	Se voc no especificar nada, o bot ir kickar sempre
	que a palavra for escrita pelo usurio.
	
	O comando BADWORDS DEL remove uma palavra da lista de
	palavres de um determinado canal. Se uma lista de nmeros
	de entrada for fornecida, essas entradas sero apagadas
	(veja o exemplo para LIST abaixo).
	
	O comando BADWORDS LIST mostra a lista de palavres.
	Se forem usados coringas, apenas aquelas entradas com
	as determinadas mscaras sero mostradas. Se uma lista
	de nmeros de entrada for dada, apenas aquelas entradas
	sero mostradas; por exemplo:
	
	   BADWORDS #canal LIST 2-5,7-9
	      Lista as entradas dos palavres numeradas de 2 a 5
	      e de 7 a 9.
	
	O comando BADWORDS CLEAR limpa todas entradas da lista.

BOT_HELP_SAY
	Sintaxe: SAY canal texto
	
	Faz com que o bot diga determinado texto no canal dado.

BOT_HELP_ACT
	Sintaxe: ACT canal texto
	
	Faz com que o bot faa o mesmo que o comando "/me"
	em um determinado canal com o determinado texto.

BOT_SERVADMIN_HELP_BOT
	Sintaxe: BOT ADD nick user host real
	         BOT CHANGE NickAntigo NickNovo [user [host [real]]]
	         BOT DEL nick
	
	Permite que os Administradores dos Services criem,
	modifiquem, e apaguem bots que os usurios podero usar
	em seus prprios canais.
	
	BOT ADD adiciona um bot com um determinado nick, username,
	hostname e realname. 
	BOT CHANGE permite alterar o nick, username, hostname
	ou realname de um bot sem que seja necessrio apag-lo (e
	todas as informaes nele contidas).
	BOT DEL remove um bot da lista de bots.  
	
	Nota: voc no pode criar um bot que use um nick que j
	seja registrado. Se um usurio no registrado est atualmente
	usando o nick, ele ser killado.
	
BOT_SERVADMIN_HELP_SET
	
	Essas opes so reservadas aos Administradores dos Services:
	
	    NOBOT            Previne um bot de ser associado a 
	                       um canal
	    PRIVATE          Previne um bot de ser associado por
	                       quem no  Operador de IRC.

BOT_SERVADMIN_HELP_SET_NOBOT
	Sintaxe: SET canal NOBOT {ON|OFF}
	
	Este comando faz com que um determinado bot no possa ser
	associado a um canal. Se j houver um bot associado a este
	canal, este ser automaticamente desassociado quando voc
	ativar essa opo.
	
	Limitado aos Administradores dos Services.
	
BOT_SERVADMIN_HELP_SET_PRIVATE
	Sintaxe: SET nick PRIVATE {ON|OFF}
	
	Esta opo previne um bot de ser associado a um canal
	por usurios que no sejam Operadores de IRC.
	
	Limitado aos Administradores dos Services.

###########################################################################
#
# HostServ messages
#
###########################################################################
HOST_EMPTY
	A lista de vHost est limpa.
HOST_ENTRY
	#%d Nick:%s, vHost:%s (%s - %s)
HOST_IDENT_ENTRY
	#%d Nick:%s, vHost:%s@%s (%s - %s)
HOST_SET
	vhost de %s ajustado para %s.
HOST_IDENT_SET
	vhost de %s ajustado para %s@%s.
HOST_SETALL
	vhost do grupo %s ajustado para %s.
HOST_DELALL
	vhosts do grupo %s foi removido.
HOST_DELALL_SYNTAX
	Sintaxe: DELALL <nick>.
HOST_IDENT_SETALL
	vhost do grupo %s ajustado para %s@%s.
HOST_SET_ERROR
	Erro! Um vhost pode conter apenas A-Z, a-z, 0-9, '.' e '-'.
HOST_SET_IDENT_ERROR
	O Ident de um vhost deve estar no formato de um Ident vlido.
HOST_SET_TOOLONG
	Erro! O host  muito comprido, por favor use um host de at %d caracteres.
HOST_SET_IDENTTOOLONG
	Erro! O Ident  muito comprido, por favor use um Ident de at %d caracteres.
HOST_NOREG
	Usurio %s no encontrado na DB do NickServ.
HOST_SET_SYNTAX
	Sintaxe: %R%s set <nick> <hostmask>.
HOST_SETALL_SYNTAX
	Sintaxe: %R%s setall <nick> <hostmask>.
HOST_DENIED
	Acesso Negado.
HOST_NOT_ASSIGNED
	Por favor contacte algum Operator para receber um vhost associado a este nick.
HOST_ACTIVATED
	Seu vhost %s est agora ativado.
HOST_IDENT_ACTIVATED
	Seu vhost %s@%s est agora ativado.
HOST_ID
	Por favor, identifique-se aos Services primeiro.
HOST_NOT_REGED
	Primeiro voc precisa registrar seu nick seno um vhost no pode ser associado a voc.
HOST_DEL
	vhost para %s removido.
HOST_DEL_SYNTAX
	Sintaxe: %R%s del <nick>.
HOST_OFF_UNREAL
	Seu vhost foi removido. Para reabilitar a encriptao padro de host, digite /mode %s +%s
HOST_NO_VIDENT
	Seu IRCD no suporta vIdent's, se isto no est certo, por favor reporte isso como um possvel bug.
HOST_GROUP
	Todos os vhost's no grupo %s foram ajustados para %s
HOST_IDENT_GROUP
	Todos os vhost's no grupo %s foram ajustados para %s@%s
HOST_LIST_FOOTER
	Exibidos todos os registros (Contador: %d)
HOST_LIST_RANGE_FOOTER
	Exibidos registros de %d at %d
HOST_LIST_KEY_FOOTER
	Exibidos registros coincidindo com a chave %s (Contador: %d)

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_HELP_CMD_ON
	    ON          Ativa seu vHost associado
HOST_HELP_CMD_OFF
	    OFF         Desativa seu vHost associado
HOST_HELP_CMD_GROUP
	    GROUP       Sincroniza um mesmo vHost para todos os nicks de um grupo
HOST_HELP_CMD_SET
	    SET         Ajusta o vHost de outro usurio
HOST_HELP_CMD_SETALL
	    SETALL      Ajusta o vHost de todos os nicks de um grupo
HOST_HELP_CMD_DEL
	    DEL         Deleta o vHost de outro usurio
HOST_HELP_CMD_DELALL
	    DELALL      Deleta o vHost de todos os nicks de um grupo
HOST_HELP_CMD_LIST
	    LIST        Exibe uma ou mais entradas de vHost

HOST_OPER_HELP
	not used.

HOST_ADMIN_HELP
	not used.

HOST_HELP
	Comandos do %S:

HOST_HELP_ON
	Sintaxe: ON

	Ativa o vhost atualmente associado ao nick em uso.
	Quando voc usa este comando, qualquer usurio que faa um /whois
	em voc ir ver o vhost em vez do seu endereo IP real/encriptado.

HOST_HELP_SET
	Sintaxe: SET <nick> <hostmask>.

	Ajusta o vhost para o nick dado com a hostmask fornecida.
	Caso seu IRCd suporte vIdents, ento usando
	SET <nick> <ident>@<hostmask> ajustar idents para
	usurios, assim como vhosts.

	Limitado a Host Setters/Operadores dos Services.

HOST_HELP_DELALL
	Sintaxe: DELALL <nick>.

	Deleta o vhost para todos os nicks no mesmo grupo do
	nick fornecido.

	Limitado a Host Removers/Operadores dos Servicess.

HOST_HELP_SETALL
	Sintaxe: SETALL <nick> <hostmask>.

	Ajusta o vhost para todos os nicks no mesmo grupo do
	nick fornecido. Caso seu IRCd suporte vIdents, ento
	usando SETALL <nick> <ident>@<hostmask> ajustar idents
	para usurios, assim como vhosts.

	* NOTA: isto no ir atualizar o vhost de nenhum nick
	adicionado ao grupo depois que o comando foi usado.

	Limitado a Host Setters/Operadores dos Services.

HOST_HELP_OFF
	Sintaxe: OFF

	Desativa o vhost atualmente associado ao nick em uso.
	Quando voc usa este comando, qualquer usurio que faa um /whois
	em voc ir ver seu endereo IP real/encriptado.

HOST_HELP_DEL
	Sintaxe: DEL <nick>

	Deleta o vhost associado ao nick dado.

	Limitado a Host Removers/Operadores dos Services.

HOST_HELP_LIST
	Sintaxe: LIST [<key>|<#X-Y>]

	Este comando lista ao Operador os vhosts registrados.
	Se uma Key  especificada, apenas entradas cujo nick ou vhost
	combinem com o padro fornecido em <key> sero exibidas.
	Ex.: Rob* mostra todas as entradas comeando com "Rob"

	Se o estilo #X-Y for usado, apenas entradas entre o alvo X
	e Y sero exibidas. Ex.: #1-3 ir mostrar as 3 primeiras
	entradas de nick/vhost.

	A lista usa o valor de NSListMax como limite do nmero de
	itens para exibir a um Operator de uma vez s.

	Limitado aos Operadores dos Services.

HOST_HELP_GROUP
	Sintaxe: GROUP
	
	Este comando permite aos usurios ajustar o vhost do seu
	nick ATUAL para ser o vhost de todos os nicks no mesmo grupo.

OPER_SVSNICK_UNSUPPORTED
	Desculpe, SVSNICK no est disponvel nesta rede.

OPER_SQLINE_UNSUPPORTED
	Desculpe, SQLINE no est disponvel nesta rede.

OPER_SVSO_UNSUPPORTED
	Desculpe, OLINE no est disponvel nesta rede.

OPER_UMODE_UNSUPPORTED
	Desculpe, UMODE no est disponvel nesta rede.

OPER_SUPER_ADMIN_NOT_ENABLED
	Opo SuperAdmin no habilitada no arquivo services.conf

