/* $NetBSD$ */

/*
 * Copyright  2005 Alistair Crooks.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "config.h"

#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_SYS_ENDIAN_H
#include <sys/endian.h>
#endif

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#include <ctype.h>

#ifdef HAVE_ERR_H
#include <err.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <unistd.h>

#include "defs.h"
#include "aa.h"


#ifndef HAVE_SETPROGNAME
static const char	*__progname;

void
setprogname(const char *s)
{
	__progname = s;
}

const char *
getprogname(void)
{
	return __progname;
}
#endif

#ifndef HAVE_ERR_H
void
errx(int ex, const char *fmt, ...)
{
	va_list	vp;

	va_start(vp, fmt);
	(void) fprintf(stderr, "%s: ", getprogname());
	vfprintf(stderr, fmt, vp);
	va_end(vp);
	(void) fputc('\n', stderr);
	exit(ex);
}

void
warnx(const char *fmt, ...)
{
	va_list	vp;

	va_start(vp, fmt);
	(void) fprintf(stderr, "%s: ", getprogname());
	vfprintf(stderr, fmt, vp);
	va_end(vp);
	(void) fputc('\n', stderr);
}

void
err(int ex, const char *fmt, ...)
{
	va_list	vp;

	va_start(vp, fmt);
	(void) fprintf(stderr, "%s: ", getprogname());
	vfprintf(stderr, fmt, vp);
	va_end(vp);
	(void) fprintf(stderr, " (%s)\n", strerror(errno));
	exit(ex);
}

void
warn(const char *fmt, ...)
{
	va_list	vp;

	va_start(vp, fmt);
	(void) fprintf(stderr, "%s: ", getprogname());
	vfprintf(stderr, fmt, vp);
	va_end(vp);
	(void) fprintf(stderr, " (%s)\n", strerror(errno));
}
#endif

#ifndef HAVE_STRLCPY
size_t
strlcpy(char *dst, const char *src, size_t size)
{
	int	srclen;

	srclen = strlen(src);
	(void) strncpy(dst, src, MIN(size - 1, srclen));
	dst[size - 1] = 0x0;
	return srclen;
}
#endif
