#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "functions.h"

int parse_for_each()
{
char token[TOKENSIZE];
char variable[TOKENSIZE];
char molecule[LINELENGTH];
int tokentype,c,objidx,objtype,objidx2,objtype2;

  tokentype=gettoken(variable);
  tokentype=gettoken(token);

  if (strcasecmp(token,"in")!=0)
  {
    error(token,"In","For Each");
  }

  fprintf(out,"foreach (");

  tokentype=gettoken(token);
  eval_element(molecule,tokentype,token);

  fprintf(out,"%s as $%s)\n",molecule,variable);
  
  /* In a for each, "molecule" may return a collection of objects. */
  /* While we can't determine what class molecule returns in many cases, */
  /* if it is a single variable, then assume variable and molecule are the same class. */
  /* This works particularly well for filesystemobject's. */
  if (molecule[0]=='$' && (objtype=getobject(&molecule[1],&objidx)))
  {
    objtype2=getobject(variable,&objidx2);
    if (objidx2==objectsptr)
    {
      strcpy(objects[objidx2],variable);
      objectsptr++;
    }
    strcpy(objectstype[objidx2],objectstype[objidx]);
  }
  
  autoindent();
  fprintf(out,"{");
  indent++;
  c=parse_body(0);
  indent--;
  autoindent();
  fprintf(out,"}\n");

  tokentype=gettoken(token);
/* printf("Extra token: %s\n",token); */

  return 0;
}

int parse_do()
{
char token[TOKENSIZE];
int c;

  loopcount++;

  if ((c=gettoken(token))!=2 || strcasecmp(token,"while")!=0)
  {
    push(token,c);
    parse_do_loop();
    return 0;
  }

  autoindent();
  fprintf(out,"while");
  c=parse_condition();
  fprintf(out,"\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  c=parse_body(0);
  indent--;
  autoindent();
  fprintf(out,"} ");

  loopcount--;

  return 0;
}

int parse_do_until_loop()
{
int c;

  loopcount++;

  autoindent();
  fprintf(out,"while(!");
  c=parse_condition();
  fprintf(out,")\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  c=parse_body(0);
  indent--;
  autoindent();
  fprintf(out,"} ");

  loopcount--;

  return 0;
}

int parse_do_loop()
{
char token[TOKENSIZE];
int c;

  loopcount++;

  c=gettoken(token);
  if (strcasecmp(token,"until")==0)
  {
    parse_do_until_loop();
    return 0;
  }

  autoindent();
  fprintf(out,"do\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  parse_body(0);
  indent--;

  c=gettoken(token);
  if (strcasecmp("until",token)!=0)
  { error(token,"Until","Do"); }

  autoindent();
  fprintf(out,"} while (!");
  c=parse_condition();
  fprintf(out,");\n");

  loopcount--;

  return 0;
}

int parse_while()
{
int c;

  loopcount++;

  autoindent();
  fprintf(out,"while");
  c=parse_condition();
  fprintf(out,"\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;
  c=parse_body(0);
  indent--;
  autoindent();
  fprintf(out,"} ");

  loopcount--;

  return 0;
}

int parse_for()
{
char token[TOKENSIZE];
char variable[TOKENSIZE];
char expression[LINELENGTH];
char newtoken[LINELENGTH];
int c,tokentype;
int step=0;

  loopcount++;
  gettoken(token);
  autoindent();

  if (strcasecmp(token,"each")==0)
  {
    parse_for_each();
    return 0;
  }

  strcpy(variable,token);
  strcase(variable);
  fprintf(out,"for ($%s",variable);

  eval_expression(" ");
  fprintf(out,"; ");
  /* sprintf(expression,""); */
  strcpy(expression,"");

  while(1)
  {
    tokentype=gettoken(token);

    if (tokentype==TOK_EOF)
    { printf("Parse error: End of file reached early on line %d\n",line); return 0; }
      else
    if (strcasecmp("step",token)==0 || (tokentype==TOK_COLON || tokentype==TOK_EOL || tokentype==TOK_ENDCODE))
    { break; }
      else
    {
      strcpy(newtoken,"");
      eval_element(newtoken,tokentype,token);
      strcat(expression,newtoken);
    }
  }

  if (strcasecmp(token,"step")==0)
  {
    tokentype=gettoken(token);
    if (strcmp("-",token)==0)
    { step=-1; }
      else
    { 
      push(token,tokentype);
      step=1;
    }
  }
    else
  {
    push(token,tokentype);
  }

  if (step==1 || step==0)
  { fprintf(out,"$%s<=%s; $%s=$%s+",variable,expression,variable,variable); }
    else
  if (step==-1)
  { fprintf(out,"$%s>=%s; $%s=$%s-",variable,expression,variable,variable); }

  if (step==0)
  { putc('1',out); }
    else
  { 
    while(1)
    {
      tokentype=gettoken(token);
      if (tokentype==TOK_EOL || tokentype==TOK_COLON)
      { break; }
	else
      if (tokentype==TOK_ENDCODE)
      { 
        push(token,tokentype);
        break;
      }
        else
      if (tokentype==TOK_EOF)
      { error(token,"?","For"); return 0; }
        else
      if (tokentype==TOK_KEYWORD)
      { fprintf(out,"$%s",token); }
        else
      { fprintf(out,"%s",token); } 
    }
  }

  fprintf(out,")\n");
  autoindent();
  fprintf(out,"{");
  indent++;
  c=parse_body(0);
  indent--;

  if (column!=0)
  { putc('\n',out); column=0; }

  autoindent();
  fprintf(out,"}");

  tokentype=gettoken(token);
  push(token,tokentype);

  if (tokentype!=TOK_ENDCODE) putc('\n',out);

  loopcount--;

  return 0;
}


