#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#include "globals.h"
#include "functions.h"

int parse_body(int iflag)
{
char token[TOKENSIZE];
char tmptoken[TOKENSIZE];
char newtoken[LINELENGTH];
int tokentype,c;

  in_body++;

  while((tokentype=gettoken(token))!=TOK_EOF)
  {
    newtoken[0]=0;

#ifdef DEBUG
printf("parse_body(%i): token=%s, type=%i, in_body=%i\n",iflag,token,tokentype,in_body);
#endif

    if (tokentype==TOK_EOL)
    {
      if (iflag==1)
      { break; }

      putc('\n',out);
      stringexpr=0;
    }
      else
    if (tokentype==TOK_COLON)
    {
      putc('\n',out);
      stringexpr=0;
    }
      else
    if (tokentype==TOK_ENDCODE)
    {
      if (iflag==1)
      {
        push(token,tokentype);
        putc('\n',out);
        break;
        /*
        if (in_body==1)
        { in_body--; return 0; }
          else
        { copyhtml(); }
        */
      }
        else
      {
        fprintf(out,"?>");

        if (in_body==1)
        { in_body--; return 0; }
          else
        { copyhtml(); }
      }
    }
      else
    if (strcasecmp(token,"case")==0)
    { push(token,tokentype); break; }
      else
    if ((strcasecmp(token,"loop")==0 || strcasecmp(token,"wend")==0) ||
        (strcasecmp(token,"next")==0))
    { break; }
      else
    if (strcasecmp(token,"end")==0)
    {
      c=gettoken(tmptoken);
      if (c!=TOK_EOL)
      {
        push(tmptoken,c);  // leave end type as next token
        break;
      }

      autoindent();
      fprintf(out,"exit();\n");
    }
      else
    if (strcasecmp(token,"elseif")==0)
    {
      indent--;
      autoindent();
      fprintf(out,"}\n");
      autoindent();
      fprintf(out,"  else\n");
      autoindent();
      fprintf(out,"if ");

      parse_condition();
      tokentype=gettoken(token);

      fprintf(out,"\n");
      autoindent();
      fprintf(out,"{\n");
      indent++;
    }
      else
    if (strcasecmp(token,"session")==0)
    { parse_session(); }
      else
    if (strcasecmp(token,"else")==0)
    {
      /* single line if/then/else needs an extra newline - MHB - 4/10/06 */
      if (iflag==1) fprintf(out,"\n");
      indent--;
      autoindent();
#ifdef DEBUG
printf("parse_body: close bracket\n");
#endif

      fprintf(out,"}\n");
      autoindent();
      fprintf(out,"  else\n");
      autoindent();
#ifdef DEBUG
printf("parse_body: open bracket\n");
#endif

      fprintf(out,"{\n");
      indent++;
    }
      else
    if (tokentype==TOK_COMMENT)
    { fprintf(out,"%s",token); }
      else
    if (tokentype==TOK_EOF)
    { return 0; }
      else
    if (isfunction2(token)!=-1)
    {
#ifdef DEBUG
printf("parse_body: function\n");
#endif
      strcpy(tmptoken,token);
      c=gettoken(token);
      if (strcmp(token,"=")==0)
      {
        autoindent();
        fprintf(out,"$function_ret=");
        eval_expression(" ");
      }
        else
      {
        autoindent();
        fprintf(out,"%s",tmptoken);
        push(token,c);
        convert_funct(newtoken,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29",4);
        fprintf(out,"%s;",newtoken);
      }
    }
      else
    if (tokentype==TOK_KEYWORD || strcmp("=",token)==0)
    {
      eval_token(tokentype,token);
    }
      else
    if (strcmp(token,"<")==0)
    {
      if (is_endscript()==1)
      {
        if (in_body==1)
        {
          in_body--;
          fprintf(out,"?>\n");
          return 0;
        }
          else
        { copyhtml(); }
      }
    }

    /* don't return from single line if/then/else until we reach EOL - MHB - 4/10/06 */
    if (iflag==1 && (tokentype==TOK_EOL || tokentype==TOK_ENDCODE)) break;
  }

  in_body--;

  if (tokentype==TOK_EOL) { putc('\n',out); }
  if (strcasecmp(token,"end")==0) return 1;

  return 0;
}

int parse_command_set(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];

  tokentype=gettoken(token);
  strcpy(newtoken,"");

  if (tokentype==TOK_KEYWORD)
  {
    autoindent();
    fprintf(out,"$%s_%s=",variable,token);

    tokentype=gettoken(token);

    if (strcmp(token,"=")!=0)
    { error(token,"=","Command Object"); }
    eval_expression(" ");
  }

  return 0;
}

int parse_command(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];
char temp[1024];

  sprintf(newtoken,"%s",variable);

  while(1)
  {
    tokentype=gettoken(token);

    if (tokentype!=TOK_KEYWORD)
    { push(token,tokentype); break; }

    sprintf(temp,"_%s",token);

    tokentype=gettoken(token);

    if (strcmp(token,".")!=0)
    { push(token,tokentype); break; }
  }

  return 0;
}


int parse_set(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
char temptoken[TOKENSIZE];
char temptoken2[TOKENSIZE];
char temp_spaces[100];
char molecule1[LINELENGTH];
int tmpidx,objidx,objtype;

  temp_spaces[0]=0;
  molecule1[0]=0;
  tokentype=gettoken(token);
#ifdef DEBUG
printf("parse_set(): %s (type=%i)\n",token,tokentype);
#endif

  strcpy(temptoken,token);
  objtype=getobject(token,&objidx);
  if (objtype==OBJ_ADODB_COMMAND)
  {
    strcpy(temptoken,token);

    tokentype=gettoken(token);
    if (strcmp(token,".")==0)
    {
      tokentype=gettoken(token);
      sprintf(newtoken,"$%s_%s=",temptoken,token);

      tokentype=gettoken(token);
      if (strcmp(token,"=")!=0)
      { error(token,"=","Set"); }

      tokentype=gettoken(token);
      if (getobject(token,&tmpidx)==OBJ_ADODB_CONNECTION)
      {
        strcat(newtoken,"$");
        strcat(newtoken,token);
      }

      while(tokentype!=TOK_EOL)
      { tokentype=gettoken(token); }

      strcat(newtoken,";");
      strcat(newtoken,"\n");

      return 0;
    }
      else
    { push(token,tokentype); }
  }

  tokentype=gettoken(temptoken2);
  if (strcmp(temptoken2,"=")!=0)
  { error(temptoken2,"=","Set"); }

  if (objidx==objectsptr)
  {
    strcpy(objects[objidx],token);
    objectsptr++;
  }
  strcpy(lastsetvar,token);
  lastsetline=line;

  tokentype=gettoken(token);
#ifdef DEBUG
printf("parse_set/next token: %s (type=%i)\n",token,tokentype);
#endif
  
  /* this is a guess! we're not testing whether this set is behind some kind of conditional! MHB 5/4/06 */
  if (strcasecmp(token,"nothing")!=0)
  { strcpy(objectstype[objidx],"unknown"); }
  
  if (strcasecmp(token,"nothing")==0)
  {
    sprintf(newtoken,"%s$%s=null;\n",temp_spaces,temptoken);
  }
    else
  if (strcasecmp(token,"createobject")==0)
  {
    parse_createobject(newtoken,objidx);
  }
    else
  if (strcasecmp(token,"server")==0)
  {
    tokentype=gettoken(token);
    if (strcmp(token,".")!=0)
    { error(token,".","Server"); }

    tokentype=gettoken(token);
    if (strcasecmp(token,"createobject")==0)
    {
      parse_createobject(newtoken,objidx);
    }
      else
    {
      setvar=objidx;
      eval_element(newtoken,tokentype,token);
      setvar=0;
      sprintf(newtoken,"// $%s is of type %s",objects[objidx],objectstype[objidx]);
    }
  }
    else
  if (getobject(token,&tmpidx)==OBJ_SCRIPTING_FILESYSTEM)
  {
    strcpy(objectstype[objidx],"Scripting.FileSystemObject");
    tokentype=gettoken(temptoken2);
#ifdef DEBUG
printf("parse_set/filesystem: %s (type=%i)\n",temptoken2,tokentype);
#endif
    if (strcmp(temptoken2,".")==0)
    { parse_filesystem(molecule1,token); }
      else
    { push(token,tokentype); eval_element(molecule1,tokentype,token); }
    
    strcat(newtoken,"$");
    strcat(newtoken,temptoken);
    strcat(newtoken,"=");
    strcat(newtoken,molecule1);
  }
    else
  {
    fprintf(out,"$%s=",temptoken); /* Thanks to Vsevolod (Simon) Ilyushchenko */

    setvar=objidx;
    eval_element(newtoken,tokentype,token);
    strcat(newtoken,";");
    setvar=0;
  }

  return 0;
}

int parse_rem()
{
int ch;

  fprintf(out,"// ");

  while((ch=getc(in)))
  {
    if (ch=='\r') ch='\n';
    putc(ch,out);
    if (ch=='\n' || ch==EOF) return 0;
  }

  return 0;
}

// pubpriv should be either "public", "private", or ""
int parse_dim(char *pubpriv)
{
char token[TOKENSIZE];
char newtoken[LINELENGTH];
int tokentype;

  newtoken[0]=0;

  if (inclass==0 || infunct>0)
  {
    while((tokentype=gettoken(token))!=TOK_EOF)
    {
      if (tokentype==TOK_EOL || tokentype==TOK_COLON) break;
    }
  }
    else
  {
    autoindent();
    if (php > 4)
    {
      if (strlen(pubpriv) > 0)
      { fprintf(out,"%s ",pubpriv); }
      else
      { fprintf(out,"public "); }
    }
      else
    {
      fprintf(out,"var ");
    }

    while((tokentype=gettoken(token))!=TOK_EOF)
    {
#ifdef DEBUG
printf("parse_dim(): %s (type=%i)\n",token,tokentype);
#endif
      if (tokentype==TOK_ENDCODE)
      {
        push(token,tokentype);
        fprintf(out,"; ");
        break;
      }
        else
      if (strcmp(token,"(")==0)
      {
        push(token,tokentype);
        convert_funct(newtoken,"1,2,3,4,5",20);
      }
        else
      if (tokentype==TOK_EOL || tokentype==TOK_COLON)
      { fprintf(out,";\n"); break; }
        else
      if (tokentype!=TOK_KEYWORD && tokentype!=TOK_COMMA)
      { error(token,", or variable","Dim"); }
        else
      if (tokentype==TOK_KEYWORD)
      { fprintf(out,"$%s",token); }
        else
      if (tokentype==TOK_COMMA)
      { fprintf(out,","); }
    }
  }

  return 0;
}

int parse_at_language()
{
int tokentype;
char token[TOKENSIZE];
time_t rawtime;
struct tm * timeinfo;

  tokentype=gettoken(token);
  if (strcmp(token,"=")!=0)
  {
    error(token,"=","LANGUAGE");
  }

  tokentype=gettoken(token);
  remove_quotes(token);

#ifdef DEBUG
printf("parse_at_language(): %s\n",token);
#endif

  time ( &rawtime );
  timeinfo = localtime ( &rawtime );
  if (strcasecmp(token,"vbscript")==0)
  {
    language=0;

    fprintf(out,"// asp2php (vbscript) converted on %s ",asctime(timeinfo));
  }
    else
  if (strcasecmp(token,"jscript")==0 || strcasecmp(token,"javascript")==0)
  {
    language=1;
    fprintf(out,"// asp2php (jscript) converted on %s ",asctime(timeinfo));
    printf("Warning: JScript has very little support right now.\n");
  }
    else
  {
    language=0;
    fprintf(out,"// asp2php (unknown) converted on %s ",asctime(timeinfo));
    printf("Warning: Unknown language specified.\n");
  }


  return 0;
}

/*
int parse_at()
{
int tokentype;
char token[TOKENSIZE];

  while((tokentype=gettoken(token))!=TOK_EOF)
  {
    if (tokentype==TOK_ENDCODE)
    {
      push(token,tokentype);
      return 0;
    }
      else
    if (tokentype==TOK_EOL || tokentype==TOK_COLON)
    { break; }
      else
    if (strcasecmp(token,"language")==0)
    { fprintf(out,"// LANGUAGE = asp2php converted\n"); }
  }

  return 0;
}
*/

int parse_randomize()
{
int tokentype=-1;
char token[TOKENSIZE];

  while(tokentype!=TOK_EOL)
  {
    tokentype=gettoken(token);
  }

  autoindent();
  fprintf(out,"mt_srand((double)microtime()*1000000);\n");

  return 0;
}

