#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"

/* parse_request() - Request.* object */

int parse_request(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
char token_obj[TOKENSIZE];
char molecule1[LINELENGTH];

  molecule1[0]=0;

  tokentype=gettoken(token);
  if (strcasecmp(token,")")==0)
  {
    push(token,tokentype);
    strcpy(newtoken,"$response");
    return 0;
  }
    else
  if (tokentype!=TOK_PERIOD)
  {
    push(token,tokentype);
    convert_funct(molecule1,"1",1);
    sprintf(newtoken,"${%s}",molecule1);
    return 0;
  }

  tokentype=gettoken(token);

#ifdef DEBUG
printf("parse_request(): %s (type=%i)\n",token,tokentype);
#endif

  if (strcasecmp(token,"servervariables")==0)
  { 
    if ((flags&2)==0)
    {
      strcpy(token_obj,"_SERVER");
      tokentype=gettoken(token);
      if (strcmp(token,"(")==0)
      {
        tokentype=gettoken(token);
        if (strcasecmp(token,"\"URL\"")==0)
        {
          push2("(",TOK_PAREN);
          push("\"PHP_SELF\"",tokentype);
/*
          tokentype=gettoken(token);
          if (strcmp(token,")")==0)
          {
            sprintf(newtoken,"$_SERVER[\"PHP_SELF\"]");
            return 0;
          }

          error(token,")","ServerVariables");
*/
        }
          else
        {
          push2("(",TOK_PAREN);
          push(token,tokentype);
        }
      }
        else
      { push(token,tokentype); }
    }
      else
    {
      convert_funct(molecule1,"1",1);
      sprintf(newtoken,"${%s}",molecule1);
      return 0;
    }
  } 
    else
  if (strcasecmp(token,"form")==0)
  {
    if ((flags&2)==0)
    { strcpy(token_obj,"_POST"); }
      else
    { strcpy(token_obj,"HTTP_POST_VARS"); }
  }
    else
  if (strcasecmp(token,"querystring")==0)
  { 
    if ((flags&2)==0)
    { strcpy(token_obj,"_GET"); }
      else
    { strcpy(token_obj,"HTTP_GET_VARS"); }
  }
    else
  if (strcasecmp(token,"cookies")==0)
  { 
    if ((flags&2)==0)
    { strcpy(token_obj,"_COOKIE"); }
      else
    { strcpy(token_obj,"HTTP_COOKIE_VARS"); }
  }
    else
  if (strcasecmp(token,"clientcertificate")==0)
  { 
    if ((flags&2)==0)
    { strcpy(token_obj,"HTTP_CERTIFICATE_VARS"); }
      else
    { strcpy(token_obj,"HTTP_CERTIFICATE_VARS"); }

    printf("Warning: ClientCertificates are unsupported (line %d)\n",line);
  }
    else
  {
    strcat(newtoken,"// unsupported: "); eval_expression(" "); 
  }

  tokentype=gettoken(token);
/*
printf("Got token: '%s' 1  <<<<<<<<<<<<<<<<\n",token);
  tokentype=gettoken(token);
printf("Got token: %s 2  <<<<<<<<<<<<<<<<\n",token);
  push(token,tokentype);
*/

  if (strcmp(token,".")==0)
  {
    tokentype=gettoken(token);
    if (strcasecmp(token,"count")==0)
    { 
      sprintf(molecule1,"count($%s)",token_obj);
      strcat(newtoken,molecule1);
    }
  }
    else
  if (strcmp(token,"(")==0)
  {
    push(token,tokentype);

    convert_funct(molecule1,"1",1);
    tokentype=gettoken(token);
    if (strcmp(token,".")==0)
    {
      tokentype=gettoken(token);
      if (strcasecmp(token,"count")==0)
      { 
        sprintf(newtoken,"(int)isset($%s[%s])",token_obj,molecule1);
      }
        else
      {
        sprintf(newtoken,"$%s[%s].%s  /* unsupported property */ ",token_obj,molecule1,token);
      }
    }
      else
    {
      sprintf(newtoken,"$%s[%s]",token_obj,molecule1);
      push(token,tokentype);
    }
  }
    else
  {
    push(token,tokentype);
    sprintf(molecule1,"$%s",token_obj);
    strcat(newtoken,molecule1);
  }

#ifdef DEBUG
printf("parse_request() end: %s\n",newtoken);
#endif

  return 0;
}

