   /* code for reading in the BenAri global data structures */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>

#include "../include/globdata.h"
#include "../include/genutil.h"

extern void exit(int);
extern int fprintf(FILE*,const char*,...);
extern int fgetc(FILE*);
extern int fclose(FILE*);
extern int sscanf(const char*,const char*,...);

static BUFFER buf;

static void index_error(char *proc, int expected, int found)
{
   fprintf(stderr,"\n%s:  index mismatch  %d expected   %d found\n",
      proc,expected,found);
   exit(1);
}  /* index_error */

int last_infile;  /* index of last file in InputFile array */

InputFile   *inputfile; /* array of input file information */

int read_code_table(FILE *f, ORDER code[])
{
int   tmp, ix, org_lc, last_lc;
   fgets(buf,MAX_FNAME,f);
   sscanf(buf," %d %d",&org_lc,&last_lc);
   if (org_lc != 0) index_error("read_code_table",0,org_lc); 
   if (last_lc > CMAX) index_error("read_code_table",CMAX,last_lc);
   fgets(buf,MAX_FNAME,f); /* header line */
   for (ix = org_lc; ix <= last_lc; ix++) {
      fgets(buf,MAX_FNAME,f);
      sscanf(buf," %d %d %d %d",&tmp,&code[ix].f,&code[ix].x,&code[ix].y);
      if (tmp != ix) index_error("read_code_table",tmp,ix);
   }
   return last_lc;
}  /* read_code_table */

int read_identifier_table(FILE *f, TAB_STRUCT tab[])
{
int   tmp, ix, first_ix, last_ix;
   fgets(buf,MAX_FNAME,f);
   sscanf(buf," %d %d",&first_ix,&last_ix);
   /* the interpreter doesn't use tab[0], but the compiler DOES    */
   if (first_ix != 1) index_error("read_identifier_table",1,first_ix); 
   if (last_ix > TMAX) index_error("read_identifier_table",TMAX,last_ix);
   fgets(buf,MAX_FNAME,f); /* header line */
   for (ix = 1; ix <= last_ix; ix++) {
      fgets(buf,MAX_FNAME,f);
      sscanf(buf," %d %s %d %d %d %d %d %d %d %d %d",
         &tmp,(char *)&tab[ix].name,&tab[ix].link,(int *)&tab[ix].obj,
         (int *) &tab[ix].typ,&tab[ix].ref,&tab[ix].normal,
         &tab[ix].lev,&tab[ix].adr,&tab[ix].mon, &tab[ix].atomic);
      if (tmp != ix) index_error("read_identifier_table",tmp,ix);
      if (tab[ix].name[0] == '\0'){
         fprintf(stderr,"read_identifier_table:  empty id, index = %d\n", ix);
         exit(1);
      }
   } /* for */
   return last_ix;
}  /* read_identifier_table */

int read_block_table(FILE *f, BTAB_STRUCT btab[])
{
int   tmp, ix, first_b, last_b;
   fgets(buf,MAX_FNAME,f);
   sscanf(buf," %d %d",&first_b,&last_b);
   if (first_b != 0) index_error("read_block_table",0,first_b); 
   if (last_b > BMAX) index_error("read_block_table",BMAX,last_b);
   fgets(buf,MAX_FNAME,f); /* header line */
   for (ix = 0; ix <= last_b; ix++) {
      fgets(buf,MAX_FNAME,f); /* header line */
      sscanf(buf," %d %d %d %d %d",&tmp,&btab[ix].last,
         &btab[ix].lastpar,&btab[ix].psize,&btab[ix].vsize);
      if (tmp != ix) index_error("read_block_table",tmp,ix);
   } /* for */
   return last_b;
}  /* read_block_table */

int read_array_table(FILE *f, ATAB_STRUCT atab[])
{
int   tmp, ix, first_a, last_a;
   fgets(buf,MAX_FNAME,f); 
   sscanf(buf," %d %d",&first_a,&last_a);
   if (first_a != 0) index_error("read_array_table",0,first_a); 
   if (last_a > AMAX) index_error("read_array_table",AMAX,last_a);
   fgets(buf,MAX_FNAME,f); /* header line */
   for (ix = 0; ix <= last_a; ix++) {
      fgets(buf,MAX_FNAME,f); 
      sscanf(buf," %d %d %d %d %d %d %d %d",&tmp,(int *)&atab[ix].inxtyp,
         (int *)&atab[ix].eltyp,&atab[ix].elref,&atab[ix].low,&atab[ix].high,
         &atab[ix].elsize,&atab[ix].size);
      if (tmp != ix) index_error("read_array_table",tmp,ix);
   } /* for */
   return last_a;
}  /* read_array_table */

int read_string_table(FILE *f, char stab[])
{
char c;
int   ix, stop_sx, stop_ix, first_sx, gulpsize;
   fgets(buf,MAX_FNAME,f);
   sscanf(buf," %d %d %d",&first_sx,&stop_sx,&gulpsize); 
   if (first_sx != 0) index_error("read_string_table",0,first_sx); 
   if (stop_sx > SSIZE) index_error("read_string_table",SSIZE,stop_sx);
   if (stop_sx == 0) return 0;
   /* write_string_table() adds a newline '\n' character after each */
   /* group of 'gulpsize' chars.  Only these newlines have to be    */
   /* removed. Any other newlines in stab must be kept.             */
   c = fgetc(f);
   for (ix = 0; ix < stop_sx; ) {
      stop_ix = ix + gulpsize;
      if (stop_ix > stop_sx) stop_ix = stop_sx;
      while (ix < stop_ix) {
         stab[ix++] = c;
         c = fgetc(f);
      }
      if ((c == '\n')&&(ix < stop_sx)) c = fgetc(f);
      if (ix != stop_ix) 
         index_error("read_string_table",stop_ix,ix);
   }   
   return stop_sx;
}  /* read_string_table */

int read_file_info(FILE* f, InputFile** inputfile)
   /*  reads source filenames and nesting information */
{
   InputFile* tmp;
   char tstring[256];
   int ix, dummy, first_infile, last_infile,infile_size;
   fgets(buf,MAX_FNAME,f); 
   sscanf(buf," %d %d",&first_infile,&last_infile);
   if (first_infile != 0) index_error("read_file_info",0,first_infile);
   infile_size = last_infile + 1;
   tmp = (InputFile *) calloc((infile_size), sizeof(InputFile));
   if (tmp == NULL) {
      fprintf(stderr,"Can't get space for infile array");
      exit(1);
   }
   *inputfile = tmp;
   fgets(buf,MAX_FNAME,f); /* header line */
   for (ix = 0; ix < infile_size; ix++) {
      fgets(buf,MAX_FNAME,f);
      sscanf(buf," %d %d %s ", &dummy, &tmp[ix].parent,tstring);
      if (dummy != ix) index_error("read_file_info",ix,dummy);
      tmp[ix].fname = savestr(tstring);
      tmp[ix].line_no = 0;
      tmp[ix].f = NULL;
   }
   return last_infile;
}  /* read_file_info */


int read_debug_info(FILE* f, PCDEBUG dbg[])
   /* reads debugging information */
{
   int   ix, org_lc, last_lc;
   fgets(buf,MAX_FNAME,f);
   sscanf(buf," %d %d",&org_lc,&last_lc);
   if (org_lc != 0) index_error("read_debug_info",0,org_lc); 
   if (last_lc > CMAX) index_error("read_debug_info",CMAX,last_lc);
   fgets(buf,MAX_FNAME,f); /* header line */
   for (ix = org_lc; ix <= last_lc; ix++) {
      fgets(buf,MAX_FNAME,f);
      sscanf(buf," %d %d %d",&dbg[ix].lc,&dbg[ix].fix,&dbg[ix].flno);
   }
   return last_lc;
}  /* read_debug_info */

void check_header(FILE* f)
   /* check header line of a .pob or .pco file */
{
   FNAME_STRING   header;
   fgets(header,MAX_FNAME,f);
   if (strspn(comp_proot,header) != strlen(comp_proot)) {
      fprintf(stderr,"Bad PCODE file header\n");
      fprintf(stderr,"expected: %s\n",comp_proot);
      fprintf(stderr,"found   : %s",header);
      exit(1);
   }
}

void read_pcode_file(FILE *f)
{
   check_header(f);
   fgets(filename_line,MAX_FNAME,f);
   last_code = read_code_table(f,code);
   last_tab = read_identifier_table(f,tab);
   last_btab = read_block_table(f,btab);
   last_atab = read_array_table(f,atab);
   stab_size = read_string_table(f,stab);
   fclose(f);
}  /* read_pcode_file */

void read_entire_pcode_file(FILE *f)
{
   check_header(f);
   fgets(filename_line,MAX_FNAME,f);
   last_code = read_code_table(f,code);
   last_tab = read_identifier_table(f,tab);
   last_btab = read_block_table(f,btab);
   last_atab = read_array_table(f,atab);
   stab_size = read_string_table(f,stab);
   last_infile = read_file_info(f,&inputfile);
   last_dbg_ix = read_debug_info(f,dbg);
   fclose(f);
}  /* read_entire_pcode_file */


/*
 *
 *  $Log: readtab.c,v $
 *  Revision 1.6  1998/07/05 22:38:58  bynum
 *  remove output in readtab, add fcloses
 *
 * Revision 1.5  1997/11/04  06:41:54  bynum
 * add stdlib include for malloc, realloc on AIX
 *
 * Revision 1.4  1997/07/10  17:15:32  bynum
 * add array names to the read_...() function prototypes
 *
 * Revision 1.3  1997/06/17  05:37:17  bynum
 * add global constants for the array sizes, convert the read functions
 * from void to int, add read_entire_pcode_file() for reading dbg info
 *
 * Revision 1.2  1997/03/25  14:31:25  bynum
 * incorporate name changes in include directory, add prototypes, includes,
 * and typecasts to silence the gcc -Wall complaints
 *
 * Revision 1.1  1995/09/07  15:16:36  bynum
 * Initial revision
 *
 *
 */

/*
 *
 *  $Log: readtab.c,v $
 *  Revision 1.6  1998/07/05 22:38:58  bynum
 *  remove output in readtab, add fcloses
 *
 * Revision 1.5  1997/11/04  06:41:54  bynum
 * add stdlib include for malloc, realloc on AIX
 *
 * Revision 1.4  1997/07/10  17:15:32  bynum
 * add array names to the read_...() function prototypes
 *
 * Revision 1.3  1997/06/17  05:37:17  bynum
 * add global constants for the array sizes, convert the read functions
 * from void to int, add read_entire_pcode_file() for reading dbg info
 *
 * Revision 1.2  1997/03/25  14:31:25  bynum
 * incorporate name changes in include directory, add prototypes, includes,
 * and typecasts to silence the gcc -Wall complaints
 *
 * Revision 1.1  1995/09/07  15:16:36  bynum
 * Initial revision
 *
 *
 */
