#!/usr/bin/env python
"""Installs properties using distutils

Run:
	python setup.py install
to install the packages from the source archive.
"""

if __name__ == "__main__":
	import os, sys, string
	try:
		import py2exe
	except ImportError:
		pass
	from distutils.command.install_data import install_data
	from distutils.sysconfig import *
	from distutils.core import setup

	def isPackage( filename ):
		return os.path.isdir(filename) and os.path.isfile( os.path.join(filename,'__init__.py'))
	def packagesFor( filename, basePackage="" ):
		"""Find all packages in filename"""
		set = {}
		for item in os.listdir(filename):
			dir = os.path.join(filename, item)
			if isPackage( dir ):
				if basePackage:
					moduleName = basePackage+'.'+item
				else:
					moduleName = item
				set[ moduleName] = dir
				set.update( packagesFor( dir, moduleName))
		return set
	def npFilesFor( dirname ):
		"""Return all non-python-file filenames in dir"""
		result = []
		allResults = []
		for name in os.listdir(dirname):
			path = os.path.join( dirname, name )
			if os.path.isfile( path) and os.path.splitext( name )[1] not in ('.py','.pyc','.pyo'):
				result.append( path )
			elif os.path.isdir( path ) and name.lower() !='cvs':
				allResults.extend( npFilesFor(path))
		if result:
			allResults.append( (dirname, result))
		return allResults
	def scriptFilesFor( dirname ):
		result = []
		allResults = []
		for name in os.listdir(dirname):
			path = os.path.join( dirname, name )
			if os.path.isfile( path) and os.path.splitext( name )[1] == '.py':
				result.append( path )
			elif os.path.isdir( path ) and name.lower() !='cvs':
				allResults.extend( npFilesFor(path))
		if result:
			allResults.append( (dirname, result))
		return allResults
		
	

	##############
	## Following is from Pete Shinners,
	## apparently it will work around the reported bug on
	## some unix machines where the data files are copied
	## to weird locations if the user's configuration options
	## were entered during the wrong phase of the moon :) .
	from distutils.command.install_data import install_data
	class smart_install_data(install_data):
		def run(self):
			#need to change self.install_dir to the library dir
			install_cmd = self.get_finalized_command('install')
			self.install_dir = getattr(install_cmd, 'install_lib')
			return install_data.run(self)
	##############
	
	packages = packagesFor( "." )
	dataFiles = (
		npFilesFor( 'basictypes') +
		npFilesFor( 'basicproperty') +
		scriptFilesFor( os.path.join('basicproperty','tests'))
	)

	from distutils.sysconfig import *
	from distutils.core import setup

	from sys import hexversion
	if hexversion >= 0x2030000:
		# work around distutils complaints under Python 2.2.x
		extraArguments = {
			'classifiers': [
				"""License :: OSI Approved :: BSD License""",
				"""Programming Language :: Python""",
				"""Topic :: Software Development :: Libraries :: Python Modules""",
				"""Intended Audience :: Developers""",
			],
			'download_url': "https://sourceforge.net/project/showfiles.php?group_id=87034",
			'keywords': 'descriptor,property,basicproperty,coerce,propertied,enumeration',
			'long_description' : """Core data-types and property classes

BasicProperty and BasicTypes provide the core datatypes for
both wxoo and the PyTable RDBMS Wrapper project.
""",
			'platforms': ['Any'],
		}
	else:
		extraArguments = {
		}

	setup (
		name = "basicproperty",
		version = "0.6.3a",
		description = "Core data-types and property classes",
		author = "Mike C. Fletcher",
		author_email = "mcfletch@users.sourceforge.net",
		url = "http://basicproperty.sourceforge.net/",
		license = "BSD-style, see license.txt for details",

		package_dir = packages,

		packages = packages.keys(),
		data_files = dataFiles,
		cmdclass = {'install_data':smart_install_data},
		**extraArguments
	)
	
