#if !defined __FFT8AUX_H
#define      __FFT8AUX_H

#include "fxtaux.h"  /* for SQRT12  */


#define INPUT_SCR_RE \
{\
    t1r=fr[0]+fr[4];\
    t2r=fr[2]+fr[6];\
    t7r=t1r+t2r;\
    t3r=fr[1]-fr[5];\
    t4r=fr[1]+fr[5];\
    t5r=fr[3]+fr[7];\
    t8r=t4r+t5r;\
    t6r=fr[3]-fr[7];\
}

#define INPUT_SCR_IM \
{\
    t1i=fi[0]+fi[4];\
    t2i=fi[2]+fi[6];\
    t7i=t1i+t2i;\
    t3i=fi[1]-fi[5];\
    t4i=fi[1]+fi[5];\
    t5i=fi[3]+fi[7];\
    t8i=t4i+t5i;\
    t6i=fi[3]-fi[7];\
}


#define INPUT_SCR_IM_BACK \
{\
    t1i=-(fi[0]+fi[4]);\
    t2i=-(fi[2]+fi[6]);\
    t7i=+(t1i+t2i);\
    t3i=-(fi[1]-fi[5]);\
    t4i=-(fi[1]+fi[5]);\
    t5i=-(fi[3]+fi[7]);\
    t8i=+(t4i+t5i);\
    t6i=-(fi[3]-fi[7]);\
}


#define INPUT_SCR_RE_0 \
{\
    t7r=(t1r=fr[0])+(t2r=fr[2]);\
    t3r=t4r=fr[1];\
    t5r=t6r=fr[3];\
    t8r=t4r+t5r;\
}

#define INPUT_SCR_IM_0 \
{\
    t7i=(t1i=fi[0])+(t2i=fi[2]);\
    t3i=t4i=fi[1];\
    t5i=t6i=fi[3];\
    t8i=t4i+t5i;\
}



#define INPUT_SCR_IM_0_BACK \
{\
    t7i=(t1i=-fi[0])+(t2i=-fi[2]);\
    t3i=(t4i=-fi[1]);\
    t5i=(t6i=-fi[3]);\
    t8i=t4i+t5i;\
}


#define OUTPUT_RE \
{\
    fr[0]=m0r;\
    fr[1]=s1r+s3r;\
    fr[2]=m2r+m5r;\
    fr[3]=s2r-s4r;\
    fr[4]=m1r;\
    fr[5]=s2r+s4r;\
    fr[6]=m2r-m5r;\
    fr[7]=s1r-s3r;\
}

#define OUTPUT_IM \
{\
    fi[0]=m0i;\
    fi[1]=s1i+s3i;\
    fi[2]=m2i+m5i;\
    fi[3]=s2i-s4i;\
    fi[4]=m1i;\
    fi[5]=s2i+s4i;\
    fi[6]=m2i-m5i;\
    fi[7]=s1i-s3i;\
}


#define OUTPUT_RE_BACK \
{\
    fr[0]=-(m0r);\
    fr[1]=-(s1r+s3r);\
    fr[2]=-(m2r+m5r);\
    fr[3]=-(s2r-s4r);\
    fr[4]=-(m1r);\
    fr[5]=-(s2r+s4r);\
    fr[6]=-(m2r-m5r);\
    fr[7]=-(s1r-s3r);\
}

#define OUTPUT_IM_BACK \
{\
    fi[0]=-(m0i);\
    fi[1]=-(s1i+s3i);\
    fi[2]=-(m2i+m5i);\
    fi[3]=-(s2i-s4i);\
    fi[4]=-(m1i);\
    fi[5]=-(s2i+s4i);\
    fi[6]=-(m2i-m5i);\
    fi[7]=-(s1i-s3i);\
}

/* sd: */

#define INPUT_SCR_RE \
{\
    t1r=fr[0]+fr[4];\
    t2r=fr[2]+fr[6];\
    t7r=t1r+t2r;\
    t3r=fr[1]-fr[5];\
    t4r=fr[1]+fr[5];\
    t5r=fr[3]+fr[7];\
    t8r=t4r+t5r;\
    t6r=fr[3]-fr[7];\
}

#define INPUT_SCR_IM \
{\
    t1i=fi[0]+fi[4];\
    t2i=fi[2]+fi[6];\
    t7i=t1i+t2i;\
    t3i=fi[1]-fi[5];\
    t4i=fi[1]+fi[5];\
    t5i=fi[3]+fi[7];\
    t8i=t4i+t5i;\
    t6i=fi[3]-fi[7];\
}


#define INPUT_SCR_RE_0 \
{\
    t7r=(t1r=fr[0])+(t2r=fr[2]);\
    t3r=t4r=fr[1];\
    t5r=t6r=fr[3];\
    t8r=t4r+t5r;\
}

#define INPUT_SCR_IM_0 \
{\
    t7i=(t1i=fi[0])+(t2i=fi[2]);\
    t3i=t4i=fi[1];\
    t5i=t6i=fi[3];\
    t8i=t4i+t5i;\
}

#define OUTPUT_SCR_RE \
{\
    fr[0]=m0r;\
    fr[4]=s1r+s3r;\
    fr[2]=m2r+m5r;\
    fr[6]=s2r-s4r;\
    fr[1]=m1r;\
    fr[5]=s2r+s4r;\
    fr[3]=m2r-m5r;\
    fr[7]=s1r-s3r;\
}

#define OUTPUT_SCR_IM \
{\
    fi[0]=m0i;\
    fi[4]=s1i+s3i;\
    fi[2]=m2i+m5i;\
    fi[6]=s2i-s4i;\
    fi[1]=m1i;\
    fi[5]=s2i+s4i;\
    fi[3]=m2i-m5i;\
    fi[7]=s1i-s3i;\
}

#define OUTPUT_SCR_REV_RE \
{\
    fr[0]=m0r;\
    fr[7]=s1r+s3r;\
    fr[3]=m2r+m5r;\
    fr[5]=s2r-s4r;\
    fr[1]=m1r;\
    fr[6]=s2r+s4r;\
    fr[2]=m2r-m5r;\
    fr[4]=s1r-s3r;\
}

#define OUTPUT_SCR_REV_IM \
{\
    fi[0]=m0i;\
    fi[7]=s1i+s3i;\
    fi[3]=m2i+m5i;\
    fi[5]=s2i-s4i;\
    fi[1]=m1i;\
    fi[6]=s2i+s4i;\
    fi[2]=m2i-m5i;\
    fi[4]=s1i-s3i;\
}


/* cl: */

#define INPUT_RE \
{\
    t1r=fr[0]+fr[1];\
    t2r=fr[2]+fr[3];\
    t7r=t1r+t2r;\
    t3r=fr[4]-fr[5];\
    t4r=fr[4]+fr[5];\
    t5r=fr[6]+fr[7];\
    t8r=t4r+t5r;\
    t6r=fr[6]-fr[7];\
}

#define INPUT_IM \
{\
    t1i=fi[0]+fi[1];\
    t2i=fi[2]+fi[3];\
    t7i=t1i+t2i;\
    t3i=fi[4]-fi[5];\
    t4i=fi[4]+fi[5];\
    t5i=fi[6]+fi[7];\
    t8i=t4i+t5i;\
    t6i=fi[6]-fi[7];\
}

#define OUTPUT_RE \
{\
    fr[0]=m0r;\
    fr[1]=s1r+s3r;\
    fr[2]=m2r+m5r;\
    fr[3]=s2r-s4r;\
    fr[4]=m1r;\
    fr[5]=s2r+s4r;\
    fr[6]=m2r-m5r;\
    fr[7]=s1r-s3r;\
}

#define OUTPUT_IM \
{\
    fi[0]=m0i;\
    fi[1]=s1i+s3i;\
    fi[2]=m2i+m5i;\
    fi[3]=s2i-s4i;\
    fi[4]=m1i;\
    fi[5]=s2i+s4i;\
    fi[6]=m2i-m5i;\
    fi[7]=s1i-s3i;\
}


#define OUTPUT_REV_RE \
{\
    fr[0]=m0r;\
    fr[7]=s1r+s3r;\
    fr[6]=m2r+m5r;\
    fr[5]=s2r-s4r;\
    fr[4]=m1r;\
    fr[3]=s2r+s4r;\
    fr[2]=m2r-m5r;\
    fr[1]=s1r-s3r;\
}

#define OUTPUT_REV_IM \
{\
    fi[0]=m0i;\
    fi[7]=s1i+s3i;\
    fi[6]=m2i+m5i;\
    fi[5]=s2i-s4i;\
    fi[4]=m1i;\
    fi[3]=s2i+s4i;\
    fi[2]=m2i-m5i;\
    fi[1]=s1i-s3i;\
}



#define OUTPUT_RE_BACK \
{\
    fr[0]=-(m0r);\
    fr[1]=-(s1r+s3r);\
    fr[2]=-(m2r+m5r);\
    fr[3]=-(s2r-s4r);\
    fr[4]=-(m1r);\
    fr[5]=-(s2r+s4r);\
    fr[6]=-(m2r-m5r);\
    fr[7]=-(s1r-s3r);\
}

#define OUTPUT_IM_BACK \
{\
    fi[0]=-(m0i);\
    fi[1]=-(s1i+s3i);\
    fi[2]=-(m2i+m5i);\
    fi[3]=-(s2i-s4i);\
    fi[4]=-(m1i);\
    fi[5]=-(s2i+s4i);\
    fi[6]=-(m2i-m5i);\
    fi[7]=-(s1i-s3i);\
}


#endif /* !defined __FFT8AUX_H */
