      SUBROUTINE MFFTOV(C,IVS,IES,NV,NE,INDEX,ITEMP)
*
*   PURPOSE :
*     THIS ROUTINE PERFORMS A REORDERING OF A VECTOR-OF-VECTORS
*     OF COMPLEX C[IVS,NV [IES,NE]], ACCORDING TO A
*     PERMUTATION INDEX "INDEX".
*     SEE REF.[1] FOR NOTATIONS, AND COMMENTS TO MFFTDV.
*  ARGUMENTS
*     C : VECTOR-OF-VECTORS TO BE REORDERED
*     IVS,IES,NV,NE: THESE ARGUMENTS DESCRIBE THE STRUCTURE OF
*     C, ACCORDING TO THE ABOVE DEFINITION;
*     INDEX: INTEGER ARRAY , CONTAINING THE PERMUTATION INDEX ;
*            IT IS NV ELEMENTS LONG; PREPARED BY MFFTP.
*     IWORK: INTEGER ARRAY, OF LENGTH AT LEAST NV, USED AS WORKSPACE;
*
      INTEGER INDEX(0:NV-1),ITEMP(0:NV-1)
      COMPLEX C(IVS,0:*),T
 
      NEIES=NE*IES
      DO 1 I=0,NV-1
1     ITEMP(I)=INDEX(I)
 
      DO 4 I=1,NV-3
2       IF(ITEMP(I).NE.I)THEN
          IDEST=ITEMP(I)
          DO 3 J=1,NEIES,IES
            T=C(J,I)
            C(J,I)=C(J,IDEST)
            C(J,IDEST)=T
3         CONTINUE
          ITEMP(I)=ITEMP(IDEST)
          ITEMP(IDEST)=IDEST
        GOTO 2
        ENDIF
4     CONTINUE
      END
