      SUBROUTINE MFFTRI(C,ISV,ISE,NV,NE,RW)
*
*   PURPOSE:
*       THIS ROUTINE PERFORMS THE PRE-PROCESSING PHASE FOR
*       REAL 2-DIMENSIONAL INVERSE DFT'S (SEE FORMULA (2.7)
*       IN REF.[1]).
*       PRE-PROCESSING ACTS ON SEQUENTAL DATA BEFORE A CALL TO
*       MFFTOV AN BEFORE COMPUTING THE IDFT (A CALL TO MFFTIV)
*       AND EVENTUAL REORDERING (CALLS TO MFFTIV AND MFFTOV).
*       IT APPLIES TO A VECTOR-OF-VECTORS-OF-COMPLEX
*               C[IVS,NV [IES,NE]].
*       SEE REF.[1] FOR NOTATIONS.
*
*   ARGUMENTS:
*      INPUT:
*       C : DATA ARRAY, OUTPUT FROM MFFTDV, MFFTOV; TO BE DECLARED
*                      REAL C(ISE*2,NE)
*           IN THE CALLING PROGRAM.
*     ISV : SEPARATION OF ELEMENTS IN A COLUMN OF C (USUALLY 1)
*     ISE : SEPARATION OF ELEMENTS IN A ROW OF C, DIVIDED BY 2
*      NV : NO. OF ELEMENTS TO BE PROCESSED IN A COLUMN OF C
*      NE : NO. OF ELEMENTS IN A ROW OF C, DIVIDED BY 2.
*      RW : COMPLEX ARRAY OF LENGHT AT LEAST NV; IT MUST
*           BE INITIALIZED BY A CALL TO MFFTRP; IT REMAINS
*           UNCHANGED IN OUTPUT.
*
*  OUTPUT : POST-PROCESSED ARRAY C
*
*
      COMPLEX C(0:ISV-1,0:*),RW(0:*),T1,T2
*
*
      IF(NV.GT.1) THEN
*
      DO 200 IV=1,(NV-1)/2
        DO 190 IE=0,(NE-1)*ISE,ISE
        T1=C(IE,IV)
        T2=C(IE,NV-IV)
*
        C(IE,IV)=(T1+CONJG(T2))+(CONJG(RW(IV))*(T1-CONJG(T2)))
        C(IE,NV-IV)=CONJG(T1+CONJG(T2))-CONJG(CONJG(RW(IV))*(T1-
     $              CONJG(T2)))
 
 
 190    CONTINUE
 200   CONTINUE
*
*
        IF(2*IV.EQ.NV) THEN
*
        DO 210 IE=0,(NE-1)*ISE,ISE
        C(IE,IV)=2*CONJG(C(IE,IV))
 210   CONTINUE
*
*
      ENDIF
*
      ENDIF
*
*
      DO 220 IE=0,(NE-1)*ISE,ISE
         RP=REAL(C(IE,0))+REAL(C(IE,NV))
         RM=REAL(C(IE,0))-REAL(C(IE,NV))
         C(IE,0)=CMPLX(RP,RM)
 220  CONTINUE
*
*
      END
