.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH BIBINDEX 1 "31 March 1998" "Version 2.9"
.SH NAME
bibindex \- create a bibliography index file for \fBbiblook\fP(1)
.SH SYNOPSIS
.B "bibindex \fIbasename\fP [[\-i] keyword .\|.\|.]
.SH DESCRIPTION
.I bibindex
creates a compact binary index file from a \*(Bi\& bibliography file
to permit fast lookup by \fIbiblook\fP(1).  The \fIbasename\fP
argument can optionally omit the \fI.bib\fP extension.  The output
index file will be named with the same basename, and extension
\fI.bix\fP .
.PP
For indexing purposes, a word is any contiguous set of letters and
numbers, \fIafter\fP the following steps:
.RS
.TP \w'1.'u+2n
0.
Single characters and a few very common words ("an", "and", "for",
"in", "of", "on", "the", "to", and "with") are never indexed.
.TP
1.
Letters are folded to lower case.  Thus, "Voronoi" is indexed as
"voronoi".
.TP
2.
All \*(Te\& commands, except those in math expressions, are removed,
but their arguments are left behind.  Thus, "Erd{\\H o}ss" is indexed
as "erdos".
.TP
3.
All other non-alphanumeric characters are removed.  Non-word
characters inside {{possibly} nested} braces or dollar signs do not
delimit words, so they may cause unexpected results.  Within braces,
spaces and tabs delimit components of compound words, which are
indexed both as a unit and as individual components.  Thus, "{this
example}" is indexed as "this example thisexample".
.TP
4.
\*(Te\& commands in math expressions are considered normal text.
However, each contiguous string of letters and numbers is considered a
component of a compound word.  Thus, "$O(n\\log^2 n)$" is indexed as
"log onlog2n" instead of "on2".
.TP
5.
Apostrophes and brackets are ignored.  Thus, "{\\'O}'D{\\'u}nlaing" is
indexed as "odunlaing", and "J[ohn]" is indexed as "john".
.TP
6.
Single hyphens separate components of compound words.  Thus,
"semi-on-line" is indexed as "semi line semionline".  (Recall that
"on" is ignored.)
.RE
.PP
\fIbibindex\fP examines the contents of all value strings, and expects
them to be well-formed \*(Te\& input.  In particular, braces,
quotation marks, and dollar signs should be balanced.
.PP
Errors detected result in a message giving the line number of the
\*(Bi\& entry in which the error was detected, and the line number at
the point of the error.  Unbalanced braces or dollar signs can result
in large differences between these line numbers; in such a case, the
error is somewhere in the entry indicated by the first line number.
.SH OPTIONS
.TP \w'\-i'u+2n
.B \-i \fIkeyword\fP .\|.\|.
Add \fIkeyword\fP to the list of \*(Bi\& keywords that are to be
ignored, along with their string values, in preparing the index.  By
default, all \fIkeyword = "value"\fP pairs are indexed.  Any number
of keywords may be specified after the \-i flag.
.SH ENVIRONMENT
.TP
.B BIBINDEXFLAGS
Default list of options, used if and only if no options are given on
the command line.  The proper syntax to ensure that all fields are
indexed, even though BIBINDEXOPTS is set, is "bibindex \fIbasename\fP
\-i".
.SH "SEE ALSO"
bibclean(1), biblook(1), bibtex(1), latex(1), tex(1)
.SH AUTHORS
Jeff Erickson <jeffe@cs.duke.edu> and Bill Jones <jones@cs.usask.ca>,
with significant contributions from Nelson Beebe, Sariel Har-Peled,
and Erik Schoenfelder
.PP
This program is in the public domain.  You may use it or modify it to
your heart's content, at your own risk.
.PP
The most current version of biblook and bibindex is archived at the URL
"http://www.cs.duke.edu/~jeffe/biblook.html".
.\" =======================[End of bibindex.man]========================
