#! /bin/sh
# This script configures and builds an optimized version of bibparse on
# all local systems at the University of Utah Mathematics and Physics
# Departments.
#
# Usage:
#	./BUILD-BIBPARSE.sh
#
# [08-May-1999]

# Default C compiler
CC=c89
YACC=yacc

# Adjustments for particular systems

case "`uname -s`" in
	AIX)
		CC=c89
		OPT='-O3 -qarch=ppc'
		# Don't use -qarch=ppc: AIX doesn't emulate those extra instructions
		# on older models that lack them, sigh... Sun does a much better job
		OPT='-O3'
		;;
	HP-UX)
		CC=c89
		OPT='+O4'
		;;
	IRIX)
		CC='cc -cckr'
		OPT='-O2'
		# IRIX 5.3 yacc quits with ``Redeclaration of precedence of ASGNOP, line 75''
		# so switch to bison, sigh...
		YACC='bison -y'
		;;
	IRIX64)
		CC=c89
		OPT='-O2'
		;;
	Linux)
		CC=gcc
		OPT='-O3'	
		;;
	Mach)
		CC=gcc
		OPT='-O3 -m68030'
		;;
	OSF1)
		CC=c89
		OPT=-O4
		;;
	SunOS)
		case "`uname -r`" in
			4.*)
				CC='acc'
				OPT='-O2 -dalign -libmil -cg89'
				;;
			5.5)
				CC="gcc -ansi"
				CC=c89
				OPT='-xO5 -dalign -xlibmil -fsimple=2 -fns -xsafe=mem -xtarget=ultra1/2200'
				;;
			5.*)
				CC="gcc -ansi"
				CC=c89
				OPT='-xO5 -dalign -xlibmil -fsimple=2 -fns -xsafe=mem -xtarget=ultra2/2300'
				;;
			*)
				echo "Unrecognized SunOS version...proceeding with defaults and fingers crossed :^)"
				CC=c89
				OPT='-O'
				;;
		esac
		;;
	*)
		echo "Unrecognized operating system...proceeding with defaults and fingers crossed :^)"
		OPT='-O'
		;;
esac

if test -f Makefile 
then
	make distclean
else
	rm -f *.o config.cache config.log config.status awklex maketab \
		proctab.c ytab.c ytab.h
fi

echo 'CC             =' $CC
echo 'OPT            =' $OPT
echo 'YACC           =' $YACC

env CC="${CC}" ./configure && make OPT="$OPT" YACC="${YACC}" all check
