/* /u/sy/beebe/tex/biblex/bibyydcl.h, Sat Jan 16 16:24:55 1993 */
/* Edit by Nelson H. F. Beebe <beebe@plot79.math.utah.edu> */

#ifndef BIBYYDCL_H
#define BIBYYDCL_H

/***********************************************************************
This file contains function prototypes of lex library functions.

We need them because most current lex implementations do not generate
prototypes in the output C code, making it impossible to compile the
code with C++ compilers.

flex implementations do not require most of these prototypes.

There are also variations in the types of some of these functions
which we must handle by preprocessor conditionals below.
***********************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

extern void		yyerror ARGS((const char *s_));
extern int		yylex ARGS((void));
extern int		yyparse ARGS((void));
extern int		yywrap ARGS((void));

#if defined(__cplusplus)
}
#endif

#if defined(FLEX_SCANNER)
#define input		yyinput
#define output		putchar

#if !defined(HAVE_FILENO)
#define YY_NEVER_INTERACTIVE 1	/* suppresses need for isatty() and fileno() */
#endif

#else /* NOT defined(FLEX_SCANNER) */

#if defined(__cplusplus) && defined(__sun)
/* Sun Solaris 2.x lex changed the names of these functions under C++ */
#define input lex_input
#define output lex_output
#endif

#endif /* defined(FLEX_SCANNER) */

#endif /* BIBYYDCL_H */
