#include <stdio.h>
#include <stdlib.h>
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# ifndef YYLMAX 
#define YYLMAX BIBYYLMAX
# endif 
#ifndef __cplusplus
# define output(c) (void)putc(c,yyout)
#else
# define lex_output(c) (void)putc(c,yyout)
#endif

#if defined(__cplusplus) || defined(__STDC__)

#if defined(__cplusplus) && defined(__EXTERN_C__)
extern "C" {
#endif
	int yyback(int *, int);
	int yyinput(void);
	int yylook(void);
	void yyoutput(int);
	int yyracc(int);
	int yyreject(void);
	void yyunput(int);
	int yylex(void);
#ifdef YYLEX_E
	void yywoutput(wchar_t);
	wchar_t yywinput(void);
#endif
#ifndef yyless
	int yyless(int);
#endif
#ifndef yywrap
	int yywrap(void);
#endif
#ifdef LEXDEBUG
	void allprint(char);
	void sprint(char *);
#endif
#if defined(__cplusplus) && defined(__EXTERN_C__)
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
	void exit(int);
#ifdef __cplusplus
}
#endif

#endif
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
#ifndef __cplusplus
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#else
# define lex_input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#endif
#define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng;
#define YYISARRAY
char yytext[131072];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
 /**********************************************************************
 @Lex-file{
    author              = "Nelson H. F. Beebe",
    version             = "1.03",
    date                = "02 June 1998",
    time                = "17:56:46 MDT",
    filename            = "bibunlex.l",
    address             = "Center for Scientific Computing
                           University of Utah
                           Department of Mathematics, 322 INSCC
                           155 S 1400 E RM 233
                           Salt Lake City, UT 84112-0090
                           USA",
    telephone           = "+1 801 581 5254",
    FAX                 = "+1 801 585 1640, +1 801 581 4148",
    URL                 = "http://www.math.utah.edu/~beebe",
    checksum            = "15084 502 1155 9600",
    email               = "beebe@math.utah.edu, beebe@acm.org,
                           beebe@ieee.org (Internet)",
    codetable           = "ISO/ASCII",
    keywords            = "BibTeX, bibliography, lexical analysis, lexer",
    supported           = "yes",
    docstring           = "Convert a lexical token stream from biblex
                           or bibclean back into a BibTeX file on
                           stdout.

                           Usage:
				bibunlex < infile > outfile
			   or
				bibunlex file(s) >outfile

			   This utility can be conveniently used at
                           the end of a biblex or bibclean pipeline
                           that filters BibTeX files for some purpose.

                           The checksum field above contains a CRC-16
                           checksum as the first value, followed by the
                           equivalent of the standard UNIX wc (word
                           count) utility output of lines, words, and
                           characters.  This is produced by Robert
                           Solovay's checksum utility.",
 }
 **********************************************************************/

#include <config.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#if defined(HAVE_STDLIB_H)
#include <stdlib.h>
#endif

#include "args.h"
#include "bibyydcl.h"
#include "token.h"


# line 61 "bibunlex.l"
/* Token types for biblex/bibclean token stream grammar */

#if NEW_STYLE
typedef enum t_list {
    T_NUMBER = 2001,
    T_NAME,
    T_UNKNOWN,
    T_VALUE
} biblex_token_t;
#else /* NOT NEW_STYLE */
typedef int biblex_token_t;
#define T_NUMBER	2001
#define T_NAME		2002
#define T_UNKNOWN	2003
#define T_VALUE		2004
#endif /* NEW_STYLE */

#define digval(c)	((int)((c) - '0'))
#define isoctal(c)	(isdigit(c) && ((c) != '8') && ((c) != '9'))
#define ishexadecimal(c) (isdigit(c) || \
				(strchr("ABCDEFabcdef",(c)) != (char*)NULL))

static void		bad_token ARGS((void));
static void		dounlex ARGS((void));
static int		hexval ARGS((int c_));
int			main ARGS((int argc_, char *argv_[]));
static void		out_s ARGS((char *s_));
static void		out_space ARGS((int n_));
static void		out_string ARGS((const char *s_));
static void		out_token ARGS((token_t token_));
static char		*unescape ARGS((char *s_));

static long		line_number = 1L;
static long		line_width = 0L;
static const char	*the_filename = "";

#define	ERROR_PREFIX	"??"	/* this prefixes all error messages */

#define FIELD_INDENTATION 2	/* how far to indent "field = value," pairs */

#if !defined(MAX_FIELD_LENGTH)
#define MAX_FIELD_LENGTH 12	/* "howpublished" */
#endif /* !defined(MAX_FIELD_LENGTH) */

#define VALUE_INDENTATION	(FIELD_INDENTATION + MAX_FIELD_LENGTH + 3)

#undef YYLMAX

#if defined(HAVE_IBMPC)
#define YYLMAX BIBYYLMAX
#else
#define YYLMAX BIBYYLMAX
#endif

  /* here is a lex grammar for the bibclean and biblex output token stream */

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
#ifdef __cplusplus
/* to avoid CC and lint complaining yyfussy not being used ...*/
static int __lex_hack = 0;
if (__lex_hack) goto yyfussy;
#endif
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:

# line 121 "bibunlex.l"
;
break;
case 2:

# line 123 "bibunlex.l"
	return (T_NUMBER);
break;
case 3:

# line 125 "bibunlex.l"
	return (T_NAME);
break;
case 4:

# line 127 "bibunlex.l"
	;
break;
case 5:

# line 129 "bibunlex.l"
	return (T_VALUE);
break;
case 6:

# line 131 "bibunlex.l"
	line_number++;
break;
case 7:

# line 133 "bibunlex.l"
	return (T_UNKNOWN);
break;
case -1:
break;
default:
(void)fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

# line 135 "bibunlex.l"
static void
bad_token(VOID)
{
    (void)fprintf(stderr,"%s \"%s\", line %ld: %s [%s].\n",
		  ERROR_PREFIX,
		  the_filename,
		  line_number,
		  "Unrecognized token",
		  yytext);
}


static void
dounlex(VOID)
{
    biblex_token_t type;
    token_t token = TOKEN_UNKNOWN;

    line_number = 1L;
    while ((type = (biblex_token_t)yylex()) > 0)
    {
	switch (type)
	{
	case T_NUMBER:
	    token = (token_t)atoi((const char*)&yytext[0]);
	    break;

	case T_NAME:
	    break;			/* discard name */

	case T_VALUE:
	    out_token(token);
	    break;

	default:
	case T_UNKNOWN:
	    bad_token();
	    break;
	}
    }
}


#if NEW_STYLE
static int
hexval(int c)
#else /* K&R style */
static int
hexval(c)
int c;
#endif /* NEW_STYLE */
{
    static const char *hexdigits = "0123456789abcdef";
    const char *p = (const char *)strchr(hexdigits,
	isupper(c) ? tolower(c) : c);

    return ((p == (const char*)NULL) ? (-1) : (int)(p - hexdigits));
}


#if NEW_STYLE
int
main(int argc, char *argv[])
#else /* K&R style */
int
main(argc, argv)
int argc;
char *argv[];
#endif /* NEW_STYLE */
{
    int k;
    FILE *fp;

    if (argc > 1)		/* files to unlex named on command line */
    {
	for (k = 1; k < argc; ++k)
	{
	    fp = freopen(argv[k],"r",stdin);
	    if (fp == (FILE*)NULL)
	    {
		(void)fprintf(stderr,
		    "\n%s Ignoring open failure on file [%s]\n",
		    ERROR_PREFIX, argv[k]);
		(void)perror("perror() says");
	    }
	    else
	    {
		the_filename = argv[k];
		dounlex();
		(void)fclose(fp);
	    }
	}
    }
    else				/* unlex stdin */
    {
	the_filename = "stdin";
	dounlex();
    }
    exit (EXIT_SUCCESS);
    return (0);
}


#if NEW_STYLE
static void
out_s(char *s)			/* output a string, wrapping long lines */
#else /* K&R style */
static void
out_s(s)			/* output a string, wrapping long lines */
char *s;
#endif /* NEW_STYLE */
{				/* s[] is modified on return */
    s[strlen(s)-1] = '\0';	/* zap final quote */
    out_string(unescape(s+1)); /* discard initial quote */
}


#if NEW_STYLE
static void
out_space(int n)
#else /* K&R style */
static void
out_space(n)
int n;
#endif /* NEW_STYLE */
{
    for ( ; n > 0 ; --n)
	out_string(" ");
}


#if NEW_STYLE
static void
out_string(const char *s)
#else /* K&R style */
static void
out_string(s)
const char *s;
#endif /* NEW_STYLE */
{
    for (; *s; ++s)
    {
	switch (*s)
	{
	case '\r':
	case '\n':
	    line_width = 0L;
	    break;

	case '\t':
	    line_width = (line_width + 7L) & ~7L;
	    break;

	default:
	    line_width++;
	    break;
	}
	putchar(*s);
    }
}


#if NEW_STYLE
static void
out_token(token_t token)
#else /* K&R style */
static void
out_token(token)
token_t token;
#endif /* NEW_STYLE */
{		/* ALL token output is directed through this function */
    static token_t last_token = TOKEN_UNKNOWN;

    switch (token)
    {
    case TOKEN_ABBREV:
	if (last_token == TOKEN_EQUALS)
	    out_space((int)(VALUE_INDENTATION - line_width));
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_AT:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_COMMA:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_COMMENT:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_ENTRY:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_EQUALS:
	if (last_token != TOKEN_SPACE)
	    out_space(1);
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_FIELD:
	if (last_token != TOKEN_SPACE)
	    out_space(FIELD_INDENTATION);
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_INCLUDE:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_INLINE:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_KEY:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_LBRACE:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_LITERAL:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_NEWLINE:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_PREAMBLE:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_RBRACE:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_SHARP:
	if (last_token != TOKEN_SPACE)
	    out_space(1);
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_SPACE:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_STRING:
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_VALUE:
	if (last_token != TOKEN_SPACE)
	    out_space((int)(VALUE_INDENTATION - line_width));
	out_s((char*)&yytext[0]);
	break;

    case TOKEN_UNKNOWN:
    default:
	bad_token();
	break;
    }
    last_token = token;
}


#if NEW_STYLE
static char*
unescape(char *s)	/* convert escape sequences to chars in place */
#else /* K&R style */
static char*
unescape(s)
char *s;
#endif /* NEW_STYLE */
{
    int c;
    int n;
    char *original = s;
    char *t;				/* target string (overwrites s[]) */

    for (t = s ; *s; )
    {
	switch (*s)
	{
	case '\\':
	    ++s;
	    switch (*s)
	    {
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
		for (n = 0, c = digval(*s), ++s; (n < 3) && isoctal(*s);
		    n++, s++)
		    c = 8*c + digval(*s);
		break;

	    case 'a':
		++s;
		c = '\007';		/* '\a' */
		break;

	    case 'b':
		++s;
		c = '\b';
		break;

	    case 'f':
		++s;
		c = '\f';
		break;

	    case 'n':
		++s;
		c = '\n';
		break;

	    case 'r':
		++s;
		c = '\r';
		break;

	    case 't':
		++s;
		c = '\t';
		break;

	    case 'v':
		++s;
		c = '\v';
		break;

	    case 'x':
		for (++s, c = hexval(*s); ishexadecimal(*s); ++s)
		    c = 16*c + hexval(*s);
		break;

	    default:
		c = *s++;
	    }
	    *t++ = c;
	    break;

	default:
	    *t++ = *s++;
	    break;
	}
    }
    *t = '\0';
    return (original);
}


#if defined(HAVE_IBMPC)
int
yywrap(VOID)
{
    return 1;
}
#endif
int yyvstop[] = {
0,

7,
0, 

4,
7,
0, 

6,
0, 

7,
-5,
0, 

3,
7,
0, 

7,
-1,
0, 

2,
7,
0, 

-5,
0, 

5,
0, 

3,
0, 

-1,
0, 

1,
0, 

2,
0, 
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	6,10,	0,0,	0,0,	
0,0,	1,4,	0,0,	1,5,	
6,10,	0,0,	6,11,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,6,	
1,3,	2,8,	6,10,	6,10,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,3,	2,9,	0,0,	
6,10,	9,15,	9,15,	9,15,	
9,15,	9,15,	9,15,	9,15,	
9,15,	9,15,	9,15,	0,0,	
0,0,	0,0,	1,7,	0,0,	
0,0,	6,10,	7,12,	7,12,	
7,12,	7,12,	7,12,	7,12,	
7,12,	7,12,	7,12,	7,12,	
7,12,	7,12,	7,12,	7,12,	
7,12,	7,12,	7,12,	7,12,	
7,12,	7,12,	7,12,	7,12,	
7,12,	7,12,	7,12,	7,12,	
8,13,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	8,13,	
0,0,	8,14,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	8,13,	8,13,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	8,13,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
8,13,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-2,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+-4,	0,		yyvstop+8,
yycrank+5,	0,		yyvstop+11,
yycrank+-95,	0,		yyvstop+14,
yycrank+5,	0,		yyvstop+17,
yycrank+0,	yysvec+6,	yyvstop+20,
yycrank+0,	0,		yyvstop+22,
yycrank+0,	yysvec+7,	yyvstop+24,
yycrank+0,	yysvec+8,	yyvstop+26,
yycrank+0,	0,		yyvstop+28,
yycrank+0,	yysvec+9,	yyvstop+30,
0,	0,	0};
struct yywork *yytop = yycrank+160;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
  0,   1,   1,   1,   1,   1,   1,   1, 
  8,   8,  10,   8,   8,   8,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  8,   1,  34,  35,   1,  35,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
 48,  48,  48,  48,  48,  48,  48,  48, 
 48,  48,   1,   1,   1,   1,   1,  35, 
  1,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,  65,  65,  65,  65,  65, 
 65,  65,  65,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
0};
char yyextra[] = {
0,1,0,0,0,1,0,0,
0};
/*	Copyright (c) 1989 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#pragma ident	"@(#)ncform	6.11	97/01/06 SMI"

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
#if defined(__cplusplus) || defined(__STDC__)
int yylook(void)
#else
yylook()
#endif
{
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
#ifndef __cplusplus
			*yylastch++ = yych = input();
#else
			*yylastch++ = yych = lex_input();
#endif
#ifdef YYISARRAY
			if(yylastch > &yytext[YYLMAX]) {
				fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
				exit(1);
			}
#else
			if (yylastch >= &yytext[ yytextsz ]) {
				int	x = yylastch - yytext;

				yytextsz += YYTEXTSZINC;
				if (yytext == yy_tbuf) {
				    yytext = (char *) malloc(yytextsz);
				    memcpy(yytext, yy_tbuf, sizeof (yy_tbuf));
				}
				else
				    yytext = (char *) realloc(yytext, yytextsz);
				if (!yytext) {
				    fprintf(yyout,
					"Cannot realloc yytext\n");
				    exit(1);
				}
				yylastch = yytext + x;
			}
#endif
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
#ifndef __cplusplus
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
#else
		yyprevious = yytext[0] = lex_input();
		if (yyprevious>0)
			lex_output(yyprevious);
#endif
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
#if defined(__cplusplus) || defined(__STDC__)
int yyback(int *p, int m)
#else
yyback(p, m)
	int *p;
#endif
{
	if (p==0) return(0);
	while (*p) {
		if (*p++ == m)
			return(1);
	}
	return(0);
}
	/* the following are only used in the lex library */
#if defined(__cplusplus) || defined(__STDC__)
int yyinput(void)
#else
yyinput()
#endif
{
#ifndef __cplusplus
	return(input());
#else
	return(lex_input());
#endif
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyoutput(int c)
#else
yyoutput(c)
  int c; 
#endif
{
#ifndef __cplusplus
	output(c);
#else
	lex_output(c);
#endif
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyunput(int c)
#else
yyunput(c)
   int c; 
#endif
{
	unput(c);
	}
