/*
 * Copyright (c) 2001 Tommy Bohlin <tommy@gatespace.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* obexformat.h
 */

/**********************************************************************
 * Constants
 **********************************************************************/

#define TYPE_UNICODE             0x00
#define TYPE_BYTES               0x40
#define TYPE_INT1                0x80
#define TYPE_INT4                0xc0
#define TYPE_MASK                0xc0

#define HI_COUNT                 0x00
#define HI_NAME                  0x01
#define HI_TYPE                  0x02
#define HI_LENGTH                0x03
#define HI_DATE                  0x04
#define HI_DESCRIPTION           0x05
#define HI_TARGET                0x06
#define HI_HTTP                  0x07
#define HI_BODY                  0x08
#define HI_END_OF_BODY           0x09
#define HI_WHO                   0x0a
#define HI_CONNECTION_ID         0x0b
#define HI_APP_PARAMETERS        0x0c
#define HI_AUTH_CHALLENGE        0x0d
#define HI_AUTH_RESPONSE         0x0e
#define HI_CLASS                 0x0f

/**********************************************************************
 * Functions
 **********************************************************************/

void putName(const void* name, int len);
void putLength(int len);
void putDate(int date);
void putDescription(const void* desc, int len);
void putClass(int class);
void putBody(const void* body, int len);
void putEndOfBody(const void* body, int len);
