/*
 * rules.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "rules";

/*
** GLOBALS
*/

	static long undefined[] = {5119};
long G_rules_HASHEDRULENAMES_NR0B = 0;
value G_rules_HASHEDRULENAMES_NR0 = &G_rules_HASHEDRULENAMES_NR0B;
long G_rules_RULENAMES_NR1B = 0;
value G_rules_RULENAMES_NR1 = &G_rules_RULENAMES_NR1B;
long G_rules_RULENRS_NR2B = 0;
value G_rules_RULENRS_NR2 = &G_rules_RULENRS_NR2B;
long G_rules_RULES_NR3B = 0;
value G_rules_RULES_NR3 = &G_rules_RULES_NR3B;
long G_rules_FRAMESIZES_NR4B = 0;
value G_rules_FRAMESIZES_NR4 = &G_rules_FRAMESIZES_NR4B;
long G_rules_NR_OF_RULES_NR5 = 0;
long G_rules_NR_OF_RULENAMES_NR6 = 0;
value G_rules_PRELUDES_NR7 = undefined;
value G_rules_POSTLUDES_NR8 = undefined;
value G_rules_INTERLUDES_NR9 = undefined;
value G_rules_ERRORS_NR10 = undefined;
long G_rules_IDS_NR11A = 1;
value G_rules_IDS_NR11 = &G_rules_IDS_NR11A;
long G_rules_ROOT_RULE_ID_NR12 = 0;
long G_rules_ROOT_ERROR_HANDLER_NR13 = 0;
long G_rules_RULENRS_NR2896[] = {Tag(1,1)};
long G_rules_EXTNR_NR2897[] = {Tag(1,2)};
long G_rules_TEXT_NR2898[] = {Tag(1,T_TEXT),1,(long)":"};
long G_rules_TEXT_NR2899[] = {Tag(1,T_TEXT),22,(long)" duplicate definition\n"};
long G_rules_TEXT_NR2900[] = {Tag(1,T_TEXT),1,(long)":"};
long G_rules_TEXT_NR2901[] = {Tag(1,T_TEXT),22,(long)" duplicate definition\n"};
long G_rules_FRAMESIZES_NR2902[] = {Tag(1,1)};
long G_rules_EXTNR_NR2903[] = {Tag(1,2)};
long G_rules_TEXT_NR2904[] = {Tag(1,T_TEXT),1,(long)":"};
long G_rules_TEXT_NR2905[] = {Tag(1,T_TEXT),18,(long)" already exported\n"};
long G_rules_FRAMESIZES_NR2906[] = {Tag(1,1)};
long G_rules_TEXT_NR2907[] = {Tag(1,T_TEXT),2,(long)": "};
long G_rules_TEXT_NR2908[] = {Tag(1,T_TEXT),25,(long)" duplicate specification\n"};
long G_rules_FRAMESIZES_NR2909[] = {Tag(1,1)};
long G_rules_FIRST_NR2910[] = {Tag(1,1)};
long G_rules_FIRST_NR2911[] = {Tag(1,1)};
long G_rules_TEXT_NR2912[] = {Tag(1,T_TEXT),1,(long)" "};
long G_rules_FIRST_NR2913[] = {Tag(1,1)};
long G_rules_TEXT_NR2914[] = {Tag(1,T_TEXT),1,(long)" "};
long G_rules_FIRST_NR2915[] = {Tag(1,1)};
long G_rules_TEXT_NR2916[] = {Tag(1,T_TEXT),1,(long)" "};
long G_rules_FIRST_NR2917[] = {Tag(1,1)};
long G_rules_TEXT_NR2918[] = {Tag(1,T_TEXT),38,(long)"error handler for root already defined"};
long G_rules_TEXT_NR2919[] = {Tag(1,T_TEXT),33,(long)"multiple ROOTs found in module(s)"};
long G_rules_RULENRS_NR2920[] = {Tag(1,1)};
long G_rules_RULENRS_NR2921[] = {Tag(1,1)};
long G_rules_RULENRS_NR2922[] = {Tag(1,1)};
long G_rules_ERRORS_NR2923[] = {Tag(1,1)};
long G_rules_ERRORS_NR2924[] = {Tag(1,0)};
long G_rules_RULEIDLIST_NR2925[] = {Tag(1,1)};
long G_rules_TEXT_NR2927[] = {Tag(1,T_TEXT),1,(long)":"};
long G_rules_TEXT_NR2928[] = {Tag(1,T_TEXT),26,(long)" export after import from "};
long G_rules_TEXT_NR2929[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_rules_TEXT_NR2930[] = {Tag(1,T_TEXT),1,(long)":"};
long G_rules_TEXT_NR2931[] = {Tag(1,T_TEXT),26,(long)" export after import from "};
long G_rules_TEXT_NR2932[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_rules_TEXT_NR2933[] = {Tag(1,T_TEXT),1,(long)":"};
long G_rules_TEXT_NR2934[] = {Tag(1,T_TEXT),26,(long)" export after import from "};
long G_rules_TEXT_NR2935[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_rules_EXTNR_NR2936[] = {Tag(1,2)};
long G_rules_TEXT_NR2937[] = {Tag(1,T_TEXT),1,(long)":"};
long G_rules_TEXT_NR2938[] = {Tag(1,T_TEXT),27,(long)" is exported but undefined\n"};
long G_rules_TEXT_NR2939[] = {Tag(1,T_TEXT),7,(long)"PRELUDE"};
long G_rules_TEXT_NR2940[] = {Tag(1,T_TEXT),9,(long)"INTERLUDE"};
long G_rules_TEXT_NR2941[] = {Tag(1,T_TEXT),8,(long)"POSTLUDE"};
long G_rules_TEXT_NR2942[] = {Tag(1,T_TEXT),6,(long)"ACTION"};
long G_rules_TEXT_NR2943[] = {Tag(1,T_TEXT),4,(long)"PRED"};
long G_rules_TEXT_NR2944[] = {Tag(1,T_TEXT),4,(long)"TEST"};
long G_rules_TEXT_NR2945[] = {Tag(1,T_TEXT),8,(long)"FUNCTION"};
long G_rules_TEXT_NR2946[] = {Tag(1,T_TEXT),1,(long)"["};
long G_rules_TEXT_NR2947[] = {Tag(1,T_TEXT),1,(long)"]"};
long G_rules_FIRST_NR2948[] = {Tag(1,2)};
long G_rules_TEXT_NR2949[] = {Tag(1,T_TEXT),1,(long)"("};
long G_rules_TEXT_NR2950[] = {Tag(1,T_TEXT),1,(long)" "};
long G_rules_FIRST_NR2951[] = {Tag(1,2)};
long G_rules_TEXT_NR2952[] = {Tag(1,T_TEXT),1,(long)"("};
long G_rules_TEXT_NR2953[] = {Tag(1,T_TEXT),1,(long)"("};
long G_rules_TEXT_NR2954[] = {Tag(1,T_TEXT),1,(long)")"};
long G_rules_FIRST_NR2955[] = {Tag(1,0)};
long G_rules_TEXT_NR2956[] = {Tag(1,T_TEXT),1,(long)" "};
long G_rules_TEXT_NR2957[] = {Tag(1,T_TEXT),1,(long)","};
long G_rules_TEXT_NR2958[] = {Tag(1,T_TEXT),1,(long)","};
long G_rules_TEXT_NR2959[] = {Tag(1,T_TEXT),1,(long)")"};
long G_rules_FIRST_NR2960[] = {Tag(1,0)};
long G_rules_TEXT_NR2961[] = {Tag(1,T_TEXT),1,(long)","};
long G_rules_TEXT_NR2962[] = {Tag(1,T_TEXT),2,(long)") "};
long G_rules_TEXT_NR2963[] = {Tag(1,T_TEXT),1,(long)" "};
long G_rules_TEXT_NR2964[] = {Tag(1,T_TEXT),2,(long)"/_"};
long G_rules_TEXT_NR2965[] = {Tag(1,T_TEXT),1,(long)"_"};
long G_rules_TEXT_NR2966[] = {Tag(1,T_TEXT),0,(long)""};
long G_rules_FIRST_NR2967[] = {Tag(1,2)};
long G_rules_TEXT_NR2968[] = {Tag(1,T_TEXT),1,(long)"("};
long G_rules_TEXT_NR2969[] = {Tag(1,T_TEXT),1,(long)" "};
long G_rules_FIRST_NR2970[] = {Tag(1,2)};
long G_rules_TEXT_NR2971[] = {Tag(1,T_TEXT),1,(long)"("};
long G_rules_TEXT_NR2972[] = {Tag(1,T_TEXT),1,(long)"("};
long G_rules_TEXT_NR2973[] = {Tag(1,T_TEXT),1,(long)")"};
long G_rules_FIRST_NR2974[] = {Tag(1,0)};
long G_rules_TEXT_NR2975[] = {Tag(1,T_TEXT),1,(long)" "};
long G_rules_TEXT_NR2976[] = {Tag(1,T_TEXT),1,(long)","};
long G_rules_TEXT_NR2977[] = {Tag(1,T_TEXT),1,(long)","};
long G_rules_TEXT_NR2978[] = {Tag(1,T_TEXT),1,(long)")"};
long G_rules_FIRST_NR2979[] = {Tag(1,0)};
long G_rules_TEXT_NR2980[] = {Tag(1,T_TEXT),1,(long)","};
long G_rules_TEXT_NR2981[] = {Tag(1,T_TEXT),2,(long)") "};
long G_rules_TEXT_NR2982[] = {Tag(1,T_TEXT),1,(long)" "};
long G_rules_TEXT_NR2983[] = {Tag(1,T_TEXT),0,(long)""};
long G_rules_TEXT_NR2984[] = {Tag(1,T_TEXT),1,(long)"/"};
long G_rules_TEXT_NR2985[] = {Tag(1,T_TEXT),0,(long)""};
long G_rules_TEXT_NR2986[] = {Tag(1,T_TEXT),1,(long)">"};
long G_rules_TEXT_NR2987[] = {Tag(1,T_TEXT),1,(long)">"};
long G_rules_TEXT_NR2988[] = {Tag(1,T_TEXT),1,(long)">"};
long G_rules_TEXT_NR2989[] = {Tag(1,T_TEXT),1,(long)">"};

/*
** ATTACH/DETACH/EQUAL
*/
/****RULENAMES(rules)****/

int EQ_Mrules_T2(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mrules_T15(Part(x,2),Part(y,2))&&(Part(x,3) == Part(y,3));
    };
  return 0;
}

int W_Mrules_T2(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Mrules_T15(Part(x,2));
WRITE(" ");
W_INT(Part(x,3));
WRITE(" ");
    };
  return 0;
}

int XD_Mrules_T2(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mrules_T15(Part(x,2));
            Free(x,4);
            break;
    };
}

int D_Mrules_T2(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T2(x);
}

/****RULENRS(rules)****/

int EQ_Mrules_T3(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mrules_T3(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Mrules_T3(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Mrules_T3(Part(x,2));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Mrules_T3(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mrules_T3(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mrules_T3(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T3(x);
}

/****RULES(rules)****/

int EQ_Mrules_T4(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mrules_T20(Part(x,2),Part(y,2))&&EQ_Mrules_T21(Part(x,3),Part(y,3))&&EQ_Mrules_T19(Part(x,4),Part(y,4))&&(Part(x,5) == Part(y,5));
       case 1:
         return (Part(x,1) == Part(y,1))&&EQ_Mrules_T20(Part(x,2),Part(y,2))&&EQ_Mrules_T21(Part(x,3),Part(y,3))&&EQ_Mrules_T19(Part(x,4),Part(y,4))&&(Part(x,5) == Part(y,5));
       case 2:
         return (Part(x,1) == Part(y,1))&&EQ_Mrules_T20(Part(x,2),Part(y,2))&&EQ_Mrules_T21(Part(x,3),Part(y,3));
    };
  return 0;
}

int W_Mrules_T4(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Mrules_T20(Part(x,2));
WRITE(" ");
W_Mrules_T21(Part(x,3));
WRITE(" ");
W_Mrules_T19(Part(x,4));
WRITE(" ");
W_INT(Part(x,5));
WRITE(" ");
       case 1:
WRITE("exported ");
W_INT(Part(x,1));
WRITE(" ");
W_Mrules_T20(Part(x,2));
WRITE(" ");
W_Mrules_T21(Part(x,3));
WRITE(" ");
W_Mrules_T19(Part(x,4));
WRITE(" ");
W_INT(Part(x,5));
WRITE(" ");
       case 2:
WRITE("exported ");
W_INT(Part(x,1));
WRITE(" ");
W_Mrules_T20(Part(x,2));
WRITE(" ");
W_Mrules_T21(Part(x,3));
WRITE(" ");
    };
  return 0;
}

int XD_Mrules_T4(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mrules_T20(Part(x,2));
D_Mrules_T21(Part(x,3));
D_Mrules_T19(Part(x,4));
            Free(x,6);
            break;
          case 1:
D_Mrules_T20(Part(x,2));
D_Mrules_T21(Part(x,3));
D_Mrules_T19(Part(x,4));
            Free(x,6);
            break;
          case 2:
D_Mrules_T20(Part(x,2));
D_Mrules_T21(Part(x,3));
            Free(x,4);
            break;
    };
}

int D_Mrules_T4(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T4(x);
}

/****FRAMESIZES(rules)****/

int EQ_Mrules_T5(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Mrules_T5(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Mrules_T5(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mrules_T5(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T5(x);
}

/****ERRORS(rules)****/

int EQ_Mrules_T11(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Mrules_T11(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("true ");
       case 1:
WRITE("false ");
    };
  return 0;
}

int XD_Mrules_T11(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mrules_T11(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T11(x);
}

/****RULENAME(rules)****/

int EQ_Mrules_T15(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mrules_T15(Part(x,2),Part(y,2));
       case 1:
         return EQ_Mrules_T15(Part(x,1),Part(y,1));
       case 2:
         return EQ_Mrules_T15(Part(x,1),Part(y,1));
       case 3:
         return 1;
    };
  return 0;
}

int W_Mrules_T15(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Mrules_T15(Part(x,2));
WRITE(" ");
       case 1:
WRITE("parameter ");
W_Mrules_T15(Part(x,1));
WRITE(" ");
       case 2:
WRITE("pass ");
WRITE("two ");
W_Mrules_T15(Part(x,1));
WRITE(" ");
       case 3:
WRITE("end ");
    };
  return 0;
}

int XD_Mrules_T15(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mrules_T15(Part(x,2));
            Free(x,3);
            break;
          case 1:
D_Mrules_T15(Part(x,1));
            Free(x,2);
            break;
          case 2:
D_Mrules_T15(Part(x,1));
            Free(x,2);
            break;
          case 3:
            Free(x,1);
            break;
    };
}

int D_Mrules_T15(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T15(x);
}

/****EXTNR(rules)****/

int EQ_Mrules_T19(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1));
       case 1:
         return (Part(x,1) == Part(y,1));
       case 2:
         return 1;
    };
  return 0;
}

int W_Mrules_T19(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
       case 1:
WRITE("fixed ");
W_INT(Part(x,1));
WRITE(" ");
       case 2:
WRITE("local ");
    };
  return 0;
}

int XD_Mrules_T19(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,2);
            break;
          case 1:
            Free(x,2);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mrules_T19(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T19(x);
}

/****RULETYPE(rules)****/

int EQ_Mrules_T20(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
       case 2:
         return 1;
       case 3:
         return 1;
       case 4:
         return 1;
       case 5:
         return 1;
       case 6:
         return 1;
       case 7:
         return EQ_Mrules_T20(Part(x,1),Part(y,1))&&EQ_Mrules_T20(Part(x,2),Part(y,2));
    };
  return 0;
}

int W_Mrules_T20(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("prelude ");
       case 1:
WRITE("postlude ");
       case 2:
WRITE("interlude ");
       case 3:
WRITE("action ");
       case 4:
WRITE("predicate ");
       case 5:
WRITE("test ");
       case 6:
WRITE("function ");
       case 7:
W_Mrules_T20(Part(x,1));
WRITE(" ");
WRITE("is ");
WRITE("really ");
W_Mrules_T20(Part(x,2));
WRITE(" ");
    };
  return 0;
}

int XD_Mrules_T20(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
          case 3:
            Free(x,1);
            break;
          case 4:
            Free(x,1);
            break;
          case 5:
            Free(x,1);
            break;
          case 6:
            Free(x,1);
            break;
          case 7:
D_Mrules_T20(Part(x,1));
D_Mrules_T20(Part(x,2));
            Free(x,3);
            break;
    };
}

int D_Mrules_T20(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T20(x);
}

/****PARAMETERS(rules)****/

int EQ_Mrules_T21(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mrules_T22(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Mvariables_T8(Part(x,3),Part(y,3))&&EQ_Mrules_T21(Part(x,4),Part(y,4));
       case 1:
         return EQ_Mrules_T21(Part(x,1),Part(y,1));
       case 2:
         return 1;
    };
  return 0;
}

int W_Mrules_T21(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Mrules_T22(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
W_Mvariables_T8(Part(x,3));
WRITE(" ");
WRITE("and ");
W_Mrules_T21(Part(x,4));
WRITE(" ");
       case 1:
WRITE("pass ");
WRITE("two ");
W_Mrules_T21(Part(x,1));
WRITE(" ");
       case 2:
WRITE("none ");
    };
  return 0;
}

int XD_Mrules_T21(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mrules_T22(Part(x,1));
D_Mvariables_T8(Part(x,3));
D_Mrules_T21(Part(x,4));
            Free(x,5);
            break;
          case 1:
D_Mrules_T21(Part(x,1));
            Free(x,2);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mrules_T21(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T21(x);
}

/****ACCESS(rules)****/

int EQ_Mrules_T22(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
       case 2:
         return 1;
    };
  return 0;
}

int W_Mrules_T22(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("input ");
       case 1:
WRITE("output ");
       case 2:
WRITE("transient ");
    };
  return 0;
}

int XD_Mrules_T22(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mrules_T22(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T22(x);
}

/****RULEIDLIST(rules)****/

int EQ_Mrules_T69(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mrules_T69(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Mrules_T69(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Mrules_T69(Part(x,2));
WRITE(" ");
       case 1:
WRITE("end ");
    };
  return 0;
}

int XD_Mrules_T69(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mrules_T69(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mrules_T69(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T69(x);
}

/****FIRST(rules)****/

int EQ_Mrules_T89(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
       case 2:
         return 1;
    };
  return 0;
}

int W_Mrules_T89(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("reset ");
       case 1:
WRITE("true ");
       case 2:
WRITE("false ");
    };
  return 0;
}

int XD_Mrules_T89(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mrules_T89(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrules_T89(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Mrules_P_propagate_rules,());
_PROTOTYPE(int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_definition_errors,());
_PROTOTYPE(int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(int Mrules_P_init_hash_table,());
_PROTOTYPE(int Mrules_P_def_error_MESSAGE,(value P0));
_PROTOTYPE(int Mrules_P_init_hash_table_INDEX,(value P0));
_PROTOTYPE(int Mrules_P_hash_RULENAME_INDEX,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_exists_MODULENR_RULENAME_ARITY_RULEIDLIST_RULEID,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(int Mrules_P_equal_PARAMETERS_PARAMETERS,(value P0,value P1));
_PROTOTYPE(int Mrules_P_exists_RULETYPE_PARAMETERS_RULENRS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(int Mrules_P_propagate_rule_RULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_EXPORTS,(value P0,value P1,value P2,value P3,value P4,value P5));
_PROTOTYPE(int Mrules_P_propagate_rules_RULENR,(value P0));
_PROTOTYPE(int Mrules_P_error_RULETYPE,(value P0));
_PROTOTYPE(int Mrules_P_build_rule_RULETYPE_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mrules_P_build_rule_parameter_TEXT_FIRST_RULENAME_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mrules_P_build_rule_FIRST_RULENAME_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(int Mrules_P_build_rule_parameter_FIRST_RULENAME_PARAMETERS_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mrules_P_build_rule_parameter_PARAMETERS_TEXT,(value *P0,value *P1));


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));

/*
** CODE
*/

int Mrules_P_propagate_rules()
{
  value L0;
  L0 = (value)G_rules_NR_OF_RULES_NR5;
  Mrules_P_propagate_rules_RULENR(L0);
  return 1;
}

int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  Mrules_P_hash_RULENAME_INDEX(L1,&L3);
  L4 = (value) Addr((value*)&G_rules_HASHEDRULENAMES_NR0,Int(L3));
  L5 = *((value*)L4);
  ATTACH(L5);
  L18 = L0;
  L19 = L1;
  L20 = L2;
  L21 = L5;
LAB379:
  switch (Alternative(L21)) {
  case 0: goto LAB380;
  default: goto LAB0;
  };
LAB380:
  L22 = (value)(L21[1]);
  L23 = (value)(L21[2]);
  L24 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L22));
  L25 = *((value*)L24);
  L26 = (value)(L25[1]);
  L27 = (value)(L25[2]);
  L28 = (value)(L25[3]);
  if (!(L18 == L26)) goto LAB386;
  if (!EQ_Mrules_T15(L19,L27)) goto LAB386;
  if (!(L20 == L28)) goto LAB386;
  L6 = L22;
LAB378:
if(DecrRefs(L5)<0)
XD_Mrules_T69(L5);
  *P3 = L6;
  return 1;
LAB386:
  L21 = L23;
  goto LAB379;
LAB0:
if(DecrRefs(L5)<0)
XD_Mrules_T69(L5);
LAB1:
  L7 = (value)G_rules_NR_OF_RULENAMES_NR6;
  L8 = (value)G_rules_NR_OF_RULENAMES_NR6;
  L9 = C_INT(1);
  L10 = C_INT(Int(L8) + Int(L9));
  G_rules_NR_OF_RULENAMES_NR6 = (long)L10;
  Create(&L11,0,2);
  *(value *)(L11+1) = L7;
  L12 = (value) Addr((value*)&G_rules_HASHEDRULENAMES_NR0,Int(L3));
  L13 = *((value*)L12);
  ATTACH(L13);
  *(value *)(L11+2) = L13;
if(DecrRefs(*((value*)L12))<0)
XD_Mrules_T69(*((value*)L12));
  *((value *)L12) = L11;
  L14 = G_rules_RULENRS_NR2896;
  L15 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L7));
  ATTACH(L14);
if(DecrRefs(*((value*)L15))<0)
XD_Mrules_T3(*((value*)L15));
  *((value *)L15) = L14;
  Create(&L16,0,3);
  *(value *)(L16+1) = L0;
  *(value *)(L16+2) = L1;
  ATTACH(L1);
  *(value *)(L16+3) = L2;
  L17 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L7));
if(DecrRefs(*((value*)L17))<0)
XD_Mrules_T2(*((value*)L17));
  *((value *)L17) = L16;
  *P3 = L7;
  return 1;
}

int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR(P0,P1,P2,P3,P4)
value P0;
value P1;
value P2;
value *P3;
value *P4;
{
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L0));
  L4 = *((value*)L3);
  ATTACH(L4);
  if (!Mrules_P_exists_RULETYPE_PARAMETERS_RULENRS_NODENR_RULENR(L1,L2,L4,&L5,&L6)) goto LAB2;
if(DecrRefs(L4)<0)
XD_Mrules_T3(L4);
  L7 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L6));
  L8 = *((value*)L7);
  ATTACH(L8);
  switch (Alternative(L8)) {
  case 2: goto LAB4;
  default: goto LAB5;
  };
LAB4:
  L9 = (value)(L8[1]);
  L10 = (value)(L8[2]);
  L11 = (value)(L8[3]);
if(DecrRefs(L8)<0)
XD_Mrules_T4(L8);
  Mnodes_P_new_NODENR(&L12);
  Create(&L13,1,5);
  *(value *)(L13+1) = L0;
  *(value *)(L13+2) = L1;
  ATTACH(L1);
  *(value *)(L13+3) = L2;
  ATTACH(L2);
  L14 = G_rules_EXTNR_NR2897;
  *(value *)(L13+4) = L14;
  ATTACH(L14);
  *(value *)(L13+5) = L12;
if(DecrRefs(*((value*)L7))<0)
XD_Mrules_T4(*((value*)L7));
  *((value *)L7) = L13;
  *P4 = L6;
  *P3 = L12;
  return 1;
LAB2:
if(DecrRefs(L4)<0)
XD_Mrules_T3(L4);
LAB3:
  L48 = (value)G_rules_NR_OF_RULES_NR5;
  L49 = (value)G_rules_NR_OF_RULES_NR5;
  L50 = C_INT(1);
  L51 = C_INT(Int(L49) + Int(L50));
  G_rules_NR_OF_RULES_NR5 = (long)L51;
  Create(&L52,0,2);
  *(value *)(L52+1) = L48;
  L53 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L0));
  L54 = *((value*)L53);
  ATTACH(L54);
  *(value *)(L52+2) = L54;
if(DecrRefs(*((value*)L53))<0)
XD_Mrules_T3(*((value*)L53));
  *((value *)L53) = L52;
  Mnodes_P_new_NODENR(&L55);
  L56 = G_rules_FRAMESIZES_NR2902;
  L57 = (value) Addr((value*)&G_rules_FRAMESIZES_NR4,Int(L48));
  ATTACH(L56);
if(DecrRefs(*((value*)L57))<0)
XD_Mrules_T5(*((value*)L57));
  *((value *)L57) = L56;
  L58 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L0));
  L59 = *((value*)L58);
  ATTACH(L59);
  L60 = (value)(L59[1]);
  L61 = (value)(L59[2]);
  L62 = (value)(L59[3]);
  Mmodules_P_new_id_MODULENR_ID(L60,&L63);
  L64 = (value) Addr((value*)&G_rules_IDS_NR11,Int(L48));
  *((value *)L64) = L63;
  L68 = L1;
  L69 = L48;
  L70 = L60;
  switch (Alternative(L68)) {
  case 0: goto LAB449;
  case 1: goto LAB452;
  case 2: goto LAB455;
  default: goto LAB448;
  };
LAB5:
if(DecrRefs(L8)<0)
XD_Mrules_T4(L8);
LAB6:
  L15 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L6));
  L16 = *((value*)L15);
  ATTACH(L16);
  switch (Alternative(L16)) {
  case 1: goto LAB7;
  default: goto LAB8;
  };
LAB7:
  L17 = (value)(L16[1]);
  L18 = (value)(L16[2]);
  L19 = (value)(L16[3]);
  L20 = (value)(L16[4]);
  L21 = (value)(L16[5]);
  switch (Alternative(L20)) {
  case 0: goto LAB10;
  default: goto LAB12;
  };
LAB10:
  L22 = (value)(L20[1]);
  Create(&L23,1,5);
  *(value *)(L23+1) = L17;
  *(value *)(L23+2) = L1;
  ATTACH(L1);
  *(value *)(L23+3) = L2;
  ATTACH(L2);
  Create(&L24,1,1);
  *(value *)(L24+1) = L22;
  *(value *)(L23+4) = L24;
  *(value *)(L23+5) = L21;
if(DecrRefs(L16)<0)
XD_Mrules_T4(L16);
if(DecrRefs(*((value*)L15))<0)
XD_Mrules_T4(*((value*)L15));
  *((value *)L15) = L23;
  *P4 = L6;
  *P3 = L21;
  return 1;
LAB8:
if(DecrRefs(L16)<0)
XD_Mrules_T4(L16);
LAB9:
  L36 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L0));
  L37 = *((value*)L36);
  ATTACH(L37);
  L38 = (value)(L37[1]);
  L39 = (value)(L37[2]);
  L40 = (value)(L37[3]);
  Mnodes_P_new_NODENR(&L41);
  Create(&L42,4,2);
  *(value *)(L42+1) = L38;
if(DecrRefs(L37)<0)
XD_Mrules_T2(L37);
  Create(&L43,6,2);
  L44 = G_rules_TEXT_NR2900;
  *(value *)(L43+1) = L44;
  ATTACH(L44);
  Create(&L45,0,2);
  *(value *)(L45+1) = L6;
  Create(&L46,11,1);
  L47 = G_rules_TEXT_NR2901;
  *(value *)(L46+1) = L47;
  ATTACH(L47);
  *(value *)(L45+2) = L46;
  *(value *)(L43+2) = L45;
  *(value *)(L42+2) = L43;
  Mrules_P_def_error_MESSAGE(L42);
if(DecrRefs(L42)<0)
XD_Merrors_T3(L42);
  *P4 = L6;
  *P3 = L41;
  return 1;
LAB12:
  L25 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L17));
  L26 = *((value*)L25);
  ATTACH(L26);
  L27 = (value)(L26[1]);
  L28 = (value)(L26[2]);
  L29 = (value)(L26[3]);
  Create(&L30,4,2);
  *(value *)(L30+1) = L27;
if(DecrRefs(L26)<0)
XD_Mrules_T2(L26);
  Create(&L31,6,2);
  L32 = G_rules_TEXT_NR2898;
  *(value *)(L31+1) = L32;
  ATTACH(L32);
  Create(&L33,0,2);
  *(value *)(L33+1) = L6;
  Create(&L34,11,1);
  L35 = G_rules_TEXT_NR2899;
  *(value *)(L34+1) = L35;
  ATTACH(L35);
  *(value *)(L33+2) = L34;
  *(value *)(L31+2) = L33;
  *(value *)(L30+2) = L31;
  Mrules_P_def_error_MESSAGE(L30);
if(DecrRefs(L30)<0)
XD_Merrors_T3(L30);
  *P4 = L6;
  *P3 = L21;
if(DecrRefs(L16)<0)
XD_Mrules_T4(L16);
  return 1;
LAB449:
  Create(&L71,0,2);
  *(value *)(L71+1) = L69;
  L72 = G_rules_PRELUDES_NR7;
  ATTACH(L72);
  *(value *)(L71+2) = L72;
if(DecrRefs(G_rules_PRELUDES_NR7)<0)
XD_Mrules_T3(G_rules_PRELUDES_NR7);
  G_rules_PRELUDES_NR7 = L71;
  goto LAB448;
LAB452:
  Create(&L73,0,2);
  *(value *)(L73+1) = L69;
  L74 = G_rules_POSTLUDES_NR8;
  ATTACH(L74);
  *(value *)(L73+2) = L74;
if(DecrRefs(G_rules_POSTLUDES_NR8)<0)
XD_Mrules_T3(G_rules_POSTLUDES_NR8);
  G_rules_POSTLUDES_NR8 = L73;
  goto LAB448;
LAB455:
  Create(&L75,0,2);
  *(value *)(L75+1) = L69;
  L76 = G_rules_INTERLUDES_NR9;
  ATTACH(L76);
  *(value *)(L75+2) = L76;
if(DecrRefs(G_rules_INTERLUDES_NR9)<0)
XD_Mrules_T3(G_rules_INTERLUDES_NR9);
  G_rules_INTERLUDES_NR9 = L75;
LAB448:
if(DecrRefs(L59)<0)
XD_Mrules_T2(L59);
  Create(&L65,0,5);
  *(value *)(L65+1) = L0;
  *(value *)(L65+2) = L1;
  ATTACH(L1);
  *(value *)(L65+3) = L2;
  ATTACH(L2);
  L66 = G_rules_EXTNR_NR2903;
  *(value *)(L65+4) = L66;
  ATTACH(L66);
  *(value *)(L65+5) = L55;
  L67 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L48));
if(DecrRefs(*((value*)L67))<0)
XD_Mrules_T4(*((value*)L67));
  *((value *)L67) = L65;
  *P4 = L48;
  *P3 = L55;
  return 1;
}

int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L0));
  L4 = *((value*)L3);
  ATTACH(L4);
  if (!Mrules_P_exists_RULETYPE_PARAMETERS_RULENRS_NODENR_RULENR(L1,L2,L4,&L5,&L6)) goto LAB13;
if(DecrRefs(L4)<0)
XD_Mrules_T3(L4);
  L7 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L6));
  L8 = *((value*)L7);
  ATTACH(L8);
  switch (Alternative(L8)) {
  case 0: goto LAB15;
  default: goto LAB16;
  };
LAB15:
  L9 = (value)(L8[1]);
  L10 = (value)(L8[2]);
  L11 = (value)(L8[3]);
  L12 = (value)(L8[4]);
  L13 = (value)(L8[5]);
  Create(&L14,1,5);
  *(value *)(L14+1) = L9;
  *(value *)(L14+2) = L10;
  ATTACH(L10);
  *(value *)(L14+3) = L11;
  ATTACH(L11);
  *(value *)(L14+4) = L12;
  ATTACH(L12);
  *(value *)(L14+5) = L13;
if(DecrRefs(L8)<0)
XD_Mrules_T4(L8);
if(DecrRefs(*((value*)L7))<0)
XD_Mrules_T4(*((value*)L7));
  *((value *)L7) = L14;
  *P3 = L6;
  return 1;
LAB13:
if(DecrRefs(L4)<0)
XD_Mrules_T3(L4);
LAB14:
  L26 = (value)G_rules_NR_OF_RULES_NR5;
  L27 = (value)G_rules_NR_OF_RULES_NR5;
  L28 = C_INT(1);
  L29 = C_INT(Int(L27) + Int(L28));
  G_rules_NR_OF_RULES_NR5 = (long)L29;
  Create(&L30,0,2);
  *(value *)(L30+1) = L26;
  L31 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L0));
  L32 = *((value*)L31);
  ATTACH(L32);
  *(value *)(L30+2) = L32;
if(DecrRefs(*((value*)L31))<0)
XD_Mrules_T3(*((value*)L31));
  *((value *)L31) = L30;
  L33 = G_rules_FRAMESIZES_NR2906;
  L34 = (value) Addr((value*)&G_rules_FRAMESIZES_NR4,Int(L26));
  ATTACH(L33);
if(DecrRefs(*((value*)L34))<0)
XD_Mrules_T5(*((value*)L34));
  *((value *)L34) = L33;
  L35 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L0));
  L36 = *((value*)L35);
  ATTACH(L36);
  L37 = (value)(L36[1]);
  L38 = (value)(L36[2]);
  L39 = (value)(L36[3]);
  Mmodules_P_new_id_MODULENR_ID(L37,&L40);
  L41 = (value) Addr((value*)&G_rules_IDS_NR11,Int(L26));
  *((value *)L41) = L40;
  L44 = L1;
  L45 = L26;
  L46 = L37;
  switch (Alternative(L44)) {
  case 0: goto LAB459;
  case 1: goto LAB462;
  case 2: goto LAB465;
  default: goto LAB458;
  };
LAB16:
if(DecrRefs(L8)<0)
XD_Mrules_T4(L8);
LAB17:
  L15 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L0));
  L16 = *((value*)L15);
  ATTACH(L16);
  L17 = (value)(L16[1]);
  L18 = (value)(L16[2]);
  L19 = (value)(L16[3]);
  Create(&L20,4,2);
  *(value *)(L20+1) = L17;
if(DecrRefs(L16)<0)
XD_Mrules_T2(L16);
  Create(&L21,6,2);
  L22 = G_rules_TEXT_NR2904;
  *(value *)(L21+1) = L22;
  ATTACH(L22);
  Create(&L23,0,2);
  *(value *)(L23+1) = L6;
  Create(&L24,11,1);
  L25 = G_rules_TEXT_NR2905;
  *(value *)(L24+1) = L25;
  ATTACH(L25);
  *(value *)(L23+2) = L24;
  *(value *)(L21+2) = L23;
  *(value *)(L20+2) = L21;
  Mrules_P_def_error_MESSAGE(L20);
if(DecrRefs(L20)<0)
XD_Merrors_T3(L20);
  *P3 = L6;
  return 1;
LAB459:
  Create(&L47,0,2);
  *(value *)(L47+1) = L45;
  L48 = G_rules_PRELUDES_NR7;
  ATTACH(L48);
  *(value *)(L47+2) = L48;
if(DecrRefs(G_rules_PRELUDES_NR7)<0)
XD_Mrules_T3(G_rules_PRELUDES_NR7);
  G_rules_PRELUDES_NR7 = L47;
  goto LAB458;
LAB462:
  Create(&L49,0,2);
  *(value *)(L49+1) = L45;
  L50 = G_rules_POSTLUDES_NR8;
  ATTACH(L50);
  *(value *)(L49+2) = L50;
if(DecrRefs(G_rules_POSTLUDES_NR8)<0)
XD_Mrules_T3(G_rules_POSTLUDES_NR8);
  G_rules_POSTLUDES_NR8 = L49;
  goto LAB458;
LAB465:
  Create(&L51,0,2);
  *(value *)(L51+1) = L45;
  L52 = G_rules_INTERLUDES_NR9;
  ATTACH(L52);
  *(value *)(L51+2) = L52;
if(DecrRefs(G_rules_INTERLUDES_NR9)<0)
XD_Mrules_T3(G_rules_INTERLUDES_NR9);
  G_rules_INTERLUDES_NR9 = L51;
LAB458:
if(DecrRefs(L36)<0)
XD_Mrules_T2(L36);
  Create(&L42,2,3);
  *(value *)(L42+1) = L0;
  *(value *)(L42+2) = L1;
  ATTACH(L1);
  *(value *)(L42+3) = L2;
  ATTACH(L2);
  L43 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L26));
if(DecrRefs(*((value*)L43))<0)
XD_Mrules_T4(*((value*)L43));
  *((value *)L43) = L42;
  *P3 = L26;
  return 1;
}

int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR(P0,P1,P2,P3,P4,P5)
value P0;
value P1;
value P2;
value P3;
value *P4;
value *P5;
{
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L0));
  L5 = *((value*)L4);
  ATTACH(L5);
  if (!Mrules_P_exists_RULETYPE_PARAMETERS_RULENRS_NODENR_RULENR(L1,L2,L5,&L6,&L7)) goto LAB18;
if(DecrRefs(L5)<0)
XD_Mrules_T3(L5);
  L8 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L7));
  L9 = *((value*)L8);
  ATTACH(L9);
  switch (Alternative(L9)) {
  case 2: goto LAB20;
  default: goto LAB21;
  };
LAB20:
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  L12 = (value)(L9[3]);
  Mnodes_P_new_NODENR(&L13);
  Create(&L14,1,5);
  *(value *)(L14+1) = L10;
  *(value *)(L14+2) = L11;
  ATTACH(L11);
  *(value *)(L14+3) = L12;
  ATTACH(L12);
if(DecrRefs(L9)<0)
XD_Mrules_T4(L9);
  *(value *)(L14+4) = L3;
  ATTACH(L3);
  *(value *)(L14+5) = L13;
if(DecrRefs(*((value*)L8))<0)
XD_Mrules_T4(*((value*)L8));
  *((value *)L8) = L14;
  *P5 = L7;
  *P4 = L13;
  return 1;
LAB18:
if(DecrRefs(L5)<0)
XD_Mrules_T3(L5);
LAB19:
  L36 = (value)G_rules_NR_OF_RULES_NR5;
  L37 = (value)G_rules_NR_OF_RULES_NR5;
  L38 = C_INT(1);
  L39 = C_INT(Int(L37) + Int(L38));
  G_rules_NR_OF_RULES_NR5 = (long)L39;
  Create(&L40,0,2);
  *(value *)(L40+1) = L36;
  L41 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L0));
  L42 = *((value*)L41);
  ATTACH(L42);
  *(value *)(L40+2) = L42;
if(DecrRefs(*((value*)L41))<0)
XD_Mrules_T3(*((value*)L41));
  *((value *)L41) = L40;
  L43 = G_rules_FRAMESIZES_NR2909;
  L44 = (value) Addr((value*)&G_rules_FRAMESIZES_NR4,Int(L36));
  ATTACH(L43);
if(DecrRefs(*((value*)L44))<0)
XD_Mrules_T5(*((value*)L44));
  *((value *)L44) = L43;
  Mnodes_P_new_NODENR(&L45);
  L46 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L0));
  L47 = *((value*)L46);
  ATTACH(L47);
  L48 = (value)(L47[1]);
  L49 = (value)(L47[2]);
  L50 = (value)(L47[3]);
  L51 = C_INT(0);
  L52 = (value) Addr((value*)&G_rules_IDS_NR11,Int(L36));
  *((value *)L52) = L51;
  L55 = L1;
  L56 = L36;
  L57 = L48;
  switch (Alternative(L55)) {
  case 0: goto LAB469;
  case 1: goto LAB472;
  case 2: goto LAB475;
  default: goto LAB468;
  };
LAB21:
if(DecrRefs(L9)<0)
XD_Mrules_T4(L9);
LAB22:
  L15 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L7));
  L16 = *((value*)L15);
  ATTACH(L16);
  switch (Alternative(L16)) {
  case 1: goto LAB23;
  default: goto LAB24;
  };
LAB23:
  L17 = (value)(L16[1]);
  L18 = (value)(L16[2]);
  L19 = (value)(L16[3]);
  L20 = (value)(L16[4]);
  L21 = (value)(L16[5]);
  switch (Alternative(L20)) {
  case 2: goto LAB26;
  default: goto LAB27;
  };
LAB26:
  switch (Alternative(L3)) {
  case 0: goto LAB29;
  default: goto LAB30;
  };
LAB29:
  L22 = (value)(L3[1]);
  Create(&L23,1,5);
  *(value *)(L23+1) = L0;
  *(value *)(L23+2) = L1;
  ATTACH(L1);
  *(value *)(L23+3) = L2;
  ATTACH(L2);
  Create(&L24,1,1);
  *(value *)(L24+1) = L22;
  *(value *)(L23+4) = L24;
  *(value *)(L23+5) = L21;
if(DecrRefs(L16)<0)
XD_Mrules_T4(L16);
if(DecrRefs(*((value*)L15))<0)
XD_Mrules_T4(*((value*)L15));
  *((value *)L15) = L23;
  *P5 = L7;
  *P4 = L21;
  return 1;
LAB24:
if(DecrRefs(L16)<0)
XD_Mrules_T4(L16);
  goto LAB25;
LAB27:
if(DecrRefs(L16)<0)
XD_Mrules_T4(L16);
  goto LAB25;
LAB30:
if(DecrRefs(L16)<0)
XD_Mrules_T4(L16);
LAB25:
  L25 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L0));
  L26 = *((value*)L25);
  ATTACH(L26);
  L27 = (value)(L26[1]);
  L28 = (value)(L26[2]);
  L29 = (value)(L26[3]);
  Create(&L30,4,2);
  *(value *)(L30+1) = L27;
if(DecrRefs(L26)<0)
XD_Mrules_T2(L26);
  Create(&L31,6,2);
  L32 = G_rules_TEXT_NR2907;
  *(value *)(L31+1) = L32;
  ATTACH(L32);
  Create(&L33,0,2);
  *(value *)(L33+1) = L7;
  Create(&L34,11,1);
  L35 = G_rules_TEXT_NR2908;
  *(value *)(L34+1) = L35;
  ATTACH(L35);
  *(value *)(L33+2) = L34;
  *(value *)(L31+2) = L33;
  *(value *)(L30+2) = L31;
  Mrules_P_def_error_MESSAGE(L30);
if(DecrRefs(L30)<0)
XD_Merrors_T3(L30);
  *P5 = L7;
  *P4 = L6;
  return 1;
LAB469:
  Create(&L58,0,2);
  *(value *)(L58+1) = L56;
  L59 = G_rules_PRELUDES_NR7;
  ATTACH(L59);
  *(value *)(L58+2) = L59;
if(DecrRefs(G_rules_PRELUDES_NR7)<0)
XD_Mrules_T3(G_rules_PRELUDES_NR7);
  G_rules_PRELUDES_NR7 = L58;
  goto LAB468;
LAB472:
  Create(&L60,0,2);
  *(value *)(L60+1) = L56;
  L61 = G_rules_POSTLUDES_NR8;
  ATTACH(L61);
  *(value *)(L60+2) = L61;
if(DecrRefs(G_rules_POSTLUDES_NR8)<0)
XD_Mrules_T3(G_rules_POSTLUDES_NR8);
  G_rules_POSTLUDES_NR8 = L60;
  goto LAB468;
LAB475:
  Create(&L62,0,2);
  *(value *)(L62+1) = L56;
  L63 = G_rules_INTERLUDES_NR9;
  ATTACH(L63);
  *(value *)(L62+2) = L63;
if(DecrRefs(G_rules_INTERLUDES_NR9)<0)
XD_Mrules_T3(G_rules_INTERLUDES_NR9);
  G_rules_INTERLUDES_NR9 = L62;
LAB468:
if(DecrRefs(L47)<0)
XD_Mrules_T2(L47);
  Create(&L53,1,5);
  *(value *)(L53+1) = L0;
  *(value *)(L53+2) = L1;
  ATTACH(L1);
  *(value *)(L53+3) = L2;
  ATTACH(L2);
  *(value *)(L53+4) = L3;
  ATTACH(L3);
  *(value *)(L53+5) = L45;
  L54 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L36));
if(DecrRefs(*((value*)L54))<0)
XD_Mrules_T4(*((value*)L54));
  *((value *)L54) = L53;
  *P5 = L36;
  *P4 = L45;
  return 1;
}

int Mrules_P_is_external_RULENR_EXTNR(P0,P1)
value P0;
value *P1;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB32;
  default: goto LAB34;
  };
LAB32:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  switch (Alternative(L6)) {
  case 0: goto LAB35;
  default: goto LAB37;
  };
LAB35:
  L8 = (value)(L6[1]);
  *P1 = L6;
  ATTACH(L6);
  return 1;
LAB37:
  return 0;
LAB34:
  L9 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L10 = *((value*)L9);
  switch (Alternative(L10)) {
  case 1: goto LAB38;
  default: goto LAB40;
  };
LAB38:
  L11 = (value)(L10[1]);
  L12 = (value)(L10[2]);
  L13 = (value)(L10[3]);
  L14 = (value)(L10[4]);
  L15 = (value)(L10[5]);
  switch (Alternative(L14)) {
  case 0: goto LAB41;
  default: goto LAB43;
  };
LAB41:
  L16 = (value)(L14[1]);
  *P1 = L14;
  ATTACH(L14);
  return 1;
LAB43:
  return 0;
LAB40:
  Abort(382, module_name);
}

int Mrules_P_in_interface_RULENR(P0)
value P0;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 1: goto LAB44;
  default: goto LAB46;
  };
LAB44:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  return 1;
LAB46:
  return 0;
}

int Mrules_P_is_fixed_RULENR_INT(P0,P1)
value P0;
value *P1;
{
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB47;
  default: goto LAB49;
  };
LAB47:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  switch (Alternative(L6)) {
  case 0: goto LAB50;
  case 1: goto LAB53;
  default: goto LAB55;
  };
LAB50:
  L8 = (value)(L6[1]);
  *P1 = L8;
  return 1;
LAB53:
  L9 = (value)(L6[1]);
  *P1 = L9;
  return 1;
LAB55:
  return 0;
LAB49:
  L10 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L11 = *((value*)L10);
  switch (Alternative(L11)) {
  case 1: goto LAB56;
  default: goto LAB58;
  };
LAB56:
  L12 = (value)(L11[1]);
  L13 = (value)(L11[2]);
  L14 = (value)(L11[3]);
  L15 = (value)(L11[4]);
  L16 = (value)(L11[5]);
  switch (Alternative(L15)) {
  case 0: goto LAB59;
  case 1: goto LAB62;
  default: goto LAB64;
  };
LAB59:
  L17 = (value)(L15[1]);
  *P1 = L17;
  return 1;
LAB62:
  L18 = (value)(L15[1]);
  *P1 = L18;
  return 1;
LAB64:
  return 0;
LAB58:
  Abort(396, module_name);
}

int Mrules_P_get_RULEID_RULENRS(P0,P1)
value P0;
value *P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L0));
  L2 = *((value*)L1);
  *P1 = L2;
  ATTACH(L2);
  return 1;
}

int Mrules_P_get_RULEID_RULENAME(P0,P1)
value P0;
value *P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L0));
  L2 = *((value*)L1);
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  *P1 = L4;
  ATTACH(L4);
  return 1;
}

int Mrules_P_get_RULEID_MODULENR(P0,P1)
value P0;
value *P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L0));
  L2 = *((value*)L1);
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  *P1 = L3;
  return 1;
}

int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR(P0,P1,P2,P3,P4,P5,P6)
value P0;
value *P1;
value *P2;
value *P3;
value *P4;
value *P5;
value *P6;
{
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB65;
  default: goto LAB67;
  };
LAB65:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  L8 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L3));
  L9 = *((value*)L8);
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  L12 = (value)(L9[3]);
  *P6 = L7;
  *P5 = L5;
  ATTACH(L5);
  *P4 = L12;
  *P3 = L11;
  ATTACH(L11);
  *P2 = L4;
  ATTACH(L4);
  *P1 = L10;
  return 1;
LAB67:
  L13 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L14 = *((value*)L13);
  switch (Alternative(L14)) {
  case 1: goto LAB68;
  default: goto LAB70;
  };
LAB68:
  L15 = (value)(L14[1]);
  L16 = (value)(L14[2]);
  L17 = (value)(L14[3]);
  L18 = (value)(L14[4]);
  L19 = (value)(L14[5]);
  L20 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L15));
  L21 = *((value*)L20);
  L22 = (value)(L21[1]);
  L23 = (value)(L21[2]);
  L24 = (value)(L21[3]);
  *P6 = L19;
  *P5 = L17;
  ATTACH(L17);
  *P4 = L24;
  *P3 = L23;
  ATTACH(L23);
  *P2 = L16;
  ATTACH(L16);
  *P1 = L22;
  return 1;
LAB70:
  Abort(332, module_name);
}

int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_FRAMESIZES_NR4,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB71;
  default: goto LAB73;
  };
LAB71:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  *P2 = L4;
  *P1 = L3;
  return 1;
LAB73:
  Abort(344, module_name);
}

int Mrules_P_get_RULENR_RULETYPE(P0,P1)
value P0;
value *P1;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB74;
  default: goto LAB76;
  };
LAB74:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  *P1 = L4;
  ATTACH(L4);
  return 1;
LAB76:
  Abort(348, module_name);
}

int Mrules_P_get_RULENR_RULENAME(P0,P1)
value P0;
value *P1;
{
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB77;
  default: goto LAB79;
  };
LAB77:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  L8 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L3));
  L9 = *((value*)L8);
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  L12 = (value)(L9[3]);
  *P1 = L11;
  ATTACH(L11);
  return 1;
LAB79:
  L13 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L14 = *((value*)L13);
  switch (Alternative(L14)) {
  case 1: goto LAB80;
  default: goto LAB82;
  };
LAB80:
  L15 = (value)(L14[1]);
  L16 = (value)(L14[2]);
  L17 = (value)(L14[3]);
  L18 = (value)(L14[4]);
  L19 = (value)(L14[5]);
  L20 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L15));
  L21 = *((value*)L20);
  L22 = (value)(L21[1]);
  L23 = (value)(L21[2]);
  L24 = (value)(L21[3]);
  *P1 = L23;
  ATTACH(L23);
  return 1;
LAB82:
  Abort(304, module_name);
}

int Mrules_P_get_RULENR_MODULENR(P0,P1)
value P0;
value *P1;
{
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB83;
  default: goto LAB85;
  };
LAB83:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  L8 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L3));
  L9 = *((value*)L8);
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  L12 = (value)(L9[3]);
  *P1 = L10;
  return 1;
LAB85:
  L13 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L14 = *((value*)L13);
  switch (Alternative(L14)) {
  case 1: goto LAB86;
  default: goto LAB88;
  };
LAB86:
  L15 = (value)(L14[1]);
  L16 = (value)(L14[2]);
  L17 = (value)(L14[3]);
  L18 = (value)(L14[4]);
  L19 = (value)(L14[5]);
  L20 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L15));
  L21 = *((value*)L20);
  L22 = (value)(L21[1]);
  L23 = (value)(L21[2]);
  L24 = (value)(L21[3]);
  *P1 = L22;
  return 1;
LAB88:
  Abort(325, module_name);
}

int Mrules_P_get_RULENR_PARAMETERS(P0,P1)
value P0;
value *P1;
{
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB89;
  default: goto LAB91;
  };
LAB89:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  *P1 = L5;
  ATTACH(L5);
  return 1;
LAB91:
  L8 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L9 = *((value*)L8);
  switch (Alternative(L9)) {
  case 1: goto LAB92;
  default: goto LAB94;
  };
LAB92:
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  L12 = (value)(L9[3]);
  L13 = (value)(L9[4]);
  L14 = (value)(L9[5]);
  *P1 = L12;
  ATTACH(L12);
  return 1;
LAB94:
  Abort(318, module_name);
}

int Mrules_P_get_RULENR_MODULENR_ID(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_IDS_NR11,Int(L0));
  L2 = *((value*)L1);
  L3 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L4 = *((value*)L3);
  switch (Alternative(L4)) {
  case 0: goto LAB95;
  default: goto LAB97;
  };
LAB95:
  L5 = (value)(L4[1]);
  L6 = (value)(L4[2]);
  L7 = (value)(L4[3]);
  L8 = (value)(L4[4]);
  L9 = (value)(L4[5]);
  L10 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L5));
  L11 = *((value*)L10);
  L12 = (value)(L11[1]);
  L13 = (value)(L11[2]);
  L14 = (value)(L11[3]);
  *P2 = L2;
  *P1 = L12;
  return 1;
LAB97:
  L15 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L16 = *((value*)L15);
  switch (Alternative(L16)) {
  case 1: goto LAB98;
  default: goto LAB100;
  };
LAB98:
  L17 = (value)(L16[1]);
  L18 = (value)(L16[2]);
  L19 = (value)(L16[3]);
  L20 = (value)(L16[4]);
  L21 = (value)(L16[5]);
  L22 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L17));
  L23 = *((value*)L22);
  L24 = (value)(L23[1]);
  L25 = (value)(L23[2]);
  L26 = (value)(L23[3]);
  *P2 = L2;
  *P1 = L24;
  return 1;
LAB100:
  Abort(340, module_name);
}

int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  Create(&L3,0,2);
  *(value *)(L3+1) = L1;
  *(value *)(L3+2) = L2;
  L4 = (value) Addr((value*)&G_rules_FRAMESIZES_NR4,Int(L0));
if(DecrRefs(*((value*)L4))<0)
XD_Mrules_T5(*((value*)L4));
  *((value *)L4) = L3;
  return 1;
}

int Mrules_P_get_preludes_RULENRS(P0)
value *P0;
{
  value L0;
  L0 = G_rules_PRELUDES_NR7;
  *P0 = L0;
  ATTACH(L0);
  return 1;
}

int Mrules_P_get_postludes_RULENRS(P0)
value *P0;
{
  value L0;
  L0 = G_rules_POSTLUDES_NR8;
  *P0 = L0;
  ATTACH(L0);
  return 1;
}

int Mrules_P_get_interludes_RULENRS(P0)
value *P0;
{
  value L0;
  L0 = G_rules_INTERLUDES_NR9;
  *P0 = L0;
  ATTACH(L0);
  return 1;
}

int Mrules_P_first_rule_RULENR(P0)
value *P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = C_INT(0);
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) - Int(L1));
  L3 = L2;
  if (!Mrules_P_next_rule_RULENR(&L3)) goto LAB101;
  *P0 = L3;
  return 1;
LAB101:
  return 0;
  return 0;
}

int Mrules_P_next_rule_RULENR(P0)
value *P0;
{
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) + Int(L1));
  L3 = (value)G_rules_NR_OF_RULES_NR5;
  if (!(L2 == L3)) goto LAB104;
  return 0;
LAB104:
  L4 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L2));
  L5 = *((value*)L4);
  switch (Alternative(L5)) {
  case 0: goto LAB105;
  default: goto LAB107;
  };
LAB105:
  L6 = (value)(L5[1]);
  L7 = (value)(L5[2]);
  L8 = (value)(L5[3]);
  L9 = (value)(L5[4]);
  L10 = (value)(L5[5]);
  *P0 = L2;
  return 1;
LAB107:
  L11 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L2));
  L12 = *((value*)L11);
  switch (Alternative(L12)) {
  case 1: goto LAB108;
  default: goto LAB110;
  };
LAB108:
  L13 = (value)(L12[1]);
  L14 = (value)(L12[2]);
  L15 = (value)(L12[3]);
  L16 = (value)(L12[4]);
  L17 = (value)(L12[5]);
  *P0 = L2;
  return 1;
LAB110:
  L18 = L2;
  if (!Mrules_P_next_rule_RULENR(&L18)) goto LAB111;
  *P0 = L18;
  return 1;
LAB111:
  return 0;
  return 0;
}

int Mrules_P_first_rulename_RULEID(P0)
value *P0;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = C_INT(-1);
  L1 = L0;
  L2 = L1;
  L3 = C_INT(1);
  L4 = C_INT(Int(L2) + Int(L3));
  L5 = (value)G_rules_NR_OF_RULENAMES_NR6;
  if (!(L4 == L5)) goto LAB480;
LAB113:
  return 0;
LAB480:
  L1 = L4;
LAB478:
  *P0 = L1;
  return 1;
  return 0;
}

int Mrules_P_next_rulename_RULEID(P0)
value *P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) + Int(L1));
  L3 = (value)G_rules_NR_OF_RULENAMES_NR6;
  if (!(L2 == L3)) goto LAB116;
  return 0;
LAB116:
  *P0 = L2;
  return 1;
}

int Mrules_P_error_RULENR(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  Mrules_P_build_rule_RULENR_TEXT(L0,&L1);
  Merrors_P_error_text_TEXT(L1);
D_TEXT(L1);
  return 1;
}

int Mrules_P_error_RULENAME(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_rules_FIRST_NR2910;
  Mrules_P_build_rule_FIRST_RULENAME_TEXT(L1,L0,&L2);
  Merrors_P_error_text_TEXT(L2);
D_TEXT(L2);
  return 1;
}

int Mrules_P_build_rule_RULENR_TEXT(P0,P1)
value P0;
value *P1;
{
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 1: goto LAB117;
  default: goto LAB119;
  };
LAB117:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  L8 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L3));
  L9 = *((value*)L8);
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  L12 = (value)(L9[3]);
  Mrules_P_build_rule_RULETYPE_TEXT(L4,&L13);
  L14 = G_rules_FIRST_NR2911;
  Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(L14,L11,L5,&L15);
  L18 = G_rules_TEXT_NR2912;
  L17 = Concat(L13,L18);
D_TEXT(L13);
  L16 = Concat(L17,L15);
D_TEXT(L17);
D_TEXT(L15);
  *P1 = L16;
  return 1;
LAB119:
  L19 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L20 = *((value*)L19);
  switch (Alternative(L20)) {
  case 2: goto LAB120;
  default: goto LAB122;
  };
LAB120:
  L21 = (value)(L20[1]);
  L22 = (value)(L20[2]);
  L23 = (value)(L20[3]);
  L24 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L21));
  L25 = *((value*)L24);
  L26 = (value)(L25[1]);
  L27 = (value)(L25[2]);
  L28 = (value)(L25[3]);
  Mrules_P_build_rule_RULETYPE_TEXT(L22,&L29);
  L30 = G_rules_FIRST_NR2913;
  Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(L30,L27,L23,&L31);
  L34 = G_rules_TEXT_NR2914;
  L33 = Concat(L29,L34);
D_TEXT(L29);
  L32 = Concat(L33,L31);
D_TEXT(L33);
D_TEXT(L31);
  *P1 = L32;
  return 1;
LAB122:
  L35 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L0));
  L36 = *((value*)L35);
  switch (Alternative(L36)) {
  case 0: goto LAB123;
  default: goto LAB125;
  };
LAB123:
  L37 = (value)(L36[1]);
  L38 = (value)(L36[2]);
  L39 = (value)(L36[3]);
  L40 = (value)(L36[4]);
  L41 = (value)(L36[5]);
  L42 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L37));
  L43 = *((value*)L42);
  L44 = (value)(L43[1]);
  L45 = (value)(L43[2]);
  L46 = (value)(L43[3]);
  Mrules_P_build_rule_RULETYPE_TEXT(L38,&L47);
  L48 = G_rules_FIRST_NR2915;
  Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(L48,L45,L39,&L49);
  L52 = G_rules_TEXT_NR2916;
  L51 = Concat(L47,L52);
D_TEXT(L47);
  L50 = Concat(L51,L49);
D_TEXT(L51);
D_TEXT(L49);
  *P1 = L50;
  return 1;
LAB125:
  Abort(624, module_name);
}

int Mrules_P_build_rule_RULENAME_TEXT(P0,P1)
value P0;
value *P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_rules_FIRST_NR2917;
  Mrules_P_build_rule_FIRST_RULENAME_TEXT(L1,L0,&L2);
  *P1 = L2;
  return 1;
}

int Mrules_P_definition_errors()
{
  value L0;
  L0 = G_rules_ERRORS_NR10;
  switch (Alternative(L0)) {
  case 0: goto LAB126;
  default: goto LAB128;
  };
LAB126:
  return 1;
LAB128:
  return 0;
}

int Mrules_P_set_root_error_handler_HANDLER(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_rules_ROOT_ERROR_HANDLER_NR13;
  L2 = C_INT(-1);
  if (!(L1 == L2)) goto LAB130;
  G_rules_ROOT_ERROR_HANDLER_NR13 = (long)L0;
  return 1;
LAB130:
  Create(&L3,11,1);
  L4 = G_rules_TEXT_NR2918;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  Merrors_P_error_MESSAGE(L3);
if(DecrRefs(L3)<0)
XD_Merrors_T3(L3);
  Exit();
}

int Mrules_P_get_root_error_handler_HANDLER(P0)
value *P0;
{
  value L0;
  L0 = (value)G_rules_ROOT_ERROR_HANDLER_NR13;
  *P0 = L0;
  return 1;
}

int Mrules_P_set_root_rule_ROOT(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_rules_ROOT_RULE_ID_NR12;
  L2 = C_INT(-1);
  if (!(L1 == L2)) goto LAB132;
  G_rules_ROOT_RULE_ID_NR12 = (long)L0;
  return 1;
LAB132:
  Create(&L3,11,1);
  L4 = G_rules_TEXT_NR2919;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  Merrors_P_error_MESSAGE(L3);
if(DecrRefs(L3)<0)
XD_Merrors_T3(L3);
  Exit();
}

int Mrules_P_get_root_rule_ROOT(P0)
value *P0;
{
  value L2;
  value L1;
  value L0;
  L0 = (value)G_rules_ROOT_RULE_ID_NR12;
  L1 = C_INT(-1);
  if (!(L0 == L1)) goto LAB134;
  Abort(157, module_name);
LAB134:
  L2 = (value)G_rules_ROOT_RULE_ID_NR12;
  *P0 = L2;
  return 1;
}

int Mrules_P_init_hash_table()
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = C_INT(0);
  G_rules_NR_OF_RULES_NR5 = (long)L0;
  L1 = C_INT(0);
  G_rules_NR_OF_RULENAMES_NR6 = (long)L1;
  L2 = G_rules_RULENRS_NR2920;
  ATTACH(L2);
if(DecrRefs(G_rules_PRELUDES_NR7)<0)
XD_Mrules_T3(G_rules_PRELUDES_NR7);
  G_rules_PRELUDES_NR7 = L2;
  L3 = G_rules_RULENRS_NR2921;
  ATTACH(L3);
if(DecrRefs(G_rules_POSTLUDES_NR8)<0)
XD_Mrules_T3(G_rules_POSTLUDES_NR8);
  G_rules_POSTLUDES_NR8 = L3;
  L4 = G_rules_RULENRS_NR2922;
  ATTACH(L4);
if(DecrRefs(G_rules_INTERLUDES_NR9)<0)
XD_Mrules_T3(G_rules_INTERLUDES_NR9);
  G_rules_INTERLUDES_NR9 = L4;
  L5 = G_rules_ERRORS_NR2923;
  ATTACH(L5);
if(DecrRefs(G_rules_ERRORS_NR10)<0)
XD_Mrules_T11(G_rules_ERRORS_NR10);
  G_rules_ERRORS_NR10 = L5;
  L6 = C_INT(1024);
  L7 = L6;
LAB493:
  switch (Int(L7)) {
  case 0: goto LAB492;
  default: goto LAB496;
  };
LAB496:
  L8 = C_INT(1);
  L9 = C_INT(Int(L7) - Int(L8));
  L10 = G_rules_RULEIDLIST_NR2925;
  L11 = (value) Addr((value*)&G_rules_HASHEDRULENAMES_NR0,Int(L9));
  ATTACH(L10);
if(DecrRefs(*((value*)L11))<0)
XD_Mrules_T69(*((value*)L11));
  *((value *)L11) = L10;
  L7 = L9;
  goto LAB493;
LAB492:
  L12 = C_INT(-1);
  G_rules_ROOT_RULE_ID_NR12 = (long)L12;
LAB497:
  L13 = C_INT(-1);
  G_rules_ROOT_ERROR_HANDLER_NR13 = (long)L13;
  return 1;
  return 1;
}

int Mrules_P_def_error_MESSAGE(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  L1 = G_rules_ERRORS_NR2924;
  ATTACH(L1);
if(DecrRefs(G_rules_ERRORS_NR10)<0)
XD_Mrules_T11(G_rules_ERRORS_NR10);
  G_rules_ERRORS_NR10 = L1;
  Merrors_P_error_MESSAGE(L0);
  return 1;
}

int Mrules_P_init_hash_table_INDEX(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB491:
  switch (Int(L0)) {
  case 0: goto LAB135;
  default: goto LAB137;
  };
LAB135:
  return 1;
LAB137:
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) - Int(L1));
  L3 = G_rules_RULEIDLIST_NR2925;
  L4 = (value) Addr((value*)&G_rules_HASHEDRULENAMES_NR0,Int(L2));
  ATTACH(L3);
if(DecrRefs(*((value*)L4))<0)
XD_Mrules_T69(*((value*)L4));
  *((value *)L4) = L3;
  L0 = L2;
  goto LAB491;
}

int Mrules_P_hash_RULENAME_INDEX(P0,P1)
value P0;
value *P1;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB376:
  switch (Alternative(L0)) {
  case 0: goto LAB138;
  case 1: goto LAB141;
  default: goto LAB143;
  };
LAB138:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Mrules_P_hash_RULENAME_INDEX(L2,&L3);
  L4 = C_INT(Int(L3) + Int(L1));
  L5 = C_INT(1024);
  L6 = C_INT(Int(L4) % Int(L5));
  *P1 = L6;
  return 1;
LAB141:
  L7 = (value)(L0[1]);
  L0 = L7;
  goto LAB376;
LAB143:
  L9 = C_INT(0);
  *P1 = L9;
  return 1;
}

int Mrules_P_exists_MODULENR_RULENAME_ARITY_RULEIDLIST_RULEID(P0,P1,P2,P3,P4)
value P0;
value P1;
value P2;
value P3;
value *P4;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
LAB377:
  switch (Alternative(L3)) {
  case 0: goto LAB144;
  default: goto LAB146;
  };
LAB144:
  L4 = (value)(L3[1]);
  L5 = (value)(L3[2]);
  L6 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L4));
  L7 = *((value*)L6);
  L8 = (value)(L7[1]);
  L9 = (value)(L7[2]);
  L10 = (value)(L7[3]);
  if (!(L0 == L8)) goto LAB148;
  if (!EQ_Mrules_T15(L1,L9)) goto LAB148;
  if (!(L2 == L10)) goto LAB148;
  *P4 = L4;
  return 1;
LAB148:
  L3 = L5;
  goto LAB377;
  return 0;
LAB146:
  return 0;
}

int Mrules_P_equal_PARAMETERS_PARAMETERS(P0,P1)
value P0;
value P1;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L0)) {
  case 0: goto LAB155;
  case 1: goto LAB165;
  case 2: goto LAB173;
  default: goto LAB175;
  };
LAB155:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  L4 = (value)(L0[3]);
  L5 = (value)(L0[4]);
  switch (Alternative(L1)) {
  case 0: goto LAB158;
  default: goto LAB175;
  };
LAB158:
  L6 = (value)(L1[1]);
  L7 = (value)(L1[2]);
  L8 = (value)(L1[3]);
  L9 = (value)(L1[4]);
  if (!Mtypes_P_equal_types_TYPENR_TYPENR(L3,L7)) goto LAB175;
  if (!Mrules_P_equal_PARAMETERS_PARAMETERS(L5,L9)) goto LAB175;
  return 1;
LAB165:
  L10 = (value)(L0[1]);
  switch (Alternative(L1)) {
  case 1: goto LAB168;
  default: goto LAB175;
  };
LAB168:
  L11 = (value)(L1[1]);
  if (!Mrules_P_equal_PARAMETERS_PARAMETERS(L10,L11)) goto LAB175;
  return 1;
LAB173:
  switch (Alternative(L1)) {
  case 2: goto LAB176;
  default: goto LAB175;
  };
LAB176:
  return 1;
LAB175:
  return 0;
}

int Mrules_P_exists_RULETYPE_PARAMETERS_RULENRS_NODENR_RULENR(P0,P1,P2,P3,P4)
value P0;
value P1;
value P2;
value *P3;
value *P4;
{
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB407:
  switch (Alternative(L2)) {
  case 0: goto LAB179;
  default: goto LAB181;
  };
LAB179:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L3));
  L6 = *((value*)L5);
  switch (Alternative(L6)) {
  case 0: goto LAB182;
  default: goto LAB184;
  };
LAB182:
  L7 = (value)(L6[1]);
  L8 = (value)(L6[2]);
  L9 = (value)(L6[3]);
  L10 = (value)(L6[4]);
  L11 = (value)(L6[5]);
  if (!EQ_Mrules_T20(L0,L8)) goto LAB186;
  if (!Mrules_P_equal_PARAMETERS_PARAMETERS(L1,L9)) goto LAB186;
  *P4 = L3;
  *P3 = L11;
  return 1;
LAB186:
  L2 = L4;
  goto LAB407;
  return 0;
LAB184:
  L14 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L3));
  L15 = *((value*)L14);
  switch (Alternative(L15)) {
  case 1: goto LAB191;
  default: goto LAB193;
  };
LAB191:
  L16 = (value)(L15[1]);
  L17 = (value)(L15[2]);
  L18 = (value)(L15[3]);
  L19 = (value)(L15[4]);
  L20 = (value)(L15[5]);
  if (!EQ_Mrules_T20(L0,L17)) goto LAB195;
  if (!Mrules_P_equal_PARAMETERS_PARAMETERS(L1,L18)) goto LAB195;
  *P4 = L3;
  *P3 = L20;
  return 1;
LAB195:
  L2 = L4;
  goto LAB407;
  return 0;
LAB193:
  L23 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L3));
  L24 = *((value*)L23);
  switch (Alternative(L24)) {
  case 2: goto LAB200;
  default: goto LAB202;
  };
LAB200:
  L25 = (value)(L24[1]);
  L26 = (value)(L24[2]);
  L27 = (value)(L24[3]);
  if (!EQ_Mrules_T20(L0,L26)) goto LAB204;
  if (!Mrules_P_equal_PARAMETERS_PARAMETERS(L1,L27)) goto LAB204;
  L28 = C_INT(0);
  *P4 = L3;
  *P3 = L28;
  return 1;
LAB204:
  L2 = L4;
  goto LAB407;
  return 0;
LAB202:
  Abort(228, module_name);
LAB181:
  return 0;
}

int Mrules_P_propagate_rule_RULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_EXPORTS(P0,P1,P2,P3,P4,P5)
value P0;
value P1;
value P2;
value P3;
value P4;
value P5;
{
  value L112;
  value L111;
  value L110;
  value L109;
  value L108;
  value L107;
  value L106;
  value L105;
  value L104;
  value L103;
  value L102;
  value L101;
  value L100;
  value L99;
  value L98;
  value L97;
  value L96;
  value L95;
  value L94;
  value L93;
  value L92;
  value L91;
  value L90;
  value L89;
  value L88;
  value L87;
  value L86;
  value L85;
  value L84;
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = P4;
  L5 = P5;
LAB436:
  switch (Alternative(L5)) {
  case 0: goto LAB229;
  default: goto LAB231;
  };
LAB229:
  L6 = (value)(L5[1]);
  L7 = (value)(L5[2]);
  L8 = L0;
  L9 = L6;
  L10 = L1;
  L11 = L2;
  L12 = L3;
  L13 = L4;
  L83 = L9;
  L84 = L11;
  L85 = L12;
  Mrules_P_hash_RULENAME_INDEX(L84,&L86);
  L87 = (value) Addr((value*)&G_rules_HASHEDRULENAMES_NR0,Int(L86));
  L88 = *((value*)L87);
  ATTACH(L88);
  L101 = L83;
  L102 = L84;
  L103 = L85;
  L104 = L88;
LAB409:
  switch (Alternative(L104)) {
  case 0: goto LAB410;
  default: goto LAB422;
  };
LAB410:
  L105 = (value)(L104[1]);
  L106 = (value)(L104[2]);
  L107 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L105));
  L108 = *((value*)L107);
  L109 = (value)(L108[1]);
  L110 = (value)(L108[2]);
  L111 = (value)(L108[3]);
  if (!(L101 == L109)) goto LAB417;
  if (!EQ_Mrules_T15(L102,L110)) goto LAB417;
  if (!(L103 == L111)) goto LAB417;
  L89 = L105;
LAB415:
if(DecrRefs(L88)<0)
XD_Mrules_T69(L88);
  L14 = L89;
  goto LAB423;
LAB417:
  L104 = L106;
  goto LAB409;
LAB422:
if(DecrRefs(L88)<0)
XD_Mrules_T69(L88);
LAB424:
  L90 = (value)G_rules_NR_OF_RULENAMES_NR6;
  L91 = (value)G_rules_NR_OF_RULENAMES_NR6;
  L92 = C_INT(1);
  L93 = C_INT(Int(L91) + Int(L92));
  G_rules_NR_OF_RULENAMES_NR6 = (long)L93;
  Create(&L94,0,2);
  *(value *)(L94+1) = L90;
  L95 = (value) Addr((value*)&G_rules_HASHEDRULENAMES_NR0,Int(L86));
  L96 = *((value*)L95);
  ATTACH(L96);
  *(value *)(L94+2) = L96;
if(DecrRefs(*((value*)L95))<0)
XD_Mrules_T69(*((value*)L95));
  *((value *)L95) = L94;
  L97 = G_rules_RULENRS_NR2896;
  L98 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L90));
  ATTACH(L97);
if(DecrRefs(*((value*)L98))<0)
XD_Mrules_T3(*((value*)L98));
  *((value *)L98) = L97;
  Create(&L99,0,3);
  *(value *)(L99+1) = L83;
  *(value *)(L99+2) = L84;
  ATTACH(L84);
  *(value *)(L99+3) = L85;
  L100 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L90));
if(DecrRefs(*((value*)L100))<0)
XD_Mrules_T2(*((value*)L100));
  *((value *)L100) = L99;
  L14 = L90;
LAB423:
  L15 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L14));
  L16 = *((value*)L15);
  ATTACH(L16);
  if (!Mrules_P_exists_RULETYPE_PARAMETERS_RULENRS_NODENR_RULENR(L10,L13,L16,&L17,&L18)) goto LAB425;
if(DecrRefs(L16)<0)
XD_Mrules_T3(L16);
  L19 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L18));
  L20 = *((value*)L19);
  ATTACH(L20);
  switch (Alternative(L20)) {
  case 2: goto LAB426;
  default: goto LAB427;
  };
LAB426:
  L21 = (value)(L20[1]);
  L22 = (value)(L20[2]);
  L23 = (value)(L20[3]);
  L24 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L21));
if(DecrRefs(L20)<0)
XD_Mrules_T4(L20);
  L25 = *((value*)L24);
  ATTACH(L25);
  L26 = (value)(L25[1]);
  L27 = (value)(L25[2]);
  L28 = (value)(L25[3]);
  Create(&L29,4,2);
  *(value *)(L29+1) = L9;
  Create(&L30,6,2);
  L31 = G_rules_TEXT_NR2927;
  *(value *)(L30+1) = L31;
  ATTACH(L31);
  Create(&L32,0,2);
  *(value *)(L32+1) = L18;
  Create(&L33,6,2);
  L34 = G_rules_TEXT_NR2928;
  *(value *)(L33+1) = L34;
  ATTACH(L34);
  Create(&L35,4,2);
  *(value *)(L35+1) = L26;
if(DecrRefs(L25)<0)
XD_Mrules_T2(L25);
  Create(&L36,11,1);
  L37 = G_rules_TEXT_NR2929;
  *(value *)(L36+1) = L37;
  ATTACH(L37);
  *(value *)(L35+2) = L36;
  *(value *)(L33+2) = L35;
  *(value *)(L32+2) = L33;
  *(value *)(L30+2) = L32;
  *(value *)(L29+2) = L30;
  Mrules_P_def_error_MESSAGE(L29);
if(DecrRefs(L29)<0)
XD_Merrors_T3(L29);
  goto LAB408;
LAB425:
if(DecrRefs(L16)<0)
XD_Mrules_T3(L16);
LAB428:
  Create(&L80,0,2);
  *(value *)(L80+1) = L8;
  L81 = (value) Addr((value*)&G_rules_RULENRS_NR2,Int(L14));
  L82 = *((value*)L81);
  ATTACH(L82);
  *(value *)(L80+2) = L82;
if(DecrRefs(*((value*)L81))<0)
XD_Mrules_T3(*((value*)L81));
  *((value *)L81) = L80;
LAB408:
  L5 = L7;
  goto LAB436;
LAB427:
if(DecrRefs(L20)<0)
XD_Mrules_T4(L20);
LAB429:
  L38 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L18));
  L39 = *((value*)L38);
  ATTACH(L39);
  switch (Alternative(L39)) {
  case 1: goto LAB430;
  default: goto LAB431;
  };
LAB430:
  L40 = (value)(L39[1]);
  L41 = (value)(L39[2]);
  L42 = (value)(L39[3]);
  L43 = (value)(L39[4]);
  L44 = (value)(L39[5]);
  L45 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L40));
if(DecrRefs(L39)<0)
XD_Mrules_T4(L39);
  L46 = *((value*)L45);
  ATTACH(L46);
  L47 = (value)(L46[1]);
  L48 = (value)(L46[2]);
  L49 = (value)(L46[3]);
  Create(&L50,4,2);
  *(value *)(L50+1) = L9;
  Create(&L51,6,2);
  L52 = G_rules_TEXT_NR2930;
  *(value *)(L51+1) = L52;
  ATTACH(L52);
  Create(&L53,0,2);
  *(value *)(L53+1) = L18;
  Create(&L54,6,2);
  L55 = G_rules_TEXT_NR2931;
  *(value *)(L54+1) = L55;
  ATTACH(L55);
  Create(&L56,4,2);
  *(value *)(L56+1) = L47;
if(DecrRefs(L46)<0)
XD_Mrules_T2(L46);
  Create(&L57,11,1);
  L58 = G_rules_TEXT_NR2932;
  *(value *)(L57+1) = L58;
  ATTACH(L58);
  *(value *)(L56+2) = L57;
  *(value *)(L54+2) = L56;
  *(value *)(L53+2) = L54;
  *(value *)(L51+2) = L53;
  *(value *)(L50+2) = L51;
  Mrules_P_def_error_MESSAGE(L50);
if(DecrRefs(L50)<0)
XD_Merrors_T3(L50);
  goto LAB408;
LAB431:
if(DecrRefs(L39)<0)
XD_Mrules_T4(L39);
LAB432:
  L59 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L18));
  L60 = *((value*)L59);
  ATTACH(L60);
  switch (Alternative(L60)) {
  case 0: goto LAB433;
  default: goto LAB434;
  };
LAB433:
  L61 = (value)(L60[1]);
  L62 = (value)(L60[2]);
  L63 = (value)(L60[3]);
  L64 = (value)(L60[4]);
  L65 = (value)(L60[5]);
  L66 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L61));
if(DecrRefs(L60)<0)
XD_Mrules_T4(L60);
  L67 = *((value*)L66);
  ATTACH(L67);
  L68 = (value)(L67[1]);
  L69 = (value)(L67[2]);
  L70 = (value)(L67[3]);
  Create(&L71,4,2);
  *(value *)(L71+1) = L9;
  Create(&L72,6,2);
  L73 = G_rules_TEXT_NR2933;
  *(value *)(L72+1) = L73;
  ATTACH(L73);
  Create(&L74,0,2);
  *(value *)(L74+1) = L18;
  Create(&L75,6,2);
  L76 = G_rules_TEXT_NR2934;
  *(value *)(L75+1) = L76;
  ATTACH(L76);
  Create(&L77,4,2);
  *(value *)(L77+1) = L68;
if(DecrRefs(L67)<0)
XD_Mrules_T2(L67);
  Create(&L78,11,1);
  L79 = G_rules_TEXT_NR2935;
  *(value *)(L78+1) = L79;
  ATTACH(L79);
  *(value *)(L77+2) = L78;
  *(value *)(L75+2) = L77;
  *(value *)(L74+2) = L75;
  *(value *)(L72+2) = L74;
  *(value *)(L71+2) = L72;
  Mrules_P_def_error_MESSAGE(L71);
if(DecrRefs(L71)<0)
XD_Merrors_T3(L71);
  goto LAB408;
LAB434:
if(DecrRefs(L60)<0)
XD_Mrules_T4(L60);
  Abort(410, module_name);
  Abort(410, module_name);
LAB231:
  return 1;
}

int Mrules_P_propagate_rules_RULENR(P0)
value P0;
{
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB447:
  switch (Int(L0)) {
  case 0: goto LAB241;
  default: goto LAB243;
  };
LAB241:
  return 1;
LAB243:
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) - Int(L1));
  L5 = L2;
  L6 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L5));
  L7 = *((value*)L6);
  ATTACH(L7);
  switch (Alternative(L7)) {
  case 1: goto LAB438;
  default: goto LAB439;
  };
LAB438:
  L8 = (value)(L7[1]);
  L9 = (value)(L7[2]);
  L10 = (value)(L7[3]);
  L11 = (value)(L7[4]);
  L12 = (value)(L7[5]);
  L13 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L8));
  L14 = *((value*)L13);
  ATTACH(L14);
  L15 = (value)(L14[1]);
  L16 = (value)(L14[2]);
  L17 = (value)(L14[3]);
  Mmodules_P_get_MODULENR_EXPORTS(L15,&L18);
  Mrules_P_propagate_rule_RULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_EXPORTS(L5,L9,L16,L17,L10,L18);
if(DecrRefs(L18)<0)
XD_Mmodules_T5(L18);
if(DecrRefs(L14)<0)
XD_Mrules_T2(L14);
if(DecrRefs(L7)<0)
XD_Mrules_T4(L7);
  goto LAB437;
LAB439:
if(DecrRefs(L7)<0)
XD_Mrules_T4(L7);
LAB440:
  L19 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L5));
  L20 = *((value*)L19);
  ATTACH(L20);
  switch (Alternative(L20)) {
  case 2: goto LAB441;
  default: goto LAB442;
  };
LAB441:
  L21 = (value)(L20[1]);
  L22 = (value)(L20[2]);
  L23 = (value)(L20[3]);
  L24 = (value) Addr((value*)&G_rules_RULENAMES_NR1,Int(L21));
  L25 = *((value*)L24);
  ATTACH(L25);
  L26 = (value)(L25[1]);
  L27 = (value)(L25[2]);
  L28 = (value)(L25[3]);
  Mnodes_P_new_NODENR(&L29);
  Create(&L30,1,5);
  *(value *)(L30+1) = L21;
  *(value *)(L30+2) = L22;
  ATTACH(L22);
  *(value *)(L30+3) = L23;
  ATTACH(L23);
if(DecrRefs(L20)<0)
XD_Mrules_T4(L20);
  L31 = G_rules_EXTNR_NR2936;
  *(value *)(L30+4) = L31;
  ATTACH(L31);
  *(value *)(L30+5) = L29;
if(DecrRefs(*((value*)L19))<0)
XD_Mrules_T4(*((value*)L19));
  *((value *)L19) = L30;
  Minline_P_declare_rule_RULENR(L5);
  Create(&L32,4,2);
  *(value *)(L32+1) = L26;
if(DecrRefs(L25)<0)
XD_Mrules_T2(L25);
  Create(&L33,6,2);
  L34 = G_rules_TEXT_NR2937;
  *(value *)(L33+1) = L34;
  ATTACH(L34);
  Create(&L35,0,2);
  *(value *)(L35+1) = L5;
  Create(&L36,11,1);
  L37 = G_rules_TEXT_NR2938;
  *(value *)(L36+1) = L37;
  ATTACH(L37);
  *(value *)(L35+2) = L36;
  *(value *)(L33+2) = L35;
  *(value *)(L32+2) = L33;
  Mrules_P_def_error_MESSAGE(L32);
if(DecrRefs(L32)<0)
XD_Merrors_T3(L32);
  goto LAB437;
LAB442:
if(DecrRefs(L20)<0)
XD_Mrules_T4(L20);
LAB443:
  L38 = (value) Addr((value*)&G_rules_RULES_NR3,Int(L5));
  L39 = *((value*)L38);
  ATTACH(L39);
  switch (Alternative(L39)) {
  case 0: goto LAB444;
  default: goto LAB445;
  };
LAB444:
  L40 = (value)(L39[1]);
  L41 = (value)(L39[2]);
  L42 = (value)(L39[3]);
  L43 = (value)(L39[4]);
  L44 = (value)(L39[5]);
if(DecrRefs(L39)<0)
XD_Mrules_T4(L39);
LAB437:
  L3 = C_INT(1);
  L4 = C_INT(Int(L0) - Int(L3));
  L0 = L4;
  goto LAB447;
LAB445:
if(DecrRefs(L39)<0)
XD_Mrules_T4(L39);
  Abort(431, module_name);
  Abort(431, module_name);
}

int Mrules_P_error_RULETYPE(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  Mrules_P_build_rule_RULETYPE_TEXT(L0,&L1);
  Merrors_P_error_text_TEXT(L1);
D_TEXT(L1);
  return 1;
}

int Mrules_P_build_rule_RULETYPE_TEXT(P0,P1)
value P0;
value *P1;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB244;
  case 2: goto LAB247;
  case 1: goto LAB250;
  case 3: goto LAB253;
  case 4: goto LAB256;
  case 5: goto LAB259;
  case 6: goto LAB262;
  case 7: goto LAB265;
  default: goto LAB267;
  };
LAB244:
  L1 = G_rules_TEXT_NR2939;
  *P1 = L1;
  ATTACH(L1);
  return 1;
LAB247:
  L2 = G_rules_TEXT_NR2940;
  *P1 = L2;
  ATTACH(L2);
  return 1;
LAB250:
  L3 = G_rules_TEXT_NR2941;
  *P1 = L3;
  ATTACH(L3);
  return 1;
LAB253:
  L4 = G_rules_TEXT_NR2942;
  *P1 = L4;
  ATTACH(L4);
  return 1;
LAB256:
  L5 = G_rules_TEXT_NR2943;
  *P1 = L5;
  ATTACH(L5);
  return 1;
LAB259:
  L6 = G_rules_TEXT_NR2944;
  *P1 = L6;
  ATTACH(L6);
  return 1;
LAB262:
  L7 = G_rules_TEXT_NR2945;
  *P1 = L7;
  ATTACH(L7);
  return 1;
LAB265:
  L8 = (value)(L0[1]);
  L9 = (value)(L0[2]);
  Mrules_P_build_rule_RULETYPE_TEXT(L8,&L10);
  Mrules_P_build_rule_RULETYPE_TEXT(L9,&L11);
  L15 = G_rules_TEXT_NR2946;
  L14 = Concat(L10,L15);
D_TEXT(L10);
  L13 = Concat(L14,L11);
D_TEXT(L14);
D_TEXT(L11);
  L16 = G_rules_TEXT_NR2947;
  L12 = Concat(L13,L16);
D_TEXT(L13);
  *P1 = L12;
  return 1;
LAB267:
  Abort(476, module_name);
}

int Mrules_P_build_rule_parameter_TEXT_FIRST_RULENAME_TEXT(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L1)) {
  case 0: goto LAB268;
  case 1: goto LAB277;
  case 2: goto LAB286;
  default: goto LAB288;
  };
LAB268:
  switch (Alternative(L2)) {
  case 1: goto LAB271;
  case 3: goto LAB274;
  default: goto LAB276;
  };
LAB271:
  L3 = (value)(L2[1]);
  L4 = G_rules_FIRST_NR2948;
  Mrules_P_build_rule_FIRST_RULENAME_TEXT(L4,L2,&L5);
  L8 = G_rules_TEXT_NR2949;
  L7 = Concat(L8,L0);
  L6 = Concat(L7,L5);
D_TEXT(L7);
D_TEXT(L5);
  *P3 = L6;
  return 1;
LAB274:
  *P3 = L0;
  ATTACH(L0);
  return 1;
LAB276:
  Mrules_P_build_rule_FIRST_RULENAME_TEXT(L1,L2,&L9);
  L12 = G_rules_TEXT_NR2950;
  L11 = Concat(L0,L12);
  L10 = Concat(L11,L9);
D_TEXT(L11);
D_TEXT(L9);
  *P3 = L10;
  return 1;
LAB277:
  switch (Alternative(L2)) {
  case 1: goto LAB280;
  case 3: goto LAB283;
  default: goto LAB285;
  };
LAB280:
  L13 = (value)(L2[1]);
  L14 = G_rules_FIRST_NR2951;
  Mrules_P_build_rule_FIRST_RULENAME_TEXT(L14,L2,&L15);
  L18 = G_rules_TEXT_NR2952;
  L17 = Concat(L18,L0);
  L16 = Concat(L17,L15);
D_TEXT(L17);
D_TEXT(L15);
  *P3 = L16;
  return 1;
LAB283:
  L21 = G_rules_TEXT_NR2953;
  L20 = Concat(L21,L0);
  L22 = G_rules_TEXT_NR2954;
  L19 = Concat(L20,L22);
D_TEXT(L20);
  *P3 = L19;
  return 1;
LAB285:
  L23 = G_rules_FIRST_NR2955;
  Mrules_P_build_rule_FIRST_RULENAME_TEXT(L23,L2,&L24);
  L27 = G_rules_TEXT_NR2956;
  L26 = Concat(L0,L27);
  L25 = Concat(L26,L24);
D_TEXT(L26);
D_TEXT(L24);
  *P3 = L25;
  return 1;
LAB286:
  switch (Alternative(L2)) {
  case 1: goto LAB289;
  case 3: goto LAB292;
  default: goto LAB294;
  };
LAB289:
  L28 = (value)(L2[1]);
  Mrules_P_build_rule_FIRST_RULENAME_TEXT(L1,L2,&L29);
  L32 = G_rules_TEXT_NR2957;
  L31 = Concat(L32,L0);
  L30 = Concat(L31,L29);
D_TEXT(L31);
D_TEXT(L29);
  *P3 = L30;
  return 1;
LAB292:
  L35 = G_rules_TEXT_NR2958;
  L34 = Concat(L35,L0);
  L36 = G_rules_TEXT_NR2959;
  L33 = Concat(L34,L36);
D_TEXT(L34);
  *P3 = L33;
  return 1;
LAB294:
  L37 = G_rules_FIRST_NR2960;
  Mrules_P_build_rule_FIRST_RULENAME_TEXT(L37,L2,&L38);
  L42 = G_rules_TEXT_NR2961;
  L41 = Concat(L42,L0);
  L43 = G_rules_TEXT_NR2962;
  L40 = Concat(L41,L43);
D_TEXT(L41);
  L39 = Concat(L40,L38);
D_TEXT(L40);
D_TEXT(L38);
  *P3 = L39;
  return 1;
LAB288:
  Abort(514, module_name);
}

int Mrules_P_build_rule_FIRST_RULENAME_TEXT(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L1)) {
  case 0: goto LAB295;
  case 2: goto LAB301;
  case 1: goto LAB307;
  case 3: goto LAB310;
  default: goto LAB312;
  };
LAB295:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  Mterminals_P_get_TERMINALNR_TERMINAL(L2,&L4);
  switch (Alternative(L3)) {
  case 3: goto LAB298;
  default: goto LAB300;
  };
LAB298:
  *P2 = L4;
  return 1;
LAB300:
  Mrules_P_build_rule_FIRST_RULENAME_TEXT(L0,L3,&L5);
  L8 = G_rules_TEXT_NR2963;
  L7 = Concat(L4,L8);
D_TEXT(L4);
  L6 = Concat(L7,L5);
D_TEXT(L7);
D_TEXT(L5);
  *P2 = L6;
  return 1;
LAB301:
  L9 = (value)(L1[1]);
  switch (Alternative(L9)) {
  case 1: goto LAB304;
  default: goto LAB306;
  };
LAB304:
  L10 = (value)(L9[1]);
  L11 = G_rules_TEXT_NR2964;
  Mrules_P_build_rule_parameter_TEXT_FIRST_RULENAME_TEXT(L11,L0,L10,&L12);
  *P2 = L12;
  return 1;
LAB306:
  Abort(526, module_name);
LAB307:
  L13 = (value)(L1[1]);
  L14 = G_rules_TEXT_NR2965;
  Mrules_P_build_rule_parameter_TEXT_FIRST_RULENAME_TEXT(L14,L0,L13,&L15);
  *P2 = L15;
  return 1;
LAB310:
  L16 = G_rules_TEXT_NR2966;
  *P2 = L16;
  ATTACH(L16);
  return 1;
LAB312:
  Abort(531, module_name);
}

int Mrules_P_build_rule_parameter_FIRST_RULENAME_PARAMETERS_TEXT(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L0)) {
  case 0: goto LAB313;
  case 1: goto LAB322;
  case 2: goto LAB331;
  default: goto LAB333;
  };
LAB313:
  switch (Alternative(L1)) {
  case 1: goto LAB316;
  default: goto LAB318;
  };
LAB316:
  L3 = (value)(L1[1]);
  L4 = L2;
  ATTACH(L4);
  Mrules_P_build_rule_parameter_PARAMETERS_TEXT(&L4,&L5);
  L6 = G_rules_FIRST_NR2967;
  Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(L6,L1,L4,&L7);
if(DecrRefs(L4)<0)
XD_Mrules_T21(L4);
  L10 = G_rules_TEXT_NR2968;
  L9 = Concat(L10,L5);
D_TEXT(L5);
  L8 = Concat(L9,L7);
D_TEXT(L9);
D_TEXT(L7);
  *P3 = L8;
  return 1;
LAB318:
  L11 = L2;
  ATTACH(L11);
  Mrules_P_build_rule_parameter_PARAMETERS_TEXT(&L11,&L12);
  switch (Alternative(L1)) {
  case 3: goto LAB319;
  default: goto LAB321;
  };
LAB319:
if(DecrRefs(L11)<0)
XD_Mrules_T21(L11);
  *P3 = L12;
  return 1;
LAB321:
  Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(L0,L1,L11,&L13);
if(DecrRefs(L11)<0)
XD_Mrules_T21(L11);
  L16 = G_rules_TEXT_NR2969;
  L15 = Concat(L12,L16);
D_TEXT(L12);
  L14 = Concat(L15,L13);
D_TEXT(L15);
D_TEXT(L13);
  *P3 = L14;
  return 1;
LAB322:
  switch (Alternative(L1)) {
  case 1: goto LAB325;
  case 3: goto LAB328;
  default: goto LAB330;
  };
LAB325:
  L17 = (value)(L1[1]);
  L18 = L2;
  ATTACH(L18);
  Mrules_P_build_rule_parameter_PARAMETERS_TEXT(&L18,&L19);
  L20 = G_rules_FIRST_NR2970;
  Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(L20,L1,L18,&L21);
if(DecrRefs(L18)<0)
XD_Mrules_T21(L18);
  L24 = G_rules_TEXT_NR2971;
  L23 = Concat(L24,L19);
D_TEXT(L19);
  L22 = Concat(L23,L21);
D_TEXT(L23);
D_TEXT(L21);
  *P3 = L22;
  return 1;
LAB328:
  L25 = L2;
  ATTACH(L25);
  Mrules_P_build_rule_parameter_PARAMETERS_TEXT(&L25,&L26);
if(DecrRefs(L25)<0)
XD_Mrules_T21(L25);
  L29 = G_rules_TEXT_NR2972;
  L28 = Concat(L29,L26);
D_TEXT(L26);
  L30 = G_rules_TEXT_NR2973;
  L27 = Concat(L28,L30);
D_TEXT(L28);
  *P3 = L27;
  return 1;
LAB330:
  L31 = L2;
  ATTACH(L31);
  Mrules_P_build_rule_parameter_PARAMETERS_TEXT(&L31,&L32);
  L33 = G_rules_FIRST_NR2974;
  Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(L33,L1,L31,&L34);
if(DecrRefs(L31)<0)
XD_Mrules_T21(L31);
  L37 = G_rules_TEXT_NR2975;
  L36 = Concat(L32,L37);
D_TEXT(L32);
  L35 = Concat(L36,L34);
D_TEXT(L36);
D_TEXT(L34);
  *P3 = L35;
  return 1;
LAB331:
  switch (Alternative(L1)) {
  case 1: goto LAB334;
  default: goto LAB336;
  };
LAB334:
  L38 = (value)(L1[1]);
  L39 = L2;
  ATTACH(L39);
  Mrules_P_build_rule_parameter_PARAMETERS_TEXT(&L39,&L40);
  Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(L0,L1,L39,&L41);
if(DecrRefs(L39)<0)
XD_Mrules_T21(L39);
  L44 = G_rules_TEXT_NR2976;
  L43 = Concat(L44,L40);
D_TEXT(L40);
  L42 = Concat(L43,L41);
D_TEXT(L43);
D_TEXT(L41);
  *P3 = L42;
  return 1;
LAB336:
  L45 = L2;
  ATTACH(L45);
  Mrules_P_build_rule_parameter_PARAMETERS_TEXT(&L45,&L46);
  switch (Alternative(L1)) {
  case 3: goto LAB337;
  default: goto LAB339;
  };
LAB337:
if(DecrRefs(L45)<0)
XD_Mrules_T21(L45);
  L49 = G_rules_TEXT_NR2977;
  L48 = Concat(L49,L46);
D_TEXT(L46);
  L50 = G_rules_TEXT_NR2978;
  L47 = Concat(L48,L50);
D_TEXT(L48);
  *P3 = L47;
  return 1;
LAB339:
  L51 = G_rules_FIRST_NR2979;
  Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(L51,L1,L45,&L52);
if(DecrRefs(L45)<0)
XD_Mrules_T21(L45);
  L56 = G_rules_TEXT_NR2980;
  L55 = Concat(L56,L46);
D_TEXT(L46);
  L57 = G_rules_TEXT_NR2981;
  L54 = Concat(L55,L57);
D_TEXT(L55);
  L53 = Concat(L54,L52);
D_TEXT(L54);
D_TEXT(L52);
  *P3 = L53;
  return 1;
LAB333:
  Abort(564, module_name);
}

int Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L1)) {
  case 0: goto LAB340;
  case 2: goto LAB346;
  case 1: goto LAB352;
  case 3: goto LAB355;
  default: goto LAB357;
  };
LAB340:
  L3 = (value)(L1[1]);
  L4 = (value)(L1[2]);
  Mterminals_P_get_TERMINALNR_TERMINAL(L3,&L5);
  switch (Alternative(L4)) {
  case 3: goto LAB343;
  default: goto LAB345;
  };
LAB343:
  *P3 = L5;
  return 1;
LAB345:
  Mrules_P_build_rule_FIRST_RULENAME_PARAMETERS_TEXT(L0,L4,L2,&L6);
  L9 = G_rules_TEXT_NR2982;
  L8 = Concat(L5,L9);
D_TEXT(L5);
  L7 = Concat(L8,L6);
D_TEXT(L8);
D_TEXT(L6);
  *P3 = L7;
  return 1;
LAB346:
  L10 = (value)(L1[1]);
  switch (Alternative(L10)) {
  case 1: goto LAB349;
  default: goto LAB351;
  };
LAB349:
  L11 = (value)(L10[1]);
  Mrules_P_build_rule_parameter_FIRST_RULENAME_PARAMETERS_TEXT(L0,L11,L2,&L12);
  *P3 = L12;
  return 1;
LAB351:
  Abort(576, module_name);
LAB352:
  L13 = (value)(L1[1]);
  Mrules_P_build_rule_parameter_FIRST_RULENAME_PARAMETERS_TEXT(L0,L13,L2,&L14);
  *P3 = L14;
  return 1;
LAB355:
  L15 = G_rules_TEXT_NR2983;
  *P3 = L15;
  ATTACH(L15);
  return 1;
LAB357:
  Abort(581, module_name);
}

int Mrules_P_build_rule_parameter_PARAMETERS_TEXT(P0,P1)
value *P0;
value *P1;
{
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  switch (Alternative(L0)) {
  case 0: goto LAB358;
  case 1: goto LAB361;
  case 2: goto LAB364;
  default: goto LAB366;
  };
LAB358:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L3 = (value)(L0[3]);
  L4 = (value)(L0[4]);
  L12 = L1;
  L13 = L2;
  L14 = L3;
  Mtypes_P_get_TYPENR_TYPENAME_MODULENR(L13,&L15,&L16);
  Mvariables_P_build_instance_INSTANCE_TEXT(L14,&L17);
  switch (Alternative(L12)) {
  case 0: goto LAB482;
  case 1: goto LAB485;
  case 2: goto LAB488;
  default: goto LAB490;
  };
LAB482:
  L20 = G_rules_TEXT_NR2986;
  L19 = Concat(L20,L15);
D_TEXT(L15);
  L18 = Concat(L19,L17);
D_TEXT(L19);
D_TEXT(L17);
  L5 = L18;
  goto LAB481;
LAB485:
  L22 = Concat(L15,L17);
D_TEXT(L17);
D_TEXT(L15);
  L23 = G_rules_TEXT_NR2987;
  L21 = Concat(L22,L23);
D_TEXT(L22);
  L5 = L21;
  goto LAB481;
LAB488:
  L27 = G_rules_TEXT_NR2988;
  L26 = Concat(L27,L15);
D_TEXT(L15);
  L25 = Concat(L26,L17);
D_TEXT(L26);
D_TEXT(L17);
  L28 = G_rules_TEXT_NR2989;
  L24 = Concat(L25,L28);
D_TEXT(L25);
  L5 = L24;
LAB481:
  *P1 = L5;
  *P0 = L4;
  ATTACH(L4);
if(DecrRefs(L0)<0)
XD_Mrules_T21(L0);
  return 1;
LAB490:
D_TEXT(L17);
D_TEXT(L15);
  Abort(602, module_name);
LAB361:
  L6 = (value)(L0[1]);
  L7 = L6;
  ATTACH(L7);
if(DecrRefs(L0)<0)
XD_Mrules_T21(L0);
  Mrules_P_build_rule_parameter_PARAMETERS_TEXT(&L7,&L8);
  L10 = G_rules_TEXT_NR2984;
  L9 = Concat(L10,L8);
D_TEXT(L8);
  *P1 = L9;
  *P0 = L7;
  return 1;
LAB364:
  L11 = G_rules_TEXT_NR2985;
  *P1 = L11;
  ATTACH(L11);
  *P0 = L0;
  return 1;
LAB366:
if(DecrRefs(L0)<0)
XD_Mrules_T21(L0);
  Abort(591, module_name);
}

