/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/basdef.h,v $
 * $Id: basdef.h,v 1.2 1999/07/21 20:54:48 heiner Exp $
 *
 *	Basic definitions.
 *	WARNING:	Must not depend on anything generated,
 *			since this is part of the generators.
 */

#ifndef CHEST_basdef_h_INCLUDED
#define CHEST_basdef_h_INCLUDED

/*
 * PROD_LEV == 0	development version: all features enabled (default).
 * PROD_LEV == 1	intermediate version: basic debugging still there,
 *			basic statistics still there.
 * PROD_LEV == 2	production version: many features disabled.
 *			No debugging support, no statistics,
 *			but also somewhat smaller & faster.
 */
#ifndef  PROD_LEV
# define PROD_LEV	0
#endif

/*
 * There are two ways to compile CHEST: either module by module
 * (separate compilation) or all in one ("allchest.c").
 * In the latter case (nearly) all external declarations and
 * implementations are turned into static ones, which may help
 * the optimizer.
 */
#ifndef  Extern				/* external declaration */
# define Extern		extern
#endif
#ifndef  Eximpl				/* external implementation */
# define Eximpl		/*empty*/
#endif

/*
 * Some declarations of large, implicitly zero-initialized arrays are
 * prefixed by "I0static" (instead of static).  This handle can be used
 * to stop some annoying compilers from converting them into explicitly
 * initialized data (which creates huge binaries).
 */
#ifndef  I0static			/* BSS: 0-inited data */
# define I0static	static
#endif

/*
 * With Borland/Inprise or Microsoft compilers we have to insert a
 * special mark before some function names (declaration & implementation):
 * - main()
 * - variadic functions (variable number of arguments).
 */
#if defined(_WIN32)
# define CDECL_	__cdecl		/* magic compiler hint */
#else
# define CDECL_	/*empty*/
#endif


#define TRUE	1
#define FALSE	0

#if ! defined(__STDC__)
# define const	/*nothing*/
# define signed	/*nothing*/
#endif

/*
 * Helper for separation of (possibly empty) macros in macros.
 * Example(s) in "xatt.h"/"xatt_global.h".
 */
#define TOK_			/* nothing */
#define TOK_C		,	/* comma */

#define TOK_TOK_	TOK_
#define TOK_TOK_C	TOK_C


/*
 * in_range() is general purpose range checking macro for integral types.
 * Note, that the lower bound is inclusive and the upper bound exclusive !
 * Note, that only the lower bound is expanded more than once.
 */
#define in_range(x, lo, hi)					\
	(  (((unsigned long)(x )) - ((unsigned long)(lo)))	\
	 < (((unsigned long)(hi)) - ((unsigned long)(lo)))	\
	)

/*
 * In order to avoid warnings about type promotions for ">>":
 */
#define USHR(v,c)	(((unsigned     )(v)) >> (c))	/* make lint happy */
#define ULSHR(v,c)	(((unsigned long)(v)) >> (c))	/* make lint happy */

/*
 * Helpers for accessing declaration properties without constants:
 */
#define NELEMS(arr)		(sizeof(arr) / sizeof(*(arr)))
#define NELEMS2(type,member)	NELEMS(((type *)0)->member)

#define OFFSET2(type,member)			\
 ( ((char *) (&(((type *) 0)->member)))		\
 - ((char *)    ((type *) 0))			\
 )

#endif	/* ndef CHEST_basdef_h_INCLUDED */
