/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/lang.c,v $
 * $Id: lang.c,v 3.2 1999/07/20 21:03:15 heiner Exp $
 *
 *	Languages
 */

#include "lang.h"

    Eximpl int
lang_of_char( char c )
{
    switch( c ) {
     case 'E': case 'e':	/* english */
	return LANG_ENGLISH;
     case 'G': case 'g':	/* german */
     case 'D': case 'd':	/* deutsch */
	return LANG_GERMAN;
    }
    return LANG_NONE;
}

#define SW_COLOUR(c,w,b)	\
	switch( c ) { case white: return w; case black:	return b; }

    Eximpl char
lang_chr_colour( int lang, Colour c )
{
    switch( no_lang(lang) ? DFT_LANG : lang ) {
     case LANG_ENGLISH:	SW_COLOUR(c, 'w', 'b'); break;
     case LANG_GERMAN:	SW_COLOUR(c, 'w', 's'); break;
    }
    return '?';
}

    Eximpl char
lang_chr_Colour( int lang, Colour c )
{
    switch( no_lang(lang) ? DFT_LANG : lang ) {
     case LANG_ENGLISH:	SW_COLOUR(c, 'W', 'B'); break;
     case LANG_GERMAN:	SW_COLOUR(c, 'W', 'S'); break;
    }
    return '?';
}


#define SW_FIG(f, b,s,l,t,d,k)		\
	switch( f ) {			\
	 case bauer:	return b;	\
	 case springer:	return s;	\
	 case laeufer:	return l;	\
	 case turm:	return t;	\
	 case dame:	return d;	\
	 case koenig:	return k;	\
	}

    Eximpl char
lang_chr_figure( int lang, Figure f )
{
    switch( no_lang(lang) ? DFT_LANG : lang ) {
     case LANG_ENGLISH:	SW_FIG(f, 'p', 'n', 'b', 'r', 'q', 'k'); break;
     case LANG_GERMAN:	SW_FIG(f, 'b', 's', 'l', 't', 'd', 'k'); break;
    }
    return '?';
}

    Eximpl char
lang_chr_Figure( int lang, Figure f )
{
    switch( no_lang(lang) ? DFT_LANG : lang ) {
     case LANG_ENGLISH:	SW_FIG(f, 'P', 'N', 'B', 'R', 'Q', 'K'); break;
     case LANG_GERMAN:	SW_FIG(f, 'B', 'S', 'L', 'T', 'D', 'K'); break;
    }
    return '?';
}
