#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#if defined (__linux__)
#include <linux/if.h>
#else
#include <net/if.h>
#endif

#include "chksniff.h"

int
main(int argc, char *argv[])
{
	struct ifreq   *ifr = NULL;
	struct ifconf   ifc;
	char           *iname;
	int             fd, i, n, ch;
	int             promisc = 0;
	char            buff[8192];
	extern char    *optarg;
	extern int      optind;

	if (argc > 1) {
		if (strcmp(argv[1], "-h") || strcmp(argv[1], "-v")) {
			usage();
		}
	}
	while ((ch = getopt(argc, argv, "hv")) != -1)
		switch (ch) {
		case 'h':	/* help */
			usage();/* display usage info */
			break;
		case 'v':	/* version */
			printf("chksniff version %s\n", VERSION);	/* give version info */
			exit(EXIT_SUCCESS);
			break;
		case '?':
		default:
			usage();
		}
	argc -= optind;
	argv += optind;


	if ((fd = socket(PF_INET, SOCK_DGRAM, 0)) == -1) {
		perror("socket");
		exit(EXIT_FAILURE);
	}
	ifc.ifc_len = sizeof(buff);
	ifc.ifc_buf = buff;

	if (ioctl(fd, SIOCGIFCONF, &ifc) != 0) {
		perror("ioctl");
		close(fd);
		return -1;
	}
	ifr = ifc.ifc_req;
	n = ifc.ifc_len / sizeof(struct ifreq);

	for (i = n - 1; i >= 0; i--) {
		promisc = 0;
		if (ioctl(fd, SIOCGIFFLAGS, &ifr[i]) != 0) {
			continue;
		}
		if (!(ifr[i].ifr_flags & IFF_UP)) {
			continue;
		}
		if ((ifr[i].ifr_flags & IFF_PROMISC)) {
			promisc = 1;
		}
		if (ioctl(fd, SIOCGIFADDR, &ifr[i]) != 0) {
			continue;
		}
		iname = ifr[i].ifr_name;
		printf("%s [%s]: %s", iname, inet_ntoa((*(struct sockaddr_in *) & ifr[i].ifr_addr).sin_addr), promisc ? "promisc\n" : "normal\n");

	}

	return 0;
}

void
usage()
{
	printf("usage: chksniff [-h] [-v]\n");
	exit(EXIT_SUCCESS);
}
