// Complex.h

#ifndef COMPLEX_H
#define COMPLEX_H

#if defined(__GNUC__) && (__GNUC__>=3)
#include <iostream>
using namespace std;
#else
#include <iostream.h>
#endif

// fNX //////////////////////////////////////////////////
class Complex {
 public:
  // 
  Complex(double a=0.0,double b=0.0) { re=a; im=b; }

  // 擾
  double real() const { return(re); }
  double imag() const { return(im); }

  // o֐ɂ鉉Zqd`
  Complex& operator+=(Complex& a);
  Complex& operator-=(Complex& a);
  Complex& operator*=(Complex& a);
  Complex& operator/=(Complex& a);

  // th֐ɂ鉉Zqd`
  friend bool operator==(Complex& a,Complex& b);
  friend bool operator!=(Complex& a,Complex& b){return(!(a==b));}
  friend Complex operator +(Complex& a,Complex& b);
  friend Complex operator -(Complex& a,Complex& b);
  friend Complex operator *(Complex& a,Complex& b);
  friend Complex operator /(Complex& a,Complex& b);
  friend ostream& operator <<(ostream& ios,Complex& a);

  // Zp֐̑d`
  friend double abs(Complex& a);
  friend Complex exp(Complex& a);

 private:
  double re,im;
};

#endif
