.\" Copyright (c) 2005-2008 Dieter Baron and Thomas Klausner.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above
.\"    copyright notice, this list of conditions and the following
.\"    disclaimer in the documentation and/or other materials provided
.\"    with the distribution.
.\" 3. The name of the author may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THOMAS KLAUSNER ``AS IS'' AND ANY
.\" EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR
.\" CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
.\" SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
.\" LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
.\" USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
.\" ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
.\" OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
.\" OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.TH DUMPGAME 1 "June 4, 2008" NiH
.SH "NAME"
dumpgame \- extract rom set information from ckmame database
.SH "SYNOPSIS"
.B dumpgame
.Brq \fB-b\fR | \fB--brief\fR
[Brq \fB-D\fR \fBdbfile | \fB--db\fR Ar dbfile\fR]
[\fBgame\fR]
.B dumpgame
\fB-c\fR | \fB-d\fR | \fB--checksum\fR | \fB--disk\fR
[Brq \fB-D\fR \fBdbfile | \fB--db\fR Ar dbfile\fR]
\fBchecksum\fR
[\fB...\fR]
.B dumpgame
[\fB-hV\fR]
[\fB--help\fR]
[\fB--version\fR]
.SH "DESCRIPTION"
.B dumpgame
extracts rom set information from a
ckmame(1)
database.
.B dumpgame
can also find roms matching a particular checksum.
.PP
.B dumpgame
supports the following options:
.RS
.TP 24
\fB-b\fR, \-brief
Use brief mode: don't output ROM and disk information.
.TP 24
\fB-c\fR, \-checksum
Look for a ROM by checksum (instead of the default
behaviour to look for a game by name).
.TP 24
\fB-D\fR \fBdbfile, \fB--db\fR Ar dbfile\fR
Use database
\fBdbfile\fR
instead of the default
``\fBmame.db\fR.''
.TP 24
\fB-d\fR, \-disk
Look for a disk by checksum (instead of the default
behaviour to look for a game by name).
.TP 24
\fB-h\fR, \-help
Display a short help message.
.TP 24
\fB-V\fR, \-version
Display program name and version number.
.RE
.PP
The
\fBgame\fR
argument can also be one of the following special keywords:
.RS
.TP 17
\fB/ckmame\fR
Report database version of the database, if it is supported by
.Nm.
.TP 17
\fB/dat\fR
Names of the datfiles used for creating the database, and their
descriptions.
.TP 17
\fB/detector\fR
Name and version of the CMPro XML header skip detector used (if any).
.TP 17
\fB/hashtypes\fR
Types of checksums used (crc, md5, sha1).
One line each for roms and disks.
.TP 17
\fB/list\fR
Same as
\fB/list/game.\fR
.TP 17
\fB/list/disk\fR
List names of all disks in the database.
.TP 17
\fB/list/game\fR
List names of all games in the database.
.TP 17
\fB/list/sample\fR
List names of all games with samples in the database.
.TP 17
\fB/stats\fR
List some statistics about the contents of the database.
.RE
.SH "ENVIRONMENT"
.RS
.TP 12
Ev MAMEDB
Location for the database file.
Can be overridden with the
\fB-D\fR
option.
Defaults to
``\fBmame.db\fR.''
.RE
.SH "EXAMPLES"
Display rom information for the game
``pacman'' :
.IP
\fBdumpgame pacman\fR
.PP
Display all roms matching the checksum
``c1e6ab10'' :
.IP
\fBdumpgame \-c c1e6ab10\fR
.PP
.SH "SEE ALSO"
ckmame(1),
mkmamedb(1)
.SH "AUTHORS"

.B dumpgame
was written by
Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at.>
