static char version[] = "cn2jp 1.4 (Aug 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  b2g.c: translates big5 code into any gb code

	Usage: b2g [-d] [-u]
	       b2g big5_file
	       b2g < big5_file

	-d: show debug info
	-u: output uzpj for unmappable (pinyin used when unspecified)

	uses a line buffer of 10240 chars
		[] hollow square for Big5 codes unused yet
		() hollow circle for Big5 codes unmappable to GB
		?q for non-Big5 codes (outside of the Big5 code set)
		?m for errors or entries undefined in the main translation table
		?s for errors in the supplementary translation table

  Input:

	a Chinese file in Big5 code

  Output:

	returns corresponding Chinese in GB


  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/



#include <stdio.h>
#include "lang-util.h"

/*
	Test program for translating Big5 into GB
*/

main(argc,argv)
int     argc;
char    **argv;
{
	char	istr[10240],gb[10240],*ostr;
	char	c1,c2,e1,e2;
	int	ilen,olen,line,i,ojis,candidate_filename_index;
	FILE	*fp;

	lang_uzpj=lang_debug=candidate_filename_index=0;

	for(i=argc; i>0; i--) {
		if(strcmp(argv[i-1],"-d")==0) lang_debug=1;
		else if(strcmp(argv[i-1],"-u")==0) lang_uzpj=1;
		else if(candidate_filename_index==0)
			candidate_filename_index=i-1;
	}


if(lang_debug>0) {
	puts(" Usage: b2g [-d] [-u]");
	puts("        b2g big5_file");
	puts("        b2g < big5_file");
	puts("  -d: show debug info");
	puts("  -u: output uzpj for unmappable (pinyin used when unspecified)");
	puts("");
	puts("  b2g translates big5 code into gb code");
	puts("	use a line buffer of 10240 chars");
	puts("	[] hollow square for Big5 codes unused yet");
	puts("	() hollow circle for Big5 codes unmappable to GB");
	puts("	?q for non-Big5 codes (outside of the Big5 code set)");
	puts("	?m for errors or entries undefined in main translation table");
	puts("	?s for errors in supplementary translation table");
}

	if(candidate_filename_index==0) {
		fp = stdin;
		puts("------- waiting for your input;  use <ctrl-z) to exit ----------------");
	}
	else if(!(fp = fopen(argv[candidate_filename_index],"rt")))
		return -1;

	ilen=line=0;
	while((c1=fgetc(fp))!=EOF){
		/* read a line into istr */
		istr[ilen++]=c1;

		/* translate the line */
		if(c1=='\n') {
			if(lang_debug) fprintf(stderr,"\n%d:", ++line);
			istr[ilen++]=0;

			ostr=lang_big5_to_gb(istr);
/*
	gb2hz(ostr,gb);
	strcpy(ostr,gb);
*/

			printf("%s",ostr);

			ilen=0;
		}
	}

	if(lang_debug) fprintf(stderr,"\n%d:", ++line);
	istr[ilen++]=0;

	ostr=lang_big5_to_gb(istr);
/*
	gb2hz(ostr,gb);
	strcpy(ostr,gb);
*/

	printf("%s",ostr);

	fclose(fp);

	return 0;
}
