static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  b2j.c: translates big5 code into any jis code

	Usage: b2j [-d] [-u] [-s] [-e] [-j] [-k]
	       b2j big5_file
	       b2j < big5_file

	-d: show debug info
	-u: output uzpj for unmappable (pinyin used when unspecified)
	-s: output shift-jis kanji, default
	-e: output euc-jis kanji
	-j: output jis kanji
	-k: output ku-ten

	uses a line buffer of 10240 chars
		[] hollow square for Big5 codes unused yet
		() hollow circle for Big5 codes unmappable to Jis
		?q for non-Big5 codes (outside of the Big5 code set)
		?m for errors or entries undefined in the main translation table
		?s for errors in the supplementary translation table

  Input:

	a Chinese file in Big5 code

  Output:

	returns corresponding Japanese in Shift-Jis code (default)


  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/



#include <stdio.h>
#include "lang-util.h"

/*
	Test program for translating Big5 into shift-Jis
*/

#define	EUCJIS	1
#define SHIFTJIS	2
#define	JIS	3
#define	KUTEN	4

main(argc,argv)
int     argc;
char    **argv;
{
	char	istr[10240],jis[10240],*ostr;
	char	c1,c2,e1,e2;
	int	ilen,olen,line,i,ojis,candidate_filename_index;
	FILE	*fp;
	unsigned char *EUC_TO_SJIS(), *EUC_TO_JIS();

	lang_uzpj=lang_debug=ojis=candidate_filename_index=0;

	for(i=argc; i>0; i--) {
		if(strcmp(argv[i-1],"-d")==0) lang_debug=1;
		else if(strcmp(argv[i-1],"-u")==0) lang_uzpj=1;
		else if(strcmp(argv[i-1],"-s")==0) ojis=SHIFTJIS;
		else if(strcmp(argv[i-1],"-j")==0) ojis=JIS;
		else if(strcmp(argv[i-1],"-e")==0) ojis=EUCJIS;
		else if(strcmp(argv[i-1],"-k")==0) ojis=KUTEN;
		else if(candidate_filename_index==0)
			candidate_filename_index=i-1;
	}

	if(ojis==0) ojis = SHIFTJIS;

if(lang_debug>0) {
	puts(" Usage: b2j [-d] [-u] [-s] [-e] [-j] [-k]");
	puts("        b2j big5_file");
	puts("        b2j < big5_file");
	puts("  -d: show debug info");
	puts("  -u: output uzpj for unmappable (pinyin used when unspecified)");
	puts("  -s: output shift-jis kanji, default");
	puts("  -e: output euc-jis kanji");
	puts("  -j: output jis kanji");
	puts("  -k: output ku-ten");
	puts("");
	puts("  b2j translates big5 code into any jis code");
	puts("	use a line buffer of 10240 chars");
	puts("	[] hollow square for Big5 codes unused yet");
	puts("	() hollow circle for Big5 codes unmappable to Jis");
	puts("	?q for non-Big5 codes (outside of the Big5 code set)");
	puts("	?m for errors or entries undefined in main translation table");
	puts("	?s for errors in supplementary translation table");
}

	if(candidate_filename_index==0) {
		fp = stdin;
		puts("------- waiting for your input;  use <ctrl-z) to exit ----------------");
	}
	else if(!(fp = fopen(argv[candidate_filename_index],"rt")))
		return -1;

	ilen=line=0;
	while((c1=fgetc(fp))!=EOF){
		/* read a line into istr */
		istr[ilen++]=c1;

		/* translate the line */
		if(c1=='\n') {
			if(lang_debug) fprintf(stderr,"\n%d:", ++line);
			istr[ilen++]=0;

			ostr=lang_big5_to_eucjis(istr);
			if(ojis==SHIFTJIS) EUC_TO_SJIS(ostr,jis);
			else if(ojis==JIS) EUC_TO_JIS(ostr,jis);
			else if(ojis==KUTEN) EUC_TO_KUTEN(ostr,jis);

			if(ojis==EUCJIS) printf("%s",ostr);
			else printf("%s",jis);

			ilen=0;
		}
	}

	if(lang_debug) fprintf(stderr,"\n%d:", ++line);
	istr[ilen++]=0;

	ostr=lang_big5_to_eucjis(istr);
	if(ojis==SHIFTJIS) EUC_TO_SJIS(ostr,jis);
	else if(ojis==JIS) EUC_TO_JIS(ostr,jis);
	else if(ojis==KUTEN) EUC_TO_KUTEN(ostr,jis);

	if(ojis==EUCJIS) printf("%s",ostr);
	else printf("%s",jis);

	fclose(fp);

	return 0;
}
