static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*

  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  SINO.c: 12 functions for translating among 
		Chinese {Big5/GB/HZ} and Japanese {Jis/EUC-Jis/Shift-Jis} codes

	  paramters:
		istr: input string with space allocated by caller
		ostr: output string with enough space allocated by caller
		return value: the same as output string
		

Basics:

	char *	BIG_TO_EUC(istr,ostr)
	char *	EUC_TO_BIG(istr,ostr)

	char *	GB_TO_EUC(istr,ostr)
	char *	EUC_TO_GB(istr,ostr)

	char *	GB_TO_HZ(istr,ostr)
	char *	HZ_TO_GB(istr,ostr)

	char *	BIG_TO_GB(istr,ostr)
	char *	GB_TO_BIG(istr,ostr)

Derivatives:

	char *	BIG_TO_JIS(istr,ostr)
	char *	GB_TO_JIS(istr,ostr)
	char *	HZ_TO_JIS(istr,ostr)
	char *	HZ_TO_EUC(istr,ostr)


Option:

	int	lang_uzpj (default to 0)
		;for input codes of Chinese (Big5/GB/HZ}, the translation is
		;default to output the common multi-character pinyin system for 
		;unmappable output codes. 
		;However, for alignment reason, you may want to use a special 
		;two character pinyin system.  You can enable such a uzpj system
		;by setting lang_uzpj to 1.


Reference: in deriving translation functions for any two codes, you may
		need the following auxilaries from
			${delegate3.0.17}/contrib/ccx/cn2jp/lib/jp-util.c, or
			${delegate3.0.17}/rary/JIS.c

	unsigned char * SJIS_TO_JIS1(HI,LO,JCODE)
	unsigned char * JIS_TO_SJIS1(HI,LO,SJCODE)
	unsigned char * SJIS_TO_EUC1(HI,LO,EUC)
	unsigned char * SJIS_TO_EUC(src,dst)
	unsigned char * EUC_TO_SJIS(src,dst)
	unsigned char * EUC_TO_JIS(src,dst,toK,toA)
	static unsigned char *recoverJIS(src,dstp)
	unsigned char * TO_EUC(jis,euc,ctype)
	static          is_EUC_JP(euc)
			TO_SJIS(any,sjis,ctype)
			TO_JIS(any,jis,ctype)
			EUC_TO_KUTEN(istr,ostr)


  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/

#include <stdio.h>
#include "lang-util.h"



/*----------------------------
	Big5 and EUC-Jis
------------------------------*/
char *
BIG_TO_EUC(istr,ostr)
char	*istr, *ostr;
{
	char	*o;

	o = lang_big5_to_eucjis(istr);
	strcpy(ostr, o);
	return o;
}

char *
EUC_TO_BIG(istr,ostr)
char    *istr,*ostr;
{
	char	*o;

	o = lang_eucjis_to_big5(istr);
	strcpy(ostr, o);
	return o;
}



/*----------------------------
	GB and EUC-Jis
------------------------------*/

char *
GB_TO_EUC(istr,ostr)
char	*istr, *ostr;
{
	char	*o;

	o = lang_gb_to_eucjis(istr);
	strcpy(ostr, o);

	return o;
}


char *
EUC_TO_GB(istr,ostr)
char    *istr,*ostr;
{
	char	*o;

	o = lang_eucjis_to_gb(istr);
	strcpy(ostr, o);
	return o;
}



/*----------------------------
	GB and HZ
------------------------------*/

char *
GB_TO_HZ(istr,ostr)
char	*istr, *ostr;
{

	gb2hz(istr,ostr);

}

char *
HZ_TO_GB(istr,ostr)
char	*istr, *ostr;
{

	hz2gb(istr,ostr);

}


/*----------------------------
	Big5 and GB
------------------------------*/

char *
BIG_TO_GB(istr,ostr)
char    *istr,*ostr;
{
	char	*o;

	o = lang_big5_to_gb(istr);
	strcpy(ostr, o);
	return o;
}


char *
GB_TO_BIG(istr,ostr)
char    *istr,*ostr;
{
	char	*o;

	o = lang_gb_to_big5(istr);
	strcpy(ostr, o);
	return o;
}


/*----------------------------
	Derivatives
------------------------------*/

char *
BIG_TO_JIS(istr,ostr)
char	*istr, *ostr;
{

        char    *euc;


        BIG_TO_EUC(istr,ostr);

        euc = (char *)malloc(strlen(ostr)+1024);

        TO_JIS(ostr,euc,"");

        strcpy(ostr,euc);

        free(euc);

        return ostr;
}



char *
GB_TO_JIS(istr,ostr)
char	*istr, *ostr;
{
	char	*euc;


	GB_TO_EUC(istr,ostr);

	euc = (char *)malloc(strlen(ostr)+1024);

	TO_JIS(ostr,euc,"");

	strcpy(ostr,euc);

	free(euc);

	return ostr;
}


char *
HZ_TO_JIS(istr,ostr)
char	*istr, *ostr;
{
	char	*euc;


	hz2gb(istr,ostr);

	euc = (char *)malloc(strlen(ostr)+1024);

	GB_TO_JIS(ostr,euc,"");

	strcpy(ostr,euc);

	free(euc);

}


char *
HZ_TO_EUC(istr,ostr)
char	*istr, *ostr;
{
	char	*euc;


	hz2gb(istr,ostr);

	euc = (char *)malloc(strlen(ostr)+1024);

	GB_TO_EUC(ostr,euc,"");

	strcpy(ostr,euc);

	free(euc);


}
