static char version[] = "cn2jp 1.4 (Aug 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  gb2hz.c: translates gb to hz

        int     gb2hz(istr,ostr)


  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/


#include <stdio.h>

/*
	Supplementary Routine for Translation
*/


char *
gb2hz(istr,ostr)
unsigned char	*istr,*ostr;
{
	unsigned char	*s,*d,c,c1,c2;
	int	hz_in;


	hz_in = 0;
	d = ostr;

	for(s=istr; *s!=0; s++) {

		c1=*s;
		c2=*(s+1);

		if((c1>=0xa1) && (c1<=0xfe)  &&
		   (c2>=0xa1) && (c2<=0xfe)) {	/* detect a valid GB code */

			if(!hz_in) {
				*d++ = '~';
				*d++ = '{';

				hz_in = 1;
			}

			*d++ = c1 & 0x7f;	/* eat two source chars */
			*d++ = c2 & 0x7f;

			s++;

		} else {

			if(hz_in) {

				*d++ = '~';
				*d++ = '}';

				hz_in = 0;
			}

			*d++ = c1;	/* eat single source char */
		}
	}

	*d = 0;
	return ostr;
}
