/*
	jp-util2.c
					Modified by Seke Wei
					on Feb 16 1996
		EUC_TO_KUTEN(istr,ostr)
int		seq_ejis(c1,c2)


  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/

EUC_TO_KUTEN(istr,ostr)
unsigned char *istr,*ostr;
{
	int	n;
	unsigned char	*i,*o,hi,lo,ku,ten;

	for(i=istr, o=ostr; (*i!=0); ) {
		if(*i > 0x80) {
			hi = *i;
			lo = *(i+1);

			ku = (hi - 0xa0);
			ten = (lo - 0xa0);

			sprintf(o, "(%2d:%2d) ", ku, ten);

			i += 2;
			o += 8;
		}
		else	*o++ = *i++;
	}

	*o = 0;

	return 0;
}

/*
        find the sequence number of the ejis code (c1,c2)
*/
int
seq_ejis(c1,c2)
unsigned char   c1,c2;
{
        unsigned int    hi,lo,a,b,result;


        result = -1;
        if((c1>=0xa1) && (c1<=0xfe) && (c2>=0xa1) && (c2<=0xfe)) {
                hi = c1 & 0xff;  lo = c2 & 0xff;
                a=(hi-0xa1)*94;
                b=lo-0xa1;

                result = a + b + 1;
        }
/*
         else {
                result = 9;  // question mark
        }
*/
        return result;
}

