static char version[] = "cn2jp 1.3 (Mar 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  lang-util.c: provides the supplementary routines for translation

	int	inc_ostr(postr,o_len,pbuf_size)
		;adjust the buffer *postr so that its size *pbuf_size > o_len

	int	src_seq_to_dest(tbl, seq, buf)
		;translate a word in source code sequence, seq,
		;	into a string in destin code, buf

	char *	src_to_dest(istr)
		;translate a string in soure code, istr,
		;	into a string in destin code, return value

  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/



#include <stdio.h>
#include "lang-util.h"

/*
	Supplementary Routine for Translation
*/

int	lang_debug = 0;
int 	lang_uzpj = 0;


struct code_table	b2jtbl, g2jtbl, j2btbl, g2btbl, b2gtbl, j2gtbl;
struct uzpj_table	uzpjtbl;



int
inc_ostr(postr,o_len,pbuf_size)
char	**postr;
int	o_len,*pbuf_size;
{
	static	char	*error="<truncated>";
	char	*temp;


	if(o_len > *pbuf_size) {

		*pbuf_size += 1024;
		temp = (char *) realloc(*postr, *pbuf_size);

		if(temp)
			*postr = temp;
		else {
			strcpy(*postr+*pbuf_size-1024-strlen(error)-1, error);
			return 0;
		}
	}
	return 1;
}



/*
	use the lookup table for translation
	translate a word in source code
*/
int
src_seq_to_dest(tbl, seq, buf)
struct code_table	*tbl;
int			seq;
unsigned char		*buf;
{
	int	index,offset,buf_len,hi,lo;
	unsigned char	*str3,*uzpj,temp[20],*poffset,*py2uzpj();

	buf[0] = 0;

	if(seq <= tbl->row * tbl->char_per_row) {

		buf[0]=tbl->tbl[(seq-1)*2];
		buf[1]=tbl->tbl[(seq-1)*2+1];

		if((buf[0]>=0x80) && (buf[0]<=0x9f)) {

			index=(buf[0]-0x80)*256 + buf[1];

			if(index < tbl->supp_tbl_max_index) {

				poffset = (unsigned char *) tbl->supp_tbl;
				poffset += index*2;
				lo = *(poffset++);
				hi = *(poffset++);
				offset = hi*256+lo;     /* 0-65535 */

				str3 = (unsigned char *) tbl->supp_tbl;
				str3 += offset;

				strcpy(buf,str3);
				buf_len = strlen(buf);


				if(lang_uzpj && (buf_len < 10)) {

					strcpy(temp,&buf[1]);
					temp[strlen(buf)-2] = 0;

					uzpj = (*uzpjtbl.py2uzpj)(temp);
						/* uzpj symbol*/

					if(uzpj)
						strcpy(buf,uzpj);
				}

			}
			else {	/* unknown supp table index */
				buf[0] = '?';
				buf[1] = 's';
			}
		}
		else {
			buf[2]=0;
		}
	} else {  /* undefined main table index */
		buf[0] = '?';
		buf[1] = 'm';
		buf[2]=0;
	}

	return 0;
}



/*
	use the lookup table for translation
	translate a string in source code
*/

char *
src_to_dest(tbl,istr)
struct code_table	*tbl;
char			*istr;
{
	static unsigned char	*ostr = NULL;

	static unsigned char 	buf[256],c1,c2;
	unsigned int		i,hi,lo,o_len,buf_len;
	int			seq,buf_size;
	int			ilen,*olen;

	if(!tbl->loaded) {
		fprintf(stderr,"\nsrc_to_dest: Translation table is not loaded yet!");
		return NULL;
	}

	ilen = strlen(istr);

	if(ostr) free(ostr);
	buf_size = 1024;
	ostr = (unsigned char *) malloc(buf_size);


	/* do translation */

	o_len=0;

	for(i=0; i<ilen; i++) {

		c1=istr[i];

		if((c1&0x80)==0) {
			/* copy chars below 0x80 */

			if(!inc_ostr(&ostr,o_len+1+1,&buf_size))
				return (char *) ostr;
			ostr[o_len++]=c1;

		}
		else {
			/* translate source code */

			c2=istr[++i];

			seq = (*tbl->src_seq)(c1, c2);

			if (seq > 0)
				(*tbl->src_seq_to_dest)(tbl, seq, buf);
			else
				strcpy(buf, "?q");

			buf_len = strlen(buf);


			/* i+1 chars read, o_len+buf_len+1 will be used */

			if(!inc_ostr(&ostr,o_len + buf_len + 1,&buf_size))
				return (char *) ostr;

			strcpy(&ostr[o_len],buf);
			o_len += strlen(buf);

if(lang_debug> 0)
	fprintf(stderr,"\n(src=%x%x,seq=%d) (%s)", c1, c2, seq, buf);

		}
	}

	ostr[o_len++]=0;

	return (char *) ostr;
}
