#include <stdio.h>

/*
	To compile big5.c, use 'cc -o big5 big5.c'

	To produce table, use 'big5 > big5.tbl'

	To print table, use 'cnprint -5 -l -c2 -f=kcm24.hbf big5.tbl'

	Info about Big5 Code:
	--------------------
	a140 - fefe (94 x 157 = 14,758 char)

	[punctuation mark, notation, number, english letter, greek letter,
	 zhu-in-fu-hao]
01	a140 - a17e (63)	a1a1 - a1fe (94)	Subtotal: 157 char
02	...........		...........			  157
03	a340 - a37e (63)	a3a1 - a1bf (31)		   94

	[1st level, by number of strokes]
04	a440 - a47e 		a4a1 - a4fe			  157
05-37	...........		...........			  157 x 33
38	c640 - c67e (63)					   63
39-40
	[2nd level, by bushyu]
41	c940 - c97e		c9a1 - c9fe			  157
42-88	...........		...........			  157 x 47
89	f940 - f97e (63)	f9a1 - f9d5 (53)		  116
90-94
							====================
							Used:  13,461 (91%)
							Unused:	1,297 ( 9%)
*/

main()
{
	int i, j;

puts("//	Info about Big5 Code:");
puts("//	---------------------------------");
puts("//	a140 - fefe (94 row x 157 char/row = 14,758 char)");

	for (i = 0xa1; i <= 0xfe; ++i) {
		for (j = 0x40; j <= 0xfe; ++j) {
			if ((j >= 0x7f) && (j <= 0x9f)) continue;

			if (j == 0x40) printf("\n\n//	Row (%2d)",i-0xa0);
			if (j == 0xa0) printf("\n");
			if (j % 16 == 0) printf("\n%2x%2x  ", i, j);

			if (j == 0xa0) printf("    ");
			else {
				printf("  ");
				putchar(i);
				putchar(j);
			};
		};
	};
	putchar('\n');

	exit(0);
}
