#include <stdio.h>

/*
        To compile gb.c, use 'cc -o gb gb.c'

        To produce table, use 'gb > gb.tbl'

        To print table, use 'cnprint -gb -l -c2 -f=ccs24.hbf gb.tbl'
        		use 'cnprint -gb -l -c2 -f=ccs24f.hbf gb.tbl'

	Info about GB Code: GB2312.1980
	------------------
	a1a1 - f7fe (94 x 87 = 8,178 char)

	[notation]
01	a1a1 - a1fe (94)	Subtotal:  94 char

	[number]
02	a2a1 - a2fe (94)		   94 char

	[english letter]
03	a3a1 - a3fe (94)		   94 char

	[hiragana]
04	a4a1 - a4fe (94)		   94 char

	[katakana]
05	a5a1 - a5fe (94)		   94 char

	[greek letter]
06	a6a1 - a6fe (94)		   94 char

	[russian letter]
07	a7a1 - a7fe (94)		   94 char

	[umlaut, zhu-in-fu-hao]
08	a8a1 - a8fe (94)		   94 char

	[table graphics]
09	a9a1 - a9fe (94)		   94 char
10-15
	[1st level, by pinyin]
16	b0a1 - b0fe (94)	Subtotal:  94 char
17-54	...........			   94 x 38
55	d7a1 - d7fe (94)		   94

	[2nd level, by bushyu]
56	d8a1 - d8fe (94)	Subtotal:  94 char
57-86	...........			   94 x 30
87	f7a1 - f7fe (94)		   94
88-94
				====================
				Used:   7,614 (93%)
				Unused:	  564 ( 7%)
*/

main()
{
	int i, j;

puts("//	Info about GB Code: GB2312.1980");
puts("//	---------------------------------");
puts("//	a1a1 - f7fe (94 char/row x 87 row= 8,178 char)");

	for (i = 0xa1; i <= 0xf7; ++i) {
		for (j = 0xa0; j <= 0xfe; ++j) {
			if (j == 0xa0) printf("\n\n//	Row (%2d)",i-0xa0);
			if (j % 16 == 0) printf("\n%2x%2x  ", i, j);

			if (j == 0xa0) printf("    ");
			else {
				printf("  ");
				putchar(i);
				putchar(j);
			};
		};
	};
	putchar('\n');

	return 0;
}
