#define VERSION "1.6"
/* (c) Copyright 1993 by Joseph Felsenstein.
   Written by Joseph Felsenstein, Akiko Fuseki, Sean Lamont, and Andrew Keeffe.
   Permission is granted to copy and use this program provided no fee is
   charged for it and provided that this copyright notice is not removed. */

/* machine-specific stuff:
   based on a number of factors in the library stdlib.h, we will try
   to determine what kind of machine/compiler this program is being
   built on.  However, it doesn't always succeed.  However, if you have
   ANSI conforming C, it will probably work.

 we will try to figure out machine type
 based on defines in stdio, and compiler-defined things as well.: */

#ifdef  GNUDOS
#define DJGPP
#define DOS
#endif

#ifdef THINK_C
#define MAC
#endif

#include <stdio.h>
#include <stdlib.h>

#ifdef __CMS_OPEN
#define CMS
#define EBCDIC true
#define INFILE "infile data"
#define OUTFILE "outfile data"
#define TREEFILE "treefile data"
#define FONTFILE "fontfile data"
#define PLOTFILE "plotfile data"
#define INTREE "intree data"
#define OUTTREE "outtree data"
#else
#define EBCDIC false
#define INFILE "infile"
#define OUTFILE "outfile"
#define TREEFILE "treefile"
#define FONTFILE "fontfile" /* on unix this might be /usr/local/lib/fontfile */
#define PLOTFILE "plotfile"
#define INTREE "intree"
#define OUTTREE "outtree"
#endif

#ifdef L_ctermid            /* try and detect for sysV or V7. */
#define SYSTEM_FIVE
#endif

#ifdef sequent
#define SYSTEM_FIVE
#endif

#ifndef SYSTEM_FIVE
# include<stdlib.h>
# if defined(_STDLIB_H_) || defined(_H_STDLIB) || defined(H_SCCSID) || defined(unix)
# define UNIX
# define MACHINE_TYPE "BSD Unix C"
# endif
#endif


#ifdef __STDIO_LOADED
# ifdef __DECC /* DEC C version provided by David Mathog */
# define MACHINE_TYPE "OpenVMS DECC"
# else
# define VMS /* probably obsolete VAX C version */
# define MACHINE_TYPE "VAX/VMS C"
# define printf vax_printf_is_broken
# define fprintf vax_fprintf_is_broken
void vax_printf_is_broken(const char *fmt,...);
void vax_fprintf_is_broken(FILE *fp,const char *fmt,...);
void vax_tweak_fmt(char *);
# endif
#endif

#ifdef __WATCOMC__
#define QUICKC
#define WATCOM
#define DOS
#include "graph.h"
#endif
/* watcom-c has graphics library calls that are almost identical to    *
 * quick-c, so the "QUICKC" symbol name stays.                         */


#ifdef _QC
#define MACHINE_TYPE "MS-DOS / Quick C"
#define QUICKC
#include "graph.h"
#define DOS
#endif

#ifdef _DOS_MODE
#define MACHINE_TYPE "MS-DOS /Microsoft C "
#define DOS           /* DOS is  always defined if  on a dos machine */
#define MSC           /* MSC is defined for microsoft C              */
#endif

#ifdef __MSDOS__      /* TURBO c compiler, ONLY (no other DOS C compilers) */
#define DOS
#define TURBOC
#include<stdlib.h>
#include<graphics.h>
#endif

#ifdef DJGPP          /* DJ's gnu  C/C++ port */
#include<graphics.h>
#endif

#ifndef MACHINE_TYPE
#define MACHINE_TYPE "ANSI C"
#endif

#ifdef DOS
#define MALLOCRETURN void 
#else
#define MALLOCRETURN void
#endif
#ifdef VMS
#define signed /* signed doesn't exist in VMS */
#endif

/* default screen types */
#ifdef DOS
#define IBMCRT true
#define ANSICRT false
#elif MAC
#define IBMCRT false 
#define ANSICRT false
#else
#define IBMCRT false 
#define ANSICRT true 
#endif

#ifdef DJGPP
#undef MALLOCRETURN
#define MALLOCRETURN void
#endif


/* includes: */
#ifdef UNIX
#include<strings.h>
#else
#include<string.h>
#endif

#include <math.h>
#include <ctype.h>

#ifdef MAC
#include "interface.h"
#endif

#define FClose(file) if (file) fclose(file) ; file=NULL
#define Malloc(x) mymalloc((long)x)

typedef void *Anyptr;
#define Signed     signed
#define Const     const
#define Volatile  volatile
#define Char        char      /* Characters (not bytes) */
#define Static     static     /* Private global funcs and vars */
#define Local      static     /* Nested functions */

typedef unsigned char boolean;

#define true    1
#define false   0
#define SETBITS 32

#ifdef MAC
MALLOCRETURN    *mymalloc(long);
#else
MALLOCRETURN    *mymalloc();
#endif

#include "constants.h"
#include <float.h>

typedef enum {A,C,G,T}  base;
typedef double          sitelike[(long)T - (long)A + 1];
typedef sitelike        *ratelike;
typedef ratelike        *phenotype;
typedef char            **sequence;
typedef double          *contribarr;
typedef char            naym[nmlngth];
typedef long            longer[6];

typedef struct _node {
  struct _node *next, *back;
  boolean tip;
  long number;
  phenotype x;
  naym nayme;
  boolean top;
  double v, tyme, length;
  long xcoord, ycoord, ymin, ymax;
} node;

  /* this is a list describing the tree as a series of horizontal
     slices of the tree.  Each slice starts at a node, and extends
     down until the next cut is encountered. */
typedef struct tlist {
  struct tlist *prev, *succ;
  node *eventnode;   /* points to a random tip for the tips */
  double age;        /* tyme from tree top                  */
  long numbranch;
  node **branchlist;
} tlist;

typedef struct tree {
  node   **nodep;
  double likelihood;
  node *root;
  tlist *tymelist;
} tree;

typedef struct rlrec {
  double *val;
} rlrec;

typedef struct valrec {
  double rat_xi, rat_xv, zz, z1, y1, ww1, zz1, ww2, zz2, z1zz, z1yy,
     xiz1, xiy1_xv, ww1zz1, vv1zz1, ww2zz2, vv2zz2;
} valrec;

#define FILEP(A,B) (menu ? (A) : (B))
#define ERRFILE FILEP(stderr,simlog)
#define REF_CHAIN(A) (((A) < chains[0]) ? 0 : (A)+1-chains[0])
#define MAX(A,B) (((A) > (B)) ? (A) : (B))

void openfile(FILE **fp, char *filename, char *mode, char *application,
   char *perm);
void printtymelist(void);
void findtop(node **p);
void VarMalloc(node *p, boolean allokate);
void newnode(node **p);
void freenode(node *p);
void newtymenode(tlist **t);
void freetymenode(tlist *t);
void freetymelist(tlist *t);
void hookup(node *p, node *q);
void atr(node *p);
void gettymenode(tlist **t, long target);
void gettyme(tlist **t, node *p, node *daughter1, node *daughter2,
   node *ans);
void inserttymelist(node *prime);
void subtymelist(node *ndonor, node *nrecip);
void ltov(node *p);
void joinnode(float length, node *p, node *q);
void getnums(void);
void readparmfile(void);
void getoptions(void);
void coalinit(void);
void firstinit(void);
void locusinit(void);
void inputoptions(void);
void getbasefreqs(void);
void setuptree(void);
void freetree(void);
void getdata(void);
void makevalues(void);
void makesiteptr(void);
void empiricalfreqs(void);
void getinput(void);
void orient(node *p);
void finishsetup(node *p);
void initbranchlist(void);
void inittable(void);
void initweightrat(void);
void treeout(node *p, long s, FILE **usefile);
void nuview(node *p);
void update(node *p);
void smooth(node *p);
void localsmooth(node *p);
void seekch(char c);
void getch(char *c);
void processlength(node *p);
void addelement(node *p, long *nextnode);
void treeread(void);
void treevaluate(void);
void localevaluate(node *p, node *pansdaught);
void copynode(node *source, node *target);
void constructtree(long numtips, float branchlength);
void updateslide(node *p, boolean wanted);
void rebuildbranch(void);
void setlength(long numl, long numother, double tstart, double tlength,
   node *p);
void setlength2(long numother, double tstart, double tlength, node *p,
   node *q);
void updatebranch(node *oldans, node *oldp, node *prime);
void slide(void);
void scoretree(long chain);
void thetaval(double thgiven, long chain, double *likel);
void printcurve(double theta, double tlike, long chain);
void thetapoint(long chain, boolean chend, boolean rend);
void thetapoint2(long firstlong, long lastlong, double *lthetai,
   boolean rend);
void coaliter(long lastlong, boolean chend, boolean rend);
void liketable(void);
void maketree(void);
void memerror(void);
void weightcalc(double **treewt, long firstlong, long lastlong, long
   lowcus, double *lthetai);
void locuspoints(void);
double randum(long *seed);
double lengthof(node *p);
double zerocollis(long numl, long numother, double length);
double onecollis(long numl, long numother, double length);
double twocollis(long numother, double length);
static double watterson(void);
double evaluate(tree *tr, boolean first);
double fnx (long chain, double theval, long numints, long *fxplus,
   boolean *fxzero);
double dfnx (long chain, double theval, long numints, long *dfxplus,
   boolean *dfxzero);
double interp(double theta, long firstlong, long lastlong, 
  double *lthetai, long locus);
double combined_fnx (double theval, long numints, double **treewt,
   long firstlong, long lastlong, long *fxplus, boolean *fxzero, long lowcus);
double combined_dfnx (double theval, long numints, double **treewt,
   long firstlong, long lastlong, long *dfxplus, boolean *dfxzero, long lowcus);
double locus_fnx(double theta, long numintervals, double ***treewt,
   long firstlong, long lastlong, boolean *return_zero, long *return_plus);
double locus_dfnx(double theta, long numintervals, double ***treewt,
   long firstlong, long lastlong, boolean *return_zero, long *return_plus);
double sum_interp(double theta, long firstlong, long lastlong,
   double **lthetai);
long boolcheck(char ch);
long counttymelist(tlist *first, tlist *last);
long main(int argc, char *argv[]);
boolean booleancheck(char *var, char *value);
boolean numbercheck(char *var, char *value);
boolean sitecompare(long site1, long site2);
boolean testratio(void);
/* declarations added by David Mathog */
int eof(FILE *f);
int eoln(FILE *f);
