%module rijndaelc
%{
#include "rijndael-alg-fst.h"
#include "rijndael-api-fst.h"
%}

/* Return string for Python */
typedef struct {
  int sz; //number of bytes
  char *bytes; //the bytes
} safeString;


%typemap(python,out) safeString* {
  if ( $source != NULL ) {
    $target = PyString_FromStringAndSize($source->bytes, $source->sz);
    free($source->bytes);
    free($source);
  }
  else {
    PyErr_SetString(PyExc_RuntimeError,"cipher or key error");
    return NULL;
  }
}


%typemap(python, in) char * {
  if ( !PyString_Check($source) ) {
    PyErr_SetString(PyExc_TypeError,"not a string, man.");
    return NULL;
  }
  $target = PyString_AsString($source);
}


typedef unsigned char BYTE;

/*  The structure for key information */
typedef struct {
    keyInstance();
    ~keyInstance();
    BYTE  direction;                /* Key used for encrypting or decrypting? */
    int   keyLen;                   /* Length of the key  */
    char  keyMaterial[MAX_KEY_SIZE+1];  /* Raw key data in ASCII, e.g., user input or KAT values */
	int   Nr;                       /* key-length-dependent number of rounds */
	u32   rk[4*(MAXNR + 1)];        /* key schedule */
	u32   ek[4*(MAXNR + 1)];        /* CFB1 key schedule (encryption only) */
} keyInstance;

/*  The structure for cipher information */
typedef struct {                    /* changed order of the components */
    cipherInstance();
    ~cipherInstance();
    BYTE  mode;                     /* MODE_ECB, MODE_CBC, or MODE_CFB1 */
    BYTE  IV[MAX_IV_SIZE];          /* A possible Initialization Vector for ciphering */
} cipherInstance;


extern int makeKey(keyInstance *key, BYTE direction, int keyLen, char *keyMaterial);

extern int cipherInit(cipherInstance *cipher, BYTE mode, char *IV);

extern safeString* padEncrypt(cipherInstance *cipher, keyInstance *key,
		char *inBytes, int inputOctets);



extern safeString* padDecrypt(cipherInstance *cipher, keyInstance *key,
		char *inBytes, int inputOctets);
