/* comb.orc */
; Initialize the global variables.
sr = 44100
kr = 4410
ksmps = 10
nchnls = 1

; Initialize the audio mixer.
gamix init 0 

; Instrument #1.
instr 1 
  ; Generate a source signal.
  a1 oscili 30000, cpspch(p4), 1
  ; Output the direct sound.
  out a1  

  ; Add the source signal to the audio mixer.
  gamix = gamix + a1 
endin

; Instrument #99 (highest instr number executed last)
instr 99 
  krvt = 1.5
  ilpt = 0.1

  ; Comb-filter the mixed signal.
  a99 comb gamix, krvt, ilpt
  ; Output the result.
  out a99 

  ; Empty the mixer for the next pass.
  gamix = 0 
endin
/* comb.orc */
