/* $Id: snprintf.c,v 1.1 2003/06/23 19:07:22 onoe Exp $ */

/*-
 * Copyright (c) 1998 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdarg.h>

extern int _doprnt();
#ifdef HAVE__FINDIOP
extern FILE *_findiop();
#endif

int
vsnprintf(char *string, int n, const char *fmt, va_list ap)
{
	int ret;
	int fd;
	FILE *fp;
#ifndef HAVE__FINDIOP
	FILE fb;
#endif

	if (n < 1)
		return EOF;
#ifdef HAVE__FINDIOP
	fp = _findiop();
	if (fp == NULL)
		return -1;
#else
	fp = &fb;
#endif
	fp->_file = -1;
	fp->_cnt = n;
	fp->_base = fp->_ptr = (unsigned char *)string;
#ifdef HAVE__SETBUFEND
	_setbufend(fp, string + n);
#else
	fp->_bufsiz = n;
#endif
	fp->_flag = _IOWRT;
	ret = _doprnt(fmt, ap, fp);
	if (ferror(fp)) {
		string[n - 1] = '\0';
#ifdef HAVE__FINDIOP
		fclose(fp);
#endif
		fp = fopen("/dev/null", "w");
		if (fp == NULL)
			return -1;
		ret = vfprintf(fp, fmt, ap);
		fclose(fp);
		return ret;
	}
	*fp->_ptr = '\0';
#ifdef HAVE__FINDIOP
	fclose(fp);
#endif
	return ret;
}


int
snprintf(char *string, int n, const char *fmt, ...)
{
	int ret;
	va_list ap;

	va_start(ap, fmt);
	ret = vsnprintf(string, n, fmt, ap);
	va_end(ap);
	return ret;
}
