/*----------------------------------------------------------------------------------------
  Module header file for: ht module
----------------------------------------------------------------------------------------*/
#ifndef HTDATABASE_H

#define HTDATABASE_H

#if defined __cplusplus
extern "C" {
#endif

#ifndef DD_UTIL_H
#include "ddutil.h"
#endif

/* Class reference definitions */

#if defined(DD_DEBUG) && !defined(DD_NOSTRICT)
typedef struct _struct_htGraph{char val;} *htGraph;
#define htGraphNull ((htGraph)(UINT32_MAX))
#define htGraph2Index(Graph) ((uint32)((Graph) - (htGraph)(0)))
#define htGraph2ValidIndex(Graph) ((uint32)(htValidGraph(Graph) - (htGraph)(0)))
#define htIndex2Graph(xGraph) ((htGraph)((xGraph) + (htGraph)(0)))
typedef struct _struct_htNode{char val;} *htNode;
#define htNodeNull ((htNode)(UINT32_MAX))
#define htNode2Index(Node) ((uint32)((Node) - (htNode)(0)))
#define htNode2ValidIndex(Node) ((uint32)(htValidNode(Node) - (htNode)(0)))
#define htIndex2Node(xNode) ((htNode)((xNode) + (htNode)(0)))
typedef struct _struct_htDatadrawRoot{char val;} *htDatadrawRoot;
#define htDatadrawRootNull ((htDatadrawRoot)(UINT32_MAX))
#define htDatadrawRoot2Index(DatadrawRoot) ((uint32)((DatadrawRoot) - (htDatadrawRoot)(0)))
#define htDatadrawRoot2ValidIndex(DatadrawRoot) ((uint32)(htValidDatadrawRoot(DatadrawRoot) - (htDatadrawRoot)(0)))
#define htIndex2DatadrawRoot(xDatadrawRoot) ((htDatadrawRoot)((xDatadrawRoot) + (htDatadrawRoot)(0)))
typedef struct _struct_htSparseParentGraphNodeData{char val;} *htSparseParentGraphNodeData;
#define htSparseParentGraphNodeDataNull ((htSparseParentGraphNodeData)(UINT32_MAX))
#define htSparseParentGraphNodeData2Index(SparseParentGraphNodeData) ((uint32)((SparseParentGraphNodeData) - (htSparseParentGraphNodeData)(0)))
#define htSparseParentGraphNodeData2ValidIndex(SparseParentGraphNodeData) ((uint32)(htValidSparseParentGraphNodeData(SparseParentGraphNodeData) - (htSparseParentGraphNodeData)(0)))
#define htIndex2SparseParentGraphNodeData(xSparseParentGraphNodeData) ((htSparseParentGraphNodeData)((xSparseParentGraphNodeData) + (htSparseParentGraphNodeData)(0)))
typedef struct _struct_htSparseChildGraphNodeData{char val;} *htSparseChildGraphNodeData;
#define htSparseChildGraphNodeDataNull ((htSparseChildGraphNodeData)(UINT32_MAX))
#define htSparseChildGraphNodeData2Index(SparseChildGraphNodeData) ((uint32)((SparseChildGraphNodeData) - (htSparseChildGraphNodeData)(0)))
#define htSparseChildGraphNodeData2ValidIndex(SparseChildGraphNodeData) ((uint32)(htValidSparseChildGraphNodeData(SparseChildGraphNodeData) - (htSparseChildGraphNodeData)(0)))
#define htIndex2SparseChildGraphNodeData(xSparseChildGraphNodeData) ((htSparseChildGraphNodeData)((xSparseChildGraphNodeData) + (htSparseChildGraphNodeData)(0)))
typedef struct _struct_htSparseNodeNameData{char val;} *htSparseNodeNameData;
#define htSparseNodeNameDataNull ((htSparseNodeNameData)(UINT32_MAX))
#define htSparseNodeNameData2Index(SparseNodeNameData) ((uint32)((SparseNodeNameData) - (htSparseNodeNameData)(0)))
#define htSparseNodeNameData2ValidIndex(SparseNodeNameData) ((uint32)(htValidSparseNodeNameData(SparseNodeNameData) - (htSparseNodeNameData)(0)))
#define htIndex2SparseNodeNameData(xSparseNodeNameData) ((htSparseNodeNameData)((xSparseNodeNameData) + (htSparseNodeNameData)(0)))
typedef struct _struct_htSparseNodeXData{char val;} *htSparseNodeXData;
#define htSparseNodeXDataNull ((htSparseNodeXData)(UINT32_MAX))
#define htSparseNodeXData2Index(SparseNodeXData) ((uint32)((SparseNodeXData) - (htSparseNodeXData)(0)))
#define htSparseNodeXData2ValidIndex(SparseNodeXData) ((uint32)(htValidSparseNodeXData(SparseNodeXData) - (htSparseNodeXData)(0)))
#define htIndex2SparseNodeXData(xSparseNodeXData) ((htSparseNodeXData)((xSparseNodeXData) + (htSparseNodeXData)(0)))
#else
typedef uint32 htGraph;
#define htGraphNull UINT32_MAX
#define htGraph2Index(Graph) (Graph)
#define htGraph2ValidIndex(Graph) (htValidGraph(Graph))
#define htIndex2Graph(xGraph) ((xGraph))
typedef uint32 htNode;
#define htNodeNull UINT32_MAX
#define htNode2Index(Node) (Node)
#define htNode2ValidIndex(Node) (htValidNode(Node))
#define htIndex2Node(xNode) ((xNode))
typedef uint32 htDatadrawRoot;
#define htDatadrawRootNull UINT32_MAX
#define htDatadrawRoot2Index(DatadrawRoot) (DatadrawRoot)
#define htDatadrawRoot2ValidIndex(DatadrawRoot) (htValidDatadrawRoot(DatadrawRoot))
#define htIndex2DatadrawRoot(xDatadrawRoot) ((xDatadrawRoot))
typedef uint32 htSparseParentGraphNodeData;
#define htSparseParentGraphNodeDataNull UINT32_MAX
#define htSparseParentGraphNodeData2Index(SparseParentGraphNodeData) (SparseParentGraphNodeData)
#define htSparseParentGraphNodeData2ValidIndex(SparseParentGraphNodeData) (htValidSparseParentGraphNodeData(SparseParentGraphNodeData))
#define htIndex2SparseParentGraphNodeData(xSparseParentGraphNodeData) ((xSparseParentGraphNodeData))
typedef uint32 htSparseChildGraphNodeData;
#define htSparseChildGraphNodeDataNull UINT32_MAX
#define htSparseChildGraphNodeData2Index(SparseChildGraphNodeData) (SparseChildGraphNodeData)
#define htSparseChildGraphNodeData2ValidIndex(SparseChildGraphNodeData) (htValidSparseChildGraphNodeData(SparseChildGraphNodeData))
#define htIndex2SparseChildGraphNodeData(xSparseChildGraphNodeData) ((xSparseChildGraphNodeData))
typedef uint32 htSparseNodeNameData;
#define htSparseNodeNameDataNull UINT32_MAX
#define htSparseNodeNameData2Index(SparseNodeNameData) (SparseNodeNameData)
#define htSparseNodeNameData2ValidIndex(SparseNodeNameData) (htValidSparseNodeNameData(SparseNodeNameData))
#define htIndex2SparseNodeNameData(xSparseNodeNameData) ((xSparseNodeNameData))
typedef uint32 htSparseNodeXData;
#define htSparseNodeXDataNull UINT32_MAX
#define htSparseNodeXData2Index(SparseNodeXData) (SparseNodeXData)
#define htSparseNodeXData2ValidIndex(SparseNodeXData) (htValidSparseNodeXData(SparseNodeXData))
#define htIndex2SparseNodeXData(xSparseNodeXData) ((xSparseNodeXData))
#endif

/* Validate macros */
#if defined(DD_DEBUG)
#define htValidGraph(Graph) (utLikely((uint32)((Graph) - (htGraph)0) < \
    htRootData.usedGraph)? (Graph) : (utExit("Invalid Graph"), (htGraph)0))
#define htValidNode(Node) (utLikely((uint32)((Node) - (htNode)0) < \
    htRootData.usedNode)? (Node) : (utExit("Invalid Node"), (htNode)0))
#define htValidDatadrawRoot(DatadrawRoot) (utLikely((uint32)((DatadrawRoot) - (htDatadrawRoot)0) < \
    htRootData.usedDatadrawRoot)? (DatadrawRoot) : (utExit("Invalid DatadrawRoot"), (htDatadrawRoot)0))
#define htValidSparseParentGraphNodeData(SparseParentGraphNodeData) (utLikely((uint32)((SparseParentGraphNodeData) - (htSparseParentGraphNodeData)0) < \
    htRootData.usedSparseParentGraphNodeData)? (SparseParentGraphNodeData) : (utExit("Invalid SparseParentGraphNodeData"), (htSparseParentGraphNodeData)0))
#define htValidSparseChildGraphNodeData(SparseChildGraphNodeData) (utLikely((uint32)((SparseChildGraphNodeData) - (htSparseChildGraphNodeData)0) < \
    htRootData.usedSparseChildGraphNodeData)? (SparseChildGraphNodeData) : (utExit("Invalid SparseChildGraphNodeData"), (htSparseChildGraphNodeData)0))
#define htValidSparseNodeNameData(SparseNodeNameData) (utLikely((uint32)((SparseNodeNameData) - (htSparseNodeNameData)0) < \
    htRootData.usedSparseNodeNameData)? (SparseNodeNameData) : (utExit("Invalid SparseNodeNameData"), (htSparseNodeNameData)0))
#define htValidSparseNodeXData(SparseNodeXData) (utLikely((uint32)((SparseNodeXData) - (htSparseNodeXData)0) < \
    htRootData.usedSparseNodeXData)? (SparseNodeXData) : (utExit("Invalid SparseNodeXData"), (htSparseNodeXData)0))
#else
#define htValidGraph(Graph) (Graph)
#define htValidNode(Node) (Node)
#define htValidDatadrawRoot(DatadrawRoot) (DatadrawRoot)
#define htValidSparseParentGraphNodeData(SparseParentGraphNodeData) (SparseParentGraphNodeData)
#define htValidSparseChildGraphNodeData(SparseChildGraphNodeData) (SparseChildGraphNodeData)
#define htValidSparseNodeNameData(SparseNodeNameData) (SparseNodeNameData)
#define htValidSparseNodeXData(SparseNodeXData) (SparseNodeXData)
#endif

/*----------------------------------------------------------------------------------------
  Fields for class Graph.
----------------------------------------------------------------------------------------*/
struct htGraphFields {
    htNode *NodeTable;
    htGraph *FreeList;
};
extern struct htGraphFields htGraphs;

extern htNode htGraphGetFirstNode(htGraph Graph);
extern void htGraphSetFirstNode(htGraph Graph, htNode value);
extern htNode htGraphGetLastNode(htGraph Graph);
extern void htGraphSetLastNode(htGraph Graph, htNode value);
extern uint32 htGraphGetNodeTableIndex(htGraph Graph);
extern void htGraphSetNodeTableIndex(htGraph Graph, uint32 value);
extern uint32 htGraphGetNumNodeTable(htGraph Graph);
extern void htGraphSetNumNodeTable(htGraph Graph, uint32 value);
#if defined(DD_DEBUG)
#define htGraphCheckNodeTableIndex(Graph, x) ((uint32)(x) < htGraphGetNumNodeTable(Graph)? (x) : \
    (utAssert(false),(x)))
#else
#define htGraphCheckNodeTableIndex(Graph, x) (x)
#endif
#define htGraphGetiNodeTable(_Graph, x) ((htGraphs.NodeTable)[ \
    htGraphGetNodeTableIndex(_Graph) + htGraphCheckNodeTableIndex(_Graph, (x))])
#define htGraphGetNodeTable(Graph) (htGraphs.NodeTable + htGraphGetNodeTableIndex(Graph))
#define htGraphGetNodeTables htGraphGetNodeTable
#define htGraphSetNodeTable(Graph, valuePtr, numNodeTable) (htGraphResizeNodeTables(Graph, numNodeTable), memcpy(htGraphGetNodeTables(Graph), valuePtr, \
    numNodeTable*sizeof(htNode)))
#define htGraphSetiNodeTable(Graph, x, value) ((htGraphs.NodeTable)[ \
    htGraphGetNodeTableIndex(Graph) + htGraphCheckNodeTableIndex(Graph, (x))] = (value))
extern uint32 htGraphGetNumNode(htGraph Graph);
extern void htGraphSetNumNode(htGraph Graph, uint32 value);
#define htGraphGetFreeList(_Graph) (htGraphs.FreeList[htGraph2ValidIndex(_Graph)])
#define htGraphSetFreeList(_Graph, value) ((htGraphs.FreeList)[htGraph2ValidIndex(_Graph)] = (value))
htNode htGraphFindNode(htGraph Graph, int32 X, int32 Y);
#define htForeachGraphNode(pVar, cVar) \
    for(cVar = htGraphGetFirstNode(pVar); cVar != htNodeNull; \
        cVar = htNodeGetNextGraphNode(cVar))
#define htEndGraphNode
#define htSafeForeachGraphNode(pVar, cVar) { \
    htNode _nextNode; \
    for(cVar = htGraphGetFirstNode(pVar); cVar != htNodeNull; cVar = _nextNode) { \
        _nextNode = htNodeGetNextGraphNode(cVar);
#define htEndSafeGraphNode }}
#define htGraphSetConstructorCallback(func) (htGraphConstructorCallback = (func))
#define htGraphGetConstructorCallback() (htGraphConstructorCallback)
#define htGraphSetDestructorCallback(func) (htGraphDestructorCallback = (func))
#define htGraphGetDestructorCallback() (htGraphDestructorCallback)
#define htGraphNextFree(_Graph) (((htGraph *)(void *)(htGraphs.FreeList))[htGraph2ValidIndex(_Graph)])
#define htGraphSetNextFree(_Graph, value) (((htGraph *)(void *)(htGraphs.FreeList)) \
    [htGraph2ValidIndex(_Graph)] = (value))
#define htGraphAllocRaw() ( \
    htRootData.firstFreeGraph != htGraphNull? \
        (htTemp_.Graph = htRootData.firstFreeGraph, \
        htSetFirstFreeGraph(htGraphNextFree(htTemp_.Graph)), true) \
    : (htRootData.usedGraph == htRootData.allocatedGraph && (htGraphAllocMore(), true), \
        htTemp_.Graph = htIndex2Graph(htRootData.usedGraph), \
        htSetUsedGraph(htUsedGraph() + 1)), \
    htTemp_.Graph)
#define htGraphAlloc() ( \
    htRootData.firstFreeGraph != htGraphNull? \
        (htTemp_.Graph = htRootData.firstFreeGraph, \
        htSetFirstFreeGraph(htGraphNextFree(htTemp_.Graph)), true) \
    : (htRootData.usedGraph == htRootData.allocatedGraph && (htGraphAllocMore(), true), \
        htTemp_.Graph = htIndex2Graph(htRootData.usedGraph), \
        htSetUsedGraph(htUsedGraph() + 1)), \
    htGraphSetFirstNode(htTemp_.Graph, htNodeNull), \
    htGraphSetLastNode(htTemp_.Graph, htNodeNull), \
    htGraphSetNodeTableIndex(htTemp_.Graph, 0), \
    htGraphSetNumNodeTable(htTemp_.Graph, 0), \
    htGraphSetNumNodeTable(htTemp_.Graph, 0), \
    htGraphSetNumNode(htTemp_.Graph, 0), \
    htGraphSetFreeList(htTemp_.Graph, htGraphNull), \
    htGraphConstructorCallback != NULL && (htGraphConstructorCallback(htTemp_.Graph), true), \
    htTemp_.Graph)

#define htGraphFree(Graph) (htGraphFreeNodeTables(Graph), \
    htGraphSetNextFree(Graph, htRootData.firstFreeGraph), \
    htSetFirstFreeGraph(Graph))
void htGraphDestroy(htGraph Graph);
void htGraphAllocMore(void);
void htGraphCopyProps(htGraph htOldGraph, htGraph htNewGraph);
void htGraphAllocNodeTables(htGraph Graph, uint32 numNodeTables);
void htGraphResizeNodeTables(htGraph Graph, uint32 numNodeTables);
void htGraphFreeNodeTables(htGraph Graph);
void htCompactGraphNodeTables(void);
void htGraphInsertNode(htGraph Graph, htNode _Node);
void htGraphRemoveNode(htGraph Graph, htNode _Node);
void htGraphInsertAfterNode(htGraph Graph, htNode prevNode, htNode _Node);
void htGraphAppendNode(htGraph Graph, htNode _Node);

/*----------------------------------------------------------------------------------------
  Fields for class Node.
----------------------------------------------------------------------------------------*/
struct htNodeFields {
    char *Name;
    int32 *Y;
    htNode *FreeList;
};
extern struct htNodeFields htNodes;

extern uint32 htNodeGetNameIndex(htNode Node);
extern void htNodeSetNameIndex(htNode Node, uint32 value);
extern uint32 htNodeGetNumName(htNode Node);
extern void htNodeSetNumName(htNode Node, uint32 value);
#if defined(DD_DEBUG)
#define htNodeCheckNameIndex(Node, x) ((uint32)(x) < htNodeGetNumName(Node)? (x) : \
    (utAssert(false),(x)))
#else
#define htNodeCheckNameIndex(Node, x) (x)
#endif
#define htNodeGetiName(_Node, x) ((htNodes.Name)[ \
    htNodeGetNameIndex(_Node) + htNodeCheckNameIndex(_Node, (x))])
#define htNodeGetName(Node) (htNodes.Name + htNodeGetNameIndex(Node))
#define htNodeGetNames htNodeGetName
#define htNodeSetName(Node, valuePtr, numName) (htNodeResizeNames(Node, numName), memcpy(htNodeGetNames(Node), valuePtr, \
    numName*sizeof(char)))
#define htNodeSetiName(Node, x, value) ((htNodes.Name)[ \
    htNodeGetNameIndex(Node) + htNodeCheckNameIndex(Node, (x))] = (value))
extern int32 htNodeGetX(htNode Node);
extern void htNodeSetX(htNode Node, int32 value);
#define htNodeGetY(_Node) (htNodes.Y[htNode2ValidIndex(_Node)])
#define htNodeSetY(_Node, value) ((htNodes.Y)[htNode2ValidIndex(_Node)] = (value))
extern htNode htNodeGetNextGraphNode(htNode Node);
extern void htNodeSetNextGraphNode(htNode Node, htNode value);
extern htNode htNodeGetPrevGraphNode(htNode Node);
extern void htNodeSetPrevGraphNode(htNode Node, htNode value);
extern htNode htNodeGetNextTableGraphNode(htNode Node);
extern void htNodeSetNextTableGraphNode(htNode Node, htNode value);
#define htNodeGetFreeList(_Node) (htNodes.FreeList[htNode2ValidIndex(_Node)])
#define htNodeSetFreeList(_Node, value) ((htNodes.FreeList)[htNode2ValidIndex(_Node)] = (value))
#define htNodeSetConstructorCallback(func) (htNodeConstructorCallback = (func))
#define htNodeGetConstructorCallback() (htNodeConstructorCallback)
#define htNodeSetDestructorCallback(func) (htNodeDestructorCallback = (func))
#define htNodeGetDestructorCallback() (htNodeDestructorCallback)
#define htNodeNextFree(_Node) (((htNode *)(void *)(htNodes.FreeList))[htNode2ValidIndex(_Node)])
#define htNodeSetNextFree(_Node, value) (((htNode *)(void *)(htNodes.FreeList)) \
    [htNode2ValidIndex(_Node)] = (value))
#define htNodeAllocRaw() ( \
    htRootData.firstFreeNode != htNodeNull? \
        (htTemp_.Node = htRootData.firstFreeNode, \
        htSetFirstFreeNode(htNodeNextFree(htTemp_.Node)), true) \
    : (htRootData.usedNode == htRootData.allocatedNode && (htNodeAllocMore(), true), \
        htTemp_.Node = htIndex2Node(htRootData.usedNode), \
        htSetUsedNode(htUsedNode() + 1)), \
    htTemp_.Node)
#define htNodeAlloc() ( \
    htRootData.firstFreeNode != htNodeNull? \
        (htTemp_.Node = htRootData.firstFreeNode, \
        htSetFirstFreeNode(htNodeNextFree(htTemp_.Node)), true) \
    : (htRootData.usedNode == htRootData.allocatedNode && (htNodeAllocMore(), true), \
        htTemp_.Node = htIndex2Node(htRootData.usedNode), \
        htSetUsedNode(htUsedNode() + 1)), \
    htNodeSetNameIndex(htTemp_.Node, 0), \
    htNodeSetNumName(htTemp_.Node, 0), \
    htNodeSetNumName(htTemp_.Node, 0), \
    htNodeSetX(htTemp_.Node, 1), \
    htNodeSetY(htTemp_.Node, 1), \
    htNodeSetNextGraphNode(htTemp_.Node, htNodeNull), \
    htNodeSetPrevGraphNode(htTemp_.Node, htNodeNull), \
    htNodeSetNextTableGraphNode(htTemp_.Node, htNodeNull), \
    htNodeSetFreeList(htTemp_.Node, htNodeNull), \
    htNodeConstructorCallback != NULL && (htNodeConstructorCallback(htTemp_.Node), true), \
    htTemp_.Node)

#define htNodeFree(Node) (htNodeFreeNames(Node), \
    htNodeSetNextFree(Node, htRootData.firstFreeNode), \
    htSetFirstFreeNode(Node))
void htNodeDestroy(htNode Node);
void htNodeAllocMore(void);
void htNodeCopyProps(htNode htOldNode, htNode htNewNode);
void htNodeAllocNames(htNode Node, uint32 numNames);
void htNodeResizeNames(htNode Node, uint32 numNames);
void htNodeFreeNames(htNode Node);
void htCompactNodeNames(void);

/*----------------------------------------------------------------------------------------
  Fields for class DatadrawRoot.
----------------------------------------------------------------------------------------*/
struct htDatadrawRootFields {
    htSparseParentGraphNodeData *FirstSparseParentGraphNodeData;
    htSparseParentGraphNodeData *LastSparseParentGraphNodeData;
    uint32 *SparseParentGraphNodeDataTableIndex;
    uint32 *NumSparseParentGraphNodeDataTable;
    htSparseParentGraphNodeData *SparseParentGraphNodeDataTable;
    uint32 *NumSparseParentGraphNodeData;
    htSparseChildGraphNodeData *FirstSparseChildGraphNodeData;
    htSparseChildGraphNodeData *LastSparseChildGraphNodeData;
    uint32 *SparseChildGraphNodeDataTableIndex;
    uint32 *NumSparseChildGraphNodeDataTable;
    htSparseChildGraphNodeData *SparseChildGraphNodeDataTable;
    uint32 *NumSparseChildGraphNodeData;
    htSparseNodeNameData *FirstSparseNodeNameData;
    htSparseNodeNameData *LastSparseNodeNameData;
    uint32 *SparseNodeNameDataTableIndex;
    uint32 *NumSparseNodeNameDataTable;
    htSparseNodeNameData *SparseNodeNameDataTable;
    uint32 *NumSparseNodeNameData;
    htSparseNodeXData *FirstSparseNodeXData;
    htSparseNodeXData *LastSparseNodeXData;
    uint32 *SparseNodeXDataTableIndex;
    uint32 *NumSparseNodeXDataTable;
    htSparseNodeXData *SparseNodeXDataTable;
    uint32 *NumSparseNodeXData;
};
extern struct htDatadrawRootFields htDatadrawRoots;

#define htDatadrawRootGetFirstSparseParentGraphNodeData(_DatadrawRoot) (htDatadrawRoots.FirstSparseParentGraphNodeData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetFirstSparseParentGraphNodeData(_DatadrawRoot, value) ((htDatadrawRoots.FirstSparseParentGraphNodeData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetLastSparseParentGraphNodeData(_DatadrawRoot) (htDatadrawRoots.LastSparseParentGraphNodeData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetLastSparseParentGraphNodeData(_DatadrawRoot, value) ((htDatadrawRoots.LastSparseParentGraphNodeData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetSparseParentGraphNodeDataTableIndex(_DatadrawRoot) (htDatadrawRoots.SparseParentGraphNodeDataTableIndex[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetSparseParentGraphNodeDataTableIndex(_DatadrawRoot, value) ((htDatadrawRoots.SparseParentGraphNodeDataTableIndex)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetNumSparseParentGraphNodeDataTable(_DatadrawRoot) (htDatadrawRoots.NumSparseParentGraphNodeDataTable[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetNumSparseParentGraphNodeDataTable(_DatadrawRoot, value) ((htDatadrawRoots.NumSparseParentGraphNodeDataTable)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#if defined(DD_DEBUG)
#define htDatadrawRootCheckSparseParentGraphNodeDataTableIndex(DatadrawRoot, x) ((uint32)(x) < htDatadrawRootGetNumSparseParentGraphNodeDataTable(DatadrawRoot)? (x) : \
    (utAssert(false),(x)))
#else
#define htDatadrawRootCheckSparseParentGraphNodeDataTableIndex(DatadrawRoot, x) (x)
#endif
#define htDatadrawRootGetiSparseParentGraphNodeDataTable(_DatadrawRoot, x) ((htDatadrawRoots.SparseParentGraphNodeDataTable)[ \
    htDatadrawRootGetSparseParentGraphNodeDataTableIndex(_DatadrawRoot) + htDatadrawRootCheckSparseParentGraphNodeDataTableIndex(_DatadrawRoot, (x))])
#define htDatadrawRootGetSparseParentGraphNodeDataTable(DatadrawRoot) (htDatadrawRoots.SparseParentGraphNodeDataTable + htDatadrawRootGetSparseParentGraphNodeDataTableIndex(DatadrawRoot))
#define htDatadrawRootGetSparseParentGraphNodeDataTables htDatadrawRootGetSparseParentGraphNodeDataTable
#define htDatadrawRootSetSparseParentGraphNodeDataTable(DatadrawRoot, valuePtr, numSparseParentGraphNodeDataTable) (htDatadrawRootResizeSparseParentGraphNodeDataTables(DatadrawRoot, numSparseParentGraphNodeDataTable), memcpy(htDatadrawRootGetSparseParentGraphNodeDataTables(DatadrawRoot), valuePtr, \
    numSparseParentGraphNodeDataTable*sizeof(htSparseParentGraphNodeData)))
#define htDatadrawRootSetiSparseParentGraphNodeDataTable(DatadrawRoot, x, value) ((htDatadrawRoots.SparseParentGraphNodeDataTable)[ \
    htDatadrawRootGetSparseParentGraphNodeDataTableIndex(DatadrawRoot) + htDatadrawRootCheckSparseParentGraphNodeDataTableIndex(DatadrawRoot, (x))] = (value))
#define htDatadrawRootGetNumSparseParentGraphNodeData(_DatadrawRoot) (htDatadrawRoots.NumSparseParentGraphNodeData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetNumSparseParentGraphNodeData(_DatadrawRoot, value) ((htDatadrawRoots.NumSparseParentGraphNodeData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetFirstSparseChildGraphNodeData(_DatadrawRoot) (htDatadrawRoots.FirstSparseChildGraphNodeData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetFirstSparseChildGraphNodeData(_DatadrawRoot, value) ((htDatadrawRoots.FirstSparseChildGraphNodeData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetLastSparseChildGraphNodeData(_DatadrawRoot) (htDatadrawRoots.LastSparseChildGraphNodeData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetLastSparseChildGraphNodeData(_DatadrawRoot, value) ((htDatadrawRoots.LastSparseChildGraphNodeData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetSparseChildGraphNodeDataTableIndex(_DatadrawRoot) (htDatadrawRoots.SparseChildGraphNodeDataTableIndex[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetSparseChildGraphNodeDataTableIndex(_DatadrawRoot, value) ((htDatadrawRoots.SparseChildGraphNodeDataTableIndex)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetNumSparseChildGraphNodeDataTable(_DatadrawRoot) (htDatadrawRoots.NumSparseChildGraphNodeDataTable[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetNumSparseChildGraphNodeDataTable(_DatadrawRoot, value) ((htDatadrawRoots.NumSparseChildGraphNodeDataTable)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#if defined(DD_DEBUG)
#define htDatadrawRootCheckSparseChildGraphNodeDataTableIndex(DatadrawRoot, x) ((uint32)(x) < htDatadrawRootGetNumSparseChildGraphNodeDataTable(DatadrawRoot)? (x) : \
    (utAssert(false),(x)))
#else
#define htDatadrawRootCheckSparseChildGraphNodeDataTableIndex(DatadrawRoot, x) (x)
#endif
#define htDatadrawRootGetiSparseChildGraphNodeDataTable(_DatadrawRoot, x) ((htDatadrawRoots.SparseChildGraphNodeDataTable)[ \
    htDatadrawRootGetSparseChildGraphNodeDataTableIndex(_DatadrawRoot) + htDatadrawRootCheckSparseChildGraphNodeDataTableIndex(_DatadrawRoot, (x))])
#define htDatadrawRootGetSparseChildGraphNodeDataTable(DatadrawRoot) (htDatadrawRoots.SparseChildGraphNodeDataTable + htDatadrawRootGetSparseChildGraphNodeDataTableIndex(DatadrawRoot))
#define htDatadrawRootGetSparseChildGraphNodeDataTables htDatadrawRootGetSparseChildGraphNodeDataTable
#define htDatadrawRootSetSparseChildGraphNodeDataTable(DatadrawRoot, valuePtr, numSparseChildGraphNodeDataTable) (htDatadrawRootResizeSparseChildGraphNodeDataTables(DatadrawRoot, numSparseChildGraphNodeDataTable), memcpy(htDatadrawRootGetSparseChildGraphNodeDataTables(DatadrawRoot), valuePtr, \
    numSparseChildGraphNodeDataTable*sizeof(htSparseChildGraphNodeData)))
#define htDatadrawRootSetiSparseChildGraphNodeDataTable(DatadrawRoot, x, value) ((htDatadrawRoots.SparseChildGraphNodeDataTable)[ \
    htDatadrawRootGetSparseChildGraphNodeDataTableIndex(DatadrawRoot) + htDatadrawRootCheckSparseChildGraphNodeDataTableIndex(DatadrawRoot, (x))] = (value))
#define htDatadrawRootGetNumSparseChildGraphNodeData(_DatadrawRoot) (htDatadrawRoots.NumSparseChildGraphNodeData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetNumSparseChildGraphNodeData(_DatadrawRoot, value) ((htDatadrawRoots.NumSparseChildGraphNodeData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetFirstSparseNodeNameData(_DatadrawRoot) (htDatadrawRoots.FirstSparseNodeNameData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetFirstSparseNodeNameData(_DatadrawRoot, value) ((htDatadrawRoots.FirstSparseNodeNameData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetLastSparseNodeNameData(_DatadrawRoot) (htDatadrawRoots.LastSparseNodeNameData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetLastSparseNodeNameData(_DatadrawRoot, value) ((htDatadrawRoots.LastSparseNodeNameData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetSparseNodeNameDataTableIndex(_DatadrawRoot) (htDatadrawRoots.SparseNodeNameDataTableIndex[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetSparseNodeNameDataTableIndex(_DatadrawRoot, value) ((htDatadrawRoots.SparseNodeNameDataTableIndex)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetNumSparseNodeNameDataTable(_DatadrawRoot) (htDatadrawRoots.NumSparseNodeNameDataTable[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetNumSparseNodeNameDataTable(_DatadrawRoot, value) ((htDatadrawRoots.NumSparseNodeNameDataTable)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#if defined(DD_DEBUG)
#define htDatadrawRootCheckSparseNodeNameDataTableIndex(DatadrawRoot, x) ((uint32)(x) < htDatadrawRootGetNumSparseNodeNameDataTable(DatadrawRoot)? (x) : \
    (utAssert(false),(x)))
#else
#define htDatadrawRootCheckSparseNodeNameDataTableIndex(DatadrawRoot, x) (x)
#endif
#define htDatadrawRootGetiSparseNodeNameDataTable(_DatadrawRoot, x) ((htDatadrawRoots.SparseNodeNameDataTable)[ \
    htDatadrawRootGetSparseNodeNameDataTableIndex(_DatadrawRoot) + htDatadrawRootCheckSparseNodeNameDataTableIndex(_DatadrawRoot, (x))])
#define htDatadrawRootGetSparseNodeNameDataTable(DatadrawRoot) (htDatadrawRoots.SparseNodeNameDataTable + htDatadrawRootGetSparseNodeNameDataTableIndex(DatadrawRoot))
#define htDatadrawRootGetSparseNodeNameDataTables htDatadrawRootGetSparseNodeNameDataTable
#define htDatadrawRootSetSparseNodeNameDataTable(DatadrawRoot, valuePtr, numSparseNodeNameDataTable) (htDatadrawRootResizeSparseNodeNameDataTables(DatadrawRoot, numSparseNodeNameDataTable), memcpy(htDatadrawRootGetSparseNodeNameDataTables(DatadrawRoot), valuePtr, \
    numSparseNodeNameDataTable*sizeof(htSparseNodeNameData)))
#define htDatadrawRootSetiSparseNodeNameDataTable(DatadrawRoot, x, value) ((htDatadrawRoots.SparseNodeNameDataTable)[ \
    htDatadrawRootGetSparseNodeNameDataTableIndex(DatadrawRoot) + htDatadrawRootCheckSparseNodeNameDataTableIndex(DatadrawRoot, (x))] = (value))
#define htDatadrawRootGetNumSparseNodeNameData(_DatadrawRoot) (htDatadrawRoots.NumSparseNodeNameData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetNumSparseNodeNameData(_DatadrawRoot, value) ((htDatadrawRoots.NumSparseNodeNameData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetFirstSparseNodeXData(_DatadrawRoot) (htDatadrawRoots.FirstSparseNodeXData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetFirstSparseNodeXData(_DatadrawRoot, value) ((htDatadrawRoots.FirstSparseNodeXData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetLastSparseNodeXData(_DatadrawRoot) (htDatadrawRoots.LastSparseNodeXData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetLastSparseNodeXData(_DatadrawRoot, value) ((htDatadrawRoots.LastSparseNodeXData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetSparseNodeXDataTableIndex(_DatadrawRoot) (htDatadrawRoots.SparseNodeXDataTableIndex[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetSparseNodeXDataTableIndex(_DatadrawRoot, value) ((htDatadrawRoots.SparseNodeXDataTableIndex)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#define htDatadrawRootGetNumSparseNodeXDataTable(_DatadrawRoot) (htDatadrawRoots.NumSparseNodeXDataTable[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetNumSparseNodeXDataTable(_DatadrawRoot, value) ((htDatadrawRoots.NumSparseNodeXDataTable)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
#if defined(DD_DEBUG)
#define htDatadrawRootCheckSparseNodeXDataTableIndex(DatadrawRoot, x) ((uint32)(x) < htDatadrawRootGetNumSparseNodeXDataTable(DatadrawRoot)? (x) : \
    (utAssert(false),(x)))
#else
#define htDatadrawRootCheckSparseNodeXDataTableIndex(DatadrawRoot, x) (x)
#endif
#define htDatadrawRootGetiSparseNodeXDataTable(_DatadrawRoot, x) ((htDatadrawRoots.SparseNodeXDataTable)[ \
    htDatadrawRootGetSparseNodeXDataTableIndex(_DatadrawRoot) + htDatadrawRootCheckSparseNodeXDataTableIndex(_DatadrawRoot, (x))])
#define htDatadrawRootGetSparseNodeXDataTable(DatadrawRoot) (htDatadrawRoots.SparseNodeXDataTable + htDatadrawRootGetSparseNodeXDataTableIndex(DatadrawRoot))
#define htDatadrawRootGetSparseNodeXDataTables htDatadrawRootGetSparseNodeXDataTable
#define htDatadrawRootSetSparseNodeXDataTable(DatadrawRoot, valuePtr, numSparseNodeXDataTable) (htDatadrawRootResizeSparseNodeXDataTables(DatadrawRoot, numSparseNodeXDataTable), memcpy(htDatadrawRootGetSparseNodeXDataTables(DatadrawRoot), valuePtr, \
    numSparseNodeXDataTable*sizeof(htSparseNodeXData)))
#define htDatadrawRootSetiSparseNodeXDataTable(DatadrawRoot, x, value) ((htDatadrawRoots.SparseNodeXDataTable)[ \
    htDatadrawRootGetSparseNodeXDataTableIndex(DatadrawRoot) + htDatadrawRootCheckSparseNodeXDataTableIndex(DatadrawRoot, (x))] = (value))
#define htDatadrawRootGetNumSparseNodeXData(_DatadrawRoot) (htDatadrawRoots.NumSparseNodeXData[htDatadrawRoot2ValidIndex(_DatadrawRoot)])
#define htDatadrawRootSetNumSparseNodeXData(_DatadrawRoot, value) ((htDatadrawRoots.NumSparseNodeXData)[htDatadrawRoot2ValidIndex(_DatadrawRoot)] = (value))
htSparseParentGraphNodeData htDatadrawRootFindSparseParentGraphNodeData(htDatadrawRoot DatadrawRoot, htGraph GraphKey);
#define htForeachDatadrawRootSparseParentGraphNodeData(pVar, cVar) \
    for(cVar = htDatadrawRootGetFirstSparseParentGraphNodeData(pVar); cVar != htSparseParentGraphNodeDataNull; \
        cVar = htSparseParentGraphNodeDataGetNextDatadrawRootSparseParentGraphNodeData(cVar))
#define htEndDatadrawRootSparseParentGraphNodeData
#define htSafeForeachDatadrawRootSparseParentGraphNodeData(pVar, cVar) { \
    htSparseParentGraphNodeData _nextSparseParentGraphNodeData; \
    for(cVar = htDatadrawRootGetFirstSparseParentGraphNodeData(pVar); cVar != htSparseParentGraphNodeDataNull; cVar = _nextSparseParentGraphNodeData) { \
        _nextSparseParentGraphNodeData = htSparseParentGraphNodeDataGetNextDatadrawRootSparseParentGraphNodeData(cVar);
#define htEndSafeDatadrawRootSparseParentGraphNodeData }}
htSparseChildGraphNodeData htDatadrawRootFindSparseChildGraphNodeData(htDatadrawRoot DatadrawRoot, htNode NodeKey);
#define htForeachDatadrawRootSparseChildGraphNodeData(pVar, cVar) \
    for(cVar = htDatadrawRootGetFirstSparseChildGraphNodeData(pVar); cVar != htSparseChildGraphNodeDataNull; \
        cVar = htSparseChildGraphNodeDataGetNextDatadrawRootSparseChildGraphNodeData(cVar))
#define htEndDatadrawRootSparseChildGraphNodeData
#define htSafeForeachDatadrawRootSparseChildGraphNodeData(pVar, cVar) { \
    htSparseChildGraphNodeData _nextSparseChildGraphNodeData; \
    for(cVar = htDatadrawRootGetFirstSparseChildGraphNodeData(pVar); cVar != htSparseChildGraphNodeDataNull; cVar = _nextSparseChildGraphNodeData) { \
        _nextSparseChildGraphNodeData = htSparseChildGraphNodeDataGetNextDatadrawRootSparseChildGraphNodeData(cVar);
#define htEndSafeDatadrawRootSparseChildGraphNodeData }}
htSparseNodeNameData htDatadrawRootFindSparseNodeNameData(htDatadrawRoot DatadrawRoot, htNode NodeKey);
#define htForeachDatadrawRootSparseNodeNameData(pVar, cVar) \
    for(cVar = htDatadrawRootGetFirstSparseNodeNameData(pVar); cVar != htSparseNodeNameDataNull; \
        cVar = htSparseNodeNameDataGetNextDatadrawRootSparseNodeNameData(cVar))
#define htEndDatadrawRootSparseNodeNameData
#define htSafeForeachDatadrawRootSparseNodeNameData(pVar, cVar) { \
    htSparseNodeNameData _nextSparseNodeNameData; \
    for(cVar = htDatadrawRootGetFirstSparseNodeNameData(pVar); cVar != htSparseNodeNameDataNull; cVar = _nextSparseNodeNameData) { \
        _nextSparseNodeNameData = htSparseNodeNameDataGetNextDatadrawRootSparseNodeNameData(cVar);
#define htEndSafeDatadrawRootSparseNodeNameData }}
htSparseNodeXData htDatadrawRootFindSparseNodeXData(htDatadrawRoot DatadrawRoot, htNode NodeKey);
#define htForeachDatadrawRootSparseNodeXData(pVar, cVar) \
    for(cVar = htDatadrawRootGetFirstSparseNodeXData(pVar); cVar != htSparseNodeXDataNull; \
        cVar = htSparseNodeXDataGetNextDatadrawRootSparseNodeXData(cVar))
#define htEndDatadrawRootSparseNodeXData
#define htSafeForeachDatadrawRootSparseNodeXData(pVar, cVar) { \
    htSparseNodeXData _nextSparseNodeXData; \
    for(cVar = htDatadrawRootGetFirstSparseNodeXData(pVar); cVar != htSparseNodeXDataNull; cVar = _nextSparseNodeXData) { \
        _nextSparseNodeXData = htSparseNodeXDataGetNextDatadrawRootSparseNodeXData(cVar);
#define htEndSafeDatadrawRootSparseNodeXData }}
#define htDatadrawRootSetConstructorCallback(func) (htDatadrawRootConstructorCallback = (func))
#define htDatadrawRootGetConstructorCallback() (htDatadrawRootConstructorCallback)
#define htFirstDatadrawRoot() (htRootData.usedDatadrawRoot == 0? htDatadrawRootNull : htIndex2DatadrawRoot(0))
#define htLastDatadrawRoot() (htRootData.usedDatadrawRoot == 0? htDatadrawRootNull : \
    htIndex2DatadrawRoot(htRootData.usedDatadrawRoot - 1))
#define htNextDatadrawRoot(DatadrawRoot) (htDatadrawRoot2ValidIndex(DatadrawRoot) + 1 == htRootData.usedDatadrawRoot? htDatadrawRootNull : \
    (DatadrawRoot) + 1)
#define htPrevDatadrawRoot(DatadrawRoot) (htDatadrawRoot2ValidIndex(DatadrawRoot) == 0? htDatadrawRootNull : (DatadrawRoot) - 1)
#define htForeachDatadrawRoot(var) \
    for(var = htIndex2DatadrawRoot(0); htDatadrawRoot2Index(var) != htRootData.usedDatadrawRoot; var++)
#define htEndDatadrawRoot
#define htDatadrawRootFreeAll() (htSetUsedDatadrawRoot(0), htSetUsedDatadrawRootSparseParentGraphNodeDataTable(0), htSetUsedDatadrawRootSparseChildGraphNodeDataTable(0), htSetUsedDatadrawRootSparseNodeNameDataTable(0), htSetUsedDatadrawRootSparseNodeXDataTable(0))
#define htDatadrawRootAllocRaw() ( \
    htRootData.usedDatadrawRoot == htRootData.allocatedDatadrawRoot && (htDatadrawRootAllocMore(), true), \
    htTemp_.DatadrawRoot = htIndex2DatadrawRoot(htRootData.usedDatadrawRoot), \
    htSetUsedDatadrawRoot(htUsedDatadrawRoot() + 1), \
    htTemp_.DatadrawRoot)
#define htDatadrawRootAlloc() ( \
    htRootData.usedDatadrawRoot == htRootData.allocatedDatadrawRoot && (htDatadrawRootAllocMore(), true), \
    htTemp_.DatadrawRoot = htIndex2DatadrawRoot(htRootData.usedDatadrawRoot), \
    htSetUsedDatadrawRoot(htUsedDatadrawRoot() + 1), \
    htDatadrawRootSetFirstSparseParentGraphNodeData(htTemp_.DatadrawRoot, htSparseParentGraphNodeDataNull), \
    htDatadrawRootSetLastSparseParentGraphNodeData(htTemp_.DatadrawRoot, htSparseParentGraphNodeDataNull), \
    htDatadrawRootSetSparseParentGraphNodeDataTableIndex(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseParentGraphNodeDataTable(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseParentGraphNodeDataTable(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseParentGraphNodeData(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetFirstSparseChildGraphNodeData(htTemp_.DatadrawRoot, htSparseChildGraphNodeDataNull), \
    htDatadrawRootSetLastSparseChildGraphNodeData(htTemp_.DatadrawRoot, htSparseChildGraphNodeDataNull), \
    htDatadrawRootSetSparseChildGraphNodeDataTableIndex(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseChildGraphNodeDataTable(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseChildGraphNodeDataTable(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseChildGraphNodeData(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetFirstSparseNodeNameData(htTemp_.DatadrawRoot, htSparseNodeNameDataNull), \
    htDatadrawRootSetLastSparseNodeNameData(htTemp_.DatadrawRoot, htSparseNodeNameDataNull), \
    htDatadrawRootSetSparseNodeNameDataTableIndex(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseNodeNameDataTable(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseNodeNameDataTable(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseNodeNameData(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetFirstSparseNodeXData(htTemp_.DatadrawRoot, htSparseNodeXDataNull), \
    htDatadrawRootSetLastSparseNodeXData(htTemp_.DatadrawRoot, htSparseNodeXDataNull), \
    htDatadrawRootSetSparseNodeXDataTableIndex(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseNodeXDataTable(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseNodeXDataTable(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootSetNumSparseNodeXData(htTemp_.DatadrawRoot, 0), \
    htDatadrawRootConstructorCallback != NULL && (htDatadrawRootConstructorCallback(htTemp_.DatadrawRoot), true), \
    htTemp_.DatadrawRoot)

void htDatadrawRootAllocMore(void);
void htDatadrawRootCopyProps(htDatadrawRoot htOldDatadrawRoot, htDatadrawRoot htNewDatadrawRoot);
void htDatadrawRootAllocSparseParentGraphNodeDataTables(htDatadrawRoot DatadrawRoot, uint32 numSparseParentGraphNodeDataTables);
void htDatadrawRootResizeSparseParentGraphNodeDataTables(htDatadrawRoot DatadrawRoot, uint32 numSparseParentGraphNodeDataTables);
void htDatadrawRootFreeSparseParentGraphNodeDataTables(htDatadrawRoot DatadrawRoot);
void htCompactDatadrawRootSparseParentGraphNodeDataTables(void);
void htDatadrawRootAllocSparseChildGraphNodeDataTables(htDatadrawRoot DatadrawRoot, uint32 numSparseChildGraphNodeDataTables);
void htDatadrawRootResizeSparseChildGraphNodeDataTables(htDatadrawRoot DatadrawRoot, uint32 numSparseChildGraphNodeDataTables);
void htDatadrawRootFreeSparseChildGraphNodeDataTables(htDatadrawRoot DatadrawRoot);
void htCompactDatadrawRootSparseChildGraphNodeDataTables(void);
void htDatadrawRootAllocSparseNodeNameDataTables(htDatadrawRoot DatadrawRoot, uint32 numSparseNodeNameDataTables);
void htDatadrawRootResizeSparseNodeNameDataTables(htDatadrawRoot DatadrawRoot, uint32 numSparseNodeNameDataTables);
void htDatadrawRootFreeSparseNodeNameDataTables(htDatadrawRoot DatadrawRoot);
void htCompactDatadrawRootSparseNodeNameDataTables(void);
void htDatadrawRootAllocSparseNodeXDataTables(htDatadrawRoot DatadrawRoot, uint32 numSparseNodeXDataTables);
void htDatadrawRootResizeSparseNodeXDataTables(htDatadrawRoot DatadrawRoot, uint32 numSparseNodeXDataTables);
void htDatadrawRootFreeSparseNodeXDataTables(htDatadrawRoot DatadrawRoot);
void htCompactDatadrawRootSparseNodeXDataTables(void);
void htDatadrawRootInsertSparseParentGraphNodeData(htDatadrawRoot DatadrawRoot, htSparseParentGraphNodeData _SparseParentGraphNodeData);
void htDatadrawRootRemoveSparseParentGraphNodeData(htDatadrawRoot DatadrawRoot, htSparseParentGraphNodeData _SparseParentGraphNodeData);
void htDatadrawRootInsertAfterSparseParentGraphNodeData(htDatadrawRoot DatadrawRoot, htSparseParentGraphNodeData prevSparseParentGraphNodeData, htSparseParentGraphNodeData _SparseParentGraphNodeData);
void htDatadrawRootAppendSparseParentGraphNodeData(htDatadrawRoot DatadrawRoot, htSparseParentGraphNodeData _SparseParentGraphNodeData);
void htDatadrawRootInsertSparseChildGraphNodeData(htDatadrawRoot DatadrawRoot, htSparseChildGraphNodeData _SparseChildGraphNodeData);
void htDatadrawRootRemoveSparseChildGraphNodeData(htDatadrawRoot DatadrawRoot, htSparseChildGraphNodeData _SparseChildGraphNodeData);
void htDatadrawRootInsertAfterSparseChildGraphNodeData(htDatadrawRoot DatadrawRoot, htSparseChildGraphNodeData prevSparseChildGraphNodeData, htSparseChildGraphNodeData _SparseChildGraphNodeData);
void htDatadrawRootAppendSparseChildGraphNodeData(htDatadrawRoot DatadrawRoot, htSparseChildGraphNodeData _SparseChildGraphNodeData);
void htDatadrawRootInsertSparseNodeNameData(htDatadrawRoot DatadrawRoot, htSparseNodeNameData _SparseNodeNameData);
void htDatadrawRootRemoveSparseNodeNameData(htDatadrawRoot DatadrawRoot, htSparseNodeNameData _SparseNodeNameData);
void htDatadrawRootInsertAfterSparseNodeNameData(htDatadrawRoot DatadrawRoot, htSparseNodeNameData prevSparseNodeNameData, htSparseNodeNameData _SparseNodeNameData);
void htDatadrawRootAppendSparseNodeNameData(htDatadrawRoot DatadrawRoot, htSparseNodeNameData _SparseNodeNameData);
void htDatadrawRootInsertSparseNodeXData(htDatadrawRoot DatadrawRoot, htSparseNodeXData _SparseNodeXData);
void htDatadrawRootRemoveSparseNodeXData(htDatadrawRoot DatadrawRoot, htSparseNodeXData _SparseNodeXData);
void htDatadrawRootInsertAfterSparseNodeXData(htDatadrawRoot DatadrawRoot, htSparseNodeXData prevSparseNodeXData, htSparseNodeXData _SparseNodeXData);
void htDatadrawRootAppendSparseNodeXData(htDatadrawRoot DatadrawRoot, htSparseNodeXData _SparseNodeXData);

/*----------------------------------------------------------------------------------------
  Fields for class SparseParentGraphNodeData.
----------------------------------------------------------------------------------------*/
struct htSparseParentGraphNodeDataFields {
    htGraph *GraphKey;
    htNode *FirstNode;
    htNode *LastNode;
    uint32 *NumNode;
    uint32 *NodeTableIndex;
    uint32 *NumNodeTable;
    htSparseParentGraphNodeData *NextDatadrawRootSparseParentGraphNodeData;
    htSparseParentGraphNodeData *PrevDatadrawRootSparseParentGraphNodeData;
    htSparseParentGraphNodeData *NextTableDatadrawRootSparseParentGraphNodeData;
};
extern struct htSparseParentGraphNodeDataFields htSparseParentGraphNodeDatas;

#define htSparseParentGraphNodeDataGetGraphKey(_SparseParentGraphNodeData) (htSparseParentGraphNodeDatas.GraphKey[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)])
#define htSparseParentGraphNodeDataSetGraphKey(_SparseParentGraphNodeData, value) ((htSparseParentGraphNodeDatas.GraphKey)[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)] = (value))
#define htSparseParentGraphNodeDataGetFirstNode(_SparseParentGraphNodeData) (htSparseParentGraphNodeDatas.FirstNode[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)])
#define htSparseParentGraphNodeDataSetFirstNode(_SparseParentGraphNodeData, value) ((htSparseParentGraphNodeDatas.FirstNode)[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)] = (value))
#define htSparseParentGraphNodeDataGetLastNode(_SparseParentGraphNodeData) (htSparseParentGraphNodeDatas.LastNode[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)])
#define htSparseParentGraphNodeDataSetLastNode(_SparseParentGraphNodeData, value) ((htSparseParentGraphNodeDatas.LastNode)[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)] = (value))
#define htSparseParentGraphNodeDataGetNumNode(_SparseParentGraphNodeData) (htSparseParentGraphNodeDatas.NumNode[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)])
#define htSparseParentGraphNodeDataSetNumNode(_SparseParentGraphNodeData, value) ((htSparseParentGraphNodeDatas.NumNode)[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)] = (value))
#define htSparseParentGraphNodeDataGetNodeTableIndex(_SparseParentGraphNodeData) (htSparseParentGraphNodeDatas.NodeTableIndex[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)])
#define htSparseParentGraphNodeDataSetNodeTableIndex(_SparseParentGraphNodeData, value) ((htSparseParentGraphNodeDatas.NodeTableIndex)[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)] = (value))
#define htSparseParentGraphNodeDataGetNumNodeTable(_SparseParentGraphNodeData) (htSparseParentGraphNodeDatas.NumNodeTable[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)])
#define htSparseParentGraphNodeDataSetNumNodeTable(_SparseParentGraphNodeData, value) ((htSparseParentGraphNodeDatas.NumNodeTable)[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)] = (value))
#define htSparseParentGraphNodeDataGetNextDatadrawRootSparseParentGraphNodeData(_SparseParentGraphNodeData) (htSparseParentGraphNodeDatas.NextDatadrawRootSparseParentGraphNodeData[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)])
#define htSparseParentGraphNodeDataSetNextDatadrawRootSparseParentGraphNodeData(_SparseParentGraphNodeData, value) ((htSparseParentGraphNodeDatas.NextDatadrawRootSparseParentGraphNodeData)[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)] = (value))
#define htSparseParentGraphNodeDataGetPrevDatadrawRootSparseParentGraphNodeData(_SparseParentGraphNodeData) (htSparseParentGraphNodeDatas.PrevDatadrawRootSparseParentGraphNodeData[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)])
#define htSparseParentGraphNodeDataSetPrevDatadrawRootSparseParentGraphNodeData(_SparseParentGraphNodeData, value) ((htSparseParentGraphNodeDatas.PrevDatadrawRootSparseParentGraphNodeData)[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)] = (value))
#define htSparseParentGraphNodeDataGetNextTableDatadrawRootSparseParentGraphNodeData(_SparseParentGraphNodeData) (htSparseParentGraphNodeDatas.NextTableDatadrawRootSparseParentGraphNodeData[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)])
#define htSparseParentGraphNodeDataSetNextTableDatadrawRootSparseParentGraphNodeData(_SparseParentGraphNodeData, value) ((htSparseParentGraphNodeDatas.NextTableDatadrawRootSparseParentGraphNodeData)[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)] = (value))
#define htSparseParentGraphNodeDataSetConstructorCallback(func) (htSparseParentGraphNodeDataConstructorCallback = (func))
#define htSparseParentGraphNodeDataGetConstructorCallback() (htSparseParentGraphNodeDataConstructorCallback)
#define htSparseParentGraphNodeDataSetDestructorCallback(func) (htSparseParentGraphNodeDataDestructorCallback = (func))
#define htSparseParentGraphNodeDataGetDestructorCallback() (htSparseParentGraphNodeDataDestructorCallback)
#define htSparseParentGraphNodeDataNextFree(_SparseParentGraphNodeData) (((htSparseParentGraphNodeData *)(void *)(htSparseParentGraphNodeDatas.GraphKey))[htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)])
#define htSparseParentGraphNodeDataSetNextFree(_SparseParentGraphNodeData, value) (((htSparseParentGraphNodeData *)(void *)(htSparseParentGraphNodeDatas.GraphKey)) \
    [htSparseParentGraphNodeData2ValidIndex(_SparseParentGraphNodeData)] = (value))
#define htSparseParentGraphNodeDataAllocRaw() ( \
    htRootData.firstFreeSparseParentGraphNodeData != htSparseParentGraphNodeDataNull? \
        (htTemp_.SparseParentGraphNodeData = htRootData.firstFreeSparseParentGraphNodeData, \
        htSetFirstFreeSparseParentGraphNodeData(htSparseParentGraphNodeDataNextFree(htTemp_.SparseParentGraphNodeData)), true) \
    : (htRootData.usedSparseParentGraphNodeData == htRootData.allocatedSparseParentGraphNodeData && (htSparseParentGraphNodeDataAllocMore(), true), \
        htTemp_.SparseParentGraphNodeData = htIndex2SparseParentGraphNodeData(htRootData.usedSparseParentGraphNodeData), \
        htSetUsedSparseParentGraphNodeData(htUsedSparseParentGraphNodeData() + 1)), \
    htTemp_.SparseParentGraphNodeData)
#define htSparseParentGraphNodeDataAlloc() ( \
    htRootData.firstFreeSparseParentGraphNodeData != htSparseParentGraphNodeDataNull? \
        (htTemp_.SparseParentGraphNodeData = htRootData.firstFreeSparseParentGraphNodeData, \
        htSetFirstFreeSparseParentGraphNodeData(htSparseParentGraphNodeDataNextFree(htTemp_.SparseParentGraphNodeData)), true) \
    : (htRootData.usedSparseParentGraphNodeData == htRootData.allocatedSparseParentGraphNodeData && (htSparseParentGraphNodeDataAllocMore(), true), \
        htTemp_.SparseParentGraphNodeData = htIndex2SparseParentGraphNodeData(htRootData.usedSparseParentGraphNodeData), \
        htSetUsedSparseParentGraphNodeData(htUsedSparseParentGraphNodeData() + 1)), \
    htSparseParentGraphNodeDataSetGraphKey(htTemp_.SparseParentGraphNodeData, htGraphNull), \
    htSparseParentGraphNodeDataSetFirstNode(htTemp_.SparseParentGraphNodeData, htNodeNull), \
    htSparseParentGraphNodeDataSetLastNode(htTemp_.SparseParentGraphNodeData, htNodeNull), \
    htSparseParentGraphNodeDataSetNumNode(htTemp_.SparseParentGraphNodeData, 0), \
    htSparseParentGraphNodeDataSetNodeTableIndex(htTemp_.SparseParentGraphNodeData, 0), \
    htSparseParentGraphNodeDataSetNumNodeTable(htTemp_.SparseParentGraphNodeData, 0), \
    htSparseParentGraphNodeDataSetNextDatadrawRootSparseParentGraphNodeData(htTemp_.SparseParentGraphNodeData, htSparseParentGraphNodeDataNull), \
    htSparseParentGraphNodeDataSetPrevDatadrawRootSparseParentGraphNodeData(htTemp_.SparseParentGraphNodeData, htSparseParentGraphNodeDataNull), \
    htSparseParentGraphNodeDataSetNextTableDatadrawRootSparseParentGraphNodeData(htTemp_.SparseParentGraphNodeData, htSparseParentGraphNodeDataNull), \
    htSparseParentGraphNodeDataConstructorCallback != NULL && (htSparseParentGraphNodeDataConstructorCallback(htTemp_.SparseParentGraphNodeData), true), \
    htTemp_.SparseParentGraphNodeData)

#define htSparseParentGraphNodeDataFree(SparseParentGraphNodeData) (htSparseParentGraphNodeDataSetNextFree(SparseParentGraphNodeData, htRootData.firstFreeSparseParentGraphNodeData), \
    htSetFirstFreeSparseParentGraphNodeData(SparseParentGraphNodeData))
void htSparseParentGraphNodeDataDestroy(htSparseParentGraphNodeData SparseParentGraphNodeData);
void htSparseParentGraphNodeDataAllocMore(void);
void htSparseParentGraphNodeDataCopyProps(htSparseParentGraphNodeData htOldSparseParentGraphNodeData, htSparseParentGraphNodeData htNewSparseParentGraphNodeData);

/*----------------------------------------------------------------------------------------
  Fields for class SparseChildGraphNodeData.
----------------------------------------------------------------------------------------*/
struct htSparseChildGraphNodeDataFields {
    htNode *NodeKey;
    htNode *NextGraphNode;
    htNode *PrevGraphNode;
    htNode *NextTableGraphNode;
    htSparseChildGraphNodeData *NextDatadrawRootSparseChildGraphNodeData;
    htSparseChildGraphNodeData *PrevDatadrawRootSparseChildGraphNodeData;
    htSparseChildGraphNodeData *NextTableDatadrawRootSparseChildGraphNodeData;
};
extern struct htSparseChildGraphNodeDataFields htSparseChildGraphNodeDatas;

#define htSparseChildGraphNodeDataGetNodeKey(_SparseChildGraphNodeData) (htSparseChildGraphNodeDatas.NodeKey[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)])
#define htSparseChildGraphNodeDataSetNodeKey(_SparseChildGraphNodeData, value) ((htSparseChildGraphNodeDatas.NodeKey)[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)] = (value))
#define htSparseChildGraphNodeDataGetNextGraphNode(_SparseChildGraphNodeData) (htSparseChildGraphNodeDatas.NextGraphNode[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)])
#define htSparseChildGraphNodeDataSetNextGraphNode(_SparseChildGraphNodeData, value) ((htSparseChildGraphNodeDatas.NextGraphNode)[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)] = (value))
#define htSparseChildGraphNodeDataGetPrevGraphNode(_SparseChildGraphNodeData) (htSparseChildGraphNodeDatas.PrevGraphNode[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)])
#define htSparseChildGraphNodeDataSetPrevGraphNode(_SparseChildGraphNodeData, value) ((htSparseChildGraphNodeDatas.PrevGraphNode)[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)] = (value))
#define htSparseChildGraphNodeDataGetNextTableGraphNode(_SparseChildGraphNodeData) (htSparseChildGraphNodeDatas.NextTableGraphNode[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)])
#define htSparseChildGraphNodeDataSetNextTableGraphNode(_SparseChildGraphNodeData, value) ((htSparseChildGraphNodeDatas.NextTableGraphNode)[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)] = (value))
#define htSparseChildGraphNodeDataGetNextDatadrawRootSparseChildGraphNodeData(_SparseChildGraphNodeData) (htSparseChildGraphNodeDatas.NextDatadrawRootSparseChildGraphNodeData[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)])
#define htSparseChildGraphNodeDataSetNextDatadrawRootSparseChildGraphNodeData(_SparseChildGraphNodeData, value) ((htSparseChildGraphNodeDatas.NextDatadrawRootSparseChildGraphNodeData)[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)] = (value))
#define htSparseChildGraphNodeDataGetPrevDatadrawRootSparseChildGraphNodeData(_SparseChildGraphNodeData) (htSparseChildGraphNodeDatas.PrevDatadrawRootSparseChildGraphNodeData[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)])
#define htSparseChildGraphNodeDataSetPrevDatadrawRootSparseChildGraphNodeData(_SparseChildGraphNodeData, value) ((htSparseChildGraphNodeDatas.PrevDatadrawRootSparseChildGraphNodeData)[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)] = (value))
#define htSparseChildGraphNodeDataGetNextTableDatadrawRootSparseChildGraphNodeData(_SparseChildGraphNodeData) (htSparseChildGraphNodeDatas.NextTableDatadrawRootSparseChildGraphNodeData[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)])
#define htSparseChildGraphNodeDataSetNextTableDatadrawRootSparseChildGraphNodeData(_SparseChildGraphNodeData, value) ((htSparseChildGraphNodeDatas.NextTableDatadrawRootSparseChildGraphNodeData)[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)] = (value))
#define htSparseChildGraphNodeDataSetConstructorCallback(func) (htSparseChildGraphNodeDataConstructorCallback = (func))
#define htSparseChildGraphNodeDataGetConstructorCallback() (htSparseChildGraphNodeDataConstructorCallback)
#define htSparseChildGraphNodeDataSetDestructorCallback(func) (htSparseChildGraphNodeDataDestructorCallback = (func))
#define htSparseChildGraphNodeDataGetDestructorCallback() (htSparseChildGraphNodeDataDestructorCallback)
#define htSparseChildGraphNodeDataNextFree(_SparseChildGraphNodeData) (((htSparseChildGraphNodeData *)(void *)(htSparseChildGraphNodeDatas.NodeKey))[htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)])
#define htSparseChildGraphNodeDataSetNextFree(_SparseChildGraphNodeData, value) (((htSparseChildGraphNodeData *)(void *)(htSparseChildGraphNodeDatas.NodeKey)) \
    [htSparseChildGraphNodeData2ValidIndex(_SparseChildGraphNodeData)] = (value))
#define htSparseChildGraphNodeDataAllocRaw() ( \
    htRootData.firstFreeSparseChildGraphNodeData != htSparseChildGraphNodeDataNull? \
        (htTemp_.SparseChildGraphNodeData = htRootData.firstFreeSparseChildGraphNodeData, \
        htSetFirstFreeSparseChildGraphNodeData(htSparseChildGraphNodeDataNextFree(htTemp_.SparseChildGraphNodeData)), true) \
    : (htRootData.usedSparseChildGraphNodeData == htRootData.allocatedSparseChildGraphNodeData && (htSparseChildGraphNodeDataAllocMore(), true), \
        htTemp_.SparseChildGraphNodeData = htIndex2SparseChildGraphNodeData(htRootData.usedSparseChildGraphNodeData), \
        htSetUsedSparseChildGraphNodeData(htUsedSparseChildGraphNodeData() + 1)), \
    htTemp_.SparseChildGraphNodeData)
#define htSparseChildGraphNodeDataAlloc() ( \
    htRootData.firstFreeSparseChildGraphNodeData != htSparseChildGraphNodeDataNull? \
        (htTemp_.SparseChildGraphNodeData = htRootData.firstFreeSparseChildGraphNodeData, \
        htSetFirstFreeSparseChildGraphNodeData(htSparseChildGraphNodeDataNextFree(htTemp_.SparseChildGraphNodeData)), true) \
    : (htRootData.usedSparseChildGraphNodeData == htRootData.allocatedSparseChildGraphNodeData && (htSparseChildGraphNodeDataAllocMore(), true), \
        htTemp_.SparseChildGraphNodeData = htIndex2SparseChildGraphNodeData(htRootData.usedSparseChildGraphNodeData), \
        htSetUsedSparseChildGraphNodeData(htUsedSparseChildGraphNodeData() + 1)), \
    htSparseChildGraphNodeDataSetNodeKey(htTemp_.SparseChildGraphNodeData, htNodeNull), \
    htSparseChildGraphNodeDataSetNextGraphNode(htTemp_.SparseChildGraphNodeData, htNodeNull), \
    htSparseChildGraphNodeDataSetPrevGraphNode(htTemp_.SparseChildGraphNodeData, htNodeNull), \
    htSparseChildGraphNodeDataSetNextTableGraphNode(htTemp_.SparseChildGraphNodeData, htNodeNull), \
    htSparseChildGraphNodeDataSetNextDatadrawRootSparseChildGraphNodeData(htTemp_.SparseChildGraphNodeData, htSparseChildGraphNodeDataNull), \
    htSparseChildGraphNodeDataSetPrevDatadrawRootSparseChildGraphNodeData(htTemp_.SparseChildGraphNodeData, htSparseChildGraphNodeDataNull), \
    htSparseChildGraphNodeDataSetNextTableDatadrawRootSparseChildGraphNodeData(htTemp_.SparseChildGraphNodeData, htSparseChildGraphNodeDataNull), \
    htSparseChildGraphNodeDataConstructorCallback != NULL && (htSparseChildGraphNodeDataConstructorCallback(htTemp_.SparseChildGraphNodeData), true), \
    htTemp_.SparseChildGraphNodeData)

#define htSparseChildGraphNodeDataFree(SparseChildGraphNodeData) (htSparseChildGraphNodeDataSetNextFree(SparseChildGraphNodeData, htRootData.firstFreeSparseChildGraphNodeData), \
    htSetFirstFreeSparseChildGraphNodeData(SparseChildGraphNodeData))
void htSparseChildGraphNodeDataDestroy(htSparseChildGraphNodeData SparseChildGraphNodeData);
void htSparseChildGraphNodeDataAllocMore(void);
void htSparseChildGraphNodeDataCopyProps(htSparseChildGraphNodeData htOldSparseChildGraphNodeData, htSparseChildGraphNodeData htNewSparseChildGraphNodeData);

/*----------------------------------------------------------------------------------------
  Fields for class SparseNodeNameData.
----------------------------------------------------------------------------------------*/
struct htSparseNodeNameDataFields {
    htNode *NodeKey;
    uint32 *NameIndex;
    uint32 *NumName;
    htSparseNodeNameData *NextDatadrawRootSparseNodeNameData;
    htSparseNodeNameData *PrevDatadrawRootSparseNodeNameData;
    htSparseNodeNameData *NextTableDatadrawRootSparseNodeNameData;
};
extern struct htSparseNodeNameDataFields htSparseNodeNameDatas;

#define htSparseNodeNameDataGetNodeKey(_SparseNodeNameData) (htSparseNodeNameDatas.NodeKey[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)])
#define htSparseNodeNameDataSetNodeKey(_SparseNodeNameData, value) ((htSparseNodeNameDatas.NodeKey)[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)] = (value))
#define htSparseNodeNameDataGetNameIndex(_SparseNodeNameData) (htSparseNodeNameDatas.NameIndex[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)])
#define htSparseNodeNameDataSetNameIndex(_SparseNodeNameData, value) ((htSparseNodeNameDatas.NameIndex)[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)] = (value))
#define htSparseNodeNameDataGetNumName(_SparseNodeNameData) (htSparseNodeNameDatas.NumName[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)])
#define htSparseNodeNameDataSetNumName(_SparseNodeNameData, value) ((htSparseNodeNameDatas.NumName)[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)] = (value))
#define htSparseNodeNameDataGetNextDatadrawRootSparseNodeNameData(_SparseNodeNameData) (htSparseNodeNameDatas.NextDatadrawRootSparseNodeNameData[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)])
#define htSparseNodeNameDataSetNextDatadrawRootSparseNodeNameData(_SparseNodeNameData, value) ((htSparseNodeNameDatas.NextDatadrawRootSparseNodeNameData)[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)] = (value))
#define htSparseNodeNameDataGetPrevDatadrawRootSparseNodeNameData(_SparseNodeNameData) (htSparseNodeNameDatas.PrevDatadrawRootSparseNodeNameData[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)])
#define htSparseNodeNameDataSetPrevDatadrawRootSparseNodeNameData(_SparseNodeNameData, value) ((htSparseNodeNameDatas.PrevDatadrawRootSparseNodeNameData)[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)] = (value))
#define htSparseNodeNameDataGetNextTableDatadrawRootSparseNodeNameData(_SparseNodeNameData) (htSparseNodeNameDatas.NextTableDatadrawRootSparseNodeNameData[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)])
#define htSparseNodeNameDataSetNextTableDatadrawRootSparseNodeNameData(_SparseNodeNameData, value) ((htSparseNodeNameDatas.NextTableDatadrawRootSparseNodeNameData)[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)] = (value))
#define htSparseNodeNameDataSetConstructorCallback(func) (htSparseNodeNameDataConstructorCallback = (func))
#define htSparseNodeNameDataGetConstructorCallback() (htSparseNodeNameDataConstructorCallback)
#define htSparseNodeNameDataSetDestructorCallback(func) (htSparseNodeNameDataDestructorCallback = (func))
#define htSparseNodeNameDataGetDestructorCallback() (htSparseNodeNameDataDestructorCallback)
#define htSparseNodeNameDataNextFree(_SparseNodeNameData) (((htSparseNodeNameData *)(void *)(htSparseNodeNameDatas.NodeKey))[htSparseNodeNameData2ValidIndex(_SparseNodeNameData)])
#define htSparseNodeNameDataSetNextFree(_SparseNodeNameData, value) (((htSparseNodeNameData *)(void *)(htSparseNodeNameDatas.NodeKey)) \
    [htSparseNodeNameData2ValidIndex(_SparseNodeNameData)] = (value))
#define htSparseNodeNameDataAllocRaw() ( \
    htRootData.firstFreeSparseNodeNameData != htSparseNodeNameDataNull? \
        (htTemp_.SparseNodeNameData = htRootData.firstFreeSparseNodeNameData, \
        htSetFirstFreeSparseNodeNameData(htSparseNodeNameDataNextFree(htTemp_.SparseNodeNameData)), true) \
    : (htRootData.usedSparseNodeNameData == htRootData.allocatedSparseNodeNameData && (htSparseNodeNameDataAllocMore(), true), \
        htTemp_.SparseNodeNameData = htIndex2SparseNodeNameData(htRootData.usedSparseNodeNameData), \
        htSetUsedSparseNodeNameData(htUsedSparseNodeNameData() + 1)), \
    htTemp_.SparseNodeNameData)
#define htSparseNodeNameDataAlloc() ( \
    htRootData.firstFreeSparseNodeNameData != htSparseNodeNameDataNull? \
        (htTemp_.SparseNodeNameData = htRootData.firstFreeSparseNodeNameData, \
        htSetFirstFreeSparseNodeNameData(htSparseNodeNameDataNextFree(htTemp_.SparseNodeNameData)), true) \
    : (htRootData.usedSparseNodeNameData == htRootData.allocatedSparseNodeNameData && (htSparseNodeNameDataAllocMore(), true), \
        htTemp_.SparseNodeNameData = htIndex2SparseNodeNameData(htRootData.usedSparseNodeNameData), \
        htSetUsedSparseNodeNameData(htUsedSparseNodeNameData() + 1)), \
    htSparseNodeNameDataSetNodeKey(htTemp_.SparseNodeNameData, htNodeNull), \
    htSparseNodeNameDataSetNameIndex(htTemp_.SparseNodeNameData, 0), \
    htSparseNodeNameDataSetNumName(htTemp_.SparseNodeNameData, 0), \
    htSparseNodeNameDataSetNextDatadrawRootSparseNodeNameData(htTemp_.SparseNodeNameData, htSparseNodeNameDataNull), \
    htSparseNodeNameDataSetPrevDatadrawRootSparseNodeNameData(htTemp_.SparseNodeNameData, htSparseNodeNameDataNull), \
    htSparseNodeNameDataSetNextTableDatadrawRootSparseNodeNameData(htTemp_.SparseNodeNameData, htSparseNodeNameDataNull), \
    htSparseNodeNameDataConstructorCallback != NULL && (htSparseNodeNameDataConstructorCallback(htTemp_.SparseNodeNameData), true), \
    htTemp_.SparseNodeNameData)

#define htSparseNodeNameDataFree(SparseNodeNameData) (htSparseNodeNameDataSetNextFree(SparseNodeNameData, htRootData.firstFreeSparseNodeNameData), \
    htSetFirstFreeSparseNodeNameData(SparseNodeNameData))
void htSparseNodeNameDataDestroy(htSparseNodeNameData SparseNodeNameData);
void htSparseNodeNameDataAllocMore(void);
void htSparseNodeNameDataCopyProps(htSparseNodeNameData htOldSparseNodeNameData, htSparseNodeNameData htNewSparseNodeNameData);

/*----------------------------------------------------------------------------------------
  Fields for class SparseNodeXData.
----------------------------------------------------------------------------------------*/
struct htSparseNodeXDataFields {
    htNode *NodeKey;
    int32 *X;
    htSparseNodeXData *NextDatadrawRootSparseNodeXData;
    htSparseNodeXData *PrevDatadrawRootSparseNodeXData;
    htSparseNodeXData *NextTableDatadrawRootSparseNodeXData;
};
extern struct htSparseNodeXDataFields htSparseNodeXDatas;

#define htSparseNodeXDataGetNodeKey(_SparseNodeXData) (htSparseNodeXDatas.NodeKey[htSparseNodeXData2ValidIndex(_SparseNodeXData)])
#define htSparseNodeXDataSetNodeKey(_SparseNodeXData, value) ((htSparseNodeXDatas.NodeKey)[htSparseNodeXData2ValidIndex(_SparseNodeXData)] = (value))
#define htSparseNodeXDataGetX(_SparseNodeXData) (htSparseNodeXDatas.X[htSparseNodeXData2ValidIndex(_SparseNodeXData)])
#define htSparseNodeXDataSetX(_SparseNodeXData, value) ((htSparseNodeXDatas.X)[htSparseNodeXData2ValidIndex(_SparseNodeXData)] = (value))
#define htSparseNodeXDataGetNextDatadrawRootSparseNodeXData(_SparseNodeXData) (htSparseNodeXDatas.NextDatadrawRootSparseNodeXData[htSparseNodeXData2ValidIndex(_SparseNodeXData)])
#define htSparseNodeXDataSetNextDatadrawRootSparseNodeXData(_SparseNodeXData, value) ((htSparseNodeXDatas.NextDatadrawRootSparseNodeXData)[htSparseNodeXData2ValidIndex(_SparseNodeXData)] = (value))
#define htSparseNodeXDataGetPrevDatadrawRootSparseNodeXData(_SparseNodeXData) (htSparseNodeXDatas.PrevDatadrawRootSparseNodeXData[htSparseNodeXData2ValidIndex(_SparseNodeXData)])
#define htSparseNodeXDataSetPrevDatadrawRootSparseNodeXData(_SparseNodeXData, value) ((htSparseNodeXDatas.PrevDatadrawRootSparseNodeXData)[htSparseNodeXData2ValidIndex(_SparseNodeXData)] = (value))
#define htSparseNodeXDataGetNextTableDatadrawRootSparseNodeXData(_SparseNodeXData) (htSparseNodeXDatas.NextTableDatadrawRootSparseNodeXData[htSparseNodeXData2ValidIndex(_SparseNodeXData)])
#define htSparseNodeXDataSetNextTableDatadrawRootSparseNodeXData(_SparseNodeXData, value) ((htSparseNodeXDatas.NextTableDatadrawRootSparseNodeXData)[htSparseNodeXData2ValidIndex(_SparseNodeXData)] = (value))
#define htSparseNodeXDataSetConstructorCallback(func) (htSparseNodeXDataConstructorCallback = (func))
#define htSparseNodeXDataGetConstructorCallback() (htSparseNodeXDataConstructorCallback)
#define htSparseNodeXDataSetDestructorCallback(func) (htSparseNodeXDataDestructorCallback = (func))
#define htSparseNodeXDataGetDestructorCallback() (htSparseNodeXDataDestructorCallback)
#define htSparseNodeXDataNextFree(_SparseNodeXData) (((htSparseNodeXData *)(void *)(htSparseNodeXDatas.NodeKey))[htSparseNodeXData2ValidIndex(_SparseNodeXData)])
#define htSparseNodeXDataSetNextFree(_SparseNodeXData, value) (((htSparseNodeXData *)(void *)(htSparseNodeXDatas.NodeKey)) \
    [htSparseNodeXData2ValidIndex(_SparseNodeXData)] = (value))
#define htSparseNodeXDataAllocRaw() ( \
    htRootData.firstFreeSparseNodeXData != htSparseNodeXDataNull? \
        (htTemp_.SparseNodeXData = htRootData.firstFreeSparseNodeXData, \
        htSetFirstFreeSparseNodeXData(htSparseNodeXDataNextFree(htTemp_.SparseNodeXData)), true) \
    : (htRootData.usedSparseNodeXData == htRootData.allocatedSparseNodeXData && (htSparseNodeXDataAllocMore(), true), \
        htTemp_.SparseNodeXData = htIndex2SparseNodeXData(htRootData.usedSparseNodeXData), \
        htSetUsedSparseNodeXData(htUsedSparseNodeXData() + 1)), \
    htTemp_.SparseNodeXData)
#define htSparseNodeXDataAlloc() ( \
    htRootData.firstFreeSparseNodeXData != htSparseNodeXDataNull? \
        (htTemp_.SparseNodeXData = htRootData.firstFreeSparseNodeXData, \
        htSetFirstFreeSparseNodeXData(htSparseNodeXDataNextFree(htTemp_.SparseNodeXData)), true) \
    : (htRootData.usedSparseNodeXData == htRootData.allocatedSparseNodeXData && (htSparseNodeXDataAllocMore(), true), \
        htTemp_.SparseNodeXData = htIndex2SparseNodeXData(htRootData.usedSparseNodeXData), \
        htSetUsedSparseNodeXData(htUsedSparseNodeXData() + 1)), \
    htSparseNodeXDataSetNodeKey(htTemp_.SparseNodeXData, htNodeNull), \
    htSparseNodeXDataSetX(htTemp_.SparseNodeXData, 0), \
    htSparseNodeXDataSetNextDatadrawRootSparseNodeXData(htTemp_.SparseNodeXData, htSparseNodeXDataNull), \
    htSparseNodeXDataSetPrevDatadrawRootSparseNodeXData(htTemp_.SparseNodeXData, htSparseNodeXDataNull), \
    htSparseNodeXDataSetNextTableDatadrawRootSparseNodeXData(htTemp_.SparseNodeXData, htSparseNodeXDataNull), \
    htSparseNodeXDataConstructorCallback != NULL && (htSparseNodeXDataConstructorCallback(htTemp_.SparseNodeXData), true), \
    htTemp_.SparseNodeXData)

#define htSparseNodeXDataFree(SparseNodeXData) (htSparseNodeXDataSetNextFree(SparseNodeXData, htRootData.firstFreeSparseNodeXData), \
    htSetFirstFreeSparseNodeXData(SparseNodeXData))
void htSparseNodeXDataDestroy(htSparseNodeXData SparseNodeXData);
void htSparseNodeXDataAllocMore(void);
void htSparseNodeXDataCopyProps(htSparseNodeXData htOldSparseNodeXData, htSparseNodeXData htNewSparseNodeXData);

/*----------------------------------------------------------------------------------------
  Temp Union structure - Macro temp variables, use only one
----------------------------------------------------------------------------------------*/
union htTempType_ {
    htGraph Graph;
    htNode Node;
    htDatadrawRoot DatadrawRoot;
    htSparseParentGraphNodeData SparseParentGraphNodeData;
    htSparseChildGraphNodeData SparseChildGraphNodeData;
    htSparseNodeNameData SparseNodeNameData;
    htSparseNodeXData SparseNodeXData;
};

extern union htTempType_ htTemp_;

/*----------------------------------------------------------------------------------------
  Constructor/Destructor hooks.
----------------------------------------------------------------------------------------*/
extern void(*htGraphConstructorCallback)(htGraph);
extern void(*htGraphDestructorCallback)(htGraph);
extern void(*htNodeConstructorCallback)(htNode);
extern void(*htNodeDestructorCallback)(htNode);
extern void(*htDatadrawRootConstructorCallback)(htDatadrawRoot);
extern void(*htSparseParentGraphNodeDataConstructorCallback)(htSparseParentGraphNodeData);
extern void(*htSparseParentGraphNodeDataDestructorCallback)(htSparseParentGraphNodeData);
extern void(*htSparseChildGraphNodeDataConstructorCallback)(htSparseChildGraphNodeData);
extern void(*htSparseChildGraphNodeDataDestructorCallback)(htSparseChildGraphNodeData);
extern void(*htSparseNodeNameDataConstructorCallback)(htSparseNodeNameData);
extern void(*htSparseNodeNameDataDestructorCallback)(htSparseNodeNameData);
extern void(*htSparseNodeXDataConstructorCallback)(htSparseNodeXData);
extern void(*htSparseNodeXDataDestructorCallback)(htSparseNodeXData);

/*----------------------------------------------------------------------------------------
  Root structure
----------------------------------------------------------------------------------------*/
struct htRootType_ {
    uint32 hash; /* This depends only on the structure of the database */
    htGraph firstFreeGraph;
    uint32 usedGraph, allocatedGraph;
    uint32 usedGraphNodeTable, allocatedGraphNodeTable, freeGraphNodeTable;
    htNode firstFreeNode;
    uint32 usedNode, allocatedNode;
    uint32 usedNodeName, allocatedNodeName, freeNodeName;
    uint32 usedDatadrawRoot, allocatedDatadrawRoot;
    uint32 usedDatadrawRootSparseParentGraphNodeDataTable, allocatedDatadrawRootSparseParentGraphNodeDataTable, freeDatadrawRootSparseParentGraphNodeDataTable;
    uint32 usedDatadrawRootSparseChildGraphNodeDataTable, allocatedDatadrawRootSparseChildGraphNodeDataTable, freeDatadrawRootSparseChildGraphNodeDataTable;
    uint32 usedDatadrawRootSparseNodeNameDataTable, allocatedDatadrawRootSparseNodeNameDataTable, freeDatadrawRootSparseNodeNameDataTable;
    uint32 usedDatadrawRootSparseNodeXDataTable, allocatedDatadrawRootSparseNodeXDataTable, freeDatadrawRootSparseNodeXDataTable;
    htSparseParentGraphNodeData firstFreeSparseParentGraphNodeData;
    uint32 usedSparseParentGraphNodeData, allocatedSparseParentGraphNodeData;
    htSparseChildGraphNodeData firstFreeSparseChildGraphNodeData;
    uint32 usedSparseChildGraphNodeData, allocatedSparseChildGraphNodeData;
    htSparseNodeNameData firstFreeSparseNodeNameData;
    uint32 usedSparseNodeNameData, allocatedSparseNodeNameData;
    htSparseNodeXData firstFreeSparseNodeXData;
    uint32 usedSparseNodeXData, allocatedSparseNodeXData;
};
extern struct htRootType_ htRootData;

#define htHash() (htRootData.hash)
#define htFirstFreeGraph() htRootData.firstFreeGraph
#define htSetFirstFreeGraph(value) (htRootData.firstFreeGraph = (value))
#define htUsedGraph() htRootData.usedGraph
#define htAllocatedGraph() htRootData.allocatedGraph
#define htSetUsedGraph(value) (htRootData.usedGraph = (value))
#define htSetAllocatedGraph(value) (htRootData.allocatedGraph = (value))
#define htUsedGraphNodeTable() htRootData.usedGraphNodeTable
#define htAllocatedGraphNodeTable() htRootData.allocatedGraphNodeTable
#define htFreeGraphNodeTable() htRootData.freeGraphNodeTable
#define htSetUsedGraphNodeTable(value) (htRootData.usedGraphNodeTable = (value))
#define htSetAllocatedGraphNodeTable(value) (htRootData.allocatedGraphNodeTable = (value))
#define htSetFreeGraphNodeTable(value) (htRootData.freeGraphNodeTable = (value))
#define htFirstFreeNode() htRootData.firstFreeNode
#define htSetFirstFreeNode(value) (htRootData.firstFreeNode = (value))
#define htUsedNode() htRootData.usedNode
#define htAllocatedNode() htRootData.allocatedNode
#define htSetUsedNode(value) (htRootData.usedNode = (value))
#define htSetAllocatedNode(value) (htRootData.allocatedNode = (value))
#define htUsedNodeName() htRootData.usedNodeName
#define htAllocatedNodeName() htRootData.allocatedNodeName
#define htFreeNodeName() htRootData.freeNodeName
#define htSetUsedNodeName(value) (htRootData.usedNodeName = (value))
#define htSetAllocatedNodeName(value) (htRootData.allocatedNodeName = (value))
#define htSetFreeNodeName(value) (htRootData.freeNodeName = (value))
#define htUsedDatadrawRoot() htRootData.usedDatadrawRoot
#define htAllocatedDatadrawRoot() htRootData.allocatedDatadrawRoot
#define htSetUsedDatadrawRoot(value) (htRootData.usedDatadrawRoot = (value))
#define htSetAllocatedDatadrawRoot(value) (htRootData.allocatedDatadrawRoot = (value))
#define htUsedDatadrawRootSparseParentGraphNodeDataTable() htRootData.usedDatadrawRootSparseParentGraphNodeDataTable
#define htAllocatedDatadrawRootSparseParentGraphNodeDataTable() htRootData.allocatedDatadrawRootSparseParentGraphNodeDataTable
#define htFreeDatadrawRootSparseParentGraphNodeDataTable() htRootData.freeDatadrawRootSparseParentGraphNodeDataTable
#define htSetUsedDatadrawRootSparseParentGraphNodeDataTable(value) (htRootData.usedDatadrawRootSparseParentGraphNodeDataTable = (value))
#define htSetAllocatedDatadrawRootSparseParentGraphNodeDataTable(value) (htRootData.allocatedDatadrawRootSparseParentGraphNodeDataTable = (value))
#define htSetFreeDatadrawRootSparseParentGraphNodeDataTable(value) (htRootData.freeDatadrawRootSparseParentGraphNodeDataTable = (value))
#define htUsedDatadrawRootSparseChildGraphNodeDataTable() htRootData.usedDatadrawRootSparseChildGraphNodeDataTable
#define htAllocatedDatadrawRootSparseChildGraphNodeDataTable() htRootData.allocatedDatadrawRootSparseChildGraphNodeDataTable
#define htFreeDatadrawRootSparseChildGraphNodeDataTable() htRootData.freeDatadrawRootSparseChildGraphNodeDataTable
#define htSetUsedDatadrawRootSparseChildGraphNodeDataTable(value) (htRootData.usedDatadrawRootSparseChildGraphNodeDataTable = (value))
#define htSetAllocatedDatadrawRootSparseChildGraphNodeDataTable(value) (htRootData.allocatedDatadrawRootSparseChildGraphNodeDataTable = (value))
#define htSetFreeDatadrawRootSparseChildGraphNodeDataTable(value) (htRootData.freeDatadrawRootSparseChildGraphNodeDataTable = (value))
#define htUsedDatadrawRootSparseNodeNameDataTable() htRootData.usedDatadrawRootSparseNodeNameDataTable
#define htAllocatedDatadrawRootSparseNodeNameDataTable() htRootData.allocatedDatadrawRootSparseNodeNameDataTable
#define htFreeDatadrawRootSparseNodeNameDataTable() htRootData.freeDatadrawRootSparseNodeNameDataTable
#define htSetUsedDatadrawRootSparseNodeNameDataTable(value) (htRootData.usedDatadrawRootSparseNodeNameDataTable = (value))
#define htSetAllocatedDatadrawRootSparseNodeNameDataTable(value) (htRootData.allocatedDatadrawRootSparseNodeNameDataTable = (value))
#define htSetFreeDatadrawRootSparseNodeNameDataTable(value) (htRootData.freeDatadrawRootSparseNodeNameDataTable = (value))
#define htUsedDatadrawRootSparseNodeXDataTable() htRootData.usedDatadrawRootSparseNodeXDataTable
#define htAllocatedDatadrawRootSparseNodeXDataTable() htRootData.allocatedDatadrawRootSparseNodeXDataTable
#define htFreeDatadrawRootSparseNodeXDataTable() htRootData.freeDatadrawRootSparseNodeXDataTable
#define htSetUsedDatadrawRootSparseNodeXDataTable(value) (htRootData.usedDatadrawRootSparseNodeXDataTable = (value))
#define htSetAllocatedDatadrawRootSparseNodeXDataTable(value) (htRootData.allocatedDatadrawRootSparseNodeXDataTable = (value))
#define htSetFreeDatadrawRootSparseNodeXDataTable(value) (htRootData.freeDatadrawRootSparseNodeXDataTable = (value))
#define htFirstFreeSparseParentGraphNodeData() htRootData.firstFreeSparseParentGraphNodeData
#define htSetFirstFreeSparseParentGraphNodeData(value) (htRootData.firstFreeSparseParentGraphNodeData = (value))
#define htUsedSparseParentGraphNodeData() htRootData.usedSparseParentGraphNodeData
#define htAllocatedSparseParentGraphNodeData() htRootData.allocatedSparseParentGraphNodeData
#define htSetUsedSparseParentGraphNodeData(value) (htRootData.usedSparseParentGraphNodeData = (value))
#define htSetAllocatedSparseParentGraphNodeData(value) (htRootData.allocatedSparseParentGraphNodeData = (value))
#define htFirstFreeSparseChildGraphNodeData() htRootData.firstFreeSparseChildGraphNodeData
#define htSetFirstFreeSparseChildGraphNodeData(value) (htRootData.firstFreeSparseChildGraphNodeData = (value))
#define htUsedSparseChildGraphNodeData() htRootData.usedSparseChildGraphNodeData
#define htAllocatedSparseChildGraphNodeData() htRootData.allocatedSparseChildGraphNodeData
#define htSetUsedSparseChildGraphNodeData(value) (htRootData.usedSparseChildGraphNodeData = (value))
#define htSetAllocatedSparseChildGraphNodeData(value) (htRootData.allocatedSparseChildGraphNodeData = (value))
#define htFirstFreeSparseNodeNameData() htRootData.firstFreeSparseNodeNameData
#define htSetFirstFreeSparseNodeNameData(value) (htRootData.firstFreeSparseNodeNameData = (value))
#define htUsedSparseNodeNameData() htRootData.usedSparseNodeNameData
#define htAllocatedSparseNodeNameData() htRootData.allocatedSparseNodeNameData
#define htSetUsedSparseNodeNameData(value) (htRootData.usedSparseNodeNameData = (value))
#define htSetAllocatedSparseNodeNameData(value) (htRootData.allocatedSparseNodeNameData = (value))
#define htFirstFreeSparseNodeXData() htRootData.firstFreeSparseNodeXData
#define htSetFirstFreeSparseNodeXData(value) (htRootData.firstFreeSparseNodeXData = (value))
#define htUsedSparseNodeXData() htRootData.usedSparseNodeXData
#define htAllocatedSparseNodeXData() htRootData.allocatedSparseNodeXData
#define htSetUsedSparseNodeXData(value) (htRootData.usedSparseNodeXData = (value))
#define htSetAllocatedSparseNodeXData(value) (htRootData.allocatedSparseNodeXData = (value))

extern uint8 htModuleID;
void htDatabaseStart(void);
void htDatabaseStop(void);
#if defined __cplusplus
}
#endif

#endif
