#currently only x86 is supported
ARCH     = x86

DDELINUX26DIR ?= /usr/pkg/include/ddelinux26
DDEKIT_INCDIR ?= /usr/include

MY_LINUX26_INCDIR = \
	$(DDELINUX26DIR)/include/ \
	$(DDELINUX26DIR)/include/dde/linux26 \
	$(DDELINUX26DIR)/contrib/include \
	$(DDELINUX26DIR)/contrib/arch/x86/include\
	$(DDELINUX26DIR)/contrib/arch/x86/include/asm/mach-generic \
	$(DDELINUX26DIR)/contrib/arch/x86/include/asm/mach-default

KBUILD_DEFINES = \
	-D"KBUILD_STR(s)=\#s" \
	-D"KBUILD_BASENAME=KBUILD_STR($(patsubst %.o, %, $(notdir $@)))" \
	-D"KBUILD_MODNAME=KBUILD_STR($(patsubst %.o, %, $@))"


CPPFLAGS += \
	-Wall -include linux/autoconf.h -include ddefines.h\
	-ffunction-sections -fdata-sections -fno-strict-aliasing

AFLAGS += -D__ASSEMBLY__ -include linux/autoconf.h -include ddefines.h ${DEFINES}

PRIVATE_INCDIR += ${MY_LINUX26_INCDIR} ${DDEKIT_INCDIR} ${MY_DDE_INCDIR}

.for _incdir in ${PRIVATE_INCDIR}
CFLAGS +=  -I${_incdir}
AFLAGS += -I${_incdir}
.endfor
