#ifndef DDE_DRIVE_H
#define DDE_DRIVE_H 1

#include <ddekit/memory.h>
#include <ddekit/minix/msg_queue.h>
#include <ddekit/panic.h>
#include <ddekit/semaphore.h>
#include <ddekit/thread.h>
#include <minix/blockdriver.h>
#include <minix/drvlib.h>
#include <sys/ioc_disk.h>
#include <ddekit/debug.h>

#include "ddekit_bd.h"

struct gen_disk;

#define MAX_DRIVES         8
#define COMPAT_DRIVES      4
#define NR_MINORS       (MAX_DRIVES * DEV_PER_DRIVE)
#define SUB_PER_DRIVE   (NR_PARTITIONS * NR_PARTITIONS)
#define NR_SUBDEVS      (MAX_DRIVES * SUB_PER_DRIVE)

#define DDEMINIX_NAME_LEN 8

struct dde_minix_drive {
	struct ddekit_bd_disk *disk;
	unsigned open_ct;
	struct device part[DEV_PER_DRIVE];	/* disks and partitions */
	struct device subpart[SUB_PER_DRIVE];	/* subpartitions */
	char name[8];
};

#endif
