#include <ddekit/ddekit.h>
#include <ddekit/printf.h>
#include <ddekit/initcall.h>
#include <minix/drivers.h>
#include <minix/blockdriver.h>

#include <dde/linux26/dde26.h>

#define USB_STORAGE_MAJOR 18

void ddekit_minix_wait_exit(void);

static int sef_cb_init(int type, sef_init_info_t *info)
{
	blockdriver_announce(BLOCKDRIVER_TYPE_DISK);
    /* Initialization completed successfully. */
    return 0;
}


/** noop_init and ddeusb_vhcd_init rely on the 
 *  linux module_init mechanism but currently
 *  linkers optimized this code away
 *  read about module init here
 *  http://linuxgazette.net/157/amurray.html
 *  and the linked documentation about declaring
 *  attributes of functions.
 *
 *  Until the code gest sorted we created a dummy
 *  function to ensure the code does not get optimized
 *  away
 **/
static void alibi_init() {
	volatile int never=0;
	if (never) {
		noop_init();
		ddeusb_vhcd_init();
	}
}

void dde_block_init();
void ddekit_shutdown();
extern void idr_init_cache(void);

int main(int argc, char **argv)
{
	/*
	 * Before we init dde set the sef callbacks.
	 * ...sef_startup is called by dde.
	 */
	sef_setcb_init_fresh(sef_cb_init);
	sef_setcb_signal_handler(ddekit_shutdown);

	alibi_init();

	l4dde26_init();
	l4dde26_kmalloc_init();
	l4dde26_process_init();
	l4dde26_init_timers();
	l4dde26_softirq_init();
	idr_init_cache();
	l4dde26_do_initcalls();
	dde_block_init();
	ddekit_minix_wait_exit();
	ddekit_printf("Bye!\n");
	return 0;
}

