#include <ddekit/ddekit.h>
#include <ddekit/thread.h>
#include <ddekit/initcall.h>
#include <ddekit/usb.h>
#include <minix/drivers.h>
#include <minix/driver.h>
#include <minix/devman.h>
#include <dde/linux26/dde26.h>

void uhci_hcd_cleanup(void);
void ehci_hcd_cleanup(void);
void ddekit_minix_wait_exit(void);
void ohci_hcd_mod_exit(void);


static void usb_server_thread(void* unused)
{
	l4dde26_process_add_worker();
	ddekit_usb_server_init();
}


static int sef_cb_init(int type, sef_init_info_t *info)
{
    return 0;
}

void dde_block_init();
void ddekit_shutdown();

int main(int argc, char **argv)
{
	/*
	 * Before we init dde set the sef callbacks.
	 * ...sef_startup is called by dde.
	 */
	sef_setcb_init_fresh(sef_cb_init);
	sef_setcb_signal_handler(ddekit_shutdown);


	l4dde26_init();
	l4dde26_kmalloc_init();
	l4dde26_process_init();
	l4dde26_init_timers();
	l4dde26_softirq_init();
	ddekit_thread_msleep(1);
	devman_init();

	l4dde26_do_initcalls();
    /* Initialization completed successfully. */
	ddekit_thread_create(usb_server_thread,NULL,"USBSERVER");
	ddekit_minix_wait_exit();
	uhci_hcd_cleanup();
	ohci_hcd_mod_exit();
	ehci_hcd_cleanup();
	return 0;
}

