.\"
.\" $Header: /afs/andrew/system/src/local/depot2/009/RCS/DEPOTDB.man,v 1.1 1993/09/20 21:22:00 sohan Exp $
.\" $Source: /afs/andrew/system/src/local/depot2/009/RCS/DEPOTDB.man,v $
.\"
.\"/***********************************************************
.\"        Copyright 1991 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"******************************************************************/
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH DEPOTDB 7
.SH Name
DEPOTDB - depot database
.SH Description
The
.PN DEPOTDB
structure is used to represent the depot database.
The components of
.PN DEPOTDB
are:
.nf
typedef struct DepotDB
{
	PREFERENCEDB preferencelist;
	DEPOTCONFDB *depotconfdb;
	COLLECTIONLIST *collectionlist;
	TARGETDB *targetdb;
	PREFERENCEDB preferencelist.old;
	DEPOTCONFDB *depotconfdb_old;
	COLLECTIONLIST *collectionlist_old;
} DEPOTDB;

#define DEPOTDB_PreferenceDB(dp) ((dp)->preferencedb)
#define DEPOTDB_DepotConfDB(dp) ((dp)->depotconfdb)
#define DEPOTDB_CollectionList(dp) ((dp)->collectionlist)
#define DEPOTDB_TargetDB(dp) ((dp)->targetdb)
#define DEPOTDB_OldPreferenceDB(dp) ((dp)->preferencedb_old)
#define DEPOTDB_OldDepotConfDB(dp) ((dp)->depotconfdb_old)
#define DEPOTDB_OldCollectionList(dp) ((dp)->collectionlist_old)
.fi

.SH Author
Sohan C. Ramakrishna-Pillai
.SH See Also
TARGETDB(7), PREFERENCE(7), HINT(7), COLLECTION(7), DEPOTCONFDB(7)
